/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime.time;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.basics.debug.Assure;
import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TimeMeasurement {
    static final String IDLE = "___idle___";
    private final List<String> phases = new ArrayList<String>();
    private String nameOfRunningPhase;
    private final Map<String, StopWatch> watches;

    public TimeMeasurement() {
        this.phases.add(IDLE);
        this.watches = new HashMap<String, StopWatch>();
        this.nameOfRunningPhase = "! --- not any phase starte yet --- !";
    }

    public void addPhases(String ... stringArray) {
        List<String> list = CollectionsHelper.stringArrayToList(stringArray);
        this.addPhases(list);
    }

    public void addPhases(List<String> list) {
        for (String string : list) {
            Assure.isFalse("Die Phase '" + string + "' ist bereits bekannt. Dies", this.phases.contains(string));
            this.phases.add(string);
        }
        this.createWatchesForAllPhases();
        this.initialStartIdle();
    }

    private void createWatchesForAllPhases() {
        for (String string : this.phases) {
            StopWatch stopWatch = new StopWatch();
            stopWatch.stop();
            this.watches.put(string, stopWatch);
        }
    }

    private void initialStartIdle() {
        this.nameOfRunningPhase = IDLE;
        this.startWatchForPhase(this.nameOfRunningPhase);
    }

    public void start(String string) {
        this.stopWatchForPhase(this.nameOfRunningPhase);
        this.nameOfRunningPhase = string;
        this.startWatchForPhase(this.nameOfRunningPhase);
    }

    public void stop(String string) {
        Assure.isEqual("Die Phase '" + string + "' scheint nicht zu laufen, sondern die Phase '" + this.nameOfRunningPhase + "'. Diese", this.nameOfRunningPhase, string);
        this.start(IDLE);
    }

    private void startWatchForPhase(String string) {
        Assure.isTrue("Die Phase '" + string + "' scheint nicht bekannt zu sein. Dies", this.phases.contains(string));
        Assure.isTrue("addPhases() vergessen? Es gibt keine Stoppuhr zur Phase '" + string + "'. Dies", this.watches.containsKey(string));
        StopWatch stopWatch = this.watches.get(string);
        stopWatch.restart();
    }

    private void stopWatchForPhase(String string) {
        Assure.isTrue("Die Phase '" + string + "' scheint nicht bekannt zu sein. Dies", this.phases.contains(string));
        Assure.isTrue("addPhases() vergessen? Es gibt keine Stoppuhr zur Phase '" + string + "'. Dies", this.watches.containsKey(string));
        StopWatch stopWatch = this.watches.get(string);
        stopWatch.stop();
    }

    public Map<String, String> createReport() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : this.phases) {
            Assure.isTrue("addPhases() vergessen? Es gibt keine Stoppuhr zur Phase '" + string + "'. Dies", this.watches.containsKey(string));
            StopWatch stopWatch = this.watches.get(string);
            String string2 = stopWatch.getTime();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public List<String> createReportAsLines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, String> map = this.createReport();
        for (String string : this.phases) {
            String string2 = string + "\t" + map.get(string);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public void writeReportToFile(String string) {
        FileHelper.writeLinesToFile(this.createReportAsLines(), string, Charset.UTF_8);
    }
}

