/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io;

import de.duehl.basics.caller.CallerDeterminer;
import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.collections.Stack;
import de.duehl.basics.datetime.DateAndTime;
import de.duehl.basics.datetime.data.DateAndTimeString;
import de.duehl.basics.datetime.date.DateHelper;
import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.time.ImmutualTime;
import de.duehl.basics.datetime.time.TimeHelper;
import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FineFileReader;
import de.duehl.basics.io.FineFileWriter;
import de.duehl.basics.io.Reader;
import de.duehl.basics.io.Writer;
import de.duehl.basics.io.data.FileWithModificationTime;
import de.duehl.basics.io.exceptions.DirectoryNotCreatedRuntimeException;
import de.duehl.basics.io.exceptions.FileNotFoundRuntimeException;
import de.duehl.basics.io.exceptions.IORuntimeException;
import de.duehl.basics.io.textfile.StringsFromNormalTextFileReader;
import de.duehl.basics.io.textfile.StringsFromTextFileInJarReader;
import de.duehl.basics.io.textfile.data.DataWithTitlesAndValues;
import de.duehl.basics.io.textfile.dictionary.Dictionary;
import de.duehl.basics.io.textfile.dictionary.io.reader.DictionaryFromNormalTextFileReader;
import de.duehl.basics.io.textfile.dictionary.io.reader.DictionaryFromTextFileInJarReader;
import de.duehl.basics.system.SystemTools;
import de.duehl.basics.text.Lines;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileSystemView;

public class FileHelper {
    public static final String NO_EXTENSION_FOUND = "OHNE_EXTENSION";
    private static final List<String> FORBIDDEN_FILENAME_CHARACTERS = CollectionsHelper.buildListFrom("<", ">", ":", "\"", "/", "\\", "|", "?", "*");

    private FileHelper() {
    }

    public static void deleteTree(File file) {
        FileHelper.deleteTree(file, true);
    }

    private static void deleteTree(File file, boolean bl) {
        if (!file.exists()) {
            return;
        }
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                FileHelper.deleteTree(file2);
                continue;
            }
            if (file2.delete() || !bl) continue;
            throw new IORuntimeException(file2 + " could not be deleted!");
        }
        if (!file.delete() && bl) {
            throw new IORuntimeException(file + " could not be deleted!");
        }
    }

    public static void deleteTree(String string) {
        FileHelper.deleteTree(new File(string));
    }

    public static void deleteTreeIgnoreErrors(File file) {
        FileHelper.deleteTree(file, false);
    }

    public static void deleteTreeIgnoreErrors(String string) {
        FileHelper.deleteTreeIgnoreErrors(new File(string));
    }

    public static List<String> findFiles(String string, String ... stringArray) {
        if (0 == stringArray.length) {
            throw new IllegalArgumentException("Mindestens eine Endung muss angegebene werden.");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            arrayList.add(string2.toLowerCase());
        }
        ArrayList arrayList2 = new ArrayList();
        for (File file : new File(string).listFiles()) {
            String string3 = file.getPath();
            if (file.isDirectory()) {
                arrayList2.addAll(FileHelper.findFiles(string3, stringArray));
                continue;
            }
            String string4 = string3.toLowerCase();
            for (String string5 : arrayList) {
                if (!string4.endsWith(string5)) continue;
                arrayList2.add(string3);
            }
        }
        return arrayList2;
    }

    public static List<String> findFilesNio2Old(String string, String ... stringArray) {
        if (0 == stringArray.length) {
            throw new IllegalArgumentException("Mindestens eine Endung muss angegebene werden.");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            arrayList.add(string2.toLowerCase());
        }
        ArrayList arrayList2 = new ArrayList();
        for (String string3 : FileHelper.findAllFilesNio2(string)) {
            String string2;
            string2 = string3.toLowerCase();
            for (String string4 : arrayList) {
                if (!string2.endsWith(string4)) continue;
                arrayList2.add(string3);
            }
        }
        return arrayList2;
    }

    public static List<String> findFilesNio2(String string, String ... stringArray) {
        if (0 == stringArray.length) {
            throw new IllegalArgumentException("Mindestens eine Endung muss angegebene werden.");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            arrayList.add(string2.toLowerCase());
        }
        ArrayList arrayList2 = new ArrayList();
        Path path = Paths.get(string, new String[0]);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            block8: for (Path path2 : directoryStream) {
                if (Files.isRegularFile(path2, new LinkOption[0])) {
                    String string3 = path2.toString();
                    String string4 = string3.toLowerCase();
                    for (String string5 : arrayList) {
                        if (!string4.endsWith(string5)) continue;
                        arrayList2.add(string3);
                        continue block8;
                    }
                    continue;
                }
                if (!Files.isDirectory(path2, new LinkOption[0])) continue;
                arrayList2.addAll(FileHelper.findFilesNio2(path2.toString(), stringArray));
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Fehler bei der Suche nach Dateien mit den Endungen " + stringArray + " im Verzeichnis " + string, iOException);
        }
        return arrayList2;
    }

    public static List<String> findAllFilesNio2(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Path path = Paths.get(string, new String[0]);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                if (Files.isRegularFile(path2, new LinkOption[0])) {
                    arrayList.add(path2.toString());
                    continue;
                }
                if (!Files.isDirectory(path2, new LinkOption[0])) continue;
                arrayList.addAll(FileHelper.findAllFilesNio2(path2.toString()));
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Fehler bei der Suche nach Dateien im Verzeichnis " + string, iOException);
        }
        return arrayList;
    }

    public static List<String> findAllDirectoriesNio2(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Path path = Paths.get(string, new String[0]);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                if (!Files.isDirectory(path2, new LinkOption[0])) continue;
                arrayList.add(path2.toString());
                arrayList.addAll(FileHelper.findAllDirectoriesNio2(path2.toString()));
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Fehler bei der Suche nach Unterverzeichnissen im Verzeichnis " + string, iOException);
        }
        return arrayList;
    }

    public static List<String> findAllFilesInMainDirectory(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        for (File file2 : file.listFiles()) {
            if (!file2.isFile()) continue;
            arrayList.add(file2.getPath());
        }
        return arrayList;
    }

    public static List<String> findAllFilesInMainDirectoryNio2(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Path path = Paths.get(string, new String[0]);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                if (!Files.isRegularFile(path2, new LinkOption[0])) continue;
                arrayList.add(path2.toString());
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Fehler bei der Suche nach Dateien im Verzeichnis " + string, iOException);
        }
        return arrayList;
    }

    public static List<String> findAllFilesInMainDirectoryWithoutPath(String string) {
        List<String> list = FileHelper.findAllFilesInMainDirectory(string);
        return FileHelper.removePath(list);
    }

    public static List<String> findFilesInMainDirectory(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        String string3 = string2.toLowerCase();
        for (File file2 : file.listFiles()) {
            if (!file2.getPath().toLowerCase().endsWith(string3)) continue;
            arrayList.add(file2.getPath());
        }
        return arrayList;
    }

    public static List<String> findFilesInMainDirectoryNio2WithExtensions(String string, String ... stringArray) {
        List<String> list = CollectionsHelper.stringArrayToList(stringArray);
        return FileHelper.findFilesInMainDirectoryNio2WithExtensions(string, list);
    }

    public static List<String> findFilesInMainDirectoryNio2WithExtensions(String string, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            if (string2.startsWith(".")) {
                string2 = string2.substring(1);
            }
            Path path = Paths.get(string, new String[0]);
            FileHelper.addFilesInMainDirectoryNio2ToList(string, path, string2, arrayList, list);
        }
        return arrayList;
    }

    private static void addFilesInMainDirectoryNio2ToList(String string, Path path, String string2, List<String> list, List<String> list2) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, "*." + string2);){
            for (Path path2 : directoryStream) {
                if (!Files.isRegularFile(path2, new LinkOption[0])) continue;
                list.add(path2.toString());
            }
        }
        catch (IOException iOException) {
            String string3 = "Fehler bei der Suche nach Dateien mit " + (list2.size() == 1 ? "der Endung '" + list2.get(0) + "'" : "den Endungen '" + Text.join("', '", list2) + "'") + " im Verzeichnis " + string;
            throw new IllegalStateException(string3, iOException);
        }
    }

    public static List<String> findFilesInMainDirectoryNio2StartsWith(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Path path = Paths.get(string, new String[0]);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, string2 + "*.*");){
            for (Path path2 : directoryStream) {
                if (!Files.isRegularFile(path2, new LinkOption[0])) continue;
                arrayList.add(path2.toString());
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Fehler bei der Suche nach Dateien mit dem Anfang " + string2 + " im Verzeichnis " + path, iOException);
        }
        return arrayList;
    }

    public static List<String> findFilesInMainDirectoryNio2EndsWith(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Path path = Paths.get(string, new String[0]);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, "*" + string2);){
            for (Path path2 : directoryStream) {
                if (!Files.isRegularFile(path2, new LinkOption[0])) continue;
                arrayList.add(path2.toString());
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Fehler bei der Suche nach Dateien mit dem Ende " + string2 + " im Verzeichnis " + string, iOException);
        }
        return arrayList;
    }

    public static List<String> findFilesNio2EndsWith(String string, String string2) {
        List<String> list = FileHelper.findAllDirectoriesNio2(string);
        list.add(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : list) {
            arrayList.addAll(FileHelper.findFilesInMainDirectoryNio2EndsWith(string3, string2));
        }
        return arrayList;
    }

    public static List<String> findFilesInMainDirectoryNio2(String string, String string2, String string3) {
        List<String> list = FileHelper.findFilesInMainDirectoryNio2WithExtensions(string, string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string4 : list) {
            String string5 = FileHelper.getBareName(string4);
            if (!string5.startsWith(string2)) continue;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public static List<String> findFilesInMainDirectoryWithoutPath(String string, String string2) {
        List<String> list = FileHelper.findFilesInMainDirectory(string, string2);
        return FileHelper.removePath(list);
    }

    public static List<String> findAllSubdirectoriesInMainDirectoryNio2(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Path path = Paths.get(string, new String[0]);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                if (!Files.isDirectory(path2, LinkOption.NOFOLLOW_LINKS)) continue;
                arrayList.add(path2.toString());
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Fehler bei der Suche nach Unterverzeichnissen im Verzeichnis " + string, iOException);
        }
        return arrayList;
    }

    public static List<String> findSubdirectoriesInMainDirectory(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        for (File file2 : file.listFiles()) {
            if (!file2.isDirectory()) continue;
            arrayList.add(file2.getPath());
        }
        return arrayList;
    }

    public static List<String> findSubdirectoriesInMainDirectoryWithoutPath(String string) {
        List<String> list = FileHelper.findSubdirectoriesInMainDirectory(string);
        return FileHelper.removePath(list);
    }

    public static List<String> findSubdirectoriesInMainDirectory(String string, Pattern pattern) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        for (File file2 : file.listFiles()) {
            String string2;
            String string3;
            Matcher matcher;
            if (!file2.isDirectory() || !(matcher = pattern.matcher(string3 = FileHelper.getBareName(string2 = file2.getPath()))).matches()) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static List<String> findSubdirectoriesInMainDirectoryWithoutPath(String string, Pattern pattern) {
        List<String> list = FileHelper.findSubdirectoriesInMainDirectory(string, pattern);
        return FileHelper.removePath(list);
    }

    public static List<String> findAllNormalFilesInMainDirectory(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        for (File file2 : file.listFiles()) {
            if (!file2.isFile()) continue;
            arrayList.add(file2.getPath());
        }
        return arrayList;
    }

    public static boolean containsFiles(String string, String string2) {
        File file = new File(string);
        for (File file2 : file.listFiles()) {
            if (!(file2.isDirectory() ? FileHelper.containsFiles(file2.getPath(), string2) : file2.getPath().endsWith(string2))) continue;
            return true;
        }
        return false;
    }

    public static int firstSlash(String string) {
        int n = string.indexOf("/");
        int n2 = string.indexOf("\\");
        if (n == -1) {
            return n2;
        }
        if (n2 == -1) {
            return n;
        }
        if (n < n2) {
            return n;
        }
        return n2;
    }

    public static int lastSlash(String string) {
        int n;
        int n2 = string.lastIndexOf("/");
        if (n2 > (n = string.lastIndexOf("\\"))) {
            return n2;
        }
        return n;
    }

    public static String removeTrailingSlash(String string) {
        int n = FileHelper.lastSlash(string);
        if (n == string.length() - 1) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String normalizeToSlahes(String string) {
        return string.replace("\\", "/");
    }

    public static String normalizeToBackSlahes(String string) {
        return string.replace("/", "\\");
    }

    public static List<String> splitPath(String string) {
        return Text.splitBy(string, "[/\\\\]");
    }

    public static String getDirName(String string) {
        int n = FileHelper.lastSlash(string);
        if (n == string.length() - 1) {
            return FileHelper.getDirName(string.substring(0, string.length() - 1));
        }
        return string.substring(0, n + 1);
    }

    public static String getDirNameWithoutLastSlash(String string) {
        return FileHelper.removeTrailingSlashOrBackslash(FileHelper.getDirName(FileHelper.removeTrailingSlashOrBackslash(string)));
    }

    public static String removeTrailingSlashOrBackslash(String string) {
        String string2 = string;
        for (String string3 : CollectionsHelper.buildListFrom("/", "\\")) {
            if (!string2.endsWith(string3)) continue;
            string2 = Text.removeTextAtEndIfEndsWith(string2, string3);
            break;
        }
        return string2;
    }

    public static String getBareName(File file) {
        return FileHelper.getBareName(file.getPath());
    }

    public static String getBareName(String string) {
        int n = FileHelper.lastSlash(string);
        if (string.length() > n + 1) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static String getBareNameWithoutLastSlash(String string) {
        return FileHelper.getBareName(FileHelper.removeTrailingSlashOrBackslash(string));
    }

    public static String getAndPerhapsCreateDirectoryAtHome(String string) {
        String string2 = SystemTools.getHomeDirectory();
        return FileHelper.createSubdirectoryWithMissingSubdirectoriesInExistingDirectoryIfNecessary(string2, string);
    }

    public static String createSubdirectoryInExistingDirectoryIfNecessary(String string, String string2) {
        if (!FileHelper.isDirectory(string)) {
            throw new FileNotFoundRuntimeException("Das Verzeichnis '" + string + "' existiert nicht!");
        }
        String string3 = FileHelper.concatPathes(string, string2);
        FileHelper.createDirectoryIfNotExists(string3);
        return string3;
    }

    public static String createSubdirectoryWithMissingSubdirectoriesInExistingDirectoryIfNecessary(String string, String string2) {
        if (!FileHelper.isDirectory(string)) {
            throw new FileNotFoundRuntimeException("Das Verzeichnis '" + string + "' existiert nicht!");
        }
        String string3 = FileHelper.concatPathes(string, string2);
        FileHelper.createDirectoryWithMissingSubdirectoriesIfNotExists(string3);
        return string3;
    }

    public static boolean createDirectory(String string) {
        File file = new File(string);
        boolean bl = file.mkdir();
        return bl;
    }

    public static void createDirectoryWithMissingSubdirectoriesIfNotExists(String string) {
        String string2;
        Stack<String> stack = new Stack<String>();
        String string3 = Text.removeTrailingSlash(string);
        while (!FileHelper.exists(string3)) {
            string2 = FileHelper.getBareName(string3);
            string3 = FileHelper.getDirNameWithoutLastSlash(string3);
            stack.push(string2);
        }
        while (!stack.isEmpty()) {
            string2 = (String)stack.pop();
            string3 = FileHelper.concatPathes(string3, string2);
            FileHelper.createDirectory(string3);
        }
    }

    public static void createDirectoryIfNotExists(String string) {
        boolean bl;
        if (!FileHelper.exists(string) && !(bl = FileHelper.createDirectory(string))) {
            throw new DirectoryNotCreatedRuntimeException("Das Verzeichnis " + string + " kann nicht angelegt werden.");
        }
    }

    public static void createNotExistingDirectory(String string) {
        if (FileHelper.exists(string)) {
            throw new RuntimeException("Das Verzeichnis '" + string + "', das angelegt werden soll, existiert bereits!");
        }
        boolean bl = FileHelper.createDirectory(string);
        if (!bl) {
            throw new RuntimeException("Das Verzeichnis '" + string + "', das angelegt werden soll, konnte nicht angelegt werden!");
        }
    }

    public static void createMissingDirectoriesForFile(String string) {
        String string2 = FileHelper.getDirNameWithoutLastSlash(string);
        FileHelper.createDirectoryWithMissingSubdirectoriesIfNotExists(string2);
    }

    public static void copyFile(String string, String string2) {
        Path path = Paths.get(string, new String[0]);
        Path path2 = Paths.get(string2, new String[0]);
        try {
            Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static void copyFile(File file, File file2) {
        FileHelper.copyFile(file.getAbsolutePath(), file2.getAbsolutePath());
    }

    public static void copyFile(File file, String string) {
        FileHelper.copyFile(file.getAbsolutePath(), string);
    }

    public static void moveFile(String string, String string2) {
        Path path = Paths.get(string, new String[0]);
        Path path2 = Paths.get(string2, new String[0]);
        try {
            Files.move(path, path2, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static void moveFile(File file, File file2) {
        FileHelper.moveFile(file.getAbsolutePath(), file2.getAbsolutePath());
    }

    public static void moveFileViaCopyAndDelete(String string, String string2) {
        FileHelper.copyFile(string, string2);
        FileHelper.deleteFile(string);
    }

    public static void moveFileViaCopyAndDelete(File file, File file2) {
        FileHelper.moveFileViaCopyAndDelete(file.getAbsolutePath(), file2.getAbsolutePath());
    }

    public static void copyTree(String string, String string2) {
        FileHelper.copyTree(new File(string), new File(string2));
    }

    public static void copyTree(File file, String string) {
        FileHelper.copyTree(file, new File(string));
    }

    public static void copyTree(File file, File file2) {
        if (!file.exists()) {
            return;
        }
        FileHelper.createDirectoryIfNotExists(file2.getPath());
        for (File file3 : file.listFiles()) {
            String string;
            String string2;
            if (file3.isDirectory()) {
                string2 = FileHelper.getBareName(file3);
                string = FileHelper.concatPathes(file2, string2);
                FileHelper.createNotExistingDirectory(string);
                FileHelper.copyTree(file3, string);
                continue;
            }
            string2 = FileHelper.getBareName(file3);
            string = FileHelper.concatPathes(file2, string2);
            FileHelper.copyFile(file3, string);
        }
    }

    public static void moveTree(String string, String string2) {
        FileHelper.moveTree(new File(string), new File(string2));
    }

    public static void moveTree(File file, String string) {
        FileHelper.moveTree(file, new File(string));
    }

    public static void moveTree(File file, File file2) {
        FileHelper.copyTree(file, file2);
        FileHelper.deleteTree(file);
    }

    public static boolean exists(String string) {
        File file = new File(string);
        return file.exists();
    }

    public static boolean isFile(String string) {
        File file = new File(string);
        return file.isFile();
    }

    public static boolean isDirectory(String string) {
        File file = new File(string);
        return file.isDirectory();
    }

    public static boolean isNotADirectory(String string) {
        return !FileHelper.isDirectory(string);
    }

    public static void deleteFiles(List<String> list) {
        for (String string : list) {
            FileHelper.deleteFile(string);
        }
    }

    public static void deleteFilesPrintErrors(List<String> list) {
        for (String string : list) {
            FileHelper.deleteFilePrintError(string);
        }
    }

    public static void deleteFile(String string) {
        try {
            Files.delete(Paths.get(string, new String[0]));
        }
        catch (IOException iOException) {
            throw new IORuntimeException(string + " konnte nicht gel\u00f6scht werden!", iOException);
        }
    }

    public static void deleteFilePrintError(String string) {
        try {
            Files.delete(Paths.get(string, new String[0]));
        }
        catch (IOException iOException) {
            System.out.println("Die Datei\n\t" + string + "\nl\u00e4sst sich nicht l\u00f6schen: " + iOException.getMessage());
        }
    }

    public static void deleteFileIfExistent(String string) {
        if (FileHelper.exists(string)) {
            FileHelper.deleteFile(string);
        }
    }

    public static void deleteAllFilesInMainDirectory(String string) {
        List<String> list = FileHelper.findAllFilesInMainDirectoryNio2(string);
        for (String string2 : list) {
            FileHelper.deleteFile(string2);
        }
    }

    public static void deleteMostFilesInMainDirectory(String string, List<String> list) {
        List<String> list2 = FileHelper.findAllFilesInMainDirectoryNio2(string);
        for (String string2 : list2) {
            String string3 = FileHelper.getBareName(string2);
            if (list.contains(string3)) continue;
            FileHelper.deleteFile(string2);
        }
    }

    public static void copyAllFilesInMainDirectory(String string, String string2) {
        List<String> list = FileHelper.findAllFilesInMainDirectory(string);
        for (String string3 : list) {
            String string4 = FileHelper.getBareName(string3);
            String string5 = FileHelper.concatPathes(string2, string4);
            FileHelper.copyFile(string3, string5);
        }
    }

    public static void createEmptyFile(String string) {
        FineFileWriter fineFileWriter = new FineFileWriter(string);
        fineFileWriter.close();
    }

    public static void createEmptyFileIfNotExisting(String string) {
        if (!FileHelper.exists(string)) {
            FileHelper.createEmptyFile(string);
        }
    }

    public static void createEmptyFile(String string, Charset charset) {
        FineFileWriter fineFileWriter = new FineFileWriter(string, charset);
        fineFileWriter.close();
    }

    public static String readFileToString(String string) {
        FineFileReader fineFileReader = new FineFileReader(string);
        String string2 = fineFileReader.readFileToString();
        fineFileReader.close();
        return string2;
    }

    public static String readFileToString(String string, Charset charset) {
        FineFileReader fineFileReader = new FineFileReader(string, charset);
        String string2 = fineFileReader.readFileToString();
        fineFileReader.close();
        return string2;
    }

    public static String readFileToString(File file) {
        return FileHelper.readFileToString(file.getPath());
    }

    public static List<String> readFileToList(String string) {
        return FileHelper.readFromReaderToList(new FineFileReader(string));
    }

    public static List<String> readFileToList(String string, Charset charset) {
        return FileHelper.readFromReaderToList(new FineFileReader(string, charset));
    }

    public static List<String> readFileToListWithoutTitleLine(String string) {
        List<String> list = FileHelper.readFileToList(string);
        if (!list.isEmpty()) {
            list.remove(0);
        }
        return list;
    }

    private static List<String> readFromReaderToList(Reader reader) {
        List<String> list = reader.readFileToListOfStrings();
        reader.close();
        return list;
    }

    public static List<String> readFileToListIgnoreBlankAndCommentLines(String string) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        FineFileReader fineFileReader = new FineFileReader(string);
        while (null != (string2 = fineFileReader.readNextLine())) {
            String string3 = string2.trim();
            if (string3.isEmpty() || string3.startsWith("#")) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static List<List<String>> readFileToListOfFieldLines(String string) {
        return FileHelper.readFromReaderToListOfFieldLines(new FineFileReader(string));
    }

    public static List<List<String>> readFileToListOfFieldLines(String string, Charset charset) {
        return FileHelper.readFromReaderToListOfFieldLines(new FineFileReader(string, charset));
    }

    private static List<List<String>> readFromReaderToListOfFieldLines(Reader reader) {
        List<List<String>> list = reader.readFileToListOfFieldLines();
        reader.close();
        return list;
    }

    public static byte[] readBinaryFileToByteArray(String string) {
        try {
            return FileHelper.tryToReadBinaryFileToByteArray(string);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static byte[] tryToReadBinaryFileToByteArray(String string) throws IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = file.length();
        byte[] byArray = new byte[(int)l];
        ((InputStream)fileInputStream).read(byArray);
        ((InputStream)fileInputStream).close();
        return byArray;
    }

    public static String readLastNotEmptyLine(String string) {
        List<String> list = FileHelper.readFileToList(string);
        for (int i = list.size() - 1; i >= 0; --i) {
            String string2 = list.get(i);
            if (string2.isEmpty()) continue;
            return string2;
        }
        return "";
    }

    public static void backupFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            long l = file.lastModified();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(new Date(l));
            String string2 = String.format("_%1$tY%1$tm%1$td", gregorianCalendar);
            String string3 = FileHelper.insertBeforeExtension(string, string2);
            FileHelper.copyFile(string, string3);
        }
    }

    public static String insertBeforeExtension(String string, String string2) {
        String string3;
        String string4 = FileHelper.getDirName(string);
        String string5 = FileHelper.getBareName(string);
        int n = string5.lastIndexOf(".");
        if (n > -1) {
            String string6 = string5.substring(0, n);
            String string7 = string5.substring(n);
            string3 = string6 + string2 + string7;
        } else {
            string3 = string5 + string2;
        }
        if (string4.isEmpty()) {
            return string3;
        }
        return FileHelper.concatPathes(string4, string3);
    }

    public static String removeBeforeExtension(String string, String string2) {
        String string3;
        String string4 = FileHelper.getDirName(string);
        String string5 = FileHelper.getBareName(string);
        int n = string5.lastIndexOf(".");
        if (n > -1) {
            string3 = string5.substring(0, n);
            if (!string3.endsWith(string2)) {
                throw new IllegalArgumentException("In '" + string + "' befindet sich kein '" + string2 + "' vor der Extension.");
            }
        } else {
            throw new IllegalArgumentException("In '" + string + "' gibt es keine Extension.");
        }
        String string6 = string3.substring(0, string3.length() - string2.length());
        String string7 = string5.substring(n);
        String string8 = string6 + string7;
        if (string4.isEmpty()) {
            return string8;
        }
        return FileHelper.concatPathes(string4, string8);
    }

    public static String removeExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String removeAllFromLastUnderline(String string) {
        int n = string.lastIndexOf("_");
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String determineExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n > -1) {
            return string.substring(n);
        }
        return NO_EXTENSION_FOUND;
    }

    public static void writeTextToFile(String string, String string2) {
        FineFileWriter fineFileWriter = new FineFileWriter(string2);
        if (!string.isBlank()) {
            fineFileWriter.writeln(string);
        }
        fineFileWriter.close();
    }

    public static void writeTextToFile(String string, String string2, Charset charset) {
        FineFileWriter fineFileWriter = new FineFileWriter(string2, charset);
        fineFileWriter.writeln(string);
        fineFileWriter.close();
    }

    public static void writeTextToFileWithDate(String string, String string2, String string3) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string4 = String.format("%1$tY%1$tm%1$td_%1$tH%1$tM%1$tS", gregorianCalendar);
        FileHelper.writeTextToFile(string, string2 + string4 + string3);
    }

    public static void writeLinesToFile(List<String> list, String string) {
        FileHelper.writeLinesToWriter(new FineFileWriter(string), list);
    }

    public static void writeLinesToFile(List<String> list, String string, Charset charset) {
        FileHelper.writeLinesToWriter(new FineFileWriter(string, charset), list);
    }

    public static void writeLinesToUCS2LeBom(List<String> list, String string) {
        FileHelper.writeLinesToFileWithByteOrderMask(list, string, Charset.UTF_16LE, "\ufeff");
    }

    public static void writeLinesToUTF8Bom(List<String> list, String string) {
        FileHelper.writeLinesToFileWithByteOrderMask(list, string, Charset.UTF_8, "\ufeff");
    }

    public static void writeLinesToFileWithByteOrderMask(List<String> list, String string, Charset charset, String string2) {
        FineFileWriter fineFileWriter = new FineFileWriter(string, charset);
        fineFileWriter.write(string2);
        FileHelper.writeLinesToWriter(fineFileWriter, list);
    }

    private static void writeLinesToWriter(Writer writer, List<String> list) {
        writer.writeAllLines(list);
        writer.close();
    }

    public static void writeTextToUCS2LeBom(String string, String string2) {
        FileHelper.writeTextToFileWithByteOrderMask(string, string2, Charset.UTF_16LE, "\ufeff");
    }

    public static void writeTextToUTF8Bom(String string, String string2) {
        FileHelper.writeTextToFileWithByteOrderMask(string, string2, Charset.UTF_8, "\ufeff");
    }

    public static void writeTextToFileWithByteOrderMask(String string, String string2, Charset charset, String string3) {
        FineFileWriter fineFileWriter = new FineFileWriter(string2, charset);
        fineFileWriter.write(string3);
        fineFileWriter.writeln(string);
        fineFileWriter.close();
    }

    public static void appendLineToFile(String string, String string2) {
        FineFileWriter fineFileWriter = new FineFileWriter(string2, true);
        fineFileWriter.writeln(string);
        fineFileWriter.close();
    }

    public static void appendLineToFile(String string, String string2, Charset charset) {
        FineFileWriter fineFileWriter = new FineFileWriter(string2, charset, true);
        fineFileWriter.writeln(string);
        fineFileWriter.close();
    }

    public static void appendLinesToFile(List<String> list, String string, Charset charset) {
        FineFileWriter fineFileWriter = new FineFileWriter(string, charset, true);
        for (String string2 : list) {
            fineFileWriter.writeln(string2);
        }
        fineFileWriter.close();
    }

    public static boolean moveFileByRenameTo(String string, String string2) {
        if (string.equals(string2)) {
            return false;
        }
        File file = new File(string);
        File file2 = new File(string2);
        return file.renameTo(file2);
    }

    public static boolean moveFileByFilesMove(String string, String string2) {
        if (string.equals(string2)) {
            return false;
        }
        Path path = Paths.get(string, new String[0]);
        Path path2 = Paths.get(string2, new String[0]);
        try {
            Files.move(path, path2, new CopyOption[0]);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void copyTextFileByReadAndWrite(String string, String string2) {
        String string3;
        if (string.equals(string2)) {
            return;
        }
        FineFileReader fineFileReader = new FineFileReader(string);
        FineFileWriter fineFileWriter = new FineFileWriter(string2);
        while (null != (string3 = fineFileReader.readNextLine())) {
            fineFileWriter.writeln(string3);
        }
        fineFileWriter.close();
        fineFileReader.close();
    }

    public static String concatPathes(String string, String string2) {
        boolean bl;
        boolean bl2 = string.endsWith("/") || string.endsWith("\\");
        boolean bl3 = bl = string2.startsWith("/") || string2.startsWith("\\");
        if (bl2 && bl) {
            String string3 = string.substring(0, string.length() - 1);
            return string3 + string2;
        }
        if (bl2 || bl) {
            return string + string2;
        }
        return string + File.separator + string2;
    }

    public static String concatPathes(File file, String string) {
        return FileHelper.concatPathes(file.getPath(), string);
    }

    public static String concatPathes(String string, File file) {
        return FileHelper.concatPathes(string, file.getPath());
    }

    public static String concatPathes(File file, File file2) {
        return FileHelper.concatPathes(file.getPath(), file2.getPath());
    }

    public static String concatPathesMultiple(String ... stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        String string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string = FileHelper.concatPathes(string, stringArray[i]);
        }
        return string;
    }

    public static List<String> splitCsvSemikolonLine(String string) {
        if (!string.startsWith("\"")) {
            throw new IllegalArgumentException("Die zum Aufsplitten \u00fcbergebene Zeile beginnt nicht mit einem Anf\u00fchrungzeichen!\n\tZeile: " + string);
        }
        if (!string.endsWith("\"")) {
            throw new IllegalArgumentException("Die zum Aufsplitten \u00fcbergebene Zeile wird nicht von einem Anf\u00fchrungzeichen beendet!\n\tZeile: " + string);
        }
        String string2 = string.substring(1, string.length() - 1);
        return Arrays.asList(string2.split("\";\"", -1));
    }

    public static List<String> findInDirWithoutPath(String string, FilenameFilter filenameFilter) {
        List<String> list = FileHelper.findInDir(string, filenameFilter);
        return FileHelper.removePath(list);
    }

    private static List<String> removePath(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = FileHelper.getBareName(string);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static List<String> findInDir(String string, FilenameFilter filenameFilter) {
        return FileHelper.findInDir(new File(string), filenameFilter);
    }

    public static List<String> findInDir(File file, FilenameFilter filenameFilter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file2 : file.listFiles(filenameFilter)) {
            arrayList.add(file2.getPath());
        }
        return arrayList;
    }

    public static DateAndTime fileLastModifiedAsDateAndTime(String string) {
        String string2 = FileHelper.fileLastModified(string);
        String string3 = string2.substring(0, 8);
        ImmutualDate immutualDate = new ImmutualDate(string3);
        Object object = string2.substring(9);
        if (((String)object).length() != 6) {
            throw new RuntimeException("Die ermittelte Zeit hat nicht sechs Stellen\n\tfilename                 = '" + string + "'\n\tdateAndTimeString        = '" + string2 + "'\n\tlastModifiedDateYyyyMmDd = '" + string3 + "'\n\tlastModifiedDate         = '" + immutualDate + "'\n\tlastModifiedDateHhMmSs   = '" + (String)object + "'\n");
        }
        object = ((String)object).substring(0, 2) + ":" + ((String)object).substring(2, 4) + ":" + ((String)object).substring(4, 6);
        ImmutualTime immutualTime = new ImmutualTime((String)object);
        return new DateAndTime(immutualDate, immutualTime);
    }

    public static DateAndTimeString fileLastModifiedAsDateAndTimeString(String string) {
        String string2 = FileHelper.fileLastModified(string);
        int n = string2.indexOf("_");
        if (n == -1) {
            throw new RuntimeException("Keinen Unterstrich im Timestamp gefunden, den FileHelper.fileLastModified() liefert.\n\tfilename : " + string + "\n\ttimestamp: " + string2 + "\n");
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        ImmutualDate immutualDate = DateHelper.getDateFromYYYYMMDD(string3);
        string3 = immutualDate.toString();
        string4 = TimeHelper.insertTimeColonsHHMMSS(string4);
        return new DateAndTimeString(string3, string4);
    }

    public static String fileLastModified(String string) {
        return FileHelper.fileLastModified(new File(string));
    }

    public static String fileLastModified(File file) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        return simpleDateFormat.format(FileHelper.fileLastModifiedAsMillis(file));
    }

    public static long fileLastModifiedAsMillis(String string) {
        return FileHelper.fileLastModifiedAsMillis(new File(string));
    }

    public static long fileLastModifiedAsMillis(File file) {
        return file.lastModified();
    }

    public static void setLastModified(String string, String string2, String string3) {
        long l = FileHelper.dateAndTimeToMillisecondsSinceEpoche(string2, string3);
        FileHelper.setLastModified(string, l);
    }

    public static long dateAndTimeToMillisecondsSinceEpoche(String string, String string2) {
        try {
            return FileHelper.tryToDateAndTimeToMillisecondsSinceEpoche(string, string2);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static long tryToDateAndTimeToMillisecondsSinceEpoche(String string, String string2) throws ParseException {
        String string3 = string + " " + string2;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        Date date = simpleDateFormat.parse(string3);
        long l = date.getTime();
        return l;
    }

    public static void setLastModified(String string, long l) {
        FileHelper.setLastModified(new File(string), l);
    }

    private static void setLastModified(File file, long l) {
        if (file.isFile()) {
            file.setLastModified(l);
        }
    }

    public static void setCreationLastModifiedAndLastAccessTime(String string, String string2, String string3) {
        long l = FileHelper.dateAndTimeToMillisecondsSinceEpoche(string2, string3);
        FileHelper.setCreationLastModifiedAndLastAccessTime(string, l);
    }

    public static void setCreationLastModifiedAndLastAccessTime(String string, long l) {
        try {
            FileHelper.tryToSetCreationLastModifiedAndLastAccessTime(string, l);
        }
        catch (Exception exception) {
            throw new RuntimeException("Die Zeitpunkte der Erstellung, der letzten Modifikation und des letzten Zugriffs der Datei konnten nicht gesetzt werden.\n\tfilename = " + string + "\n\tmilliseconds = " + l + "\n", exception);
        }
    }

    private static void tryToSetCreationLastModifiedAndLastAccessTime(String string, long l) throws IOException {
        BasicFileAttributeView basicFileAttributeView = Files.getFileAttributeView(Paths.get(string, new String[0]), BasicFileAttributeView.class, new LinkOption[0]);
        FileTime fileTime = FileTime.fromMillis(l);
        basicFileAttributeView.setTimes(fileTime, fileTime, fileTime);
    }

    public static boolean isDirectoryEmpty(String string) {
        File file = new File(string);
        int n = file.listFiles().length;
        return 0 == n;
    }

    public static boolean isEmptyDirectory(String string) {
        return FileHelper.isDirectory(string) && FileHelper.isDirectoryEmpty(string);
    }

    public static boolean isFileEmpty(String string) {
        String string2 = FileHelper.readFileToString(string);
        return string2.isEmpty();
    }

    public static boolean isEmptyFile(String string) {
        return FileHelper.isFile(string) && FileHelper.isFileEmpty(string);
    }

    public static boolean hasDirectorySubdirectories(String string) {
        if (!FileHelper.isDirectory(string)) {
            return false;
        }
        File file = new File(string);
        for (File file2 : file.listFiles()) {
            if (!file2.isDirectory()) continue;
            return true;
        }
        return false;
    }

    public static File createTempFile(String string, String string2) {
        try {
            return File.createTempFile(string, string2);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static String normalisePath(String string) {
        try {
            File file = new File(string);
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static String getSystemDisplayName(String string) {
        File file = new File(string);
        if (!file.exists()) {
            throw new RuntimeException("Die Datei oder das Verzeichnis '" + string + "' existiert nicht!");
        }
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        String string2 = string.toUpperCase();
        for (File file2 : File.listRoots()) {
            String string3 = file2.getPath();
            String string4 = string3.toUpperCase();
            if (!string2.startsWith(string4)) continue;
            String string5 = fileSystemView.getSystemDisplayName(file2);
            if (string5.matches(".* \\([A-Z]:\\)")) {
                string5 = string5.substring(0, string5.length() - 5);
            }
            return string5;
        }
        throw new RuntimeException("Zur Datei oder das Verzeichnis '" + string + "' konnte die Laufwerksbezeichnung nicht ermittelt werden!");
    }

    public static String buildFilenameFromPath(String string) {
        String string2 = string;
        string2 = string2.replace(":", "");
        string2 = string2.replace("\\", "_");
        string2 = string2.replace("/", "_");
        string2 = string2.replace(";", "_");
        string2 = string2.replaceAll("^_+", "");
        return string2;
    }

    public static long fileSize(File file) {
        if (!file.isFile()) {
            throw new IORuntimeException("Die Datei '" + file.getPath() + "', deren L\u00e4nge ermittelt wird, ist keine Datei im Dataeisystem!");
        }
        return file.length();
    }

    public static long fileSize(String string) {
        return FileHelper.fileSize(new File(string));
    }

    public static long freeDiscSpace(String string) {
        return FileHelper.freeDiscSpace(new File(string));
    }

    public static long freeDiscSpace(File file) {
        return file.getUsableSpace();
    }

    public static long totalDiscSpace(String string) {
        return FileHelper.totalDiscSpace(new File(string));
    }

    public static long totalDiscSpace(File file) {
        return file.getTotalSpace();
    }

    public static boolean filesAreEqualEnough(File file, File file2) {
        return FileHelper.filesHaveSameLastModifiedTime(file, file2) && FileHelper.filesHaveEqualSize(file, file2);
    }

    public static boolean filesAreEqualEnough(String string, String string2) {
        return FileHelper.filesAreEqualEnough(new File(string), new File(string2));
    }

    public static boolean filesHaveSameLastModifiedTime(File file, File file2) {
        String string = FileHelper.fileLastModified(file);
        String string2 = FileHelper.fileLastModified(file2);
        return string.equals(string2);
    }

    public static boolean filesHaveSameLastModifiedTime(String string, String string2) {
        return FileHelper.filesHaveSameLastModifiedTime(new File(string), new File(string2));
    }

    public static boolean filesHaveEqualSize(File file, File file2) {
        long l;
        long l2 = FileHelper.fileSize(file);
        return l2 == (l = FileHelper.fileSize(file2));
    }

    public static boolean filesHaveEqualSize(String string, String string2) {
        return FileHelper.filesHaveEqualSize(new File(string), new File(string2));
    }

    public static String exchangeExtension(String string, String string2) {
        int n = string.lastIndexOf(".");
        if (0 > n) {
            throw new IllegalArgumentException("Der Dateiname '" + string + "' enth\u00e4lt keinen Punkt.");
        }
        if (0 == n) {
            throw new IllegalArgumentException("Der Dateiname '" + string + "' startet mit einem Punkt und das ist auch der einzige Punkt.");
        }
        String string3 = string.substring(n + 1);
        if (string3.isEmpty()) {
            throw new IllegalArgumentException("Der Dateiname '" + string + "' endet auf einen Punkt.");
        }
        if (Text.containsOnlyNormalLettersOrDigits(string3)) {
            String string4 = string.substring(0, n);
            String string5 = string2.startsWith(".") ? string4 + string2 : string4 + "." + string2;
            if (string.equals(string5)) {
                throw new IllegalArgumentException("Der neue Dateiname ist gleich dem \u00fcbergebenen Dateinamen!\n\tfilename     = " + string + "\n\tnewExtension = " + string2 + "\n\tnewFilename  = " + string5);
            }
            return string5;
        }
        throw new IllegalArgumentException("Die Endung '" + string3 + "' des Dateinamens '" + string + "' ist seltsam.");
    }

    public static String replaceUncPathes(String string) {
        String string2 = string;
        string2 = string2.replace("\\\\Cluster1\\user1\\CD", "u:");
        string2 = string2.replace("\\\\Cluster1\\User1\\CD", "u:");
        string2 = string2.replace("\\\\Cluster2\\Projekte2\\Schufa\\Impressum", "i:");
        string2 = string2.replace("\\\\Cluster1\\Projekte1", "r:");
        string2 = string2.replace("\\\\Cluster2\\Projekte2", "s:");
        return string2;
    }

    public static String readAndRemoveIndentation(String string, Charset charset) {
        FineFileReader fineFileReader = new FineFileReader(string, charset);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = fineFileReader.readNextLine();
        while (string2 != null) {
            stringBuilder.append(string2.trim());
            stringBuilder.append(Text.LINE_BREAK);
            string2 = fineFileReader.readNextLine();
        }
        fineFileReader.close();
        return stringBuilder.toString();
    }

    public static void cleanDirectory(String string) {
        FileHelper.deleteTree(string);
        FileHelper.createDirectory(string);
    }

    public static List<FileWithModificationTime> determineAllFilesInMainDirectoryDescendingByTime(String string) {
        List<String> list = FileHelper.findAllFilesInMainDirectoryNio2(string);
        ArrayList<FileWithModificationTime> arrayList = new ArrayList<FileWithModificationTime>();
        for (String string2 : list) {
            FileWithModificationTime fileWithModificationTime = new FileWithModificationTime(string2);
            arrayList.add(fileWithModificationTime);
        }
        Collections.sort(arrayList, new Comparator<FileWithModificationTime>(){

            @Override
            public int compare(FileWithModificationTime fileWithModificationTime, FileWithModificationTime fileWithModificationTime2) {
                String string = fileWithModificationTime.getModificationTime();
                String string2 = fileWithModificationTime2.getModificationTime();
                int n = string2.compareTo(string);
                if (n == 0) {
                    String string3 = fileWithModificationTime.getFilename();
                    String string4 = fileWithModificationTime2.getFilename();
                    n = string3.compareTo(string4);
                }
                return n;
            }
        });
        return arrayList;
    }

    public static String prepareToFilenamePart(String string) {
        String string2 = string;
        string2 = string2.replaceAll("[^_.A-Za-z0-9\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df-]", "_");
        string2 = string2.replaceAll("__+", "_");
        string2 = string2.replaceAll("^_+", "");
        string2 = string2.replaceAll("_+$", "");
        return string2;
    }

    public static void clearFile(String string, Charset charset) {
        FineFileWriter fineFileWriter = new FineFileWriter(string, charset);
        fineFileWriter.close();
    }

    public static String readFirstLine(String string) {
        return FileHelper.readFirstLine(string, Charset.ISO_8859_1);
    }

    public static String readFirstLine(String string, Charset charset) {
        FineFileReader fineFileReader = new FineFileReader(string, charset);
        String string2 = fineFileReader.readNextLine();
        if (string2 == null) {
            throw new RuntimeException("Die Datei '" + string + "' ist leer.");
        }
        fineFileReader.close();
        return string2;
    }

    public static String readFirstLineStartingWith(String string, Charset charset, String string2) {
        FineFileReader fineFileReader = new FineFileReader(string, charset);
        boolean bl = false;
        String string3 = "";
        while (!bl && null != (string3 = fineFileReader.readNextLine())) {
            if (!string3.startsWith(string2)) continue;
            bl = true;
        }
        fineFileReader.close();
        if (bl) {
            return string3;
        }
        return "";
    }

    public static void copyFirstNLinesOfTextFile(String string, String string2, Charset charset, int n) {
        String string3;
        FineFileWriter fineFileWriter = new FineFileWriter(string2, charset);
        FineFileReader fineFileReader = new FineFileReader(string, charset);
        int n2 = 0;
        while (null != (string3 = fineFileReader.readNextLine()) && ++n2 <= n) {
            fineFileWriter.writeln(string3);
        }
        fineFileReader.close();
        fineFileWriter.close();
    }

    public static String copyFileToBackupIfExisting(String string, String string2, int n) {
        boolean bl = false;
        boolean bl2 = false;
        return FileHelper.copyOrMoveFileToBackupIfExisting(string, string2, n, bl, bl2);
    }

    public static String moveFileToBackupIfExisting(String string, String string2, int n) {
        boolean bl = true;
        boolean bl2 = false;
        return FileHelper.copyOrMoveFileToBackupIfExisting(string, string2, n, bl, bl2);
    }

    public static String moveFileToBackupInSubdirectoryIfExisting(String string, String string2, int n) {
        boolean bl = true;
        boolean bl2 = true;
        return FileHelper.copyOrMoveFileToBackupIfExisting(string, string2, n, bl, bl2);
    }

    private static String copyOrMoveFileToBackupIfExisting(String string, String string2, int n, boolean bl, boolean bl2) {
        String string3 = "";
        if (FileHelper.exists(string)) {
            int n2 = 0;
            boolean bl3 = true;
            while (bl3) {
                string3 = FileHelper.insertBeforeExtension(string, "_" + string2 + "_" + NumberString.addLeadingZeroes(++n2, n));
                if (bl2) {
                    String string4 = FileHelper.getDirName(string3);
                    String string5 = FileHelper.getBareName(string3);
                    String string6 = FileHelper.concatPathesMultiple(string4, string2);
                    FileHelper.createDirectoryIfNotExists(string6);
                    string3 = FileHelper.concatPathesMultiple(string6, string5);
                }
                if (FileHelper.exists(string3)) continue;
                bl3 = false;
                if (bl) {
                    FileHelper.moveFile(string, string3);
                    continue;
                }
                FileHelper.copyFile(string, string3);
            }
        }
        return string3;
    }

    public static List<String> readStringsFromExternalTextFile(String string, Charset charset) {
        StringsFromNormalTextFileReader stringsFromNormalTextFileReader = new StringsFromNormalTextFileReader(string, charset, "#");
        stringsFromNormalTextFileReader.beQuiet();
        return stringsFromNormalTextFileReader.read();
    }

    public static List<String> readFromExternalFileSortByLengthDescanding(String string, Charset charset) {
        List<String> list = FileHelper.readStringsFromExternalTextFile(string, charset);
        CollectionsHelper.sortStringListByLengthDescanding(list);
        return list;
    }

    public static List<String> readStringsFromTextFileInJar(String string) {
        return FileHelper.readStringsFromTextFileInJar(string, 1);
    }

    public static List<String> readStringsFromTextFileInJar(String string, int n) {
        StringsFromTextFileInJarReader stringsFromTextFileInJarReader = new StringsFromTextFileInJarReader(string, CallerDeterminer.determineCallingClass(n));
        stringsFromTextFileInJarReader.beQuiet();
        return stringsFromTextFileInJarReader.read();
    }

    public static List<String> readStringsFromTextFileInJarAndSortByLengthDescanding(String string) {
        List<String> list = FileHelper.readStringsFromTextFileInJar(string, 1);
        CollectionsHelper.sortStringListByLengthDescanding(list);
        return list;
    }

    public static Dictionary readDictionaryTextFileInJar(String string) {
        return FileHelper.readDictionaryTextFileInJar(string, 1);
    }

    public static Dictionary readDictionaryTextFileInJar(String string, int n) {
        DictionaryFromTextFileInJarReader dictionaryFromTextFileInJarReader = new DictionaryFromTextFileInJarReader(string, CallerDeterminer.determineCallingClass(n));
        dictionaryFromTextFileInJarReader.beQuiet();
        dictionaryFromTextFileInJarReader.read();
        return dictionaryFromTextFileInJarReader.getDictionary();
    }

    public static Dictionary readDictionaryFromNormalTextFile(String string, Charset charset) {
        DictionaryFromNormalTextFileReader dictionaryFromNormalTextFileReader = new DictionaryFromNormalTextFileReader(string, charset);
        dictionaryFromNormalTextFileReader.beQuiet();
        dictionaryFromNormalTextFileReader.read();
        return dictionaryFromNormalTextFileReader.getDictionary();
    }

    public static Dictionary readDictionaryFromNormalTextFileMultipleEqualValuesAreErrors(String string, Charset charset) {
        DictionaryFromNormalTextFileReader dictionaryFromNormalTextFileReader = new DictionaryFromNormalTextFileReader(string, charset);
        dictionaryFromNormalTextFileReader.beQuiet();
        dictionaryFromNormalTextFileReader.multipleEqualValuesAreError();
        dictionaryFromNormalTextFileReader.read();
        return dictionaryFromNormalTextFileReader.getDictionary();
    }

    public static String replaceForbiddenFilenameCharacters(String string, String string2) {
        String string3 = string;
        for (String string4 : FORBIDDEN_FILENAME_CHARACTERS) {
            string3 = string3.replace(string4, string2);
        }
        return string3;
    }

    public static String readFileInJarBesideJavaClass(Class<?> clazz, String string) {
        List<String> list = FileHelper.readFileInJarBesideJavaClassAsList(clazz, string);
        return Text.join("\n", list);
    }

    public static List<String> readFileInJarBesideJavaClassAsList(Class<?> clazz, String string) {
        try {
            return FileHelper.tryToRreadFileInJarBesideJavaClassAsList(clazz, string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Fehler beim Lesen der Datei '" + string + "' aus dem Jar.", exception);
        }
    }

    private static List<String> tryToRreadFileInJarBesideJavaClassAsList(Class<?> clazz, String string) throws IOException {
        String string2;
        InputStream inputStream = clazz.getResourceAsStream(string);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (null != (string2 = bufferedReader.readLine())) {
            arrayList.add(string2);
        }
        bufferedReader.close();
        return arrayList;
    }

    public static Lines readFileInJarBesideJavaClassAsLines(Class<?> clazz, String string) {
        List<String> list = FileHelper.readFileInJarBesideJavaClassAsList(clazz, string);
        return new Lines(list);
    }

    public static void writeTitlesAndValues(List<String> list, List<List<String>> list2, String string) {
        FileHelper.writeTitlesAndValues(new FineFileWriter(string), list, list2);
    }

    public static void writeTitlesAndValues(List<String> list, List<List<String>> list2, String string, Charset charset) {
        FileHelper.writeTitlesAndValues(new FineFileWriter(string, charset), list, list2);
    }

    private static void writeTitlesAndValues(FineFileWriter fineFileWriter, List<String> list, List<List<String>> list2) {
        if (!list.isEmpty()) {
            fineFileWriter.writeFieldsLine(list);
        }
        for (List<String> list3 : list2) {
            fineFileWriter.writeFieldsLine(list3);
        }
        fineFileWriter.close();
    }

    public static void writeDataWithTitlesAndValuesToFile(String string, List<? extends DataWithTitlesAndValues> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<List<String>> arrayList2 = new ArrayList<List<String>>();
        if (!list.isEmpty()) {
            DataWithTitlesAndValues dataWithTitlesAndValues = list.get(0);
            arrayList.addAll(dataWithTitlesAndValues.titles());
        }
        for (DataWithTitlesAndValues dataWithTitlesAndValues : list) {
            arrayList2.add(dataWithTitlesAndValues.values());
        }
        FileHelper.writeTitlesAndValues(arrayList, arrayList2, string);
    }

    public static void writeDataWithTitlesAndValuesToFile(String string, Charset charset, List<? extends DataWithTitlesAndValues> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<List<String>> arrayList2 = new ArrayList<List<String>>();
        if (!list.isEmpty()) {
            DataWithTitlesAndValues dataWithTitlesAndValues = list.get(0);
            arrayList.addAll(dataWithTitlesAndValues.titles());
        }
        for (DataWithTitlesAndValues dataWithTitlesAndValues : list) {
            arrayList2.add(dataWithTitlesAndValues.values());
        }
        FileHelper.writeTitlesAndValues(arrayList, arrayList2, string, charset);
    }

    public static void writeDataWithTitlesAndValuesToFile(String string, List<? extends DataWithTitlesAndValues> list, List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<List<String>> arrayList2 = new ArrayList<List<String>>();
        if (list.isEmpty()) {
            arrayList.addAll(list2);
        } else {
            DataWithTitlesAndValues dataWithTitlesAndValues = list.get(0);
            arrayList.addAll(dataWithTitlesAndValues.titles());
        }
        for (DataWithTitlesAndValues dataWithTitlesAndValues : list) {
            arrayList2.add(dataWithTitlesAndValues.values());
        }
        FileHelper.writeTitlesAndValues(arrayList, arrayList2, string);
    }

    public static void writeDataWithTitlesAndValuesToFile(String string, String string2, List<? extends DataWithTitlesAndValues> list) {
        String string3 = FileHelper.concatPathes(string2, string);
        FileHelper.writeDataWithTitlesAndValuesToFile(string3, list);
    }

    public static void createOneBackupFile(String string) {
        String string2 = FileHelper.insertBeforeExtension(string, "_backup");
        if (FileHelper.exists(string)) {
            FileHelper.copyFile(string, string2);
        }
    }

    public static boolean isBareFilename(String string) {
        if (string.contains("/")) {
            return false;
        }
        return !string.contains("\\");
    }

    public static List<String> getFilesWithGivenBareFilename(List<String> list, String string) {
        if (!FileHelper.isBareFilename(string)) {
            throw new IllegalArgumentException("Der \u00fcbergebene Dateiname ohne Pfad enth\u00e4lt einen Pfad: " + string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            if (FileHelper.isBareFilename(string2)) {
                throw new IllegalArgumentException("Der Dateiname in der liste enth\u00e4lt keinen Pfad: " + string2);
            }
            String string3 = FileHelper.getBareName(string2);
            if (!string3.equals(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static List<String> getFilesWithGivenExtension(List<String> list, String string) {
        Object object = string.startsWith(".") ? string : "." + string;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            if (!string2.endsWith((String)object)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static List<String> filenamesToBareFilenames(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = FileHelper.getBareName(string);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static List<String> createExistingFileList(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (!FileHelper.isFile(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static boolean endsWithExtension(String string, String string2) {
        return FileHelper.endsWithOneOfMultipleExtensions(string, CollectionsHelper.buildListFrom(string2));
    }

    public static boolean endsWithOneOfMultipleExtensions(String string, List<String> list) {
        String string2 = Text.toLowerCase(string);
        for (String string3 : list) {
            if (!string2.endsWith(string3)) continue;
            return true;
        }
        return false;
    }

    public static boolean commandStartsWithExistingFilename(String string) {
        if (string.isBlank()) {
            return false;
        }
        int n = string.indexOf(" ");
        if (n < 1) {
            return false;
        }
        String string2 = string.substring(0, n);
        return FileHelper.isFile(string2);
    }

    public static String findTheOneFileInMainDirectory(String string, String string2, String string3) {
        List<String> list = FileHelper.findAllFilesInMainDirectoryNio2(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string4 : list) {
            String string5 = FileHelper.getBareName(string4);
            if (!string5.startsWith(string2) || !string5.endsWith(string3)) continue;
            arrayList.add(string5);
        }
        if (arrayList.size() == 1) {
            return (String)arrayList.get(0);
        }
        throw new RuntimeException("Es wurde nicht genau eine Datei mit den gew\u00fcnschten Kriterien gefunden:\n\tdirectory                 = " + string + "\n\tbareNameStart             = " + string2 + "\n\tbareNameEnd               = " + string3 + "\n\tAnzahl gefundener Dateien : " + arrayList.size() + "\n" + CollectionsHelper.listListNice(arrayList));
    }

    public static void checkDirectoryExistence(String string) {
        if (!FileHelper.isDirectory(string)) {
            throw new RuntimeException("Das Verzeichnis '" + string + "' existiert nicht.");
        }
    }
}

