/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.lock;

import de.duehl.basics.io.lock.Lock;
import de.duehl.basics.system.SystemTools;

abstract class WaitingLock<T extends Lock>
implements Lock {
    private final int waitForLockSeconds;
    private final int sleepBeforeRetryMilliseconds;
    private final T lock;
    private long timeMillisAtStart;

    public WaitingLock(int n, int n2, T t) {
        this.waitForLockSeconds = n;
        this.sleepBeforeRetryMilliseconds = n2;
        this.lock = t;
    }

    @Override
    public boolean lock() {
        this.timeMillisAtStart = System.currentTimeMillis();
        boolean bl = this.lockLoop();
        return bl;
    }

    private boolean lockLoop() {
        boolean bl = this.lock.lock();
        while (!bl) {
            SystemTools.sleep(this.sleepBeforeRetryMilliseconds);
            if (this.lockTimeExceeded()) {
                return false;
            }
            bl = this.lock.lock();
        }
        return true;
    }

    private boolean lockTimeExceeded() {
        long l;
        long l2 = System.currentTimeMillis();
        long l3 = l2 - this.timeMillisAtStart;
        return l3 > (l = (long)this.waitForLockSeconds * 1000L);
    }

    @Override
    public boolean unlock() {
        boolean bl = this.lock.unlock();
        return bl;
    }

    @Override
    public String getFilename() {
        return this.lock.getFilename();
    }
}

