/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.logging;

import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.List;

public class LogEntry {
    private final String date;
    private final String time;
    private final String className;
    private final String method;
    private final String lineNumber;
    private final String message;

    public LogEntry(String string, String string2, String string3, String string4, String string5, String string6) {
        this.date = string;
        this.time = string2;
        this.className = string3;
        this.method = string4;
        this.lineNumber = string5;
        this.message = string6;
    }

    public LogEntry(String string) {
        List<String> list = Text.splitByTabulator(string);
        this.checkEnoughParts(string, list);
        this.date = list.get(0);
        this.time = list.get(1);
        this.className = list.get(2);
        this.method = list.get(3);
        this.lineNumber = list.get(4);
        if (list.size() > 6) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 5; i < list.size(); ++i) {
                arrayList.add(list.get(i));
            }
            this.message = Text.join("\t", arrayList);
        } else {
            this.message = list.get(5);
        }
    }

    private void checkEnoughParts(String string, List<String> list) {
        if (list.size() < 6) {
            throw new IllegalArgumentException("Die Zeile hat keine sechs mit Tabulatoren unterteilten Spalten.\n\tAnzahl Elemente : " + list.size() + "\n\tZeile           : '" + string + "'");
        }
    }

    public String getDate() {
        return this.date;
    }

    public String getTime() {
        return this.time;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethod() {
        return this.method;
    }

    public String getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "LogLineElement [date=" + this.date + ", time=" + this.time + ", className=" + this.className + ", method=" + this.method + ", lineNumber=" + this.lineNumber + ", message=" + this.message + "]";
    }

    public String toNiceString() {
        return "LogEntry:\n\tdate       : " + this.date + "\n\ttime       : " + this.time + "\n\tclassName  : " + this.className + "\n\tmethod     : " + this.method + "\n\tlineNumber : " + this.lineNumber + "\n\tmessage    : " + this.message;
    }

    public String asLine() {
        String string = this.message;
        string = Text.removeLineBreaks(string);
        string = Text.tabToSpace(string);
        return Text.join("\t", this.date, this.time, this.className, this.method, this.lineNumber, string);
    }

    public static String toNiceString(List<LogEntry> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            LogEntry logEntry = list.get(i);
            int n = i + 1;
            stringBuilder.append(Text.fillWithSpacesAtFront(Integer.toString(n), 4));
            stringBuilder.append(") ");
            stringBuilder.append(logEntry.toNiceString());
            stringBuilder.append(Text.LINE_BREAK);
        }
        return stringBuilder.toString();
    }
}

