/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.logging;

import de.duehl.basics.datetime.Timestamp;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.logging.FileLogger;
import de.duehl.basics.logging.Logger;
import de.duehl.basics.logging.eraser.LogEraser;
import de.duehl.basics.text.Text;

public class PlainMessageToFileLogger
implements Logger {
    private final String logFileName;

    public PlainMessageToFileLogger(String string) {
        this.logFileName = string;
        FileHelper.createEmptyFile(string);
    }

    @Override
    public void log(String string) {
        String string2 = string;
        string2 = Text.removeLineBreaks(string2);
        string2 = Text.tabToSpace(string2);
        FileLogger.checkNoLineBreaks(string2);
        FileHelper.appendLineToFile(string2, this.logFileName);
    }

    @Override
    public void log(String string, int n) {
        throw new RuntimeException("Der PlainMessageToFileLogger verwendet keinen Stacktrace!");
    }

    @Override
    public String getLogFileName() {
        return this.logFileName;
    }

    @Override
    public String getLogPath() {
        return FileHelper.getDirName(this.logFileName);
    }

    @Override
    public int getLastWrittenLineNumber() {
        throw new RuntimeException("Der PlainMessageToFileLogger merkt sich keine Zeilennummern!");
    }

    public static Logger create(String string, String string2, String string3) {
        FileLogger.checkIfPathExistsAndIsDirectory(string3);
        String string4 = string + Timestamp.fullTimestamp() + string2;
        String string5 = FileHelper.concatPathes(string3, string4);
        PlainMessageToFileLogger plainMessageToFileLogger = new PlainMessageToFileLogger(string5);
        LogEraser logEraser = new LogEraser(string3, string, string2, plainMessageToFileLogger);
        logEraser.erase();
        return plainMessageToFileLogger;
    }
}

