/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.logging;

import de.duehl.basics.datetime.DateAndTime;
import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.time.ImmutualTime;
import de.duehl.basics.logging.LogEntry;
import de.duehl.basics.logging.NumberOfLinesLogger;

abstract class StructuredLogger
extends NumberOfLinesLogger {
    private LogEntry lastLogEntry = new LogEntry("noch", "nicht", "initialisiert", "!", "!", "!");
    private String actualDate;
    private String actualTime;
    private String className;
    private String methodName;
    private String lineNumber;
    private String message;

    StructuredLogger() {
    }

    @Override
    public void log(String string) {
        this.log(string, 1);
    }

    @Override
    public synchronized void log(String string, int n) {
        this.message = string;
        this.setActualDateAndTime();
        this.setClassNameMethodNameAndLineNumber(n);
        this.buildElement();
    }

    private void setActualDateAndTime() {
        DateAndTime dateAndTime = new DateAndTime();
        ImmutualTime immutualTime = dateAndTime.getTime();
        this.actualTime = immutualTime.toString();
        ImmutualDate immutualDate = dateAndTime.getDate();
        this.actualDate = immutualDate.toString();
    }

    private void setClassNameMethodNameAndLineNumber(int n) {
        int n2;
        this.className = "dummyClass";
        this.methodName = "dummyMethod";
        this.lineNumber = "x";
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray.length > (n2 = 4 + n)) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            this.className = stackTraceElement.getClassName();
            this.methodName = stackTraceElement.getMethodName();
            this.lineNumber = Integer.toString(stackTraceElement.getLineNumber());
        }
    }

    private void buildElement() {
        this.lastLogEntry = new LogEntry(this.actualDate, this.actualTime, this.className, this.methodName, this.lineNumber, this.message);
        this.incrementNumberOfLinesInLogfile();
    }

    protected LogEntry getLastLogEntry() {
        return this.lastLogEntry;
    }
}

