/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.persistence;

import de.duehl.basics.io.FileHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

public class SessionManagerHelper {
    private final String sessionfileName;

    public SessionManagerHelper(String string) {
        this.sessionfileName = string;
    }

    public Properties readProperties() {
        try {
            return this.tryToReadProperties();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Fehler beim Einlesen des Sessionfiles " + this.sessionfileName + ".", exception);
        }
    }

    private Properties tryToReadProperties() throws IOException, InvalidPropertiesFormatException, FileNotFoundException {
        Properties properties = new Properties();
        properties.loadFromXML(new FileInputStream(this.sessionfileName));
        return properties;
    }

    public void writeProperties(Properties properties) {
        try {
            this.tryToWriteProperties(properties);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Sessionfile " + this.sessionfileName + " wurde  nicht gefunden: " + fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Sessionfile " + this.sessionfileName + " konnte nicht geschrieben werden: " + iOException.getMessage(), iOException);
        }
    }

    private void tryToWriteProperties(Properties properties) throws IOException, FileNotFoundException {
        properties.storeToXML(new FileOutputStream(this.sessionfileName), "");
    }

    public boolean sessionfileExists() {
        return FileHelper.isFile(this.sessionfileName);
    }
}

