/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.system.launcher;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.system.SystemTools;
import de.duehl.basics.system.launcher.data.JarWithVersion;
import de.duehl.basics.version.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class NewestJarDeterminer {
    private final String jarNameStart;
    private final String currentWorkingDirectory;
    private boolean removeOldJars;
    private boolean jarFound;
    private String newestJarFilename;

    public NewestJarDeterminer(String string) {
        this.jarNameStart = string;
        this.currentWorkingDirectory = SystemTools.getCurrentWorkingDirectory();
        this.removeOldJars = false;
    }

    public void removeOldJars() {
        this.removeOldJars = true;
    }

    public void determine() {
        List<String> list = this.findJarFiles();
        if (list.isEmpty()) {
            this.jarFound = false;
            this.newestJarFilename = "";
        } else if (list.size() == 1) {
            this.jarFound = true;
            this.newestJarFilename = list.get(0);
        } else {
            List<JarWithVersion> list2 = this.createJarsWithVersions(list);
            if (list2.size() != list.size()) {
                throw new RuntimeException("Die erzeugte Liste mit den Jars und Versionsnummern\nhat nicht die gleiche Gr\u00f6\u00dfe wie die Liste der Dateinamen der Jars.\n\tjarFilenames.size()     = " + list.size() + "\n\tjarsWithVersions.size() = " + list2.size() + "\njarFilenames:\n" + CollectionsHelper.listListNiceWithoutBrackets(list) + "jarsWithVersions:\n" + CollectionsHelper.listListNiceWithoutBrackets(list2));
            }
            this.sortJarsWithVersionsByVersion(list2);
            JarWithVersion jarWithVersion = list2.get(list2.size() - 1);
            this.jarFound = true;
            this.newestJarFilename = jarWithVersion.getJarFilename();
            if (this.removeOldJars) {
                list.remove(this.newestJarFilename);
                FileHelper.deleteFilesPrintErrors(list);
            }
        }
    }

    private List<String> findJarFiles() {
        return FileHelper.findFilesInMainDirectoryNio2(this.currentWorkingDirectory, this.jarNameStart, ".jar");
    }

    private List<JarWithVersion> createJarsWithVersions(List<String> list) {
        ArrayList<JarWithVersion> arrayList = new ArrayList<JarWithVersion>();
        for (String string : list) {
            String string2 = Version.extractVersionFromJarFilename(string, this.jarNameStart);
            JarWithVersion jarWithVersion = new JarWithVersion();
            jarWithVersion.setJarFilename(string);
            jarWithVersion.setVersion(string2);
            arrayList.add(jarWithVersion);
        }
        return arrayList;
    }

    private void sortJarsWithVersionsByVersion(List<JarWithVersion> list) {
        Collections.sort(list, new Comparator<JarWithVersion>(){

            @Override
            public int compare(JarWithVersion jarWithVersion, JarWithVersion jarWithVersion2) {
                String string;
                Version version;
                String string2 = jarWithVersion.getVersion();
                Version version2 = new Version(string2, "interessiert nicht");
                if (version2.isNewerThan(version = new Version(string = jarWithVersion2.getVersion(), "interessiert nicht"))) {
                    return 1;
                }
                if (version.isNewerThan(version2)) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public boolean isJarFound() {
        return this.jarFound;
    }

    public String getNewestJarFilename() {
        return this.newestJarFilename;
    }
}

