/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.test;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.FineFileWriter;
import de.duehl.basics.io.Writer;
import de.duehl.basics.text.Lines;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UnitTestCreator {
    public static final String CLASS_NAME_PLACEHOLDER = "###CLASS_NAME###";
    public static final String LAST_PACKAGE_PART_PLACEHOLDER = "###PACKAGE_PART###";
    private static final int MAXIMAL_NUMBER_OF_LINES_PER_TESTFILE = 10000;
    private final String description;
    private final String descriptionLoweredAtFront;
    private final String goodOrTodoDescription;
    private final Lines javaTestFileHead;
    private final Lines javaTestFileTail;
    private String testDirectory;
    private boolean isTestFileOpen;
    private int lineCountInOpenTestFile;
    private Writer writer;
    private int numberOfTestFiles;
    private int numberOfTestMethodsInAllFiles;
    private String packagePartPrefix;
    private boolean testDirectoryIsModified;

    public UnitTestCreator(String string, String string2, Lines lines, Lines lines2, String string3) {
        this.description = string;
        this.goodOrTodoDescription = string2;
        this.javaTestFileHead = lines;
        this.javaTestFileTail = lines2;
        this.testDirectory = string3;
        this.descriptionLoweredAtFront = Text.firstCharToLowerCase(string);
        this.initNotOpenTestFile();
        this.numberOfTestFiles = 0;
        this.numberOfTestMethodsInAllFiles = 0;
        this.packagePartPrefix = "";
        this.testDirectoryIsModified = false;
    }

    public void setPackagePartPrefix(String string) {
        if (!string.endsWith(".")) {
            throw new RuntimeException("Das nichtleere packagePartPrefix '" + string + "' endet nicht auf einen Punkt.");
        }
        this.packagePartPrefix = string;
    }

    public void writeTest(Lines lines) {
        this.modifyTestDirectoryIfNecessary();
        if (this.isTestFileOpen) {
            int n = this.lineCountInOpenTestFile + lines.size() + this.javaTestFileTail.size();
            if (n > 10000) {
                this.closeActualTestFile();
                this.createNewTestFile();
            }
        } else {
            this.createNewTestFile();
        }
        this.writeTestInOpenTestFile(lines);
    }

    private void modifyTestDirectoryIfNecessary() {
        if (!this.testDirectoryIsModified) {
            this.modifyTestDirectory();
            this.testDirectoryIsModified = true;
            Text.say("Erzeuge Tests im Verzeichnis " + this.testDirectory);
        }
    }

    private void modifyTestDirectory() {
        FileHelper.createDirectoryIfNotExists(this.testDirectory);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.packagePartPrefix.isEmpty()) {
            String string = this.packagePartPrefix.substring(0, this.packagePartPrefix.length() - 1);
            List<String> object = Text.splitByDot(string);
            arrayList.addAll(object);
        }
        arrayList.add(this.descriptionLoweredAtFront);
        for (String string : arrayList) {
            this.testDirectory = FileHelper.concatPathes(this.testDirectory, string);
            FileHelper.createDirectoryIfNotExists(this.testDirectory);
        }
    }

    private void createNewTestFile() {
        ++this.numberOfTestFiles;
        String string = this.goodOrTodoDescription + "Test" + this.description + NumberString.addLeadingZeroes(this.numberOfTestFiles, 5);
        String string2 = string + ".java";
        String string3 = FileHelper.concatPathes(this.testDirectory, string2);
        String string4 = this.packagePartPrefix + this.descriptionLoweredAtFront;
        this.writer = new FineFileWriter(string3, Charset.UTF_8);
        this.isTestFileOpen = true;
        this.lineCountInOpenTestFile = 0;
        Iterator<String> iterator = this.javaTestFileHead.iterator();
        while (iterator.hasNext()) {
            String string5;
            String string6 = string5 = iterator.next();
            string6 = string6.replace(CLASS_NAME_PLACEHOLDER, string);
            string6 = string6.replace(LAST_PACKAGE_PART_PLACEHOLDER, string4);
            this.writer.writeln(string6);
            ++this.lineCountInOpenTestFile;
        }
        this.writer.writeln();
    }

    private void closeActualTestFile() {
        this.writer.writeAllLines(this.javaTestFileTail);
        this.writer.close();
        this.initNotOpenTestFile();
    }

    private void initNotOpenTestFile() {
        this.isTestFileOpen = false;
        this.lineCountInOpenTestFile = -1;
    }

    private void writeTestInOpenTestFile(Lines lines) {
        this.writer.writeAllLines(lines);
        this.lineCountInOpenTestFile += lines.size();
        ++this.numberOfTestMethodsInAllFiles;
    }

    public void close() {
        if (this.isTestFileOpen) {
            this.closeActualTestFile();
        }
    }

    public int getNumberOfTestFiles() {
        return this.numberOfTestFiles;
    }

    public int getNumberOfTestMethodsInAllFiles() {
        return this.numberOfTestMethodsInAllFiles;
    }
}

