/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.debug.Assure;
import de.duehl.basics.io.Charset;
import de.duehl.basics.logic.Pair;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.TextBreaker;
import de.duehl.basics.text.data.FoundSearch;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Text {
    private static final int MAXIMAL_NUMBER_OF_PARTS_FOR_SPACE_VARIATIONS = 11;
    private static final String EXTRA_BIG_CHARS = "\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c";
    public static final String BIG_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c";
    private static final String EXTRA_SMALL_CHARS = "\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b";
    public static final String SMALL_CHARS = "abcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b";
    public static final String MIXED_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b";
    public static final List<String> MIXED_CHARS_LIST = CollectionsHelper.splitStringIntoLetters("ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b");
    public static final String BIG_CHARS_REGEX = "A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c";
    public static final String SMALL_CHARS_REGEX = "a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b";
    public static final String MIXED_CHARS_REGEX = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b";
    public static final String BIG = "[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c]";
    public static final String SMALL = "[a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]";
    public static final String MIXED = "[ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]";
    public static final String NO_SMALL = "[^a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]";
    public static final String DOT = "\\.";
    public static final String BULLET = "\u00b7";
    public static final String SMALL_WORD_REGEX = "[a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+";
    public static final String SUBSTANTIVE_REGEX = "[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+";
    private static final String BIG_CHARS_WITH_QUESTION_MARK_REGEX = "A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c\\?";
    private static final String SMALL_CHARS_WITH_QUESTION_MARKS_REGEX = "a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b\\?";
    private static final String BIG_WITH_QUESTION_MARK = "[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c\\?]";
    public static final String SMALL_WITH_QUESTION_MARKS = "[a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b\\?]";
    public static final String SMALL_WORD_REGEX_WITH_QUESTION_MARKS = "[a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b\\?]+";
    public static final String SMALL_WORD_REGEX_WITH_QUESTION_MARKS_AND_UMBRUCH = "[a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b\\?]+(?:- [a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b\\?]+)*";
    public static final String SUBSTANTIVE_REGEX_WITH_QUESTION_MARKS = "[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c\\?][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b\\?]+";
    public static final String SUBSTANTIVE_REGEX_WITH_QUESTION_MARKS_AND_UMBRUCH = "[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c\\?][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b\\?]+(?:- [a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b\\?]+)*";
    public static final List<String> DIGITS = CollectionsHelper.buildListFrom("0", "1", "2", "3", "4", "5", "6", "7", "8", "9");
    public static final String LINE_BREAK = System.getProperty("line.separator");
    public static final int NOT_FOUND_INDEX = -1;
    public static final String LINE_BREAK_PLACE_HOLDER = "###LINE_BREAK###";
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("(?:[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+){2,}");
    private static final Pattern CAMEL_CASE_PATTERN_WITH_DOTS = Pattern.compile("(?:[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+\\.)+(?:[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+\\.?)");
    private static final String DELIMITER_SYMBOLS_REGEX = "[ |,|\\.|;|:|\\?|!/]";
    public static final List<String> PUNCTUATION_MARKS = CollectionsHelper.buildListFrom(".", ",", ":", ";", "-", "_", "\\", "/");
    public static final List<String> PUNCTUATION = CollectionsHelper.buildListFrom(".", "!", "?", ",", ":", ";", "-", "_", "(", ")", "[", "]", "{", "}", "\"", "'", "\u00b4", "`", "^", "\u00b0", "~", "=", "\\", "/");
    private static final int MAXIMAL_JAVA_LINE_LENGTH = 100;
    private static final Pattern CONTAINES_ONLY_NORMAL_LETTERS_PATTERN = Pattern.compile("[A-Za-z]+");
    private static final Pattern CONTAINES_ONLY_NORMAL_LETTERS_OR_DIGITS_PATTERN = Pattern.compile("[A-Za-z0-9]+");
    private static final Pattern CONTAINES_ONLY_WORD_CHARS_PATTERN = Pattern.compile("[ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+");
    private static final Pattern IS_SUPPER_CASE_PATTERN = Pattern.compile("[^a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]*");
    private static final Pattern IS_SUBSTANTIVE_PATTERN = Pattern.compile("[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+");
    private static final Pattern IS_SUBSTANTIVE_HYPHEN_SUBSTANTIVE_PATTERN = Pattern.compile("[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+-[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+");
    private static final Pattern IS_SUBSTANTIVE_SPACE_SUBSTANTIVE_PATTERN = Pattern.compile("[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+ [A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+");
    private static final Pattern IS_SUBSTANTIVE_AND_SUBSTANTIVE_PATTERN = Pattern.compile("([A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+) und ([A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+)");
    public static final Pair<String> NO_SUBSTANTIVE_PAIR_FOUND = new Pair<String>("", "");
    private static final Pattern CONTAINES_SUBSTANTIVE_PATTERN = Pattern.compile("(?:^|.*[ |,|\\.|;|:|\\?|!/])[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+(?:[ |,|\\.|;|:|\\?|!/].*|$)");
    private static final Pattern STARTS_WITH_SUBSTANTIVE_PATTERN = Pattern.compile("^([A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+)(?:[ |,|\\.|;|:|\\?|!/].*|$)");
    private static final Pattern STARTS_WITH_SUBSTANTIVE_HYPHEN_SUBSTANTIVE_PATTERN = Pattern.compile("^([A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+-[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+)(?:[ |,|\\.|;|:|\\?|!/].*|$)");
    private static final Pattern STARTS_WITH_SUBSTANTIVE_WITH_UMBRUCH_PATTERN = Pattern.compile("^([A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+- [a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+)(?:[ |,|\\.|;|:|\\?|!/].*|$)");
    private static final Pattern ENDS_WITH_SUBSTANTIVE_PATTERN = Pattern.compile("(?:^|[ |,|\\.|;|:|\\?|!/])([A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+)$");
    private static final Pattern ENDS_WITH_SUBSTANTIVE_HYPHEN_PATTERN = Pattern.compile("(?:^|.*[ |,|\\.|;|:|\\?|!/])[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+-$");
    private static final Pattern ENDS_WITH_COMMA_SUBSTANTIVE_PATTERN = Pattern.compile(", [A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c][a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+$");
    public static final String NOT_PART_OF_FILENAMES_REGEX_WITH_HYPHEN_AND_UNDERSCORE = "[-_!?.,#\"';:/\\\\()\\*\u00b4&$\u00a7+`<>\u00b3]";
    private static final Pattern NO_BREAK_AFTER_TYPE = Pattern.compile("[\\),] [ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+$");
    private static final Pattern CONTAINES_ONLY_BIG_LETTERS_PATTERN = Pattern.compile("[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c]+");
    private static final Pattern CONTAINES_ONLY_BIG_LETTERS_AND_HYPHENS_PATTERN = Pattern.compile("[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c]+(?:-[A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c]+)*");
    private static final List<String> ROUND_BRACES = CollectionsHelper.buildListFrom("(", ")");

    private Text() {
    }

    public static String addLineBreaks(String string, int n) {
        TextBreaker textBreaker = new TextBreaker(n);
        return textBreaker.addLineBreaks(string);
    }

    public static String addLineBreaks(String string, int n, int n2) {
        TextBreaker textBreaker = new TextBreaker(n, n2);
        return textBreaker.addLineBreaks(string);
    }

    public static String addLineBreaksKeepSpacesAtBreaks(String string, int n) {
        TextBreaker textBreaker = new TextBreaker(n);
        textBreaker.keepSpacesAtBreaks();
        return textBreaker.addLineBreaks(string);
    }

    public static String addLineBreaksKeepSpacesAtBreaks(String string, int n, int n2) {
        TextBreaker textBreaker = new TextBreaker(n, n2);
        textBreaker.keepSpacesAtBreaks();
        return textBreaker.addLineBreaks(string);
    }

    public static String removeLineBreaks(String string) {
        String string2 = string;
        string2 = string2.replace(LINE_BREAK, " ");
        string2 = string2.replace("\r\n", " ");
        string2 = string2.replace("\n", " ");
        string2 = string2.replace("\r", " ");
        return string2;
    }

    public static String repairLineBreaks(String string) {
        String string2 = string;
        string2 = string2.replace(LINE_BREAK, LINE_BREAK_PLACE_HOLDER);
        string2 = string2.replace("\r\n", LINE_BREAK_PLACE_HOLDER);
        string2 = string2.replace("\n", LINE_BREAK_PLACE_HOLDER);
        string2 = string2.replace("\r", LINE_BREAK_PLACE_HOLDER);
        string2 = string2.replace(LINE_BREAK_PLACE_HOLDER, LINE_BREAK);
        return string2;
    }

    public static int countLineBreaks(String string) {
        return Text.countPartInString(string, LINE_BREAK);
    }

    public static String allBackslashesToSlashes(String string) {
        return string.replace("\\", "/");
    }

    public static String allSlashesToBackslashes(String string) {
        return string.replace("/", "\\");
    }

    public static String removeTrailingSlash(String string) {
        String string2 = string;
        while (string2.endsWith("/") || string2.endsWith("\\")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static String multipleString(String string, int n) {
        if (n <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String multipleString(char c, int n) {
        String string = Character.toString(c);
        return Text.multipleString(string, n);
    }

    public static int countPartInString(String string, String string2) {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        while (bl) {
            int n3 = string.indexOf(string2, n2);
            if (n3 == -1) {
                bl = false;
                continue;
            }
            ++n;
            n2 = n3 + string2.length();
        }
        return n;
    }

    public static void say(String string) {
        System.out.println(string);
    }

    public static void say(Object object) {
        Text.say(object.toString());
    }

    public static void sayNoBreak(String string) {
        System.out.print(string);
    }

    public static void say(int n) {
        System.out.println(Integer.toString(n));
    }

    public static void say() {
        Text.say("");
    }

    public static void bar() {
        Text.sayNoBreak(Text.barLine());
    }

    public static String barLine() {
        return Text.barLineWithoutLinebreak() + "\n";
    }

    public static String barLineWithoutLinebreak() {
        return Text.multipleString("-", 80);
    }

    public static void barEqual() {
        Text.sayNoBreak(Text.barEqualLine());
    }

    public static String barEqualLine() {
        return Text.multipleString("=", 80) + "\n";
    }

    public static String stripWhitespace(String string) {
        String string2 = string;
        string2 = string2.replaceAll("\\s+", " ");
        string2 = string2.replaceAll("\\r", " ");
        string2 = string2.replaceAll("\\n", " ");
        string2 = string2.replaceAll("  +", " ");
        string2 = string2.strip();
        return string2;
    }

    public static String removeWhitespace(String string) {
        String string2 = string;
        string2 = Text.stripWhitespace(string2);
        string2 = string2.replace(" ", "");
        return string2;
    }

    public static String stretch(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            stringBuilder.append(c).append(" ");
        }
        return stringBuilder.toString();
    }

    public static boolean firstCharsAreEqual(String string, String string2, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Die Anzahl der zu ersten vergleichenden Stellen darf nicht negativ sein.");
        }
        int n2 = string.length();
        int n3 = string2.length();
        if ((n2 < n || n3 < n) && n2 != n3) {
            return false;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n4 = Math.min(n, n2);
        for (int i = 0; i < n4; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static List<Integer> findAllPositions(String string, String string2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = string2.indexOf(string);
        while (n > -1) {
            arrayList.add(n);
            int n2 = n;
            if ((n = string2.indexOf(string, n + 1)) != n2) continue;
            n = -1;
        }
        return arrayList;
    }

    public static List<Integer> findAllPositions(List<String> list, String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string2 : list) {
            List<Integer> list2 = Text.findAllPositions(string2, string);
            arrayList.addAll(list2);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static List<Integer> findAllPositionsWithoutOverlapping(String string, String string2) {
        List<Integer> list = Text.findAllPositions(string, string2);
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            int n = -string.length();
            for (int i = 0; i < list.size(); ++i) {
                int n2 = list.get(i);
                if (n2 - n < string.length()) {
                    bl = true;
                    list.remove(i);
                    continue block0;
                }
                n = n2;
            }
        }
        return list;
    }

    public static List<Integer> findAllPositionsOfCompleteWords(String string, String string2) {
        List<Integer> list = Text.findAllPositions(string, string2);
        int n = string.length();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            int n2 = list.get(i);
            if (!Text.isStartAndEndOfWord(n2, n2 + n, string2)) continue;
            arrayList.add(n2);
        }
        return arrayList;
    }

    public static String join(String string, List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            stringBuilder.append(string);
            stringBuilder.append(list.get(i));
        }
        return stringBuilder.toString();
    }

    public static String join(String string, String ... stringArray) {
        List<String> list = Arrays.asList(stringArray);
        return Text.join(string, list);
    }

    public static String joinWithTabulator(List<String> list) {
        return Text.join("\t", list);
    }

    public static String joinWithTabulator(String ... stringArray) {
        List<String> list = Arrays.asList(stringArray);
        return Text.joinWithTabulator(list);
    }

    public static String joinWithLineBreak(List<String> list) {
        return Text.join(LINE_BREAK, list);
    }

    public static String joinWithPipe(List<String> list) {
        return Text.join("|", list);
    }

    public static String joinWithBlank(List<String> list) {
        return Text.join(" ", list);
    }

    public static String joinWithSemicolon(List<String> list) {
        return Text.join(";", list);
    }

    public static String joinWithColon(List<String> list) {
        return Text.join(":", list);
    }

    public static String joinWithComma(List<String> list) {
        return Text.join(",", list);
    }

    public static String joinWithCommaAndBlank(List<String> list) {
        return Text.join(", ", list);
    }

    public static String joinWithRauteSemicolonRaute(List<String> list) {
        return Text.join("#;#", list);
    }

    public static List<String> splitBy(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!string.isEmpty()) {
            arrayList.addAll(Arrays.asList(string.split(string2, -1)));
        }
        if (string2.isEmpty() && !arrayList.isEmpty() && ((String)arrayList.get(arrayList.size() - 1)).isEmpty()) {
            arrayList.remove(arrayList.size() - 1);
        }
        return arrayList;
    }

    public static List<String> splitByWhitespace(String string) {
        return Text.splitBy(string, "[ \\t]+");
    }

    public static List<String> splitByMultipleSpaces(String string, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Die Anzahl der Leerzeichen muss mindestens 1 sien!");
        }
        return Text.splitBy(string, "[ ]{" + n + ",}");
    }

    public static List<String> splitByPipe(String string) {
        return Text.splitBy(string, " *\\| *");
    }

    public static List<String> splitByPipeNotConsumingWhitespace(String string) {
        return Text.splitBy(string, "\\|");
    }

    public static List<String> splitByQuotedBlankOrHash(String string) {
        return Text.splitBy(string, " *'(?:#| )' *");
    }

    public static List<String> splitByAddition(String string) {
        return Text.splitBy(string, " *\\+ *");
    }

    public static List<String> splitBySubtraction(String string) {
        return Text.splitBy(string, " *- *");
    }

    public static List<String> splitByKomma(String string) {
        return Text.splitBy(string, " *, *");
    }

    public static List<String> splitByTabulator(String string) {
        return Text.splitBy(string, " *\t *");
    }

    public static List<String> splitByTabulatorNotConsumingWhitespace(String string) {
        return Text.splitBy(string, "\t");
    }

    public static List<String> splitBySemicolon(String string) {
        return Text.splitBy(string, " *; *");
    }

    public static List<String> splitBySemicolonNotConsumingWhitespace(String string) {
        return Text.splitBy(string, ";");
    }

    public static List<String> splitByColon(String string) {
        return Text.splitBy(string, " *: *");
    }

    public static List<String> splitByColonNotConsumingWhitespace(String string) {
        return Text.splitBy(string, ":");
    }

    public static List<String> splitBySpecial(String string) {
        return Text.splitByRauteSemicolonRaute(string);
    }

    public static List<String> splitBySpecialNotConsumingWhitespace(String string) {
        return Text.splitByRauteSemicolonRauteNotConsumingWhitespace(string);
    }

    public static List<String> splitByRauteSemicolonRaute(String string) {
        return Text.splitBy(string, " *#;# *");
    }

    public static List<String> splitByRauteSemicolonRauteNotConsumingWhitespace(String string) {
        return Text.splitBy(string, "#;#");
    }

    public static List<String> splitByLineBreaks(String string) {
        return Text.splitBy(string, "(\\Q" + LINE_BREAK + "\\E|\r?\n|\r)");
    }

    public static List<String> splitByDot(String string) {
        return Text.splitBy(string, " *\\. *");
    }

    public static List<String> splitByDotNotConsumingWhitespace(String string) {
        return Text.splitBy(string, DOT);
    }

    public static List<String> splitByEqualSign(String string) {
        return Text.splitBy(string, " *= *");
    }

    public static List<String> splitBySlashOrBackSlash(String string) {
        return Text.splitBy(string, " *(?:/|\\\\) *");
    }

    public static List<String> splitBySlashOrBackSlashNotConsumingWhitespace(String string) {
        return Text.splitBy(string, "(?:/|\\\\)");
    }

    public static String removeFromTextRespectingSpaces(String string, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Der Anfang liegt vor dem Anfang des \u00fcbergebenen Textes.\n\tstart         = " + n + "\n\ttext          = " + string + "\n");
        }
        if (n > string.length()) {
            throw new IllegalArgumentException("Der Anfang liegt hinter dem Ende des \u00fcbergebenen Textes.\n\tstart         = " + n + "\n\ttext.length() = " + string.length() + "\n\ttext          = " + string + "\n");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("length " + n2 + " ist zu klein, muss mindestens 0 sein");
        }
        int n3 = n + n2;
        if (n3 > string.length()) {
            throw new IllegalArgumentException("Das Ende (Start + L\u00e4nge) liegt hinter dem Ende des \u00fcbergebenen Textes.\n\tstart         = " + n + "\n\tlength        = " + n2 + "\n\tend           = " + n3 + "\n\ttext.length() = " + string.length() + "\n\ttext          = " + string + "\n");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (n > 0 && n3 < string.length()) {
            if (' ' == string.charAt(n - 1) && ' ' == string.charAt(n3)) {
                stringBuilder.append(string.substring(0, n - 1));
                stringBuilder.append(string.substring(n3));
            } else if (' ' != string.charAt(n - 1) && ' ' != string.charAt(n3)) {
                stringBuilder.append(string.substring(0, n));
                stringBuilder.append(" ");
                stringBuilder.append(string.substring(n3));
            } else {
                stringBuilder.append(string.substring(0, n));
                stringBuilder.append(string.substring(n3));
            }
        } else if (n > 0) {
            stringBuilder.append(string.substring(0, n));
        } else {
            stringBuilder.append(string.substring(n3));
        }
        return stringBuilder.toString();
    }

    public static String removeFromText(String string, int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("length " + n2 + " ist zu klein, muss mindestens 0 sein");
        }
        return Text.replaceInText(string, " ", n, n + n2);
    }

    public static String removeFirstOccurance(String string, String string2) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        return Text.replaceInText(string, "", n, n + string2.length());
    }

    public static String insertIntoText(String string, String string2, int n) {
        return Text.replaceInText(string, string2, n, n);
    }

    public static String replaceInText(String string, String string2, int n, int n2) {
        Text.checkStartAndEnd(string, n, n2);
        String string3 = string.substring(0, n);
        String string4 = string.substring(n2);
        String string5 = string3 + string2 + string4;
        return string5;
    }

    private static void checkStartAndEnd(String string, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("start " + n + " ist zu klein, muss mindestens 0 sein");
        }
        if (n > 0 && n > string.length()) {
            throw new IllegalArgumentException("start " + n + " ist zu gro\u00df, darf h\u00f6chstens " + string.length() + " sein");
        }
        if (n2 > string.length()) {
            throw new IllegalArgumentException("end " + n2 + " ist zu gro\u00df, darf h\u00f6chstens " + string.length() + " sein");
        }
        if (n > n2) {
            throw new IllegalArgumentException("start (" + n + ") darf h\u00f6chstens so gro\u00df wie end (" + n2 + ") sein");
        }
    }

    public static String replaceInTextWithEqualLengthCharacterSequence(String string, char c, int n, int n2) {
        Text.checkStartAndEnd(string, n, n2);
        int n3 = n2 - n;
        String string2 = Text.multipleString(c, n3);
        return Text.replaceInText(string, string2, n, n2);
    }

    public static String replaceInTextWithEqualLengthCharacterSequence(String string, List<String> list) {
        String string2 = string;
        for (String string3 : list) {
            String string4 = "";
            while (!string2.equals(string4)) {
                string4 = string2;
                string2 = Text.replaceInTextWithEqualLengthCharacterSequenceOnce(string2, string3);
            }
        }
        return string2;
    }

    static String replaceInTextWithEqualLengthCharacterSequenceOnce(String string, String string2) {
        String string3 = string;
        int n = string.indexOf(string2);
        if (n > -1) {
            string3 = Text.replaceInTextWithEqualLengthCharacterSequence(string, '#', n, n + string2.length());
        }
        return string3;
    }

    public static String hideLineBreaks(String string) {
        return Text.replaceLineBreaks(string, LINE_BREAK_PLACE_HOLDER);
    }

    public static String hideLineBreaksWithLiteralBackslashN(String string) {
        return Text.replaceLineBreaks(string, "\\n");
    }

    public static String showLineBreaksAfterHiding(String string) {
        String string2 = string;
        string2 = string2.replace(LINE_BREAK_PLACE_HOLDER, LINE_BREAK);
        return string2;
    }

    public static String lineBreaksToSpace(String string) {
        return Text.replaceLineBreaks(string, " ");
    }

    public static String lineBreaksToBackslashN(String string) {
        return Text.replaceLineBreaks(string, "\n");
    }

    public static String backslashNToLineBreaks(String string) {
        return string.replace("\n", LINE_BREAK);
    }

    public static String replaceLineBreaks(String string, String string2) {
        String string3 = string;
        string3 = string3.replace(LINE_BREAK, string2);
        string3 = string3.replace("\r\n", string2);
        string3 = string3.replace("\n", string2);
        string3 = string3.replace("\r", string2);
        return string3;
    }

    public static String removeLineBreaksAndTabulators(String string) {
        String string2 = string;
        string2 = Text.lineBreaksToSpace(string2);
        string2 = string2.replace("\t", " ");
        string2 = string2.replaceAll(" +", " ");
        string2 = string2.strip();
        return string2;
    }

    public static List<String> stripCommentsFromLines(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (string.startsWith("#")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static String removeLastCharacters(String string, int n) {
        if (string.length() <= n) {
            return "";
        }
        return string.substring(0, string.length() - n);
    }

    public static String fillWithSpaces(String string, int n) {
        if (n <= string.length()) {
            return string;
        }
        String string2 = Text.multipleString(" ", n - string.length());
        return string + string2;
    }

    public static String fillWithSpacesAtFront(String string, int n) {
        if (n <= string.length()) {
            return string;
        }
        String string2 = Text.multipleString(" ", n - string.length());
        return string2 + string;
    }

    public static String fillWithLines(String string, int n) {
        if (n <= string.length()) {
            return string;
        }
        String string2 = Text.multipleString("-", n - string.length());
        return string + string2;
    }

    public static List<String> cleanCollectionOfStringsToNotContainingEachOther(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(collection);
        boolean bl = true;
        while (bl) {
            bl = Text.cleanCollectionOfStringsToNotContainingEachOtherOneTime(arrayList);
        }
        return arrayList;
    }

    private static boolean cleanCollectionOfStringsToNotContainingEachOtherOneTime(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                String string2 = list.get(j);
                if (string.contains(string2)) {
                    list.remove(j);
                    return true;
                }
                if (!string2.contains(string)) continue;
                list.remove(i);
                return true;
            }
        }
        return false;
    }

    public static String getLastPartAfterDivider(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (-1 == n) {
            return string;
        }
        return string.substring(n + string2.length());
    }

    public static String trimAndCompactSpaces(String string) {
        String string2 = string;
        string2 = string2.replaceAll("^ +", "");
        string2 = string2.replaceAll(" +$", "");
        string2 = string2.replaceAll(" +", " ");
        return string2;
    }

    public static String listOfLinesToString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append(LINE_BREAK);
        }
        return stringBuilder.toString();
    }

    public static List<String> stringToListOfLines(String string) {
        List<String> list = Text.splitBy(string, Pattern.quote(LINE_BREAK));
        if (!list.isEmpty() && list.get(list.size() - 1).isEmpty()) {
            list.remove(list.size() - 1);
        }
        return list;
    }

    public static int searchFirstLineIndexContainig(List<String> list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            if (!string2.contains(string)) continue;
            return i;
        }
        return -1;
    }

    public static String findInText(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (-1 == n) {
            throw new RuntimeException("Das Anfangsst\u00fcck '" + string2 + "' wurde nicht im Text gefunden.\n\ttext = " + string);
        }
        int n2 = string.indexOf(string2, n + string2.length());
        if (-1 != n2) {
            throw new RuntimeException("Das Anfangsst\u00fcck '" + string2 + "' ist nicht eindeutig im Text.\n\ttext = " + string);
        }
        int n3 = string.indexOf(string3);
        if (-1 == n3) {
            throw new RuntimeException("Das Endst\u00fcck '" + string3 + "' wurde nicht im Text gefunden.\n\ttext = " + string);
        }
        int n4 = string.indexOf(string3, n3 + string3.length());
        if (-1 != n4) {
            throw new RuntimeException("Das Endst\u00fcck '" + string3 + "' ist nicht eindeutig im Text.\n\ttext = " + string);
        }
        int n5 = n + string2.length();
        int n6 = n3;
        return string.substring(n5, n6);
    }

    public static String doubleTwoDecimalPlaces(double d) {
        return String.format("%.2f", d);
    }

    public static String buildCompareText(String string) {
        String string2 = Text.toLowerCase(string);
        string2 = string2.replace("\u00e4", "ae");
        string2 = string2.replace("\u00f6", "oe");
        string2 = string2.replace("\u00fc", "ue");
        string2 = string2.replace("\u00df", "ss");
        return string2;
    }

    public static boolean isWordChar(char c) {
        return !Text.isWhitespace(c) && !Text.isPunctuation(c) && !Text.isBrace(c);
    }

    public static boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\t';
    }

    public static boolean isBrace(char c) {
        return c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}' || c == '<' || c == '>';
    }

    public static boolean isPunctuation(char c) {
        return c == '.' || c == ',' || c == ':' || c == ';' || c == '!' || c == '?' || c == '-' || c == '_';
    }

    public static boolean isCapitalLetter(char c) {
        return c >= 'A' && c <= 'Z' || '\u00c4' == c || '\u00d6' == c || '\u00dc' == c;
    }

    public static boolean firstLetterIsCapitalLetter(String string) {
        if (string.isEmpty()) {
            return false;
        }
        char c = string.charAt(0);
        return Text.isCapitalLetter(c);
    }

    public static String findIntersection(String string, String string2) {
        String string3 = "";
        int n = Math.min(string.length(), string2.length());
        for (int i = 0; i <= n; ++i) {
            String string4 = string2.substring(0, i);
            if (!string.endsWith(string4)) continue;
            string3 = string4;
        }
        return string3;
    }

    public static boolean containsUpperLetter(String string) {
        for (char c : string.toCharArray()) {
            if (!Text.isCapitalLetter(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String string, List<String> list) {
        for (String string2 : list) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWith(String string, List<String> list) {
        for (String string2 : list) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static String firstCharToUpperCase(String string) {
        if (string.isEmpty()) {
            return string;
        }
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1);
        return Text.toUpperCase(string2) + string3;
    }

    public static String toFirstUpperCase(String string) {
        if (string.isEmpty()) {
            return string;
        }
        if (string.length() == 1) {
            return Text.toUpperCase(string);
        }
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1);
        return Text.toUpperCase(string2) + Text.toLowerCase(string3);
    }

    public static String toCamelCase(String string) {
        if (string.isEmpty()) {
            return "";
        }
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        for (String string2 : Text.splitBy(string, "[_ \\t]+")) {
            if (string2.isEmpty()) {
                throw new RuntimeException("Es wurde an Whitespace getrennt, da darf kein leerer String auftauchen!");
            }
            String string3 = string2.substring(0, 1);
            String string4 = string2.substring(1);
            String object = string3.toUpperCase() + string4;
            arrayList.add((CallSite)((Object)object));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string5 : arrayList) {
            stringBuilder.append(string5);
        }
        return stringBuilder.toString();
    }

    public static String cleanForSasVariableName(String string) {
        String string2 = string;
        string2 = string2.replaceAll("[-!?.,#\"'\\d;:/\\\\]", "_");
        string2 = Text.replaceUmlauts(string2);
        string2 = string2.strip();
        string2 = string2.replace(" ", "_");
        string2 = string2.replaceAll("__+", "_");
        string2 = string2.replaceAll("^_+", "");
        if ((string2 = string2.replaceAll("_+$", "")).length() > 32) {
            string2 = string2.substring(0, 32);
        }
        return string2;
    }

    public static String nicePath(String string) {
        String string2 = string.strip();
        string2 = Text.allSlashesToBackslashes(string2);
        return string2;
    }

    public static List<String> nicePathes(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = Text.nicePath(string);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static String skipSublinkPart(String string) {
        int n = string.indexOf("#");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static boolean containsOnlyNormalLetters(String string) {
        Matcher matcher = CONTAINES_ONLY_NORMAL_LETTERS_PATTERN.matcher(string);
        return matcher.matches();
    }

    public static boolean containsOnlyNormalLettersOrDigits(String string) {
        Matcher matcher = CONTAINES_ONLY_NORMAL_LETTERS_OR_DIGITS_PATTERN.matcher(string);
        return matcher.matches();
    }

    public static boolean containsOnlyWordChars(String string) {
        Matcher matcher = CONTAINES_ONLY_WORD_CHARS_PATTERN.matcher(string);
        return matcher.matches();
    }

    public static String tabToSpace(String string) {
        return string.replace("\t", "    ");
    }

    public static List<String> extractQuotetBraceParameters(String string) {
        List<Integer> list = Text.findAllPositions("(", string);
        Assure.hasOneElement(list);
        List<Integer> list2 = Text.findAllPositions(")", string);
        Assure.hasOneElement(list2);
        int n = list.get(0);
        int n2 = list2.get(0);
        Assure.isAtLeast(n2, n);
        String string2 = string.substring(n + 1, n2);
        if (string2.startsWith("'") && string2.endsWith("'")) {
            string2 = string2.substring(1, string2.length() - 1);
            List<String> list3 = Text.splitBy(string2, "' *, *'");
            return list3;
        }
        throw new IllegalArgumentException("Der Text in der Klammer muss mit einem einfachen Quote beginnen und aufh\u00f6ren.\n\tinput = [" + string + "]inner = [" + string2 + "]\n\t");
    }

    public static String removeTextAtFrontIfStartsWith(String string, String string2) {
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    public static String removeTextAtStartIfStartsWith(String string, String string2) {
        return Text.removeTextAtFrontIfStartsWith(string, string2);
    }

    public static String removeTextAtFrontIfStartsWith(String string, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(" ");
        arrayList.addAll(list);
        boolean bl = true;
        String string2 = string;
        while (bl) {
            String string3 = string2;
            for (String string4 : arrayList) {
                string2 = Text.removeTextAtFrontIfStartsWith(string2, string4);
            }
            bl = !string3.equals(string2);
        }
        return string2;
    }

    public static String removeTextAtEndIfEndsWith(String string, String string2) {
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String removeLineBreakAtEndIfEndsWith(String string) {
        String string2 = Text.removeTextAtEndIfEndsWith(string, LINE_BREAK);
        if (string2.equals(string)) {
            string2 = Text.removeTextAtEndIfEndsWith(string2, "\n");
        }
        return string2;
    }

    public static String removePartBeforeSearchText(String string, String string2) {
        int n = string.indexOf(string2);
        if (n > -1) {
            return string.substring(n);
        }
        return string;
    }

    public static String removePartBeforeSearchTextIncludingSearchText(String string, String string2) {
        int n = string.indexOf(string2);
        if (n > -1) {
            return string.substring(n + string2.length());
        }
        return string;
    }

    public static String removePartBeforeLastSearchText(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n > -1) {
            return string.substring(n);
        }
        return string;
    }

    public static String removePartBeforeLastSearchTextIncludingSearchText(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n > -1) {
            return string.substring(n + string2.length());
        }
        return string;
    }

    public static String unifyLineBreaks(String string) {
        String string2 = string;
        string2 = string2.replace(LINE_BREAK, LINE_BREAK_PLACE_HOLDER);
        string2 = string2.replace("\r\n", LINE_BREAK_PLACE_HOLDER);
        string2 = string2.replace("\n", LINE_BREAK_PLACE_HOLDER);
        string2 = string2.replace("\r", LINE_BREAK_PLACE_HOLDER);
        string2 = string2.replace(LINE_BREAK_PLACE_HOLDER, LINE_BREAK);
        return string2;
    }

    public static String removeEmptyLines(String string) {
        String string2 = Text.unifyLineBreaks(string);
        string2 = string2.replaceAll("(?:" + LINE_BREAK + " *)+" + LINE_BREAK, LINE_BREAK);
        string2 = string2.replaceAll("^(?: *" + LINE_BREAK + ")+", "");
        string2 = string2.replaceAll("(?:" + LINE_BREAK + " *)+$", "");
        return string2;
    }

    public static String removeEmptyLinesAtFrontAndEnd(String string) {
        List<String> list = Text.splitByLineBreaks(string);
        int n = Text.findFirstFilledLineIndex(list);
        if (n == -1) {
            return "";
        }
        int n2 = Text.findLastFilledLineIndex(list);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = n; i <= n2; ++i) {
            arrayList.add(list.get(i));
        }
        return Text.joinWithLineBreak(arrayList);
    }

    private static int findFirstFilledLineIndex(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (string.strip().isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private static int findLastFilledLineIndex(List<String> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            String string = list.get(i);
            if (string.strip().isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public static String removeShortLines(String string, int n) {
        String string2 = Text.unifyLineBreaks(string);
        String string3 = "[^\\r\\n]{1," + n + "}";
        string2 = string2.replaceAll("(?:" + LINE_BREAK + string3 + ")+" + LINE_BREAK, LINE_BREAK);
        string2 = string2.replaceAll("^(?:" + string3 + LINE_BREAK + ")+", "");
        string2 = string2.replaceAll("(?:" + LINE_BREAK + string3 + ")+$", "");
        return string2;
    }

    public static String loremImpsum() {
        return "Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat. Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum." + LINE_BREAK + LINE_BREAK + "--" + LINE_BREAK + LINE_BREAK + "Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat." + LINE_BREAK + "Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi." + LINE_BREAK + "Nam liber tempor cum soluta nobis eleifend option congue nihil imperdiet doming id quod mazim placerat facer possim assum. Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat." + LINE_BREAK + "Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis." + LINE_BREAK + "At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua. est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat." + LINE_BREAK + "Consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.";
    }

    public static List<String> eachCharFromString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(i, i + 1);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static String utf8InputStreamToString(InputStream inputStream) {
        return Text.inputStreamToString(inputStream, Charset.UTF_8);
    }

    public static String inputStreamToString(InputStream inputStream, Charset charset) {
        try {
            return Text.tryToInputStreamToString(inputStream, charset);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static String tryToInputStreamToString(InputStream inputStream, Charset charset) throws IOException {
        int n;
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset.getCharsetAsString());
        while ((n = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) >= 0) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public static FoundSearch findFirstPosition(String string, List<String> list) {
        return Text.findFirstPosition(string, list, 0);
    }

    public static FoundSearch findFirstPosition(String string, List<String> list, int n) {
        FoundSearch foundSearch = FoundSearch.NOT_FOUND;
        boolean bl = true;
        for (String string2 : list) {
            int n2 = string.indexOf(string2, n);
            int n3 = foundSearch.getIndex();
            if (n2 <= -1 || !bl && (n3 <= -1 || n2 >= n3)) continue;
            bl = false;
            foundSearch = new FoundSearch(n2, string2);
        }
        return foundSearch;
    }

    public static FoundSearch findFirstPositionNotStartingWith(String string, List<String> list, String string2) {
        return Text.findFirstPositionNotStartingWith(string, list, 0, string2);
    }

    public static FoundSearch findFirstPositionNotStartingWith(String string, List<String> list, int n, String string2) {
        FoundSearch foundSearch = FoundSearch.NOT_FOUND;
        boolean bl = true;
        for (String string3 : list) {
            String string4;
            int n2 = string.indexOf(string3, n);
            int n3 = foundSearch.getIndex();
            if (n2 <= -1 || !bl && (n3 <= -1 || n2 >= n3) || (string4 = string.substring(n2 + string3.length())).startsWith(string2)) continue;
            bl = false;
            foundSearch = new FoundSearch(n2, string3);
        }
        return foundSearch;
    }

    public static FoundSearch findLast(String string, List<String> list) {
        FoundSearch foundSearch = FoundSearch.NOT_FOUND;
        for (String string2 : list) {
            int n = string.lastIndexOf(string2);
            if (foundSearch.getIndex() >= n) continue;
            foundSearch = new FoundSearch(n, string2);
        }
        return foundSearch;
    }

    public static FoundSearch findLastNotStartingWith(String string, List<String> list, String string2) {
        return Text.findLastNotStartingWith(string, list, CollectionsHelper.buildListFrom(string2));
    }

    public static FoundSearch findLastNotStartingWith(String string, List<String> list, List<String> list2) {
        return Text.findLastNotBeginningAndNotStartingWith(string, list, new ArrayList<String>(), list2);
    }

    public static FoundSearch findLastNotBeginningAndNotStartingWith(String string, List<String> list, List<String> list2, List<String> list3) {
        Object object;
        int n;
        Object object2;
        ArrayList<FoundSearch> arrayList = new ArrayList<FoundSearch>();
        for (String object3 : list) {
            object2 = Text.findAllPositionsWithoutOverlapping(object3, string);
            Iterator<Integer> iterator = object2.iterator();
            while (iterator.hasNext()) {
                n = iterator.next();
                object = new FoundSearch(n, object3);
                arrayList.add((FoundSearch)object);
            }
        }
        FoundSearch.sortFoundSearchListReverseByEndAndIndex(arrayList);
        for (FoundSearch foundSearch : arrayList) {
            object2 = foundSearch.getSearch();
            int n2 = foundSearch.getIndex();
            n = 0;
            object = string.substring(0, n2);
            for (String string2 : list2) {
                if (!((String)object).endsWith(string2)) continue;
                n = 1;
                break;
            }
            if (n == 0) {
                String string3 = string.substring(n2 + ((String)object2).length());
                for (String string4 : list3) {
                    if (!string3.startsWith(string4)) continue;
                    n = 1;
                    break;
                }
            }
            if (n != 0) continue;
            return foundSearch;
        }
        return FoundSearch.NOT_FOUND;
    }

    public static String removeAllPartsWithStartAndEnd(String string, String string2, String string3) {
        Object object = string;
        boolean bl = true;
        while (bl) {
            int n = ((String)object).indexOf(string2);
            if (n == -1) {
                bl = false;
                continue;
            }
            int n2 = ((String)object).indexOf(string3, n + string2.length());
            if (n2 == -1) {
                object = ((String)object).substring(0, n);
                continue;
            }
            object = ((String)object).substring(0, n) + ((String)object).substring(n2 + string3.length());
        }
        return object;
    }

    public static String removeAllPartsWithStartsAndEnds(String string, List<String> list, List<String> list2) {
        Object object = string;
        boolean bl = true;
        while (bl) {
            FoundSearch foundSearch = Text.findFirstPosition((String)object, list);
            int n = foundSearch.getIndex();
            if (n == -1) {
                bl = false;
                continue;
            }
            String string2 = foundSearch.getSearch();
            FoundSearch foundSearch2 = Text.findFirstPosition((String)object, list2, n + string2.length());
            int n2 = foundSearch2.getIndex();
            if (n2 == -1) {
                object = ((String)object).substring(0, n);
                continue;
            }
            String string3 = foundSearch2.getSearch();
            object = ((String)object).substring(0, n) + ((String)object).substring(n2 + string3.length());
        }
        return object;
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        String string3 = Text.toLowerCase(string);
        String string4 = Text.toLowerCase(string2);
        return string3.startsWith(string4);
    }

    public static String removeSlashStarComments(String string) {
        return Text.removeAllPartsWithStartAndEnd(string, "/*", "*/");
    }

    public static String removeSpaces(String string) {
        return string.replace(" ", "");
    }

    public static boolean isStartAndEndOfWord(int n, int n2, String string) {
        return Text.isStartOfWord(n, string) && Text.isEndOfWord(n2, string);
    }

    public static boolean isStartOfWord(int n, String string) {
        if (n < 0 || n >= string.length()) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        String string2 = string.substring(n - 1, n);
        return !"ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b".contains(string2);
    }

    public static boolean isEndOfWord(int n, String string) {
        if (n <= 0 || n > string.length()) {
            return false;
        }
        if (n == string.length()) {
            return true;
        }
        String string2 = string.substring(n, n + 1);
        return !"ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b".contains(string2);
    }

    public static String escapeDoubleQuotes(String string) {
        return string.replace("\"", "\\\"");
    }

    public static boolean isUpperCase(String string) {
        Matcher matcher = IS_SUPPER_CASE_PATTERN.matcher(string);
        return matcher.matches();
    }

    public static boolean isCamelCase(String string) {
        Matcher matcher = CAMEL_CASE_PATTERN.matcher(string);
        return matcher.matches();
    }

    public static boolean isCamelCaseWithDots(String string) {
        Matcher matcher = CAMEL_CASE_PATTERN_WITH_DOTS.matcher(string);
        return matcher.matches();
    }

    public static String firstLoweredChar(String string) {
        if (string.isEmpty()) {
            return "";
        }
        String string2 = string.substring(0, 1);
        return Text.toLowerCase(string2);
    }

    public static String firstCharToLowerCase(String string) {
        if (string.isEmpty()) {
            return "";
        }
        String string2 = Text.firstLoweredChar(string);
        String string3 = string.substring(1);
        return string2 + string3;
    }

    public static List<String> wordToLetters(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(i, i + 1);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean isQuoted(String string) {
        return string.startsWith("\"") && string.endsWith("\"");
    }

    public static String deQuoteQuotedString(String string) {
        if (!Text.isQuoted(string)) {
            throw new IllegalArgumentException("Die Eingabe '" + string + "' beginnt oder endet nicht mit doppeltem Anf\u00fchrungszeichen.");
        }
        return string.substring(1, string.length() - 1);
    }

    public static String deQuoteQuotedStringIfQuoted(String string) {
        if (Text.isQuoted(string)) {
            return Text.deQuoteQuotedString(string);
        }
        return string;
    }

    public static boolean isSingleQuoted(String string) {
        return string.startsWith("'") && string.endsWith("'");
    }

    public static String deSingleQuoteQuotedString(String string) {
        if (!Text.isSingleQuoted(string)) {
            throw new IllegalArgumentException("Die Eingabe '" + string + "' beginnt oder endet nicht mit einfachem Anf\u00fchrungszeichen.");
        }
        return string.substring(1, string.length() - 1);
    }

    public static boolean containsOnlySmallLetters(String string) {
        if (string.isEmpty()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(i, i + 1);
            if (SMALL_CHARS.contains(string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithLowercaseLetter(String string) {
        if (string.isEmpty()) {
            return false;
        }
        String string2 = string.substring(0, 1);
        return SMALL_CHARS.contains(string2);
    }

    public static boolean startsWithUppercaseLetter(String string) {
        if (string.isEmpty()) {
            return false;
        }
        String string2 = string.substring(0, 1);
        return BIG_CHARS.contains(string2);
    }

    public static boolean endsWithUppercaseLetter(String string) {
        if (string.isEmpty()) {
            return false;
        }
        String string2 = string.substring(string.length() - 1, string.length());
        return BIG_CHARS.contains(string2);
    }

    public static boolean startsWithDigit(String string) {
        if (string.isEmpty()) {
            return false;
        }
        String string2 = string.substring(0, 1);
        return DIGITS.contains(string2);
    }

    public static boolean positionBeforePartIsEmpty(String string, String string2) {
        if (string.isEmpty() || string2.isEmpty()) {
            return false;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return false;
        }
        if (n == 0) {
            return false;
        }
        String string3 = string.substring(n - 1, n);
        return " ".equals(string3);
    }

    public static String toUpperCase(String string) {
        return string.toUpperCase(Locale.GERMAN);
    }

    public static String toLowerCase(String string) {
        return string.toLowerCase(Locale.GERMAN);
    }

    public static List<String> toLowerCase(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(Text.toLowerCase(string));
        }
        return arrayList;
    }

    public static boolean startsWith(String string, List<String> list) {
        for (String string2 : list) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithCompleteWord(String string, String string2) {
        if (string.startsWith(string2)) {
            if (string.length() == string2.length()) {
                return true;
            }
            String string3 = string.substring(string2.length(), string2.length() + 1);
            return !"ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b".contains(string3);
        }
        return false;
    }

    public static int indexAsCompleteWord(String string, String string2) {
        int n = string.indexOf(string2);
        while (n > -1) {
            boolean bl;
            String string3;
            boolean bl2;
            if (n == 0) {
                bl2 = true;
            } else {
                string3 = string.substring(n - 1, n);
                boolean bl3 = bl2 = !"ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b".contains(string3);
            }
            if (string.length() == n + string2.length()) {
                bl = true;
            } else {
                string3 = string.substring(n + string2.length(), n + string2.length() + 1);
                boolean bl4 = bl = !"ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b".contains(string3);
            }
            if (bl2 && bl) {
                return n;
            }
            n = string.indexOf(string2, n + 1);
        }
        return -1;
    }

    public static boolean containsBeforeEnd(String string, String string2) {
        int n = string.indexOf(string2);
        if (-1 == n) {
            return false;
        }
        return string.length() > n + string2.length();
    }

    public static int findIndexOfFirstDigit(String string) {
        int n = Integer.MAX_VALUE;
        for (String string2 : DIGITS) {
            int n2 = string.indexOf(string2);
            if (n2 <= -1 || n2 >= n) continue;
            n = n2;
        }
        if (n == Integer.MAX_VALUE) {
            return -1;
        }
        return n;
    }

    public static int findIndexOfLastDigit(String string) {
        int n = -1;
        for (String string2 : DIGITS) {
            int n2 = string.lastIndexOf(string2);
            if (n2 <= -1 || n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static boolean endsWithDigit(String string) {
        for (String string2 : DIGITS) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDigit(String string) {
        return DIGITS.contains(string);
    }

    public static int indexOfFirstDigitInContinousDigitsAtEnd(String string) {
        String string2;
        int n = -1;
        int n2 = string.length() - 1;
        while (n2 >= 0 && Text.isDigit(string2 = string.substring(n2, n2 + 1))) {
            n = n2--;
        }
        return n;
    }

    public static boolean isMixedWord(String string) {
        String string2 = "[ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b]+";
        String string3 = "^" + string2 + "$";
        return string.matches(string3);
    }

    public static boolean isSubstantive(String string) {
        Matcher matcher = IS_SUBSTANTIVE_PATTERN.matcher(string);
        return matcher.matches();
    }

    public static boolean isSubstantiveHyphenSubstantive(String string) {
        Matcher matcher = IS_SUBSTANTIVE_HYPHEN_SUBSTANTIVE_PATTERN.matcher(string);
        return matcher.matches();
    }

    public static boolean isSubstantiveSpaceSubstantive(String string) {
        Matcher matcher = IS_SUBSTANTIVE_SPACE_SUBSTANTIVE_PATTERN.matcher(string);
        return matcher.matches();
    }

    public static Pair<String> isSubstantiveAndSubstantive(String string) {
        Matcher matcher = IS_SUBSTANTIVE_AND_SUBSTANTIVE_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            return new Pair<String>(string2, string3);
        }
        return NO_SUBSTANTIVE_PAIR_FOUND;
    }

    public static boolean containesSubstantive(String string) {
        Matcher matcher = CONTAINES_SUBSTANTIVE_PATTERN.matcher(string);
        return matcher.matches();
    }

    public static boolean startsWithSubstantive(String string) {
        Matcher matcher = STARTS_WITH_SUBSTANTIVE_PATTERN.matcher(string);
        return matcher.find();
    }

    public static boolean startsWithSubstantiveHyphenSubstantive(String string) {
        Matcher matcher = STARTS_WITH_SUBSTANTIVE_HYPHEN_SUBSTANTIVE_PATTERN.matcher(string);
        return matcher.find();
    }

    public static boolean startsWithSubstantiveWithUmbruch(String string) {
        Matcher matcher = STARTS_WITH_SUBSTANTIVE_WITH_UMBRUCH_PATTERN.matcher(string);
        return matcher.find();
    }

    public static String determineStartingSubstantive(String string) {
        Matcher matcher = STARTS_WITH_SUBSTANTIVE_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String determineStartingSubstantiveHyphenSubstantive(String string) {
        Matcher matcher = STARTS_WITH_SUBSTANTIVE_HYPHEN_SUBSTANTIVE_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String determineStartingSubstantiveWithUmbruch(String string) {
        Matcher matcher = STARTS_WITH_SUBSTANTIVE_WITH_UMBRUCH_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String determineEndingSubstantive(String string) {
        Matcher matcher = ENDS_WITH_SUBSTANTIVE_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static boolean endsWithSubstantiveHyphen(String string) {
        Matcher matcher = ENDS_WITH_SUBSTANTIVE_HYPHEN_PATTERN.matcher(string);
        return matcher.find();
    }

    public static boolean endsWithCommaSubstantive(String string) {
        Matcher matcher = ENDS_WITH_COMMA_SUBSTANTIVE_PATTERN.matcher(string);
        return matcher.find();
    }

    public static int findIndexOfFirstDigitAfterLastSubstantive(String string) {
        int n = Integer.MAX_VALUE;
        for (String string2 : DIGITS) {
            for (int n2 : Text.findAllPositions(string2, string)) {
                if (n2 <= -1 || n2 >= n || Text.containesSubstantive(string.substring(n2))) continue;
                n = n2;
            }
        }
        if (n == Integer.MAX_VALUE) {
            return -1;
        }
        return n;
    }

    public static int findIndexOfFirstWordLetter(String string) {
        int n = Integer.MAX_VALUE;
        for (String string2 : MIXED_CHARS_LIST) {
            int n2 = string.indexOf(string2);
            if (n2 <= -1 || n2 >= n) continue;
            n = n2;
        }
        if (n == Integer.MAX_VALUE) {
            return -1;
        }
        return n;
    }

    public static int findIndexOfLastNonWordLetter(String string, int n) {
        List<String> list = CollectionsHelper.splitStringIntoLetters(string);
        int n2 = n;
        boolean bl = true;
        while (bl) {
            if (--n2 < 0) {
                n2 = -1;
                bl = false;
                continue;
            }
            String string2 = list.get(n2);
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b".contains(string2)) continue;
            bl = false;
        }
        return n2;
    }

    public static int findIndexOfFirstNonWordLetter(String string) {
        int n = 0;
        for (String string2 : CollectionsHelper.splitStringIntoLetters(string)) {
            if (!"ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b".contains(string2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int findIndexOfFirstNonSpace(String string) {
        int n = 0;
        for (String string2 : CollectionsHelper.splitStringIntoLetters(string)) {
            if (!string2.equals(" ")) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static String indent(String string, int n) {
        String string2 = string;
        for (int i = 0; i < n; ++i) {
            string2 = Text.indent(string2);
        }
        return string2;
    }

    public static String indentAfterFirstLine(String string, int n) {
        String string2 = string;
        for (int i = 0; i < n; ++i) {
            string2 = Text.indentAfterFirstLine(string2);
        }
        return string2;
    }

    public static String indent(String string) {
        return Text.indent(string, true);
    }

    public static String indentAfterFirstLine(String string) {
        return Text.indent(string, false);
    }

    private static String indent(String string, boolean bl) {
        List<String> list = Text.splitByLineBreaks(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = true;
        for (String string2 : list) {
            Object object = bl2 && !bl ? string2 : "    " + string2;
            arrayList.add((String)object);
            bl2 = false;
        }
        Object object = Text.joinWithLineBreak(arrayList);
        if (!string.contains(LINE_BREAK) && string.contains("\n")) {
            object = ((String)object).replace(LINE_BREAK, "\n");
        }
        return object;
    }

    public static String unindent(String string, int n) {
        String string2 = string;
        for (int i = 0; i < n; ++i) {
            string2 = Text.unindent(string2);
        }
        return string2;
    }

    public static String unindent(String string) {
        List<String> list = Text.splitByLineBreaks(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            int n = string2.startsWith("    ") ? 4 : (string2.startsWith("   ") ? 3 : (string2.startsWith("  ") ? 2 : (string2.startsWith(" ") ? 1 : 0)));
            String string3 = string2.substring(n);
            arrayList.add(string3);
        }
        Object object = Text.joinWithLineBreak(arrayList);
        if (!string.contains(LINE_BREAK) && string.contains("\n")) {
            object = ((String)object).replace(LINE_BREAK, "\n");
        }
        return object;
    }

    public static String insertLetterSpacing(String string) {
        List<String> list = Text.wordToLetters(string);
        return Text.joinWithBlank(list);
    }

    public static String cleanFromPunctuation(String string) {
        String string2 = string;
        List<String> list = CollectionsHelper.buildListFrom("\n", "\r", "\t");
        list.addAll(PUNCTUATION);
        for (String string3 : list) {
            string2 = string2.replace(string3, " ");
        }
        string2 = Text.trimAndCompactSpaces(string2);
        return string2;
    }

    public static String getWordAtIndex(String string, int n) {
        if (n < 0 || n >= string.length()) {
            throw new IllegalArgumentException("Der Index " + n + " liegt nicht innerhalb des \u00fcbergebenen Textes '" + string + "'.");
        }
        List<String> list = CollectionsHelper.splitStringIntoLetters(string);
        String string2 = list.get(n);
        if (!MIXED_CHARS_LIST.contains(string2)) {
            return "";
        }
        int n2 = n;
        boolean bl = true;
        while (bl) {
            if (n2 >= 1) {
                String string3 = list.get(n2 - 1);
                if (MIXED_CHARS_LIST.contains(string3)) {
                    --n2;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        }
        int n3 = n;
        boolean bl2 = true;
        while (bl2) {
            if (n3 <= string.length() - 2) {
                String string4 = list.get(n3 + 1);
                if (MIXED_CHARS_LIST.contains(string4)) {
                    ++n3;
                    continue;
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
        }
        int n4 = n3 + 1;
        return string.substring(n2, n4);
    }

    public static List<String> getDistinctWordsContaining(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Integer n : Text.findAllPositions(string2, string)) {
            if (n >= string.length()) continue;
            String string3 = Text.getWordAtIndex(string, n);
            arrayList.add(string3);
        }
        CollectionsHelper.makeListDisjunct(arrayList);
        return arrayList;
    }

    public static String lastChars(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        int n2 = string.length() - n;
        return "... " + string.substring(n2);
    }

    public static String lastThreeChars(String string) {
        if (string.length() < 3) {
            throw new IllegalArgumentException("Der Input ist zu kurz! input = '" + string + "'!");
        }
        return string.substring(string.length() - 3);
    }

    public static int findIndexOfLastCharContained(String string, String string2) {
        int n = string.length();
        boolean bl = false;
        while (!bl) {
            if (--n < 0) {
                return -1;
            }
            String string3 = string.substring(n, n + 1);
            if (!string2.contains(string3)) continue;
            bl = true;
        }
        return n;
    }

    public static String extractLastWord(String string) {
        int n = Text.findIndexOfLastWordChar(string);
        if (-1 == n) {
            return "";
        }
        int n2 = ++n;
        while (n2 > 0) {
            String string2;
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b".contains(string2 = string.substring(--n2, n2 + 1))) continue;
            ++n2;
            break;
        }
        return string.substring(n2, n);
    }

    private static int findIndexOfLastWordChar(String string) {
        return Text.findIndexOfLastCharContained(string, "ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b");
    }

    public static String extractFromLastUpperLetter(String string) {
        int n = Text.findIndexOfLastUppercaseChar(string);
        if (-1 == n) {
            return "";
        }
        int n2 = Text.findIndexOfLastWordChar(string);
        if (-1 == n2) {
            return "";
        }
        return string.substring(n, n2 + 1);
    }

    private static int findIndexOfLastUppercaseChar(String string) {
        return Text.findIndexOfLastCharContained(string, BIG_CHARS);
    }

    public static String lineDifference(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        Object object = "";
        if (n < n2) {
            object = "Die erste Zeile ist k\u00fcrzer: " + n + " < " + n2 + ".";
        } else if (n > n2) {
            object = "Die erste Zeile ist l\u00e4nger: " + n + " < " + n2 + ".";
        }
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            String string3;
            String string4 = string.substring(i, i + 1);
            if (string4.equals(string3 = string2.substring(i, i + 1))) continue;
            return "Am Index " + i + " unterscheiden sich die beiden Zeilen:\n\tZeichen der ersten Zeile : '" + string4 + "'\n\tZeichen der zweiten Zeile: '" + string3 + "'" + (((String)object).length() > 0 ? "\n" : "") + (String)object;
        }
        if (n3 == 0 && n != n2) {
            return object;
        }
        return "";
    }

    public static String firstChars(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Die L\u00e4nge darf nicht negativ sein!\n\tlength = " + n + "\n");
        }
        if (string.length() > n) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String removePunctuationAtFrontAndEnd(String string) {
        String string2 = string;
        string2 = string2.strip();
        for (String string3 : PUNCTUATION_MARKS) {
            string2 = Text.removeTextAtEndIfEndsWith(string2, string3).strip();
            string2 = Text.removeTextAtStartIfStartsWith(string2, string3).strip();
        }
        if (string.equals(string2)) {
            return string2;
        }
        return Text.removePunctuationAtFrontAndEnd(string2);
    }

    public static int countNumberOfSpacesAtBegin(String string) {
        int n = 0;
        boolean bl = true;
        while (bl) {
            if (n >= string.length()) {
                bl = false;
                continue;
            }
            String string2 = string.substring(n, n + 1);
            if (string2.equals(" ")) {
                ++n;
                continue;
            }
            bl = false;
        }
        return n;
    }

    public static String surroundSeparatingPipesWithBlanks(String string) {
        return string.replaceAll("(\\S)\\|(\\S)", "$1 \\| $2");
    }

    public static String surroundPipesWithBlanks(String string) {
        String string2 = string;
        string2 = string2.replaceAll("^\\|", " \\|");
        string2 = string2.replaceAll("\\|$", "\\| ");
        string2 = string2.replaceAll("\\|(?=\\|)", "\\| ");
        string2 = string2.replaceAll("(\\S)\\|", "$1 \\|");
        string2 = string2.replaceAll("\\|(\\S)", "\\| $1");
        string2 = string2.replaceAll("(\\S)\\|(\\S)", "$1 \\| $2");
        return string2;
    }

    public static String backslashToCodeForm(String string) {
        return string.replace("\\", "\\\\");
    }

    public static String hideQuotesForSourceCode(String string) {
        return string.replace("\"", "\\\"");
    }

    public static List<String> searchNumberWithDifferentSpacesInText(String string, String string2) {
        List<String> list = Text.determineNumbersWithDifferentSpaces(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : list) {
            if (!string2.contains(string3)) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static List<String> determineNumbersWithDifferentSpaces(String string) {
        if (string.length() < 11) {
            return Text.determineNumberWithAllDifferentSpaces(string);
        }
        return Text.determineNumbersWithDifferentSpacesBetweenDigitBorders(string);
    }

    public static List<String> determineNumberWithAllDifferentSpaces(String string) {
        String string2 = Text.removeSpaces(string);
        List<String> list = Text.wordToLetters(string2);
        return Text.generateAllDifferentMixesOfPartsBySpaces(list);
    }

    private static List<String> generateAllDifferentMixesOfPartsBySpaces(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (arrayList.isEmpty()) {
                arrayList.add(string);
                continue;
            }
            List<String> list2 = CollectionsHelper.copyList(arrayList);
            arrayList.clear();
            for (String string2 : list2) {
                arrayList.add(string2 + string);
                arrayList.add(string2 + " " + string);
            }
        }
        CollectionsHelper.makeListDisjunct(arrayList);
        return arrayList;
    }

    public static List<String> determineNumbersWithDifferentSpacesBetweenDigitBorders(String string) {
        List<String> list = Text.splitAtDigitBorders(string);
        if (list.size() < 11) {
            return Text.generateAllDifferentMixesOfPartsBySpaces(list);
        }
        return CollectionsHelper.buildListFrom(string);
    }

    public static List<String> splitAtDigitBorders(String string) {
        String string2 = Text.trimAndCompactSpaces(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        for (int i = 0; i < string2.length(); ++i) {
            String string3 = string2.substring(i, i + 1);
            if (arrayList.isEmpty()) {
                arrayList.add(string3);
                bl = !Text.isDigit(string3);
                continue;
            }
            boolean bl2 = bl;
            boolean bl3 = bl = !Text.isDigit(string3);
            if (string3.equals(" ")) continue;
            if (bl || bl2) {
                arrayList.add(string3);
                continue;
            }
            String string4 = (String)arrayList.get(arrayList.size() - 1);
            arrayList.set(arrayList.size() - 1, string4 + string3);
        }
        return arrayList;
    }

    public static FoundSearch findLongest(String string, List<String> list) {
        FoundSearch foundSearch = FoundSearch.NOT_FOUND;
        for (String string2 : list) {
            int n = string.lastIndexOf(string2);
            if (n <= -1 || foundSearch.wasSuccessfull() && foundSearch.getSearch().length() >= string2.length()) continue;
            foundSearch = new FoundSearch(n, string2);
        }
        return foundSearch;
    }

    public static String findLongestAtStart(String string, List<String> list) {
        String string2 = "";
        for (String string3 : list) {
            if (!string.startsWith(string3) || string2.length() >= string3.length()) continue;
            string2 = string3;
        }
        return string2;
    }

    public static FoundSearch findLastListElementInText(String string, List<String> list) {
        FoundSearch foundSearch = FoundSearch.NOT_FOUND;
        for (String string2 : list) {
            int n = string.lastIndexOf(string2);
            if (n <= -1) continue;
            boolean bl = false;
            if (foundSearch.wasSuccessfull()) {
                if (n > foundSearch.getIndex()) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (!bl) continue;
            foundSearch = new FoundSearch(n, string2);
        }
        return foundSearch;
    }

    public static List<FoundSearch> findAllSearchPhrasesInText(String string, List<String> list) {
        ArrayList<FoundSearch> arrayList = new ArrayList<FoundSearch>();
        for (String string2 : list) {
            int n = 0;
            int n2 = string.indexOf(string2, n);
            while (n2 > -1) {
                FoundSearch foundSearch = new FoundSearch(n2, string2);
                arrayList.add(foundSearch);
                n = n2 + string2.length();
                n2 = string.indexOf(string2, n);
            }
        }
        return arrayList;
    }

    public static String removeCommaAtStart(String string) {
        String string2 = string;
        string2 = string2.strip();
        string2 = Text.removeTextAtFrontIfStartsWith(string2, ",");
        return string2.strip();
    }

    public static String removeCommaAtEnd(String string) {
        String string2 = string;
        string2 = string2.strip();
        string2 = Text.removeTextAtEndIfEndsWith(string2, ",");
        return string2.strip();
    }

    public static List<String> createJavaMethodComment(String string) {
        String string2 = "    /**";
        String string3 = "     */";
        String string4 = "     * ";
        String string5 = "    /** ";
        String string6 = " */";
        String string7 = Text.stripWhitespace(string);
        String string8 = string5 + string7 + string6;
        if (string8.length() < 100) {
            return CollectionsHelper.buildListFrom(string8);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        int n = 99 - string4.length();
        String string9 = Text.addLineBreaks(string7, n);
        for (String string10 : Text.splitByLineBreaks(string9)) {
            String string11 = string4 + string10;
            arrayList.add(string11);
        }
        arrayList.add(string3);
        return arrayList;
    }

    public static List<String> createJavaHeadCommentLines(String string) {
        return Text.createJavaCommentLines(string, 0);
    }

    public static List<String> createJavaMethodCommentLines(String string) {
        return Text.createJavaCommentLines(string, 4);
    }

    public static List<String> createJavaInMethodCommentLines(String string) {
        return Text.createJavaCommentLines(string, 8);
    }

    public static List<String> createJavaCommentLines(String string, int n) {
        String string2;
        String string3 = Text.multipleString(" ", n) + " * ";
        String string4 = string3 + (string2 = Text.stripWhitespace(string));
        if (string4.length() < 100) {
            return CollectionsHelper.buildListFrom(string4);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 99 - string3.length();
        String string5 = Text.addLineBreaks(string2, n2);
        for (String string6 : Text.splitByLineBreaks(string5)) {
            String string7 = string3 + string6;
            arrayList.add(string7);
        }
        return arrayList;
    }

    public static List<String> createJavaCommand(String string, int n) {
        String string2 = Text.multipleString(" ", n) + Text.stripWhitespace(string);
        if (string2.length() < 100) {
            return CollectionsHelper.buildListFrom(string2);
        }
        int n2 = 100;
        int n3 = n + 8;
        String string3 = Text.addLineBreaks(string2, n2, n3);
        return Text.splitByLineBreaks(string3);
    }

    public static String changeBeginningToGenitiv(String string) {
        List<String> list = Text.splitByWhitespace(string);
        if (list.size() < 2) {
            return string;
        }
        String string2 = list.get(0);
        List<String> list2 = list.subList(1, list.size());
        if (string2.equals("der")) {
            return Text.changeMaleBeginningToGenitiv(list2);
        }
        if (string2.equals("die")) {
            return Text.changeFemaleBeginningToGenitiv(list2);
        }
        if (string2.equals("das")) {
            return Text.changeNeutralBeginningToGenitiv(list2);
        }
        return string;
    }

    private static String changeMaleBeginningToGenitiv(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("des");
        String string = list.get(0);
        List<String> list2 = list.subList(1, list.size());
        if (Text.firstLetterIsCapitalLetter(string)) {
            string = Text.maleNomenToGenitiv(string);
            arrayList.add(string);
        } else {
            string = Text.maleAdjectivToGenitiv(string);
            arrayList.add(string);
            if (!list2.isEmpty()) {
                String string2 = list2.remove(0);
                if (Text.firstLetterIsCapitalLetter(string2)) {
                    string2 = Text.maleNomenToGenitiv(string2);
                }
                arrayList.add(string2);
            }
        }
        arrayList.addAll(list2);
        return Text.joinWithBlank(arrayList);
    }

    private static String changeFemaleBeginningToGenitiv(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("der");
        String string = list.get(0);
        List<String> list2 = list.subList(1, list.size());
        if (Text.firstLetterIsCapitalLetter(string)) {
            string = Text.femaleNomenToGenitiv(string);
            arrayList.add(string);
        } else {
            string = Text.femaleAdjectivToGenitiv(string);
            arrayList.add(string);
            if (!list2.isEmpty()) {
                String string2 = list2.remove(0);
                if (Text.firstLetterIsCapitalLetter(string2)) {
                    string2 = Text.femaleNomenToGenitiv(string2);
                }
                arrayList.add(string2);
            }
        }
        arrayList.addAll(list2);
        return Text.joinWithBlank(arrayList);
    }

    private static String changeNeutralBeginningToGenitiv(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("des");
        String string = list.get(0);
        List<String> list2 = list.subList(1, list.size());
        if (Text.firstLetterIsCapitalLetter(string)) {
            string = Text.neutralNomenToGenitiv(string);
            arrayList.add(string);
        } else {
            string = Text.neutralAdjectivToGenitiv(string);
            arrayList.add(string);
            if (!list2.isEmpty()) {
                String string2 = list2.remove(0);
                if (Text.firstLetterIsCapitalLetter(string2)) {
                    string2 = Text.neutralNomenToGenitiv(string2);
                }
                arrayList.add(string2);
            }
        }
        arrayList.addAll(list2);
        return Text.joinWithBlank(arrayList);
    }

    public static String maleNomenToGenitiv(String string) {
        if (string.endsWith("n")) {
            return string + "es";
        }
        if (string.endsWith("e")) {
            return string + "ns";
        }
        if (string.endsWith("Ort")) {
            return string + "es";
        }
        switch (string) {
            case "xxx": {
                return "xxx";
            }
        }
        return string + "s";
    }

    public static String femaleNomenToGenitiv(String string) {
        return string;
    }

    public static String neutralNomenToGenitiv(String string) {
        return string + "es";
    }

    private static String maleAdjectivToGenitiv(String string) {
        if (string.endsWith("e")) {
            return string + "n";
        }
        return string;
    }

    private static String femaleAdjectivToGenitiv(String string) {
        if (string.endsWith("e")) {
            return string + "n";
        }
        return string;
    }

    private static String neutralAdjectivToGenitiv(String string) {
        if (string.endsWith("e")) {
            return string + "n";
        }
        return string;
    }

    public static final String replaceUmlauts(String string) {
        String string2 = string;
        string2 = string2.replace("\u00c4", "Ae");
        string2 = string2.replace("\u00d6", "Oe");
        string2 = string2.replace("\u00dc", "Ue");
        string2 = string2.replace("\u00e4", "ae");
        string2 = string2.replace("\u00f6", "oe");
        string2 = string2.replace("\u00fc", "ue");
        string2 = string2.replace("\u00df", "ss");
        return string2;
    }

    public static String createJavaClassName(String string) {
        String string2 = Text.createJavaVariableName(string);
        string2 = Text.firstCharToUpperCase(string2);
        return string2;
    }

    public static String createJavaVariableName(String string) {
        String string22;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string22 : Text.createReplacedPartsForJava(string)) {
            if (bl) {
                bl = false;
                stringBuilder.append(string22);
                continue;
            }
            stringBuilder.append(Text.toFirstUpperCase(string22));
        }
        Object object = stringBuilder.toString();
        string22 = NumberString.findNaturalNumberAtStartString((String)object);
        object = ((String)object).substring(string22.length());
        object = Text.firstCharToLowerCase((String)object);
        return object;
    }

    public static String createJavaConstantName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string2 : Text.createReplacedPartsForJava(string)) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("_");
            }
            stringBuilder.append(Text.toUpperCase(string2));
        }
        return stringBuilder.toString();
    }

    private static List<String> createReplacedPartsForJava(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string.replaceAll(NOT_PART_OF_FILENAMES_REGEX_WITH_HYPHEN_AND_UNDERSCORE, " ");
        string2 = string2.replaceAll("([a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b])([A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c])", "$1 $2");
        string2 = Text.stripWhitespace(string2);
        Iterator<String> iterator = Text.splitByWhitespace(string2).iterator();
        while (iterator.hasNext()) {
            String string3;
            String string4 = string3 = iterator.next();
            string4 = Text.replaceUmlauts(string4);
            string4 = Text.toLowerCase(string4);
            arrayList.add(string4);
        }
        return arrayList;
    }

    public static String prepareForFilename(String string) {
        String string2 = string;
        string2 = string2.strip();
        string2 = string2.replaceAll(NOT_PART_OF_FILENAMES_REGEX_WITH_HYPHEN_AND_UNDERSCORE, "_");
        string2 = string2.replaceAll("([a-z\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b])([A-Z\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010c])", "$1_$2");
        string2 = string2.replaceAll("\\s+", "_");
        string2 = string2.replaceAll("\\r", "_");
        string2 = string2.replaceAll("\\n", "_");
        string2 = string2.replaceAll("_+", "_");
        string2 = Text.replaceUmlauts(string2);
        string2 = Text.toLowerCase(string2);
        return string2;
    }

    public static List<String> splitCamelCase(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = "";
        for (String string2 : CollectionsHelper.splitStringIntoLetters(string)) {
            if (BIG_CHARS.contains(string2)) {
                if (!((String)object).isEmpty()) {
                    arrayList.add((String)object);
                }
                object = string2;
                continue;
            }
            if (SMALL_CHARS.contains(string2)) {
                object = (String)object + string2;
                continue;
            }
            throw new IllegalArgumentException("Die Eingabe '" + string + "' liegt nicht im CamelCase vor.");
        }
        if (!((String)object).isEmpty()) {
            arrayList.add((String)object);
        }
        return arrayList;
    }

    public static String separateCamelCase(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string3 : Text.splitCamelCase(string)) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(string2);
            }
            stringBuilder.append(Text.toLowerCase(string3));
        }
        return stringBuilder.toString();
    }

    public static List<String> breakLongJavaMethodStart(String string) {
        String string2 = Text.addLineBreaks(string, 100, 12);
        List<String> list = Text.splitByLineBreaks(string2);
        for (int i = 0; i < list.size() - 1; ++i) {
            String string3 = list.get(i);
            Matcher matcher = NO_BREAK_AFTER_TYPE.matcher(string3);
            if (!matcher.find()) continue;
            String string4 = matcher.group();
            string4 = string4.substring(1);
            string3 = Text.removeTextAtEndIfEndsWith(string3, string4);
            Object object = list.get(i + 1);
            int n = Text.findIndexOfFirstWordLetter((String)object);
            if (n <= -1) continue;
            String string5 = ((String)object).substring(0, n);
            String string6 = ((String)object).substring(n);
            object = string5 + string4.strip() + " " + string6;
            list.set(i, string3);
            list.set(i + 1, (String)object);
        }
        return list;
    }

    public static boolean endsWithLetter(String string) {
        return Text.endsWithBigLetter(string) || Text.endsWithSmallLetter(string);
    }

    public static boolean endsWithBigLetter(String string) {
        if (string.isEmpty()) {
            return false;
        }
        String string2 = string.substring(string.length() - 1, string.length());
        return BIG_CHARS.contains(string2);
    }

    public static boolean endsWithSmallLetter(String string) {
        if (string.isEmpty()) {
            return false;
        }
        String string2 = string.substring(string.length() - 1, string.length());
        return SMALL_CHARS.contains(string2);
    }

    public static boolean startsWithLetter(String string) {
        return Text.startsWithBigLetter(string) || Text.startsWithSmallLetter(string);
    }

    public static boolean startsWithBigLetter(String string) {
        if (string.isEmpty()) {
            return false;
        }
        String string2 = string.substring(0, 1);
        return BIG_CHARS.contains(string2);
    }

    public static boolean startsWithSmallLetter(String string) {
        if (string.isEmpty()) {
            return false;
        }
        String string2 = string.substring(0, 1);
        return SMALL_CHARS.contains(string2);
    }

    public static boolean endsWithRegex(String string, String string2) {
        Pattern pattern = Pattern.compile(string2 + "$");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public static String replacePhrasesInText(String string, String string2, String string3) {
        if (string2.isBlank()) {
            return string;
        }
        int n = string2.length();
        int n2 = 0;
        boolean bl = true;
        String string4 = string;
        while (bl) {
            int n3 = string4.indexOf(string2, n2);
            if (n3 == -1) {
                bl = false;
                continue;
            }
            boolean bl2 = false;
            int n4 = n3 + n;
            if (string4.length() == n4) {
                bl2 = true;
                bl = false;
            } else {
                String string5 = string4.substring(n4, n4 + 1);
                if (!"ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b".contains(string5)) {
                    bl2 = true;
                }
            }
            if (bl2) {
                string4 = Text.replaceInText(string4, string3, n3, n4);
                n2 = n3 + string3.length();
                continue;
            }
            n2 = n4;
        }
        return string4;
    }

    public static boolean containsOnlyBigLetters(String string) {
        Matcher matcher = CONTAINES_ONLY_BIG_LETTERS_PATTERN.matcher(string);
        return matcher.matches();
    }

    public static boolean containsOnlyBigLettersAndHyphens(String string) {
        Matcher matcher = CONTAINES_ONLY_BIG_LETTERS_AND_HYPHENS_PATTERN.matcher(string);
        return matcher.matches();
    }

    public static List<String> createLongJavaStringDefinition(String string, String string2) {
        int n = 8;
        int n2 = 100;
        return Text.createLongJavaStringDefinition(string, string2, n, n2);
    }

    public static List<String> createLongJavaStringDefinition(String string, String string2, int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = Text.multipleString(" ", n) + "String " + string + " = \"\"";
        arrayList.add(string3);
        int n3 = n + 8;
        int n4 = 5;
        String string4 = Text.escapeDoubleQuotes(string2);
        int n5 = n2 - n3 - n4;
        String string5 = Text.addLineBreaksKeepSpacesAtBreaks(string4, n5);
        List<String> list = Text.splitByLineBreaks(string5);
        for (int i = 0; i < list.size(); ++i) {
            String string6 = list.get(i);
            String string7 = Text.multipleString(" ", n3) + "+ \"" + string6 + "\"";
            if (i == list.size() - 1) {
                string7 = string7 + ";";
            }
            arrayList.add(string7);
        }
        return arrayList;
    }

    public static boolean isInsideBrace(String string, int n) {
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        FoundSearch foundSearch = Text.findLast(string2, ROUND_BRACES);
        FoundSearch foundSearch2 = Text.findFirstPosition(string3, ROUND_BRACES);
        if (foundSearch.wasSuccessfull() && foundSearch2.wasSuccessfull()) {
            String string4 = foundSearch.getSearch();
            String string5 = foundSearch2.getSearch();
            return "(".equals(string4) && ")".equals(string5);
        }
        return false;
    }

    public static String shortenJavaClassName(String string) {
        int n = string.lastIndexOf(".");
        if (n > -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String getShortenedJavaClassName(Class<?> clazz) {
        String string = clazz.getName();
        return Text.shortenJavaClassName(string);
    }

    public static Pair<String> splitByFirstOccurence(String string, String ... stringArray) {
        List<String> list = CollectionsHelper.arrayToList(stringArray);
        return Text.splitByFirstOccurence(string, list);
    }

    public static Pair<String> splitByFirstOccurence(String string, List<String> list) {
        FoundSearch foundSearch = Text.findFirstPosition(string, list);
        if (foundSearch.wasSuccessfull()) {
            int n = foundSearch.getIndex();
            String string2 = string.substring(0, n);
            String string3 = string.substring(n);
            return new Pair<String>(string2, string3);
        }
        throw new RuntimeException("Keiner der Suchbegriffe wurde im Text gefunden.\n\tText = '" + string + "'\n\tSuchbegriffe:\n" + CollectionsHelper.listListNice(list));
    }

    public static Pair<String> splitAfterFirstOccurence(String string, String ... stringArray) {
        List<String> list = CollectionsHelper.arrayToList(stringArray);
        return Text.splitAfterFirstOccurence(string, list);
    }

    public static Pair<String> splitAfterFirstOccurence(String string, List<String> list) {
        FoundSearch foundSearch = Text.findFirstPosition(string, list);
        if (foundSearch.wasSuccessfull()) {
            int n = foundSearch.getEnd();
            String string2 = string.substring(0, n);
            String string3 = string.substring(n);
            return new Pair<String>(string2, string3);
        }
        throw new RuntimeException("Keiner der Suchbegriffe wurde im Text gefunden.\n\tText = '" + string + "'\n\tSuchbegriffe:\n" + CollectionsHelper.listListNice(list));
    }

    public static Pair<String> splitByFirstOccurenceWithoutSearch(String string, String ... stringArray) {
        List<String> list = CollectionsHelper.arrayToList(stringArray);
        return Text.splitByFirstOccurenceWithoutSearch(string, list);
    }

    public static Pair<String> splitByFirstOccurenceWithoutSearch(String string, List<String> list) {
        FoundSearch foundSearch = Text.findFirstPosition(string, list);
        if (foundSearch.wasSuccessfull()) {
            int n = foundSearch.getIndex();
            int n2 = foundSearch.getEnd();
            String string2 = string.substring(0, n);
            String string3 = string.substring(n2);
            return new Pair<String>(string2, string3);
        }
        throw new RuntimeException("Keiner der Suchbegriffe wurde im Text gefunden.\n\tText = '" + string + "'\n\tSuchbegriffe:\n" + CollectionsHelper.listListNice(list));
    }

    public static boolean isMultipleString(String string, String string2) {
        if (string2.isEmpty()) {
            return string.isEmpty();
        }
        if (!string.startsWith(string2) || !string.endsWith(string2)) {
            return false;
        }
        Object object = "";
        while (string.startsWith((String)object) && string.length() > ((String)object).length()) {
            if (!string.equals(object = (String)object + string2)) continue;
            return true;
        }
        return false;
    }

    public static String replaceFirstMatch(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        String string4 = string.substring(0, n);
        int n2 = n + string2.length();
        String string5 = string.substring(n2);
        return string4 + string3 + string5;
    }

    public static List<String> textToCharactersList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(i, i + 1);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static String concatenate(String string, String string2) {
        if (string.isEmpty()) {
            return string2;
        }
        if (string2.isEmpty()) {
            return string;
        }
        String string3 = string.substring(string.length() - 1, string.length());
        String string4 = string2.substring(0, 1);
        if (string3.equals(" ") || string4.equals(" ")) {
            return string + string2;
        }
        return string + " " + string2;
    }

    public static String concatenate(List<String> list) {
        String string = "";
        for (String string2 : list) {
            string = Text.concatenate(string, string2);
        }
        return string;
    }

    public static String replaceSpecialUtf8Chars(String string) {
        String string2 = string;
        string2 = string2.replace("\u201e", "\"");
        string2 = string2.replace("\u201c", "\"");
        string2 = string2.replace("\u201d", "\"");
        string2 = string2.replace("\u2013", "-");
        string2 = string2.replace("\u2022", "-");
        string2 = string2.replace("\u2019", "'");
        string2 = string2.replace("\u2018", "'");
        string2 = string2.replace("\u201a", ",");
        return string2;
    }

    public static boolean isInAlphabeticalOrder(String ... stringArray) {
        List<String> list = CollectionsHelper.arrayToList(stringArray);
        List<String> list2 = CollectionsHelper.arrayToList(stringArray);
        Collections.sort(list2);
        return list.equals(list2);
    }

    public static boolean equalsIgnoringRoundOrSquareBrackets(String string, String string2) {
        String string3 = Text.removeRoundOrQuareBraces(string);
        String string4 = Text.removeRoundOrQuareBraces(string2);
        return string3.equals(string4);
    }

    private static String removeRoundOrQuareBraces(String string) {
        if (string.startsWith("(") && string.endsWith(")")) {
            return string.substring(1, string.length() - 1);
        }
        if (string.startsWith("[") && string.endsWith("]")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static int compareStringsBetter(String string, String string2) {
        String string3 = Text.toLowerCase(string);
        String string4 = Text.toLowerCase(string2);
        int n = (string3 = Text.replaceSmallUmlautsAndSz(string3)).compareTo(string4 = Text.replaceSmallUmlautsAndSz(string4));
        if (n == 0) {
            return string.compareTo(string2);
        }
        return n;
    }

    private static String replaceSmallUmlautsAndSz(String string) {
        String string2 = string;
        string2 = string2.replace("\u00e4", "ae");
        string2 = string2.replace("\u00f6", "oe");
        string2 = string2.replace("\u00fc", "ue");
        string2 = string2.replace("\u00df", "ss");
        return string2;
    }

    public static boolean containsAsWholeWord(String string, String string2) {
        int n = 0;
        boolean bl = true;
        boolean bl2 = false;
        while (bl) {
            int n2 = string.indexOf(string2, n);
            if (n2 == -1) {
                bl2 = false;
                bl = false;
                continue;
            }
            if (Text.containsAsWholeWordAtIndex(string, string2, n2)) {
                bl2 = true;
                bl = false;
                continue;
            }
            n = n2 + string2.length();
        }
        return bl2;
    }

    private static boolean containsAsWholeWordAtIndex(String string, String string2, int n) {
        String string3;
        String string4 = string.substring(0, n);
        String string5 = string.substring(n + string2.length());
        if (!string4.isEmpty() && "ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b".contains(string3 = string4.substring(string4.length() - 1))) {
            return false;
        }
        return string5.isEmpty() || !"ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dc\u00c1\u00c9\u00cd\u00d3\u00da\u00c0\u00c8\u00cc\u00d2\u00d9\u00c2\u00ca\u00ce\u00d4\u00db\u00c7\u015e\u010cabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df\u00e1\u00e9\u00ed\u00f3\u00fa\u00e0\u00e8\u00ec\u00f2\u00f9\u00e2\u00ea\u00ee\u00f4\u00fb\u00f8\u00e7\u00f1\u010d\u0144\u00e3\u0103\u00e6\u0107\u015f\u0142\u0161\u00ef\u00fd\u00f5\u00eb\u015b".contains(string3 = string5.substring(0, 1));
    }

    public static int indexOfAsWholeWord(String string, String string2) {
        return Text.indexOfAsWholeWord(string, string2, 0);
    }

    public static int indexOfAsWholeWord(String string, String string2, int n) {
        int n2 = n;
        boolean bl = true;
        int n3 = -1;
        while (bl) {
            int n4 = string.indexOf(string2, n2);
            if (n4 == -1) {
                n3 = -1;
                bl = false;
                continue;
            }
            if (Text.containsAsWholeWordAtIndex(string, string2, n4)) {
                n3 = n4;
                bl = false;
                continue;
            }
            n2 = n4 + string2.length();
        }
        return n3;
    }

    public static String hideWholeWordsInText(String string, List<String> list) {
        Object object = string;
        for (String string2 : list) {
            boolean bl = true;
            while (bl) {
                int n;
                int n2 = Text.indexOfAsWholeWord((String)object, string2);
                if (n2 == -1) {
                    bl = false;
                    continue;
                }
                String string3 = ((String)object).substring(0, n2);
                String string4 = ((String)object).substring(n2 + string2.length());
                int n3 = string2.length();
                String string5 = Text.multipleString("#", n3);
                int n4 = ((String)object).length();
                if (n4 == (n = ((String)(object = string3 + string5 + string4)).length())) continue;
                throw new RuntimeException("Fehler bei der Ersetzung von ganzen Worten in Texten:\n\ttext        = '" + string + "'\n\tchangedText = '" + (String)object + "'\n\twordToHide  = '" + string2 + "'\n\toldLength   = " + n4 + "\n\tnewLength   = " + n + "\n");
            }
        }
        return object;
    }

    public static List<String> findTextsBetweenDifferentStartAndEndQuotes(String string, String string2, String string3) {
        int n;
        int n2;
        int n3;
        List<Integer> list = Text.findAllPositions(string2, string);
        List<Integer> list2 = Text.findAllPositions(string3, string);
        if (list.size() != list2.size() || list.isEmpty()) {
            return new ArrayList<String>();
        }
        for (int i = 0; i < list.size(); ++i) {
            n3 = list.get(i);
            if (n3 >= (n2 = list2.get(i).intValue())) {
                return new ArrayList<String>();
            }
            if (i <= 0 || n3 > (n = list2.get(i - 1).intValue())) continue;
            return new ArrayList<String>();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n3 = 0; n3 < list.size(); ++n3) {
            n2 = list.get(n3);
            n = list2.get(n3);
            String string4 = string.substring(n2 + 1, n);
            arrayList.add(string4);
        }
        return arrayList;
    }

    public static List<String> findTextsBetweenJapaneseQuotes(String string) {
        return Text.findTextsBetweenDifferentStartAndEndQuotes(string, "\u300c", "\u300d");
    }

    public static String removeSpacesAtStart(String string) {
        String string2 = string;
        while (!string2.isEmpty() && string2.startsWith(" ")) {
            string2 = string2.substring(1);
        }
        return string2;
    }
}

