/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.extract.tools;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.List;

public class PrepareLines {
    private static final List<String> NON_WORD_CHARS = CollectionsHelper.buildListFrom("(", ")", "[", "]", "{", "}", "<", ">", "\u201e", "\u201c", "\u2018", "'", "\u00b4", "`", "\"", "/", "|", ",", ".", ";", ":", "!", "?", "\u00a7", "$", "%", "&", "=", "_", "#", "\u00b2", "\u00b3", "^", "\u00b0", "*", "+", "~");
    private final String text;
    private List<String> lines;

    public PrepareLines(String string) {
        this.text = string;
        this.splitTextIntoLines();
        this.removeBbCodeAndNonWordCharactersFromLines();
    }

    private void splitTextIntoLines() {
        this.lines = Text.splitByLineBreaks(this.text);
    }

    private void removeBbCodeAndNonWordCharactersFromLines() {
        this.lines = this.removeBbCodeAndNonWordCharactersFromLinesInternal();
    }

    private List<String> removeBbCodeAndNonWordCharactersFromLinesInternal() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.lines) {
            arrayList.add(this.removeBbCodeAndNonWordCharacters(string));
        }
        return arrayList;
    }

    private String removeBbCodeAndNonWordCharacters(String string) {
        String string2 = string;
        string2 = this.removeBbCode(string2);
        string2 = this.removeNonWordCharacters(string2);
        return string2;
    }

    private String removeBbCode(String string) {
        String string2 = string;
        string2 = string2.replaceAll("\\[/?[^\\]]+\\]", " ");
        return string2;
    }

    private String removeNonWordCharacters(String string) {
        String string2 = string;
        for (String string3 : NON_WORD_CHARS) {
            string2 = string2.replace(string3, " ");
        }
        return string2;
    }

    public List<String> getLines() {
        return this.lines;
    }
}

