/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.sort;

import de.duehl.basics.text.sort.tools.SortableElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WordsSorter {
    private final List<String> words;
    private final Map<String, SortableElement> sortableByWord;

    public WordsSorter(List<String> list) {
        this.words = list;
        this.sortableByWord = this.createMap();
    }

    private Map<String, SortableElement> createMap() {
        HashMap<String, SortableElement> hashMap = new HashMap<String, SortableElement>();
        for (String string : this.words) {
            SortableElement sortableElement = new SortableElement(string);
            hashMap.put(string, sortableElement);
        }
        return hashMap;
    }

    public void sort() {
        Collections.sort(this.words, (string, string2) -> this.compareWords((String)string, (String)string2));
    }

    private int compareWords(String string, String string2) {
        String string3;
        String string4 = this.sortableByWord.get(string).getCompareWord();
        int n = string4.compareTo(string3 = this.sortableByWord.get(string2).getCompareWord());
        if (n == 0) {
            n = string.compareTo(string2);
        }
        return n;
    }
}

