/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.version;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.List;

public final class Version
implements Comparable<Version> {
    private static final String SERIALIZATION_SEPARATOR = "#;#";
    private final String version;
    private final String date;
    private final List<Integer> numericVersion;

    public Version(String string, String string2) {
        this.date = string2;
        this.version = string;
        this.numericVersion = new ArrayList<Integer>();
        this.initNumericVersion(string);
    }

    private void initNumericVersion(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("[^0-9a-zA-Z]+")) {
            this.initNumericVersionPart(string2);
        }
    }

    private void initNumericVersionPart(String string) {
        if (string.matches("[0-9]+")) {
            this.initNumericVersionNumericalPart(string);
        } else if (string.matches("[a-zA-Z]+")) {
            this.initNumericVersionAlphanumericalPart(string);
        } else {
            this.initNumericVersionMixedPart(string);
        }
    }

    private void initNumericVersionNumericalPart(String string) {
        int n = Integer.parseInt(string);
        this.numericVersion.add(n);
    }

    private void initNumericVersionAlphanumericalPart(String string) {
        char[] cArray;
        for (char c : cArray = string.toCharArray()) {
            this.initNumericVersionAlphanumericalChar(c);
        }
    }

    private void initNumericVersionAlphanumericalChar(char c) {
        char c2 = c;
        this.numericVersion.add(Integer.valueOf(c2));
    }

    private void initNumericVersionMixedPart(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : cArray) {
            String string2 = String.valueOf(c);
            if (string2.matches("[a-zA-Z]")) {
                if (bl) {
                    bl = false;
                    String string3 = stringBuilder.toString();
                    this.initNumericVersionNumericalPart(string3);
                    stringBuilder.delete(0, stringBuilder.length());
                }
                this.initNumericVersionAlphanumericalChar(c);
                continue;
            }
            bl = true;
            stringBuilder.append(c);
        }
        if (bl) {
            String string4 = stringBuilder.toString();
            this.initNumericVersionNumericalPart(string4);
        }
    }

    public String getVersion() {
        return this.version;
    }

    protected List<Integer> getNumericVersion() {
        return this.numericVersion;
    }

    public String getDate() {
        return this.date;
    }

    public String getVersionAndDate() {
        return this.version + " vom " + this.date;
    }

    public String toString() {
        return "Version " + this.version + " vom " + this.date;
    }

    @Override
    public int compareTo(Version version) {
        if (null == version) {
            throw new NullPointerException("Vergleich einer Version mit null ist unzul\u00e4ssig!");
        }
        if (this.getVersion().equals(version.getVersion())) {
            return 0;
        }
        int n = this.numericVersion.size();
        int n2 = version.numericVersion.size();
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5 = this.numericVersion.get(i);
            if (n5 == (n4 = version.numericVersion.get(i).intValue())) continue;
            return n5 - n4;
        }
        if (n == n2) {
            return 0;
        }
        if (n == n3) {
            return -1;
        }
        return 1;
    }

    public boolean isNewerThan(Version version) {
        return this.compareTo(version) > 0;
    }

    public String getYear() {
        String string = this.getDate();
        List<String> list = Text.splitByWhitespace(string);
        if (list.size() != 2) {
            throw new RuntimeException("Das Datum der Version l\u00e4sst sich nicht an Leerzeichen teilen.\n\tdate = " + string + "\n\tversion = " + this.version);
        }
        return list.get(1);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.numericVersion == null ? 0 : this.numericVersion.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Version version = (Version)object;
        return !(this.numericVersion == null ? version.numericVersion != null : !this.numericVersion.equals(version.numericVersion));
    }

    public String toSerializedString() {
        return this.version + SERIALIZATION_SEPARATOR + this.date;
    }

    public static Version createFromSerializedString(String string) {
        List<String> list = Text.splitBy(string, SERIALIZATION_SEPARATOR);
        if (list.size() != 2) {
            throw new IllegalArgumentException("Der serialisierte String '" + string + "' l\u00e4sst sich nicht in zwei Teile zerlgen.");
        }
        return new Version(list.get(0), list.get(1));
    }

    public static String extractVersionFromJarFilename(String string, String string2) {
        String string3 = FileHelper.getBareName(string);
        String string4 = FileHelper.removeExtension(string3);
        if (!string4.startsWith(string2)) {
            throw new RuntimeException("Der extrahierte pure Name der Jar-Datei beginnt nicht mit dem \u00fcbergebenen Anfang des Namesns der Jar-Datei!\n\tjarFilename  = " + string + "\n\tjarNameStart = " + string2 + "\n\tbareFilename = " + string3 + "\n\tpureName     = " + string4 + "\n");
        }
        return string4.substring(string2.length());
    }
}

