/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.math.stochastic;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class RandomSample {
    private final Random random;
    private final int from;
    private final int to;
    protected final int sampleSize;
    protected final int setSize;
    private List<Integer> notWantedNumbers;
    private final List<Integer> sample;

    public RandomSample(int n, int n2) {
        this(1, n, n2);
    }

    public RandomSample(int n, int n2, int n3) {
        if (n > n2) {
            throw new IllegalArgumentException("Der Wert von (" + n + ") darf nicht gr\u00f6\u00dfer sein als der Wert bis (" + n2 + ").");
        }
        this.from = n;
        this.to = n2;
        this.sampleSize = n3;
        this.setSize = n2 - n + 1;
        this.random = new Random();
        this.sample = new ArrayList<Integer>();
        this.notWantedNumbers = new ArrayList<Integer>();
    }

    public void setIndicesToIgnore(List<Integer> list) {
        this.notWantedNumbers = list;
    }

    public void drawSample() {
        while (this.sampleIsNotFull()) {
            int n = this.getNextRandomNumber();
            if (this.notWantedNumbers.contains(n) || !this.isNumberValidToAddToSample(n)) continue;
            this.addToSample(n);
        }
    }

    private boolean sampleIsNotFull() {
        return this.sample.size() < this.sampleSize;
    }

    private int getNextRandomNumber() {
        int n = this.random.nextInt(this.setSize);
        if (this.from + n > this.to) {
            throw new RuntimeException("Logischer Fehler.\n\tthis = " + this);
        }
        return this.from + n;
    }

    protected abstract boolean isNumberValidToAddToSample(int var1);

    protected boolean sampleContains(int n) {
        return this.sample.contains(n);
    }

    private void addToSample(int n) {
        this.sample.add(n);
    }

    public List<Integer> getSample() {
        return this.sample;
    }

    public String toString() {
        return "RandomSample [from=" + this.from + ", to=" + this.to + ", sampleSize=" + this.sampleSize + ", setSize=" + this.setSize + ", sample=" + this.sample + "]";
    }
}

