/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.start;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.lock.FileLock;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.handler.error.SimpleErrorHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class LockTester {
    private static final Dimension BUTTON_SIZE = new Dimension(200, 200);
    private FileLock lock;
    private final JFrame frame;
    private final SimpleErrorHandler error;
    private final JTextField reportField;
    private final JTextField filenameField;
    private final JCheckBox weHaveTheLockCheckBox;

    public LockTester() {
        this("c:\\temp\\lock_test.lock");
    }

    private LockTester(String string) {
        this.lock = new FileLock(string);
        GuiTools.setNiceLayoutManager();
        this.frame = new JFrame();
        this.reportField = new JTextField();
        this.filenameField = new JTextField();
        this.weHaveTheLockCheckBox = new JCheckBox();
        Image image = null;
        this.error = new SimpleErrorHandler(image, this.frame);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LockTester.this.createGui();
            }
        });
    }

    private void createGui() {
        this.frame.setTitle("Lock Tester");
        this.frame.setDefaultCloseOperation(3);
        this.frame.setLayout(new BorderLayout());
        this.frame.add(this.createDetermineLockFile(), "North");
        this.frame.add(this.createReportArea(), "Center");
        this.frame.add(this.createButtons(), "South");
        this.frame.pack();
    }

    private Component createDetermineLockFile() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createFileNameTitle(), "West");
        jPanel.add(this.createFilenameTextField(), "Center");
        jPanel.add(this.createChangeFilenameButton(), "East");
        return jPanel;
    }

    private Component createFileNameTitle() {
        return new JLabel("Lock-Datei: ");
    }

    private Component createFilenameTextField() {
        this.filenameField.setText(this.lock.getFilename());
        return this.filenameField;
    }

    private Component createChangeFilenameButton() {
        JButton jButton = new JButton("\u00e4ndern");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LockTester.this.changeFilename();
            }
        });
        return jButton;
    }

    private void changeFilename() {
        String string = this.askForFilename();
        if (string.isEmpty()) {
            this.report("Abbruch durch den Benutzer. Lock-Datei bleibt: " + string);
        } else {
            this.setFilename(string);
        }
    }

    private void setFilename(String string) {
        this.lock = new FileLock(string);
        this.filenameField.setText(string);
        this.report("Neue Lock-Datei: " + string);
    }

    private String askForFilename() {
        String string = this.lock.getFilename();
        File file = new File(string);
        if (!file.exists()) {
            file = new File(FileHelper.getDirName(string));
        }
        FileFilter fileFilter = GuiTools.createLockFileFilter();
        return GuiTools.openFile((Component)this.frame, file, fileFilter);
    }

    private Component createReportArea() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createReportField(), "North");
        jPanel.add(this.createShowLockPart(), "South");
        return jPanel;
    }

    private Component createReportField() {
        this.report("");
        return this.reportField;
    }

    private Component createShowLockPart() {
        this.unLocked();
        return this.weHaveTheLockCheckBox;
    }

    private void locked() {
        this.weHaveTheLockCheckBox.setEnabled(true);
        this.weHaveTheLockCheckBox.setSelected(true);
        this.weHaveTheLockCheckBox.setText("Wir haben den Lock");
        this.weHaveTheLockCheckBox.setForeground(new Color(0, 128, 0));
        this.weHaveTheLockCheckBox.setEnabled(false);
        this.weHaveTheLockCheckBox.revalidate();
    }

    private void unLocked() {
        this.weHaveTheLockCheckBox.setEnabled(true);
        this.weHaveTheLockCheckBox.setSelected(false);
        this.weHaveTheLockCheckBox.setText("Wir haben keinen Lock.");
        this.weHaveTheLockCheckBox.setForeground(Color.RED);
        this.weHaveTheLockCheckBox.setEnabled(false);
        this.weHaveTheLockCheckBox.revalidate();
    }

    private void report(String string) {
        this.reportField.setText(string);
    }

    private Component createButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createLockButton(), "West");
        jPanel.add(this.createReleaseButton(), "East");
        return jPanel;
    }

    private Component createLockButton() {
        JButton jButton = new JButton("LOCK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LockTester.this.lock();
            }
        });
        jButton.setPreferredSize(BUTTON_SIZE);
        return jButton;
    }

    private Component createReleaseButton() {
        JButton jButton = new JButton("RELEASE");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LockTester.this.release();
            }
        });
        jButton.setPreferredSize(BUTTON_SIZE);
        return jButton;
    }

    private void lock() {
        try {
            this.tryToLock();
        }
        catch (Exception exception) {
            this.report("Fehler beim Lock: " + exception.getMessage());
            this.error.error("Fehler beim Lock", exception);
        }
    }

    private void tryToLock() {
        boolean bl = this.lock.lock();
        if (bl) {
            this.report("Lock erhalten");
            this.locked();
        } else {
            this.report("Lock NICHT erhalten");
        }
    }

    private void release() {
        try {
            this.tryToRelease();
        }
        catch (Exception exception) {
            this.report("Fehler beim Release: " + exception.getMessage());
            this.error.error("Fehler beim Release", exception);
        }
    }

    private void tryToRelease() {
        boolean bl = this.lock.unlock();
        if (bl) {
            this.report("Lock gel\u00f6st");
            this.unLocked();
        } else {
            this.report("Lock NICHT gel\u00f6st");
        }
    }

    protected void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    public static void main(String[] stringArray) {
        new LockTester().setVisible(true);
    }
}

