/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.buttons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class ButtonHelper {
    public static final Dimension BUTTON_DIMENSION = new Dimension(17, 17);
    public static final MouseListener BUTTON_MOUSE_LISTENER = ButtonHelper.getMouseListener();
    public static final MouseListener TOGGLE_BUTTON_MOUSE_LISTENER = ButtonHelper.getToggleMouseListener();

    private ButtonHelper() {
    }

    private static MouseListener getMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                Component component = mouseEvent.getComponent();
                if (component instanceof AbstractButton) {
                    AbstractButton abstractButton = (AbstractButton)component;
                    abstractButton.setBorderPainted(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                Component component = mouseEvent.getComponent();
                if (component instanceof AbstractButton) {
                    AbstractButton abstractButton = (AbstractButton)component;
                    abstractButton.setBorderPainted(false);
                }
            }
        };
    }

    private static MouseListener getToggleMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                Component component = mouseEvent.getComponent();
                if (component instanceof AbstractButton) {
                    AbstractButton abstractButton = (AbstractButton)component;
                    abstractButton.setBorderPainted(true);
                    this.toggleColor(abstractButton);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                Component component = mouseEvent.getComponent();
                if (component instanceof AbstractButton) {
                    AbstractButton abstractButton = (AbstractButton)component;
                    abstractButton.setBorderPainted(false);
                    this.toggleColor(abstractButton);
                }
            }

            private void toggleColor(AbstractButton abstractButton) {
                Color color = abstractButton.getForeground();
                int n = color.getRed();
                int n2 = color.getGreen();
                int n3 = color.getBlue();
                Color color2 = new Color(n, n3, n2);
                abstractButton.setForeground(color2);
            }
        };
    }

    public static Color antiColor(Color color) {
        int n = 255 - color.getRed();
        int n2 = 255 - color.getGreen();
        int n3 = 255 - color.getBlue();
        return new Color(n, n2, n3);
    }

    public static void addLeftAndRightClickMouseListenerToButton(final JButton jButton, final Runnable runnable, final Runnable runnable2) {
        jButton.addMouseListener(new MouseAdapter(){
            private boolean pressed;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                jButton.getModel().setArmed(true);
                jButton.getModel().setPressed(true);
                this.pressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                jButton.getModel().setArmed(false);
                jButton.getModel().setPressed(false);
                if (this.pressed) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        runnable2.run();
                    } else {
                        runnable.run();
                    }
                    this.pressed = false;
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                this.pressed = false;
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.pressed = true;
            }
        });
    }
}

