/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.colors;

import de.duehl.swing.ui.colors.NamedColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class NamedColorList {
    private final List<NamedColor> namedColors = new ArrayList<NamedColor>();

    public void add(NamedColor namedColor) {
        if (this.existsNamedColorByName(namedColor.getName())) {
            throw new IllegalArgumentException("Eine Farbe mit dem Namen '" + namedColor.getName() + "' ist bereits vorhanden!");
        }
        this.namedColors.add(namedColor);
    }

    private boolean existsNamedColorByName(String string) {
        for (NamedColor namedColor : this.namedColors) {
            if (!namedColor.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public NamedColor getNamedColorByName(String string) {
        for (NamedColor namedColor : this.namedColors) {
            if (!namedColor.getName().equals(string)) continue;
            return namedColor;
        }
        throw new IllegalArgumentException("Keine Farbe mit dem Namen '" + string + "' vorhanden!");
    }

    public NamedColor getNamedColorByHexcode(String string) {
        for (NamedColor namedColor : this.namedColors) {
            if (!namedColor.getHexValue().equals(string)) continue;
            return namedColor;
        }
        throw new IllegalArgumentException("Keine Farbe mit der hexadezimale Stringdarstellung '" + string + "' vorhanden!");
    }

    public Color getColorByName(String string) {
        NamedColor namedColor = this.getNamedColorByName(string);
        return namedColor.getColor();
    }

    public Color getColorByHexcode(String string) {
        NamedColor namedColor = this.getNamedColorByHexcode(string);
        return namedColor.getColor();
    }

    public String getHexCodeFromNamedColorByName(String string) {
        NamedColor namedColor = this.getNamedColorByName(string);
        return namedColor.getHexValue();
    }
}

