/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.selections;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.area.NotEnteringTabulatorKeyListener;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.components.selections.FontSizeChangable;
import de.duehl.swing.ui.dragndrop.EditorUiElementManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentListener;

public class TextAreaSelection
implements FontSizeChangable {
    private final JLabel titleLabel;
    private final JPanel mainPanel;
    private final JTextArea textArea;
    private int standardFontSize;
    private int standardLabelFontSize;

    public TextAreaSelection(String string) {
        this.titleLabel = new JLabel(string);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.textArea = new JTextArea();
        GuiTools.setEditFieldColors(this.textArea);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.mainPanel = this.createPanel();
        this.standardFontSize = -1;
        this.standardLabelFontSize = -1;
    }

    private JPanel createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.titleLabel, "North");
        jPanel.add((Component)this.textArea, "Center");
        return jPanel;
    }

    public String getText() {
        String string = this.textArea.getText();
        return string;
    }

    public String getTrimmedText() {
        String string = this.getText();
        string = string.trim();
        return string;
    }

    public void setText(String string) {
        this.textArea.setText(string);
    }

    public void setText(int n) {
        this.setText(Integer.toString(n));
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    public void colorize(Colorizer colorizer) {
        colorizer.setColors(this.mainPanel);
        colorizer.setColors(this.titleLabel);
        colorizer.setColors(this.textArea);
        colorizer.setEditFieldColors(this.textArea);
    }

    public void setPreferredSize(Dimension dimension) {
        this.textArea.setPreferredSize(dimension);
    }

    public void addTextFieldFocuslistener(FocusListener focusListener) {
        this.textArea.addFocusListener(focusListener);
    }

    public void setEditable(boolean bl) {
        this.textArea.setEditable(bl);
    }

    public void setFocusable(boolean bl) {
        this.textArea.setFocusable(bl);
    }

    public void requestFocus() {
        this.textArea.requestFocus();
    }

    public void makeHorizontal() {
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mainPanel.removeAll();
        this.mainPanel.add((Component)this.titleLabel, "West");
        this.mainPanel.add((Component)this.textArea, "Center");
    }

    public void addKeyListener(KeyListener keyListener) {
        this.textArea.addKeyListener(keyListener);
    }

    public void addReturnListener(final Runnable runnable) {
        this.textArea.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && keyEvent.getModifiersEx() == 0) {
                    runnable.run();
                }
            }
        });
    }

    public void setToolTipText(String string) {
        this.titleLabel.setToolTipText(string);
        this.mainPanel.setToolTipText(string);
        this.textArea.setToolTipText(string);
    }

    public void setForegroundColor(Color color) {
        this.textArea.setForeground(color);
    }

    public void setBackgroundColor(Color color) {
        this.textArea.setBackground(color);
    }

    public void setRows(int n) {
        this.textArea.setRows(n);
    }

    @Override
    public void biggerText(int n) {
        GuiTools.biggerFont(this.textArea, n);
    }

    public void addNotEnteringTabulatorKeyListener() {
        this.textArea.addKeyListener(new NotEnteringTabulatorKeyListener(this.textArea));
    }

    public void addChangeListenerAndDragNDropCorrectorToTextArea(EditorUiElementManager editorUiElementManager) {
        editorUiElementManager.addChangeListenerAndDragNDropCorrectorToTextArea(this.textArea);
    }

    public void setDragEnabled(boolean bl) {
        this.textArea.setDragEnabled(bl);
    }

    @Override
    public int getFontSize() {
        return this.textArea.getFont().getSize();
    }

    @Override
    public void setFontSize(int n) {
        GuiTools.setFontSize(this.textArea, n);
    }

    public void setTitle(String string) {
        this.titleLabel.setText(string);
    }

    public void setMonospacedFont() {
        GuiTools.setMonospacedFont(this.textArea);
    }

    public void setMonospacedFont(int n) {
        GuiTools.setMonospacedFont(this.textArea, n);
    }

    public void swithLabelToBold() {
        GuiTools.boldFont(this.titleLabel);
    }

    @Override
    public void storeAsStandardFontSize() {
        Font font = this.textArea.getFont();
        this.standardFontSize = font.getSize();
    }

    @Override
    public void setToStandardFontSize() {
        if (this.standardFontSize != -1) {
            this.setFontSize(this.standardFontSize);
        }
    }

    public void ignorePageUpAndPageDown() {
        GuiTools.ignorePageUpAndPageDownInComponent(this.textArea);
    }

    public void ignoreUpAndDown() {
        GuiTools.ignoreUpAndDownInComponent(this.textArea);
    }

    public void ignoreUpAndDownInNameField() {
        GuiTools.ignoreUpAndDownInComponent(this.textArea);
    }

    public void ignoreCtrlPos1AndCtrlEndInNameField() {
        GuiTools.ignoreCtrlPos1AndCtrlEndInComponent(this.textArea);
    }

    @Override
    public void biggerLabelText(int n) {
        GuiTools.biggerFont(this.titleLabel, n);
    }

    @Override
    public void storeAsStandardLabelFontSize() {
        Font font = this.titleLabel.getFont();
        this.standardLabelFontSize = font.getSize();
    }

    @Override
    public void setToStandardLabelFontSize() {
        if (this.standardLabelFontSize != -1) {
            this.setLabelFontSize(this.standardLabelFontSize);
        }
    }

    @Override
    public int getLabelFontSize() {
        Font font = this.titleLabel.getFont();
        return font.getSize();
    }

    @Override
    public void setLabelFontSize(int n) {
        GuiTools.setFontSize(this.titleLabel, n);
    }

    public void switchTextToBold() {
        GuiTools.boldFont(this.textArea);
    }

    public void reactOnDoubleClick(Runnable runnable) {
        GuiTools.createDoubleClickAndDispatchMouseScrollEventMouseAdapter(this.textArea, runnable);
    }

    public boolean hasFocus() {
        return this.textArea.hasFocus();
    }

    public void dispatchMouseScrollEvent() {
        GuiTools.dispatchMouseScrollEvent(this.titleLabel);
        GuiTools.dispatchMouseScrollEvent(this.textArea);
        GuiTools.dispatchMouseScrollEvent(this.mainPanel);
    }

    public void removeAllMouseWeelListener() {
        for (MouseWheelListener mouseWheelListener : this.textArea.getMouseWheelListeners()) {
            this.textArea.removeMouseWheelListener(mouseWheelListener);
        }
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.textArea.getDocument().addDocumentListener(documentListener);
    }

    public void repaintEditArea() {
        this.textArea.repaint();
    }
}

