/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs.base;

import de.duehl.basics.logging.Logger;
import de.duehl.basics.logic.ErrorHandler;
import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.logic.Quitter;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.dialogs.DialogHelper;
import de.duehl.swing.ui.dialogs.base.additional.DialogCloser;
import de.duehl.swing.ui.dialogs.base.additional.LocationGetter;
import de.duehl.swing.ui.dialogs.base.additional.WindowRefresher;
import de.duehl.swing.ui.elements.DisabledGlassPane;
import de.duehl.swing.ui.handler.error.GlassPaneDeactivatingErrorHandler;
import de.duehl.swing.ui.key.BindKeysOnRootPane;
import de.duehl.swing.ui.listener.ClosingWindowListener;
import de.duehl.swing.ui.text.html.HtmlDialog;
import de.duehl.swing.ui.text.html.HtmlFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.net.URL;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public abstract class AbstractDialogBase
implements DialogCloser,
LongTimeProcessInformer,
LocationGetter {
    protected static final Dimension IGNORE_DIMENSION = new Dimension(-1, -1);
    private final Point parentLocation;
    private final Image programImage;
    private Window window;
    private final Dimension windowDimension;
    private final Colorizer colorizer;
    private final DisabledGlassPane glassPane;
    private boolean hasAbsoluteLocation;
    private Point absoluteWindowLocation;
    private boolean ignoreSize;
    private int minWidth = 0;
    private int minHeight = 0;
    private int longTimeProccessCounter = 0;
    private boolean useLongTimeProccessCounter = false;
    private boolean weUseAClosingWindowListener;
    private Cursor saveCursor;
    private Quitter quitter;

    public AbstractDialogBase(Image image, Colorizer colorizer) {
        this(new Point(0, 0), image, IGNORE_DIMENSION, colorizer);
        this.ignoreSize();
    }

    public AbstractDialogBase(Image image, Dimension dimension, Colorizer colorizer) {
        this(new Point(0, 0), image, dimension, colorizer);
    }

    public AbstractDialogBase(Point point, Image image, Colorizer colorizer) {
        this(point, image, IGNORE_DIMENSION, colorizer);
        this.ignoreSize();
    }

    public AbstractDialogBase(Point point, Image image, Dimension dimension, Colorizer colorizer) {
        this.parentLocation = point;
        this.programImage = image;
        this.windowDimension = dimension;
        this.colorizer = colorizer;
        this.hasAbsoluteLocation = false;
        this.ignoreSize = false;
        this.minWidth = 0;
        this.minHeight = 0;
        this.weUseAClosingWindowListener = false;
        this.glassPane = new DisabledGlassPane();
    }

    protected final void setWindow(Window window) {
        this.window = window;
        this.glassPane.connectTo(window);
    }

    protected final void fillDialog() {
        this.setColors(this.window);
        if (null != this.programImage) {
            this.window.setIconImage(this.programImage);
        }
        this.window.setLayout(new BorderLayout());
        this.populateDialog();
        if (this.ignoreSize || this.windowDimension.equals(IGNORE_DIMENSION)) {
            this.window.setMinimumSize(new Dimension(this.minWidth, this.minHeight));
            this.window.pack();
        } else {
            this.window.setPreferredSize(this.windowDimension);
        }
        this.window.pack();
        this.window.setLocation(this.calculateMyLocation());
    }

    protected abstract void populateDialog();

    private Point calculateMyLocation() {
        if (this.hasAbsoluteLocation) {
            return this.absoluteWindowLocation;
        }
        double d = this.parentLocation.getX() + 150.0;
        double d2 = this.parentLocation.getY() + 90.0;
        Point point = new Point();
        point.setLocation(d, d2);
        return point;
    }

    protected final Color determineForeground() {
        if (null != this.colorizer) {
            return this.colorizer.getForegroundColor();
        }
        return new Color(0, 0, 0);
    }

    protected final Color determineBackground() {
        if (null != this.colorizer) {
            return this.colorizer.getBackgroundColor();
        }
        return new Color(255, 255, 255);
    }

    protected final void add(Component component, Object object) {
        this.window.add(component, object);
    }

    @Override
    public final void closeDialog() {
        this.deactivateGlassPane();
        this.window.setVisible(false);
        System.gc();
        this.window.dispose();
    }

    public void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    protected void refresh() {
        this.window.revalidate();
        this.window.repaint();
    }

    protected WindowRefresher createRefresher() {
        return () -> this.refresh();
    }

    protected Component getDialog() {
        return this.window;
    }

    protected void setColors(Component component) {
        if (this.colorizer != null) {
            this.colorizer.setColors(component);
        }
    }

    protected final Point getParentLocation() {
        return this.parentLocation;
    }

    public final Image getProgramImage() {
        return this.programImage;
    }

    protected final Colorizer getColorizer() {
        return this.colorizer;
    }

    public void requestFocus() {
        this.window.requestFocus();
    }

    public void setPreferredSize(Dimension dimension) {
        this.window.setPreferredSize(dimension);
    }

    protected void ignoreSize() {
        this.ignoreSize = true;
    }

    protected void setMinimumSize(Dimension dimension) {
        this.window.setMinimumSize(dimension);
        this.minWidth = (int)dimension.getWidth();
        this.minHeight = (int)dimension.getHeight();
    }

    protected void setMinimumSize(int n, int n2) {
        this.minWidth = n;
        this.minHeight = n2;
        this.window.setMinimumSize(new Dimension(n, n2));
    }

    protected void setMinimumWidth(int n) {
        this.minWidth = n;
    }

    protected void setMinimumHeight(int n) {
        this.minHeight = n;
    }

    private void activateGlassPane(String string) {
        SwingUtilities.invokeLater(() -> this.glassPane.activate(string + " ..."));
    }

    private void deactivateGlassPane() {
        SwingUtilities.invokeLater(() -> this.glassPane.deactivate());
    }

    @Override
    public synchronized void startLongTimeProcess(String string) {
        if (this.useLongTimeProccessCounter) {
            ++this.longTimeProccessCounter;
        }
        if (!this.useLongTimeProccessCounter || this.longTimeProccessCounter == 1) {
            this.activateGlassPane(string);
            this.saveCursor = this.window.getCursor();
            this.window.setCursor(new Cursor(3));
        }
    }

    @Override
    public synchronized void endLongTimeProcess() {
        if (this.useLongTimeProccessCounter) {
            --this.longTimeProccessCounter;
        }
        if (!this.useLongTimeProccessCounter || this.longTimeProccessCounter == 0) {
            this.deactivateGlassPane();
            SwingUtilities.invokeLater(() -> this.window.setCursor(this.saveCursor));
        }
    }

    public void useLongTimeProccessCounter() {
        this.useLongTimeProccessCounter = true;
    }

    public void setLocation(int n, int n2) {
        this.setLocation(new Point(n, n2));
    }

    protected void setLocation(Point point) {
        this.hasAbsoluteLocation = true;
        this.absoluteWindowLocation = point;
        this.window.setLocation(point);
    }

    @Override
    public Point getLocation() {
        return this.window.getLocation();
    }

    protected void dispose() {
        this.window.dispose();
    }

    public Component getWindowAsComponent() {
        return this.window;
    }

    public Window getWindow() {
        return this.window;
    }

    public void waitcursorOn() {
        GuiTools.waitcursorOn(this.window);
    }

    public void waitcursorOff() {
        GuiTools.waitcursorOff(this.window);
    }

    protected DisabledGlassPane getGlassPane() {
        return this.glassPane;
    }

    public ErrorHandler createErrorHandler() {
        return this.createGlassPaneDeactivatingErrorHandler();
    }

    public GlassPaneDeactivatingErrorHandler createGlassPaneDeactivatingErrorHandler() {
        GlassPaneDeactivatingErrorHandler glassPaneDeactivatingErrorHandler = new GlassPaneDeactivatingErrorHandler(this.programImage, this.getWindowAsComponent(), this.glassPane);
        return glassPaneDeactivatingErrorHandler;
    }

    public GlassPaneDeactivatingErrorHandler createErrorHandler(Logger logger) {
        GlassPaneDeactivatingErrorHandler glassPaneDeactivatingErrorHandler = new GlassPaneDeactivatingErrorHandler(this.programImage, this.getWindowAsComponent(), this.glassPane, logger);
        return glassPaneDeactivatingErrorHandler;
    }

    protected void pack() {
        this.window.pack();
    }

    public void repaint() {
        this.window.repaint();
    }

    public void validate() {
        this.window.validate();
    }

    public void invalidate() {
        this.window.invalidate();
    }

    public void revalidate() {
        this.window.revalidate();
    }

    public abstract JRootPane getRootPane();

    protected void setKeyBindingEscape(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingEscape(runnable);
    }

    protected void setKeyBindingHome(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingHome(runnable);
    }

    protected void setKeyBindingEnd(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingEnd(runnable);
    }

    protected void setKeyBindingCtrlHome(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingCtrlHome(runnable);
    }

    protected void setKeyBindingCtrlEnd(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingCtrlEnd(runnable);
    }

    protected void setKeyBindingPageUp(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingPageUp(runnable);
    }

    protected void setKeyBindingPageDown(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingPageDown(runnable);
    }

    protected void setKeyBindingEnter(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingEnter(runnable);
    }

    protected void setKeyBindingCtrlEnter(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingCtrlEnter(runnable);
    }

    protected void setKeyBindingF1(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingF1(runnable);
    }

    protected void setKeyBindingF2(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingF2(runnable);
    }

    protected void setKeyBindingF3(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingF3(runnable);
    }

    protected void setKeyBindingF4(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingF4(runnable);
    }

    protected void setKeyBindingF5(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingF5(runnable);
    }

    protected void setKeyBindingF6(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingF6(runnable);
    }

    protected void setKeyBindingF7(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingF7(runnable);
    }

    protected void setKeyBindingF8(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingF8(runnable);
    }

    protected void setKeyBindingF9(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingF9(runnable);
    }

    protected void setKeyBindingF10(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingF10(runnable);
    }

    protected void setKeyBindingF11(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingF11(runnable);
    }

    protected void setKeyBindingF12(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingF12(runnable);
    }

    protected void setKeyBindingLeft(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingLeft(runnable);
    }

    protected void setKeyBindingRight(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingRight(runnable);
    }

    protected void setKeyBindingUp(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingUp(runnable);
    }

    protected void setKeyBindingDown(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingDown(runnable);
    }

    protected void setKeyBindingCtrlLeft(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingCtrlLeft(runnable);
    }

    protected void setKeyBindingCtrlRight(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingCtrlRight(runnable);
    }

    protected void setKeyBindingCtrlUp(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingCtrlUp(runnable);
    }

    protected void setKeyBindingCtrlDown(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingCtrlDown(runnable);
    }

    protected void setKeyBindingAltLeft(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingAltLeft(runnable);
    }

    protected void setKeyBindingAltRight(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingAltRight(runnable);
    }

    protected void setKeyBindingAltUp(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingAltUp(runnable);
    }

    protected void setKeyBindingAltDown(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingAltDown(runnable);
    }

    protected void setKeyBindingTabulator(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingTabulator(runnable);
    }

    protected void setKeyBindingDelete(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingDelete(runnable);
    }

    protected void setKeyBindingInsert(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingInsert(runnable);
    }

    protected void setKeyBindingNumpadPlus(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingNumpadPlus(runnable);
    }

    protected void setKeyBindingNumpadMinus(Runnable runnable) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(this.getRootPane());
        bindKeysOnRootPane.setKeyBindingNumpadMinus(runnable);
    }

    protected final void addEscapeBehaviour() {
        DialogHelper.addEscapeBehaviourForDialogBase(this);
    }

    protected void addClosingWindowListener(Quitter quitter) {
        this.window.addWindowListener(new ClosingWindowListener(quitter));
        this.quitter = quitter;
        this.weUseAClosingWindowListener = true;
    }

    public void closeOrCallQuitter() {
        if (this.weUseAClosingWindowListener) {
            this.quitter.quit();
        } else {
            this.closeDialog();
        }
    }

    protected final void showHtmlViaUrl(String string, URL uRL) {
        HtmlFrame htmlFrame = new HtmlFrame(string, this.getProgramImage(), this.getLocation());
        htmlFrame.showHtml(uRL);
        htmlFrame.setVisible(true);
    }

    public final void showHtmlViaHtml(String string, String string2) {
        SwingUtilities.invokeLater(() -> this.showHtmlViaHtmlInEDT(string, string2));
    }

    private void showHtmlViaHtmlInEDT(String string, String string2) {
        HtmlFrame htmlFrame = new HtmlFrame(string, this.getProgramImage(), this.getLocation());
        htmlFrame.setText(string2);
        htmlFrame.setVisible(true);
    }

    public final void showHtmlInDialog(String string, String string2) {
        HtmlDialog htmlDialog = new HtmlDialog(string, this.getProgramImage(), this.getLocation());
        htmlDialog.setText(string2);
        htmlDialog.scrollScrollbarToMinimumLater();
        htmlDialog.setVisible(true);
    }

    public Dimension getSizeOfWindow() {
        return this.window.getSize();
    }
}

