/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs.base;

import de.duehl.swing.logic.Quitter;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.dialogs.base.AbstractDialogBase;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public abstract class NonModalFrameDialogBase
extends AbstractDialogBase {
    private final JFrame frame = new JFrame();

    public NonModalFrameDialogBase(String string) {
        this(new Point(0, 0), null, string, IGNORE_DIMENSION, null);
        this.ignoreSize();
    }

    public NonModalFrameDialogBase(String string, Dimension dimension) {
        this(new Point(0, 0), null, string, dimension, null);
    }

    public NonModalFrameDialogBase(Image image, String string) {
        this(new Point(0, 0), image, string, IGNORE_DIMENSION, null);
        this.ignoreSize();
    }

    public NonModalFrameDialogBase(Image image, String string, Dimension dimension) {
        this(new Point(0, 0), image, string, dimension, null);
    }

    public NonModalFrameDialogBase(Point point, Image image, String string) {
        this(point, image, string, IGNORE_DIMENSION, null);
        this.ignoreSize();
    }

    public NonModalFrameDialogBase(Point point, Image image, String string, Dimension dimension) {
        this(point, image, string, dimension, null);
    }

    public NonModalFrameDialogBase(Image image, String string, Colorizer colorizer) {
        this(new Point(0, 0), image, string, IGNORE_DIMENSION, colorizer);
        this.ignoreSize();
    }

    public NonModalFrameDialogBase(Image image, String string, Dimension dimension, Colorizer colorizer) {
        this(new Point(0, 0), image, string, dimension, colorizer);
    }

    public NonModalFrameDialogBase(Point point, Image image, String string, Colorizer colorizer) {
        this(point, image, string, IGNORE_DIMENSION, colorizer);
        this.ignoreSize();
    }

    public NonModalFrameDialogBase(Point point, Image image, String string, Dimension dimension, Colorizer colorizer) {
        super(point, image, dimension, colorizer);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setTitle(string);
        this.setWindow(this.frame);
    }

    protected final void changeTitle(String string) {
        this.frame.setTitle(string);
        this.refresh();
    }

    @Override
    public final JRootPane getRootPane() {
        return this.frame.getRootPane();
    }

    @Override
    public void addClosingWindowListener(Quitter quitter) {
        super.addClosingWindowListener(quitter);
        this.frame.setDefaultCloseOperation(0);
    }

    public String getTitle() {
        return this.frame.getTitle();
    }

    public void setTitle(String string) {
        this.changeTitle(string);
    }

    protected JFrame getFrame() {
        return this.frame;
    }

    @Override
    public void setVisible(boolean bl) {
        SwingUtilities.invokeLater(() -> super.setVisible(bl));
    }

    public void addMenu(JMenuBar jMenuBar) {
        this.frame.setJMenuBar(jMenuBar);
        this.frame.validate();
    }

    public void maximize() {
        SwingUtilities.invokeLater(() -> this.frame.setExtendedState(6));
    }
}

