/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs.logging;

import de.duehl.basics.logging.LogEntry;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.components.selections.LongStringSelection;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.elements.navigator.NavigatorPanel;
import de.duehl.swing.ui.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.util.List;
import javax.swing.JPanel;

public class LogEntryDialog
extends ModalDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(800, 750);
    private static final int ELEMENT_HEIGHT = 30;
    public static final Dimension IGNORE_WIDTH_DIMENSION = new Dimension(1, 30);
    private final List<LogEntry> entries;
    private int entryIndex;
    private final StringSelection dateSelection;
    private final StringSelection timeSelection;
    private final StringSelection classSelection;
    private final StringSelection methodSelection;
    private final StringSelection lineNumberSelection;
    private final LongStringSelection messageSelection;

    public LogEntryDialog(List<LogEntry> list, int n, String string, Colorizer colorizer, Point point, Image image) {
        super(point, image, "Elemente der ausgew\u00e4hlten Zeile aus der Logdatei " + string, DIALOG_DIMENSION, colorizer);
        this.entries = list;
        this.entryIndex = n;
        this.dateSelection = new StringSelection("Datum");
        this.timeSelection = new StringSelection("Zeit");
        this.classSelection = new StringSelection("Klasse");
        this.methodSelection = new StringSelection("Methode");
        this.lineNumberSelection = new StringSelection("Zeilennummer");
        this.messageSelection = new LongStringSelection("Nachricht");
        this.initSelections();
        this.addEscapeBehaviour();
        this.fillDialog();
    }

    private void initSelections() {
        this.setHeightForOptionSelections();
        this.setSelectionsNotEditable();
        this.colorizeSelections();
        this.fillValuesIntoSelections();
    }

    private void setHeightForOptionSelections() {
        this.dateSelection.setTextFieldPreferredSize(IGNORE_WIDTH_DIMENSION);
        this.timeSelection.setTextFieldPreferredSize(IGNORE_WIDTH_DIMENSION);
        this.classSelection.setTextFieldPreferredSize(IGNORE_WIDTH_DIMENSION);
        this.methodSelection.setTextFieldPreferredSize(IGNORE_WIDTH_DIMENSION);
        this.lineNumberSelection.setTextFieldPreferredSize(IGNORE_WIDTH_DIMENSION);
    }

    private void setSelectionsNotEditable() {
        this.dateSelection.setEditable(false);
        this.timeSelection.setEditable(false);
        this.classSelection.setEditable(false);
        this.methodSelection.setEditable(false);
        this.lineNumberSelection.setEditable(false);
        this.messageSelection.setEditable(false);
    }

    private void colorizeSelections() {
        Colorizer colorizer = this.getColorizer();
        if (null != colorizer) {
            this.dateSelection.colorize(colorizer);
            this.timeSelection.colorize(colorizer);
            this.classSelection.colorize(colorizer);
            this.methodSelection.colorize(colorizer);
            this.lineNumberSelection.colorize(colorizer);
            this.messageSelection.colorize(colorizer);
        }
    }

    private void fillValuesIntoSelections() {
        LogEntry logEntry = this.entries.get(this.entryIndex);
        this.dateSelection.setText(logEntry.getDate());
        this.timeSelection.setText(logEntry.getTime());
        this.classSelection.setText(logEntry.getClassName());
        this.methodSelection.setText(logEntry.getMethod());
        this.lineNumberSelection.setText(logEntry.getLineNumber());
        this.messageSelection.setText(logEntry.getMessage());
    }

    @Override
    protected void populateDialog() {
        this.add(this.createMainPanel(), "Center");
        this.add(this.createNavigation(), "South");
    }

    private Component createMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createNormalStringSelections(), "North");
        jPanel.add(this.messageSelection.getPanel(), "Center");
        return jPanel;
    }

    private Component createNormalStringSelections() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.dateSelection.getPanel());
        jPanel.add(this.timeSelection.getPanel());
        jPanel.add(this.classSelection.getPanel());
        jPanel.add(this.methodSelection.getPanel());
        jPanel.add(this.lineNumberSelection.getPanel());
        return jPanel;
    }

    private Component createNavigation() {
        NavigatorPanel navigatorPanel = new NavigatorPanel(new Dimension(30, 30));
        navigatorPanel.fillNavigator();
        navigatorPanel.addFirstActionListener(actionEvent -> this.first());
        navigatorPanel.addPreviousActionListener(actionEvent -> this.previous());
        navigatorPanel.addNextActionListener(actionEvent -> this.next());
        navigatorPanel.addLastActionListener(actionEvent -> this.last());
        return navigatorPanel.centerHorizontal();
    }

    private void first() {
        this.entryIndex = 0;
        this.renewValues();
    }

    private void previous() {
        if (this.entryIndex > 0) {
            --this.entryIndex;
        }
        this.renewValues();
    }

    private void next() {
        if (this.entryIndex < this.entries.size() - 1) {
            ++this.entryIndex;
        }
        this.renewValues();
    }

    private void last() {
        this.entryIndex = this.entries.size() - 1;
        this.renewValues();
    }

    private void renewValues() {
        this.fillValuesIntoSelections();
        this.refresh();
    }
}

