/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs.logging;

import de.duehl.basics.logging.LogEntry;
import de.duehl.basics.logging.reader.LogFileReader;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.components.elements.TitledLabel;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.dialogs.logging.LogEntryDialog;
import de.duehl.swing.ui.dialogs.logging.LogFileColumnModel;
import de.duehl.swing.ui.dialogs.logging.LogFileTableModel;
import de.duehl.swing.ui.tables.DifferentBackgroundsTableRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class LogfileDialog
extends NonModalFrameDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(1400, 950);
    private final Color foreground;
    private final Color background;
    private final String logFileName;
    private final JTable logTable;
    private final LogFileTableModel logTableModel;
    private boolean showFirstLineAtTop;
    private boolean reactAtTableSelection;
    private final List<LogEntry> allLogEntries;
    private final List<LogEntry> shownLogEntries;
    private final StringSelection sortField;
    private final TitledLabel numberOfAllElementsLabel;
    private final TitledLabel numberOfFilteredElementsLabel;
    private final JRadioButton messageButton;
    private final JRadioButton methodButton;
    private final JRadioButton classButton;
    private final JLabel warningLabel;
    private final JCheckBox topDownBox;

    public LogfileDialog(String string, Point point) {
        this(string, null, point, null);
    }

    public LogfileDialog(String string, Point point, Image image) {
        this(string, null, point, image);
    }

    public LogfileDialog(String string, Colorizer colorizer, Point point, Image image) {
        super(point, image, "Logfile", DIALOG_DIMENSION, colorizer);
        this.logFileName = string;
        this.foreground = this.determineForeground();
        this.background = this.determineBackground();
        this.logTable = new JTable();
        this.logTableModel = new LogFileTableModel();
        this.sortField = new StringSelection("Filter: ");
        this.messageButton = new JRadioButton("in der Nachricht");
        this.methodButton = new JRadioButton("im Methodennamen");
        this.classButton = new JRadioButton("im Klassennamen");
        this.numberOfAllElementsLabel = new TitledLabel("Zeilen gesamt:", "");
        this.numberOfFilteredElementsLabel = new TitledLabel("Zeilen im Filter:", "");
        this.showFirstLineAtTop = true;
        this.topDownBox = new JCheckBox("fr\u00fchesten Eintrag oben anzeigen");
        this.topDownBox.setSelected(this.showFirstLineAtTop);
        this.warningLabel = new JLabel();
        this.reactAtTableSelection = false;
        this.addEscapeBehaviour();
        this.fillDialog();
        this.allLogEntries = this.readLog();
        this.shownLogEntries = new ArrayList<LogEntry>();
        this.filter();
    }

    @Override
    protected void populateDialog() {
        this.add(this.warningLabel, "North");
        this.add(this.createCenterPart(), "Center");
        this.add(this.createLowerPart(), "South");
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createLogTable(), "Center");
        return jPanel;
    }

    private Component createLogTable() {
        JTable jTable = this.createTable();
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setPreferredSize(new Dimension(250, 10));
        this.setColors(jScrollPane);
        return jScrollPane;
    }

    private JTable createTable() {
        this.logTable.setModel(this.logTableModel);
        this.logTable.setColumnModel(new LogFileColumnModel());
        this.logTable.setDefaultRenderer(Object.class, this.createRenderer());
        this.logTable.setSelectionMode(0);
        this.logTable.getSelectionModel().addListSelectionListener(this.createSelectionListener());
        this.logTable.setRowHeight(24);
        this.setColors(this.logTable);
        return this.logTable;
    }

    private TableCellRenderer createRenderer() {
        return new DifferentBackgroundsTableRenderer(this.foreground, this.background);
    }

    private ListSelectionListener createSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (!listSelectionEvent.getValueIsAdjusting() && LogfileDialog.this.reactAtTableSelection && (n = LogfileDialog.this.logTable.getSelectedRow()) > -1) {
                    LogfileDialog.this.tableRowSelected(n);
                }
            }
        };
    }

    private void tableRowSelected(int n) {
        this.clearSelection();
        List<LogEntry> list = this.logTableModel.getRows();
        Point point = this.getDialog().getLocation();
        LogEntryDialog logEntryDialog = new LogEntryDialog(list, n, this.logFileName, this.getColorizer(), point, this.getProgramImage());
        logEntryDialog.setVisible(true);
        this.clearSelection();
        this.sortField.requestFocus();
    }

    private void clearSelection() {
        this.logTable.clearSelection();
        this.logTable.validate();
        this.logTable.revalidate();
        this.logTable.repaint();
    }

    private Component createLowerPart() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createSearchPart(), "West");
        jPanel.add((Component)GuiTools.centerHorizontal(this.createInfoAndOrientationPart()), "Center");
        jPanel.add((Component)this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createSearchPart() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createSearchField(), "North");
        jPanel.add(this.createSearchOptions(), "South");
        return jPanel;
    }

    private Component createSearchField() {
        this.sortField.makeHorizontal();
        this.sortField.addReturnListener(() -> this.filter());
        return this.sortField.getPanel();
    }

    private void filter() {
        String string = this.sortField.getTrimmedText();
        this.shownLogEntries.clear();
        if (string.isEmpty()) {
            this.shownLogEntries.addAll(this.allLogEntries);
        } else {
            boolean bl = this.messageButton.isSelected();
            boolean bl2 = this.methodButton.isSelected();
            boolean bl3 = this.classButton.isSelected();
            for (LogEntry logEntry : this.allLogEntries) {
                String string2 = "";
                if (bl) {
                    string2 = logEntry.getMessage();
                } else if (bl2) {
                    string2 = logEntry.getMethod();
                } else if (bl3) {
                    string2 = logEntry.getClassName();
                }
                if (!string2.contains(string)) continue;
                this.shownLogEntries.add(logEntry);
            }
        }
        this.fillLogIntoTable();
    }

    private Component createSearchOptions() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.methodButton);
        buttonGroup.add(this.classButton);
        buttonGroup.add(this.messageButton);
        this.messageButton.setSelected(true);
        jPanel.add(this.methodButton);
        jPanel.add(this.classButton);
        jPanel.add(this.messageButton);
        return jPanel;
    }

    private JComponent createInfoAndOrientationPart() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createInfoPart(), "North");
        jPanel.add(this.createOrientaionOptions(), "South");
        return jPanel;
    }

    private Component createInfoPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 0));
        this.numberOfAllElementsLabel.setValueColor(Color.BLUE);
        this.numberOfFilteredElementsLabel.setValueColor(Color.BLUE);
        jPanel.add(this.numberOfAllElementsLabel.getPanel());
        jPanel.add(this.numberOfFilteredElementsLabel.getPanel());
        return jPanel;
    }

    private Component createOrientaionOptions() {
        this.topDownBox.addActionListener(actionEvent -> this.changeOrientation());
        this.topDownBox.setSelected(this.showFirstLineAtTop);
        return this.topDownBox;
    }

    private void changeOrientation() {
        this.showFirstLineAtTop = this.topDownBox.isSelected();
        this.fillLogIntoTable();
    }

    private JButton createQuitButton() {
        JButton jButton = new JButton("Schlie\u00dfen");
        this.setColors(jButton);
        jButton.addActionListener(actionEvent -> this.closeDialog());
        return jButton;
    }

    private List<LogEntry> readLog() {
        LogFileReader logFileReader = new LogFileReader(this.logFileName);
        List<LogEntry> list = logFileReader.read();
        if (list.size() > 0) {
            list.remove(0);
        }
        return list;
    }

    public void showLastLineAtTop() {
        this.showFirstLineAtTop = false;
        this.topDownBox.setSelected(this.showFirstLineAtTop);
    }

    @Override
    public void setVisible(boolean bl) {
        this.fillLogIntoTable();
        super.setVisible(bl);
    }

    private void fillLogIntoTable() {
        this.reactAtTableSelection = false;
        this.logTable.removeAll();
        this.logTableModel.clear();
        ArrayList<LogEntry> arrayList = new ArrayList<LogEntry>();
        arrayList.addAll(this.shownLogEntries);
        if (!this.showFirstLineAtTop) {
            Collections.reverse(arrayList);
        }
        for (LogEntry logEntry : arrayList) {
            this.logTableModel.addEntry(logEntry);
        }
        this.numberOfAllElementsLabel.setValue(Integer.toString(this.allLogEntries.size()));
        this.numberOfFilteredElementsLabel.setValue(Integer.toString(this.shownLogEntries.size()));
        this.reactAtTableSelection = true;
        this.refresh();
    }

    public void showNoAutomaticUpdate() {
        this.warningLabel.setText("<html><body>Es wird das Logfile des jetzt gerade laufenden Programms angezeigt. Das Logfile wird <b>nicht</b> automatisch aktualisiert.</body></html>");
        this.warningLabel.setForeground(Color.RED);
        this.warningLabel.setHorizontalAlignment(0);
        this.warningLabel.setBorder(new EmptyBorder(10, 20, 10, 20));
        GuiTools.biggerFont(this.warningLabel, 10);
    }
}

