/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs.values;

import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnterValueDialog
extends ModalDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(500, 80);
    private final JTextField valueField;
    private final String question;
    private final String presetting;

    public EnterValueDialog(Point point, Image image, String string, String string2, String string3) {
        this(null, point, image, string, string2, string3);
    }

    public EnterValueDialog(Colorizer colorizer, Point point, Image image, String string, String string2, String string3) {
        super(point, image, string, DIALOG_DIMENSION, colorizer);
        this.question = string2;
        this.presetting = string3;
        this.valueField = new JTextField();
        this.fillDialog();
        this.addClosingWindowListener(() -> this.escape());
    }

    @Override
    protected void populateDialog() {
        this.add(this.createQuestionPart(), "Center");
        this.add(this.createEnterValuePart(), "South");
        this.setKeyBindings();
    }

    private Component createQuestionPart() {
        JLabel jLabel = new JLabel(this.question);
        this.setColors(jLabel);
        return jLabel;
    }

    private Component createEnterValuePart() {
        this.setColors(this.valueField);
        this.valueField.setCaretColor(Color.RED);
        this.valueField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode()) {
                    EnterValueDialog.this.closeDialog();
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.valueField.setText(this.presetting);
        this.valueField.selectAll();
        return this.valueField;
    }

    private void setKeyBindings() {
        this.setKeyBindingEscape(() -> this.escape());
    }

    private void escape() {
        this.valueField.setText("");
        this.closeDialog();
    }

    public String getEnteredValue() {
        return this.valueField.getText().trim();
    }
}

