/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dragndrop;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import javax.swing.text.JTextComponent;

public class TextComponentCaretPositionRestorer {
    private boolean oldPositionAvailable = false;
    private int oldCaretPosition = -1;
    private JTextComponent textComponent = null;
    private int oldSelectionStart = -1;
    private int oldSelectionEnd = -1;

    public TextComponentCaretPositionRestorer() {
        this.detectActualFocusOwner();
    }

    private void detectActualFocusOwner() {
        boolean bl = false;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            bl = true;
            this.textComponent = jTextComponent;
        }
        if (bl) {
            this.oldPositionAvailable = true;
            this.oldCaretPosition = this.textComponent.getCaretPosition();
            this.oldSelectionStart = this.textComponent.getSelectionStart();
            this.oldSelectionEnd = this.textComponent.getSelectionEnd();
        }
    }

    public void restoreCaretPosition() {
        if (this.oldPositionAvailable) {
            int n = this.textComponent.getText().length();
            if (this.oldCaretPosition > n) {
                this.oldCaretPosition = n;
            }
            this.textComponent.setCaretPosition(this.oldCaretPosition);
            if (this.oldSelectionStart < n) {
                int n2 = this.oldSelectionStart;
                int n3 = this.oldSelectionEnd;
                if (n3 > n) {
                    n3 = n;
                }
                this.textComponent.setSelectionStart(n2);
                this.textComponent.setSelectionEnd(n3);
            }
        }
    }
}

