/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.navigator;

import de.duehl.swing.ui.elements.navigator.NavigatorPanel;
import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class NavigationMenuCreation
implements SingleMenuCreation {
    private static final char DEFAULT_MNEMONIC = 'v';
    private final NavigatorPanel navigator;
    private char menuMnemonic;
    private int alternativeModifier;

    public NavigationMenuCreation(NavigatorPanel navigatorPanel) {
        this.navigator = navigatorPanel;
        this.menuMnemonic = (char)118;
        this.alternativeModifier = 512;
    }

    public NavigationMenuCreation setMenuMnemonic(char c) {
        this.menuMnemonic = c;
        return this;
    }

    public NavigationMenuCreation alternativeWithoutAlt() {
        this.alternativeModifier = 0;
        return this;
    }

    @Override
    public JMenu createTheMenu() {
        JMenu jMenu = new JMenu("Navigation");
        jMenu.setMnemonic(this.menuMnemonic);
        jMenu.add(this.createShowFirstDocumentMenuItem());
        jMenu.add(this.createShowPreviousDocumentMenuItem());
        jMenu.add(this.createShowNextDocumentMenuItem());
        jMenu.add(this.createShowLastDocumentMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createAlternativeShowPreviousDocumentMenuItem());
        jMenu.add(this.createAlternativeShowNextDocumentMenuItem());
        this.addAdditionalNavigationMenuItems(jMenu);
        return jMenu;
    }

    private JMenuItem createShowFirstDocumentMenuItem() {
        return new MyMenuItem("erster Datensatz").mnemonic('e').accelerator(36, 512).actionListener(actionEvent -> this.navigator.doClickOnFirstButton());
    }

    private JMenuItem createShowPreviousDocumentMenuItem() {
        return new MyMenuItem("voriger Datensatz").mnemonic('v').accelerator(37, 512).actionListener(actionEvent -> this.navigator.doClickOnPreviousButton());
    }

    private JMenuItem createShowNextDocumentMenuItem() {
        return new MyMenuItem("n\u00e4chster Datensatz").mnemonic('n').accelerator(39, 512).actionListener(actionEvent -> this.navigator.doClickOnNextButton());
    }

    private JMenuItem createShowLastDocumentMenuItem() {
        return new MyMenuItem("letzter Datensatz").mnemonic('l').accelerator(35, 512).actionListener(actionEvent -> this.navigator.doClickOnLastButton());
    }

    private JMenuItem createAlternativeShowPreviousDocumentMenuItem() {
        return new MyMenuItem("voriger Datensatz (Alternative)").accelerator(33, this.alternativeModifier).actionListener(actionEvent -> this.navigator.doClickOnPreviousButton());
    }

    private JMenuItem createAlternativeShowNextDocumentMenuItem() {
        return new MyMenuItem("n\u00e4chster Datensatz (Alternative)").accelerator(34, this.alternativeModifier).actionListener(actionEvent -> this.navigator.doClickOnNextButton());
    }

    protected void addAdditionalNavigationMenuItems(JMenu jMenu) {
    }
}

