/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.navigator.list;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.buttons.painted.FirstButton;
import de.duehl.swing.ui.buttons.painted.LastButton;
import de.duehl.swing.ui.buttons.painted.NextButton;
import de.duehl.swing.ui.buttons.painted.PreviousButton;
import de.duehl.swing.ui.elements.navigator.list.ListNavigatorDataUser;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ListNavigator<DataType> {
    private static final int NO_NUMBER_OF_ELEMENTS_DETECTED = -2;
    private static final Dimension DEFAULT_BUTTON_SIZE = new Dimension(30, 40);
    private static final int HORIZONTAL_GAP = 5;
    private static final int VERTICAL_GAP = 0;
    private List<DataType> dataList;
    private ListNavigatorDataUser<DataType> dataUser;
    private boolean fromLeftToRight;
    private boolean showActualAndTotalNumberOfDatasets;
    private int actualShownNumberOfElement;
    private final JPanel panel;
    private final Dimension buttonSize;
    private final JButton firstButton;
    private final JButton previousButton;
    private final JButton nextButton;
    private final JButton lastButton;
    private final JTextField goToNumberOfElementsIndexField;
    private final JTextField totalNumberOfElementsIndexField;

    public ListNavigator() {
        this(DEFAULT_BUTTON_SIZE);
    }

    public ListNavigator(Dimension dimension) {
        this.buttonSize = dimension;
        this.fromLeftToRight = true;
        this.actualShownNumberOfElement = -1;
        this.showActualAndTotalNumberOfDatasets = true;
        this.panel = new JPanel();
        this.firstButton = new FirstButton();
        this.previousButton = new PreviousButton();
        this.nextButton = new NextButton();
        this.lastButton = new LastButton();
        this.goToNumberOfElementsIndexField = new JTextField("", 4);
        this.totalNumberOfElementsIndexField = new JTextField("", 4);
        this.initElelents();
        this.buildPanel();
    }

    public void setDataList(List<DataType> list) {
        this.setDataListWithoutShowingFirstElement(list);
        this.first();
    }

    public void setDataListWithoutShowingFirstElement(List<DataType> list) {
        this.dataList = list;
        this.totalNumberOfElementsIndexField.setText(Integer.toString(this.dataList.size()));
    }

    public int getActualShownNumberOfElement() {
        return this.actualShownNumberOfElement;
    }

    public DataType getActualDataSet() {
        return this.dataList.get(this.actualShownNumberOfElement - 1);
    }

    public void setShowMethod(ListNavigatorDataUser<DataType> listNavigatorDataUser) {
        this.dataUser = listNavigatorDataUser;
    }

    public void navigateLeftToRight() {
        this.fromLeftToRight = true;
        this.buildPanel();
    }

    public void navigateRightToLeft() {
        this.fromLeftToRight = false;
        this.buildPanel();
    }

    public void hideActualAndTotalNumberOfDatasets() {
        this.showActualAndTotalNumberOfDatasets = false;
    }

    private void buildPanel() {
        this.panel.removeAll();
        this.setLayoutAndPreferredSize();
        this.addElements();
        this.setButtonActions();
    }

    private void setLayoutAndPreferredSize() {
        this.panel.setLayout(new FlowLayout(1, 5, 0));
        this.panel.setPreferredSize(this.calculatePreferredSize());
    }

    private Dimension calculatePreferredSize() {
        int n = this.calculatePreferredWidth();
        int n2 = this.calculatePreferredHeight();
        return new Dimension(n, n2);
    }

    private int calculatePreferredWidth() {
        int n = 4;
        int n2 = this.buttonSize.width;
        int n3 = n * n2 + (n + 1) * 5;
        n3 += n2;
        int n4 = 3;
        int n5 = 50;
        int n6 = 15;
        return n3 += (n4 + 1) * 5 + 2 * n5 + n6;
    }

    private int calculatePreferredHeight() {
        int n = 1;
        int n2 = this.buttonSize.height;
        int n3 = n * n2 + (n + 1) * 0;
        return n3;
    }

    private void addElements() {
        this.addLeftNavigationElements();
        if (this.showActualAndTotalNumberOfDatasets) {
            this.addDocumentPositionElements();
        }
        this.addRightNavigationElements();
    }

    private final void addLeftNavigationElements() {
        this.panel.add(this.firstButton);
        this.panel.add(this.previousButton);
    }

    private void addDocumentPositionElements() {
        this.panel.add(this.goToNumberOfElementsIndexField);
        this.panel.add(new JLabel("/"));
        this.panel.add(this.totalNumberOfElementsIndexField);
    }

    private final void addRightNavigationElements() {
        this.panel.add(this.nextButton);
        this.panel.add(this.lastButton);
    }

    private void initElelents() {
        this.setButtonDimensions();
        this.setButtonToolTips();
        this.setNumbers();
    }

    private void setButtonDimensions() {
        this.firstButton.setPreferredSize(this.buttonSize);
        this.previousButton.setPreferredSize(this.buttonSize);
        this.nextButton.setPreferredSize(this.buttonSize);
        this.lastButton.setPreferredSize(this.buttonSize);
    }

    private void setButtonToolTips() {
        if (this.fromLeftToRight) {
            this.firstButton.setToolTipText("Zeige ersten Datensatz an.");
            this.previousButton.setToolTipText("Zeige vorigen Datensatz an.");
            this.nextButton.setToolTipText("Zeige n\u00e4chsten Datensatz an.");
            this.lastButton.setToolTipText("Zeige letzten Datensatz an.");
        } else {
            this.firstButton.setToolTipText("Zeige letzten Datensatz an.");
            this.previousButton.setToolTipText("Zeige n\u00e4chsten Datensatz an.");
            this.nextButton.setToolTipText("Zeige vorigen Datensatz an.");
            this.lastButton.setToolTipText("Zeige ersten Datensatz an.");
        }
    }

    private void setNumbers() {
        this.goToNumberOfElementsIndexField.addActionListener(actionEvent -> this.reactOnDocumentIndexInput());
        GuiTools.biggerFont(this.goToNumberOfElementsIndexField, 3);
        this.totalNumberOfElementsIndexField.setFocusable(false);
        this.totalNumberOfElementsIndexField.setEditable(false);
        GuiTools.biggerFont(this.totalNumberOfElementsIndexField, 3);
    }

    private void reactOnDocumentIndexInput() {
        String string = this.goToNumberOfElementsIndexField.getText().trim();
        int n = NumberString.parseIntIgnore(string, -1);
        this.goToNumber(n);
    }

    public void goToNumber(int n) {
        int n2 = this.determineShownNumberOfElements(n);
        if (n2 != -2) {
            this.setActualShownNumberOfElement(n2);
        }
    }

    private int determineShownNumberOfElements(int n) {
        if (n > 0 && n <= this.dataList.size()) {
            return n;
        }
        return -2;
    }

    private void setActualShownNumberOfElement(int n) {
        this.actualShownNumberOfElement = n;
        this.goToNumberOfElementsIndexField.setText(Integer.toString(n));
        this.showActualDataset();
    }

    private void showActualDataset() {
        DataType DataType = this.getActualDataSet();
        this.dataUser.showDatasetFromListNavigator(DataType);
    }

    private void setButtonActions() {
        this.removeAllActionListener(this.firstButton);
        this.removeAllActionListener(this.previousButton);
        this.removeAllActionListener(this.nextButton);
        this.removeAllActionListener(this.lastButton);
        if (this.fromLeftToRight) {
            this.firstButton.addActionListener(actionEvent -> this.first());
            this.previousButton.addActionListener(actionEvent -> this.previous());
            this.nextButton.addActionListener(actionEvent -> this.next());
            this.lastButton.addActionListener(actionEvent -> this.last());
        } else {
            this.firstButton.addActionListener(actionEvent -> this.last());
            this.previousButton.addActionListener(actionEvent -> this.next());
            this.nextButton.addActionListener(actionEvent -> this.previous());
            this.lastButton.addActionListener(actionEvent -> this.first());
        }
    }

    private void removeAllActionListener(JButton jButton) {
        for (ActionListener actionListener : jButton.getActionListeners()) {
            jButton.removeActionListener(actionListener);
        }
    }

    private void first() {
        this.setActualShownNumberOfElement(1);
    }

    private void previous() {
        if (this.actualShownNumberOfElement > 1) {
            this.setActualShownNumberOfElement(this.actualShownNumberOfElement - 1);
        }
    }

    private void next() {
        if (this.actualShownNumberOfElement < this.dataList.size()) {
            this.setActualShownNumberOfElement(this.actualShownNumberOfElement + 1);
        }
    }

    private void last() {
        this.setActualShownNumberOfElement(this.dataList.size());
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void setFirstToolTip(String string) {
        this.firstButton.setToolTipText(string);
    }

    public void setPreviousToolTip(String string) {
        this.previousButton.setToolTipText(string);
    }

    public void setNextToolTip(String string) {
        this.nextButton.setToolTipText(string);
    }

    public void setLastToolTip(String string) {
        this.lastButton.setToolTipText(string);
    }

    public void doClickOnFirstButton() {
        this.firstButton.doClick();
    }

    public void doClickOnPreviousButton() {
        this.previousButton.doClick();
    }

    public void doClickOnNextButton() {
        this.nextButton.doClick();
    }

    public void doClickOnLastButton() {
        this.lastButton.doClick();
    }

    public List<DataType> getAllDatasets() {
        return this.dataList;
    }

    public int getNumberOfDatasets() {
        return this.dataList.size();
    }
}

