/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.sidelist;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.elements.sidelist.data.ButtonAndComponent;
import de.duehl.swing.ui.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SideListOrganiserPanel {
    private static final Color ACTIVE_COLOR = new Color(0, 0, 255);
    private static final Color INACTIVE_COLOR = new Color(80, 80, 80);
    private final Map<String, ButtonAndComponent> buttonAndComponentByListText;
    private String firstElementText = "";
    private final JPanel mainPanel = new JPanel();
    private final JPanel listPanel = new JPanel();
    private final JPanel contentPanel = new JPanel();

    public SideListOrganiserPanel() {
        this.buttonAndComponentByListText = new HashMap<String, ButtonAndComponent>();
        this.initElements();
    }

    private void initElements() {
        this.initListPanel();
        this.initContentPanel();
        this.initMainPanel();
    }

    private void initListPanel() {
        this.listPanel.setLayout(new VerticalLayout(5, 3, 1));
        this.setListPanelWidth(200);
        GuiTools.createTitle(this.listPanel);
    }

    private void initContentPanel() {
        this.contentPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(this.contentPanel);
    }

    private void initMainPanel() {
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.listPanel, "West");
        this.mainPanel.add((Component)GuiTools.createScrollPane(this.contentPanel), "Center");
    }

    public void setListPanelWidth(int n) {
        this.listPanel.setPreferredSize(new Dimension(n, 100));
    }

    public void addElement(String string, Component component) {
        if (this.buttonAndComponentByListText.containsKey(string)) {
            throw new IllegalArgumentException("Es ist bereits ein Element mit dem \u00fcbergebenen Text '" + string + "' vorhanden.");
        }
        if (this.firstElementText.isEmpty()) {
            this.firstElementText = string;
        }
        JButton jButton = this.createListEntryButton(string);
        ButtonAndComponent buttonAndComponent = new ButtonAndComponent(component, jButton);
        this.buttonAndComponentByListText.put(string, buttonAndComponent);
        this.listPanel.add(jButton);
    }

    private JButton createListEntryButton(String string) {
        JButton jButton = new JButton(string);
        GuiTools.biggerFont(jButton, 5);
        jButton.addActionListener(actionEvent -> this.buttonPressed(string));
        return jButton;
    }

    private void buttonPressed(String string) {
        ButtonAndComponent buttonAndComponent = this.buttonAndComponentByListText.get(string);
        Component component = buttonAndComponent.getComponent();
        this.contentPanel.removeAll();
        this.contentPanel.add(component, "Center");
        this.changeTextColors(string);
        this.mainPanel.repaint();
        this.mainPanel.revalidate();
        this.mainPanel.invalidate();
    }

    private void changeTextColors(String string) {
        for (String string2 : this.buttonAndComponentByListText.keySet()) {
            Color color = string.equals(string2) ? ACTIVE_COLOR : INACTIVE_COLOR;
            ButtonAndComponent buttonAndComponent = this.buttonAndComponentByListText.get(string2);
            JButton jButton = buttonAndComponent.getButton();
            jButton.setForeground(color);
        }
    }

    public void showContent(String string) {
        if (!this.buttonAndComponentByListText.containsKey(string)) {
            throw new IllegalArgumentException("Unbekannter Text '" + string + "'.");
        }
        this.buttonPressed(string);
    }

    public void showFirstAddedContent() {
        this.showContent(this.firstElementText);
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }
}

