/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.error;

import de.duehl.basics.datetime.Timestamp;
import de.duehl.basics.io.FineFileReader;
import de.duehl.basics.io.FineFileWriter;
import de.duehl.basics.logging.Logger;
import de.duehl.basics.system.ExceptionHelper;
import de.duehl.basics.system.SystemTools;
import de.duehl.basics.text.html.HtmlTool;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class ErrorDialog
extends ModalDialogBase {
    private static final int WIDTH = 850;
    private static final boolean SHOW_EXCEPTION_NOTE = false;
    private final Point parentLocation;
    private final String errorText;
    private final Throwable exception;
    private final Image programImage;
    private final Color foregroundColor;
    private final Color backgroundColor;
    private String logFileName;
    private final boolean logicalError;
    private final StackTraceElement[] stackTraceElements;
    private int lastWrittenLineNumber;
    private JPanel detailPanel;
    private boolean showDetails;
    private JButton detailsButton;
    private JScrollPane stackTraceScroll;

    public ErrorDialog(String string) {
        this(string, null, null, null, null, null, null, -1);
    }

    public ErrorDialog(String string, Point point) {
        this(string, null, null, null, null, null, point, -1);
    }

    public ErrorDialog(String string, Throwable throwable) {
        this(string, throwable, null, null, null, null, new Point(300, 50), -1);
    }

    public ErrorDialog(String string, Throwable throwable, Point point) {
        this(string, throwable, null, null, null, null, point, -1);
    }

    public ErrorDialog(String string, Throwable throwable, Image image, Point point) {
        this(string, throwable, image, null, null, null, point, -1);
    }

    public ErrorDialog(String string, Color color, Color color2, Point point) {
        this(string, null, null, null, color, color2, point, -1);
    }

    public ErrorDialog(String string, Throwable throwable, Color color, Color color2, Point point) {
        this(string, throwable, null, null, color, color2, point, -1);
    }

    public ErrorDialog(String string, Image image, String string2, Color color, Color color2, Point point) {
        this(string, null, image, string2, color, color2, point, -1);
    }

    public ErrorDialog(String string, Throwable throwable, Image image, String string2, Point point) {
        this(string, throwable, image, string2, null, null, point, -1);
    }

    public ErrorDialog(String string, Throwable throwable, Image image, String string2, Color color, Color color2, Point point) {
        this(string, throwable, image, string2, color, color2, point, -1);
    }

    public ErrorDialog(String string, Throwable throwable, Image image, String string2, Color color, Color color2, Point point, int n) {
        super("");
        StackTraceElement[] stackTraceElementArray;
        this.addEscapeBehaviour();
        this.errorText = string;
        this.exception = throwable;
        this.programImage = image;
        this.logFileName = string2;
        if (null == color || null == color2) {
            stackTraceElementArray = new JPanel();
            this.foregroundColor = stackTraceElementArray.getForeground();
            this.backgroundColor = stackTraceElementArray.getBackground();
        } else {
            this.foregroundColor = color;
            this.backgroundColor = color2;
        }
        this.parentLocation = point;
        this.lastWrittenLineNumber = n;
        System.out.println("Behandelter Fehler:\n" + string + "\n");
        if (null == throwable) {
            this.logicalError = true;
            stackTraceElementArray = Thread.currentThread().getStackTrace();
            int n2 = stackTraceElementArray.length;
            this.stackTraceElements = new StackTraceElement[n2 - 3];
            for (int i = 3; i < n2; ++i) {
                this.stackTraceElements[i - 3] = stackTraceElementArray[i];
            }
        } else {
            this.logicalError = false;
            throwable.printStackTrace(System.out);
            this.stackTraceElements = throwable.getStackTrace();
        }
        this.fillDialog();
    }

    public void addLogger(Logger logger) {
        this.logFileName = logger.getLogFileName();
        this.lastWrittenLineNumber = logger.getLastWrittenLineNumber();
    }

    @Override
    protected void populateDialog() {
        this.setTitle("Es ist ein " + (this.logicalError ? "normaler Fehler" : "Fehler mit Exception") + " aufgetreten!");
        this.setColors(this.getDialog());
        if (null != this.programImage) {
            this.getWindow().setIconImage(this.programImage);
        }
        this.add(this.createErrorPanel(), "North");
        this.add(this.createDetailPanel(), "Center");
        this.add(this.createQuitButton(), "South");
        this.setLocation();
        if (!this.logicalError) {
            this.toggleDetails();
        }
    }

    private void setLocation() {
        if (this.parentLocation != null) {
            int n = (int)this.parentLocation.getX();
            int n2 = (int)this.parentLocation.getY();
            this.setLocation(n + 150, n2 + 90);
        } else {
            this.setLocation(350, 300);
        }
    }

    private JPanel createErrorPanel() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add(this.createErrorDummy(), "North");
        jPanel.add(this.createErrorText(), "Center");
        jPanel.add(this.createErrorDetailButton(), "East");
        return jPanel;
    }

    private Component createErrorDummy() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(850, 0));
        jPanel.setMaximumSize(new Dimension(850, 0));
        return jPanel;
    }

    private Component createErrorExceptionNote() {
        String string;
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        JLabel jLabel = new JLabel();
        jLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setColors(jLabel);
        if (this.logicalError) {
            string = "Es ist ein<br>normaler Fehler<br>aufgetreten!";
        } else {
            string = "Es ist eine<br>Ausnahme<br>aufgetreten!";
            jLabel.setForeground(Color.RED);
        }
        jLabel.setText("<html>" + string + "</html>");
        jPanel.add((Component)jLabel, "Center");
        return jPanel;
    }

    private Component createErrorText() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        JLabel jLabel = new JLabel(HtmlTool.htmlify(this.errorText, 60));
        jLabel.setOpaque(true);
        this.setMonospacedFont(jLabel, 18);
        this.setColors(jLabel);
        jLabel.setForeground(Color.RED);
        jLabel.setBorder(new EmptyBorder(10, 20, 10, 20));
        JScrollPane jScrollPane = new JScrollPane(jLabel);
        jScrollPane.setPreferredSize(new Dimension(500, 200));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void setMonospacedFont(Component component, int n) {
        component.setFont(new Font("Monospaced", 1, n));
    }

    private Component createErrorDetailButton() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        JButton jButton = new JButton("Details anzeigen");
        jButton.setPreferredSize(new Dimension(150, 50));
        this.setColors(jButton);
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ErrorDialog.this.toggleDetails();
            }
        });
        jPanel.add((Component)jButton, "Center");
        this.detailsButton = jButton;
        return jPanel;
    }

    private Component createDetailPanel() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        this.detailPanel = jPanel;
        return jPanel;
    }

    private JPanel createQuitButton() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        JButton jButton = new JButton("Ok");
        jButton.setPreferredSize(new Dimension(90, 40));
        this.setColors(jButton);
        jButton.setFocusable(false);
        jButton.addActionListener(actionEvent -> this.closeDialog());
        jPanel.add((Component)jButton, "East");
        SwingUtilities.invokeLater(() -> jButton.requestFocus());
        return jPanel;
    }

    private void toggleDetails() {
        if (this.showDetails) {
            this.detailPanel.setPreferredSize(new Dimension(850, 0));
            this.detailPanel.removeAll();
            this.detailsButton.setText("Details anzeigen");
        } else {
            this.detailPanel.setPreferredSize(new Dimension(850, 500));
            this.detailPanel.add(this.createInnerDetails(), "Center");
            this.detailPanel.add(this.createReportButton(), "South");
            this.detailsButton.setText("Details verbergen");
        }
        this.showDetails = !this.showDetails;
        this.pack();
        this.validate();
        this.repaint();
        this.scrollUp();
    }

    private Component createInnerDetails() {
        JSplitPane jSplitPane = new JSplitPane(0, this.createExceptionMessage(), this.createStackTrace());
        jSplitPane.setDividerLocation(100);
        this.setColors(jSplitPane);
        this.scrollUp();
        return jSplitPane;
    }

    private Component createExceptionMessage() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        Object object = this.logicalError ? "Es ist ein logischer Fehler aufgetreten. Ablauf des Programms bis zur Fehlerstelle:" : this.exception.getClass().getName() + ": " + this.exception.getMessage();
        JLabel jLabel = new JLabel(HtmlTool.htmlify((String)object, 80));
        this.setMonospacedFont(jLabel, 14);
        this.setColors(jLabel);
        jLabel.setForeground(Color.RED);
        jPanel.add((Component)jLabel, "Center");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        return jScrollPane;
    }

    private Component createStackTrace() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        JLabel jLabel = new JLabel(this.createStackTraceText());
        this.setMonospacedFont(jLabel, 13);
        this.setColors(jLabel);
        jLabel.setVerticalAlignment(1);
        jPanel.add((Component)jLabel, "Center");
        this.stackTraceScroll = new JScrollPane(jPanel);
        this.setColors(this.stackTraceScroll);
        this.scrollUp();
        return this.stackTraceScroll;
    }

    private String createStackTraceText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.addOriginalStacktraceToStackTraceOutput(stringBuilder);
        this.addCausesToStackTraceOutput(stringBuilder);
        String string = HtmlTool.htmlify(stringBuilder.toString());
        return string;
    }

    private void addOriginalStacktraceToStackTraceOutput(StringBuilder stringBuilder) {
        this.addStacktraceToStackTraceOutput(stringBuilder, this.stackTraceElements);
    }

    private void addStacktraceToStackTraceOutput(StringBuilder stringBuilder, StackTraceElement[] stackTraceElementArray) {
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            stringBuilder.append(stackTraceElement.toString());
            stringBuilder.append("\n");
        }
    }

    private void addCausesToStackTraceOutput(StringBuilder stringBuilder) {
        if (null != this.exception) {
            for (Throwable throwable = this.exception.getCause(); throwable != null; throwable = throwable.getCause()) {
                this.addOneCouseToStackTraceOutput(stringBuilder, throwable);
            }
        }
    }

    private void addOneCouseToStackTraceOutput(StringBuilder stringBuilder, Throwable throwable) {
        stringBuilder.append("\n");
        stringBuilder.append(HtmlTool.red("Caused by:\n"));
        stringBuilder.append(HtmlTool.red(throwable.getClass().getName() + ": "));
        stringBuilder.append(HtmlTool.red(throwable.getMessage()) + "\n");
        this.addStacktraceToStackTraceOutput(stringBuilder, throwable.getStackTrace());
    }

    private void scrollUp() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != ErrorDialog.this.stackTraceScroll) {
                    int n = ErrorDialog.this.stackTraceScroll.getVerticalScrollBar().getMinimum();
                    ErrorDialog.this.stackTraceScroll.getVerticalScrollBar().setValue(n);
                }
            }
        });
    }

    private Component createReportButton() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        JButton jButton = new JButton("Bericht");
        this.setColors(jButton);
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ErrorDialog.this.report();
            }
        });
        jPanel.add((Component)jButton, "Center");
        return jPanel;
    }

    private void report() {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Fehlerbericht " + Timestamp.fullTimestamp() + ":\n");
        stringBuilder.append("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        stringBuilder.append("Fehlertext:\n");
        stringBuilder.append(this.errorText + "\n");
        if (this.logicalError) {
            stringBuilder.append("\n\nEs ist ein logischer Fehler aufgetreten.\n");
            stringBuilder.append("\n\nStacktrace des Programmablaufes bis zu dieser Stelle:\n");
            this.addOriginalStacktraceToStackTraceOutput(stringBuilder);
        } else {
            stringBuilder.append("\n\nEs ist eine Ausnahme aufgetreten.\n");
            stringBuilder.append(ExceptionHelper.getDescriptionWithStackTrace(this.exception));
        }
        this.addToReport(stringBuilder);
        stringBuilder.append("\n\nLog:\n");
        if (null == this.logFileName || this.logFileName.isEmpty()) {
            stringBuilder.append("no log\n");
        } else {
            object2 = new FineFileReader(this.logFileName);
            int n = 0;
            while (null != (object = ((FineFileReader)object2).readNextLine())) {
                stringBuilder.append((String)object + "\n");
                if (this.lastWrittenLineNumber <= -1 || ++n < this.lastWrittenLineNumber) continue;
            }
        }
        object2 = SystemTools.getHomeDirectory();
        object = GuiTools.createTextFileFilter();
        Object object3 = GuiTools.saveFileAsWithTitle("Speichern des Berichts", this.getDialog(), (String)object2, (FileFilter)object, this.createPureReportFilenameSuggestion());
        if (((String)object3).isEmpty()) {
            return;
        }
        if (!((String)object3).endsWith(".txt")) {
            object3 = (String)object3 + ".txt";
        }
        FineFileWriter fineFileWriter = new FineFileWriter((String)object3);
        fineFileWriter.write(stringBuilder.toString());
        fineFileWriter.close();
    }

    private String createPureReportFilenameSuggestion() {
        Object object = this.createPureReportFilenameSuggestionAddon();
        if (!((String)object).isEmpty()) {
            object = "_" + (String)object;
        }
        return Timestamp.fullTimestamp() + "_error_report" + (String)object + ".txt";
    }

    protected String createPureReportFilenameSuggestionAddon() {
        return "";
    }

    protected void addToReport(StringBuilder stringBuilder) {
    }

    @Override
    protected void setColors(Component component) {
        component.setBackground(this.backgroundColor);
        component.setForeground(this.foregroundColor);
    }
}

