/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.highlightingeditor;

import de.duehl.basics.debug.Assure;
import de.duehl.basics.debug.DebugHelper;
import de.duehl.basics.history.History;
import de.duehl.basics.history.HistoryHelper;
import de.duehl.basics.io.Charset;
import de.duehl.swing.clipboard.Clipboard;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.CharsetDialog;
import de.duehl.swing.ui.elements.TextLineNumber;
import de.duehl.swing.ui.elements.fontsize.FontSizeInteraction;
import de.duehl.swing.ui.highlightingeditor.buttonbar.ButtonBar;
import de.duehl.swing.ui.highlightingeditor.buttonbar.EditorForButtonBar;
import de.duehl.swing.ui.highlightingeditor.changestate.EditorChangeState;
import de.duehl.swing.ui.highlightingeditor.contextmenu.EditorForContextMenu;
import de.duehl.swing.ui.highlightingeditor.contextmenu.EditorPopupMenu;
import de.duehl.swing.ui.highlightingeditor.multiplereactor.MultipleChangeReactor;
import de.duehl.swing.ui.highlightingeditor.state.EditorState;
import de.duehl.swing.ui.highlightingeditor.state.EditorStateCopier;
import de.duehl.swing.ui.highlightingeditor.syntax.SyntaxHighlighting;
import de.duehl.swing.ui.highlightingeditor.textcomponent.ScrollingSuppressingTextPane;
import de.duehl.swing.ui.highlightingeditor.userinput.EditorForReactAfterUserInput;
import de.duehl.swing.ui.highlightingeditor.userinput.ReactAfterUserInput;
import de.duehl.swing.ui.tabs.ChangeStateDisplayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.StyledDocument;

public class HighlightingEditor
implements EditorForContextMenu,
EditorForButtonBar,
EditorForReactAfterUserInput,
FontSizeInteraction {
    private static final int MILLISECONDS_BEFORE_SYNTAX_HIGHLIGHTING = 900;
    public static final Charset DEFAULT_CHARSET = Charset.ISO_8859_1;
    private static final boolean SHOW_LINE_NUMBERS = true;
    private static final boolean DEBUG = true;
    private EditorState editorState = new EditorState();
    private final History<EditorState> history = new History<EditorState>(new EditorStateCopier());
    private SyntaxHighlighting sytaxHighlighting;
    private final List<ChangeStateDisplayer> changeStateDisplayers = new ArrayList<ChangeStateDisplayer>();
    private int fontSize = 16;
    private final ReactAfterUserInput highlightAfterUserInput;
    private final MultipleChangeReactor multipleChangeReactor;
    private final EditorChangeState changeState;
    protected final ScrollingSuppressingTextPane editor;
    private final JPanel panel = new JPanel();
    private final JScrollPane scroll;
    private final ButtonBar buttonBar;
    private static HighlightingEditor activeEditor;

    public HighlightingEditor() {
        this.editor = this.createEditor();
        this.buttonBar = this.createButtonBar();
        this.scroll = this.createScroll();
        this.highlightAfterUserInput = this.createHighlightAfterUserInput();
        this.changeState = new EditorChangeState();
        this.addChangeStateDisplayer(this.changeState);
        this.multipleChangeReactor = this.createMultipleChangeReactor();
        this.createPopupMenu();
        this.initEditorBlank();
        this.populatePanel();
        this.showEditorIsActive();
        this.updateUndoRedo();
    }

    protected ScrollingSuppressingTextPane createEditor() {
        ScrollingSuppressingTextPane scrollingSuppressingTextPane = this.createScrollingSuppressingTextPane();
        scrollingSuppressingTextPane.setEditable(true);
        GuiTools.setFontSize(scrollingSuppressingTextPane, this.fontSize);
        scrollingSuppressingTextPane.addFocusListener(this.createFocusListener());
        return scrollingSuppressingTextPane;
    }

    protected ScrollingSuppressingTextPane createScrollingSuppressingTextPane() {
        return new ScrollingSuppressingTextPane();
    }

    protected ButtonBar createButtonBar() {
        return new ButtonBar(this);
    }

    private JScrollPane createScroll() {
        JScrollPane jScrollPane = new JScrollPane(this.editor);
        TextLineNumber textLineNumber = new TextLineNumber(this.editor, 5);
        jScrollPane.setRowHeaderView(textLineNumber);
        return jScrollPane;
    }

    protected ReactAfterUserInput createHighlightAfterUserInput() {
        return new ReactAfterUserInput(900L, this);
    }

    protected MultipleChangeReactor createMultipleChangeReactor() {
        MultipleChangeReactor multipleChangeReactor = new MultipleChangeReactor();
        multipleChangeReactor.addChangeReactor(this.highlightAfterUserInput);
        multipleChangeReactor.addChangeReactor(this.editor);
        multipleChangeReactor.addChangeReactor(this.changeState);
        return multipleChangeReactor;
    }

    protected void createPopupMenu() {
        this.editor.setComponentPopupMenu(new EditorPopupMenu(this));
    }

    private void initEditorBlank() {
        this.doNotReactOnChanges();
        SwingUtilities.invokeLater(() -> this.showAfterOpenFile(""));
    }

    private void populatePanel() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add(this.buttonBar.getComponent(), "North");
        this.panel.add((Component)this.scroll, "Center");
    }

    public boolean isContentChanged() {
        return this.changeState.isChanged();
    }

    private void reactOnChanges() {
        this.multipleChangeReactor.reactOnChanges();
    }

    private void doNotReactOnChanges() {
        this.multipleChangeReactor.doNotReactOnChanges();
    }

    @Override
    public void addDocumentListener(DocumentListener documentListener) {
        this.editor.getDocument().addDocumentListener(documentListener);
    }

    public void useSyntaxHighlighting(SyntaxHighlighting syntaxHighlighting) {
        this.initSyntaxHighlighting(syntaxHighlighting);
        this.highlightText();
    }

    protected void initSyntaxHighlighting(SyntaxHighlighting syntaxHighlighting) {
        this.sytaxHighlighting = syntaxHighlighting;
        StyledDocument styledDocument = this.editor.getStyledDocument();
        syntaxHighlighting.initStyles(styledDocument);
    }

    @Override
    public void reactAfterUserInput() {
        this.updateUndoRedo();
        this.highlightText();
    }

    public void highlightText() {
        SwingUtilities.invokeLater(() -> this.highlightTextInEdt());
    }

    protected void highlightTextInEdt() {
        if (null != this.sytaxHighlighting && !this.editor.getText().isEmpty()) {
            this.reallyHighlightText();
        }
    }

    private synchronized void reallyHighlightText() {
        this.say("reallyHighlightText() start");
        this.doNotReactOnChanges();
        StyledDocument styledDocument = this.editor.getStyledDocument();
        String string = this.editor.getText();
        int n = this.editor.getCaretPosition();
        this.sytaxHighlighting.highlightText(string, styledDocument);
        this.editor.validate();
        String string2 = this.editor.getText();
        Assure.isEqual(string, string2);
        this.afterSyntaxHighlightInEDT(n);
    }

    private void afterSyntaxHighlightInEDT(int n) {
        this.editor.setCaretPosition(n);
        this.editor.requestFocusInWindow();
        this.reactOnChanges();
        this.say("reallyHighlightText() ende");
    }

    public Component getComponent() {
        return this.panel;
    }

    public void setPreferredSize(Dimension dimension) {
        this.panel.setPreferredSize(dimension);
    }

    @Override
    public void signChangedState() {
        this.say("ver\u00e4ndert");
        this.showEditorIsActive();
        for (ChangeStateDisplayer changeStateDisplayer : this.changeStateDisplayers) {
            changeStateDisplayer.signChangedState();
        }
    }

    private void showEditorIsActive() {
        activeEditor = this;
    }

    protected void signUnchangedState() {
        this.say("nicht ver\u00e4ndert");
        for (ChangeStateDisplayer changeStateDisplayer : this.changeStateDisplayers) {
            changeStateDisplayer.signUnchangedState();
        }
    }

    public void addChangeStateDisplayer(ChangeStateDisplayer changeStateDisplayer) {
        this.changeStateDisplayers.add(changeStateDisplayer);
    }

    public void useMonospaceFont() {
        GuiTools.setMonospacedFont(this.editor, this.fontSize);
    }

    @Override
    public void selectAll() {
        this.editor.selectAll();
    }

    @Override
    public String getSelectedText() {
        return this.editor.getSelectedText();
    }

    @Override
    public void cutSelection() {
        this.copySelection();
        this.editor.replaceSelection("");
        this.highlightAfterUserInput.startTimer();
    }

    @Override
    public void copySelection() {
        String string = this.editor.getSelectedText();
        if (null == string || string.isEmpty()) {
            return;
        }
        Clipboard.insert(string);
    }

    @Override
    public void insertSelection() {
        String string = Clipboard.getContent();
        if (null == string || string.isEmpty()) {
            return;
        }
        this.editor.replaceSelection("");
        int n = this.editor.getCaretPosition();
        this.editor.setSelectionStart(n);
        this.editor.setSelectionEnd(n);
        this.editor.replaceSelection(string);
        this.highlightAfterUserInput.startTimer();
    }

    @Override
    public void addMouseListener(MouseAdapter mouseAdapter) {
        this.editor.addMouseListener(mouseAdapter);
    }

    @Override
    public void newFile() {
        this.editorState.newFile();
        this.editor.setText("");
        this.editor.setCaretPosition(0);
        this.signUnchangedState();
        this.updateDisplayName();
        this.updateUndoRedoFromScratch();
    }

    private void updateDisplayName() {
        for (ChangeStateDisplayer changeStateDisplayer : this.changeStateDisplayers) {
            changeStateDisplayer.updateName(this.editorState.createNameForDisplay());
        }
    }

    @Override
    public void openFile() {
        String string = this.askUserAboutFileToOpen();
        if (!string.isEmpty()) {
            Charset charset = this.askUserAboutCharset(string);
            new Thread(() -> this.openFile(string, charset)).start();
        }
    }

    private String askUserAboutFileToOpen() {
        String string = this.editorState.determineStartDirectory();
        FileFilter fileFilter = GuiTools.createAllFileFilter();
        return GuiTools.openFile((Component)this.panel, string, fileFilter);
    }

    private Charset askUserAboutCharset(String string) {
        CharsetDialog charsetDialog = new CharsetDialog(this.panel.getLocation(), null, string);
        charsetDialog.setVisible(true);
        Charset charset = charsetDialog.getSelectedCharset();
        return charset;
    }

    public void openFile(String string) {
        this.openFile(string, DEFAULT_CHARSET);
    }

    public void openFile(String string, Charset charset) {
        this.say("openFile  - filename = " + string);
        this.doNotReactOnChanges();
        String string2 = this.editorState.openFile(string, charset);
        SwingUtilities.invokeLater(() -> this.showAfterOpenFile(string2));
    }

    private void showAfterOpenFile(String string) {
        this.editor.setText(string);
        this.editor.setCaretPosition(0);
        this.say("before highlight");
        this.highlightTextInEdt();
        this.say("after highlight");
        this.reactOnChanges();
        this.signUnchangedState();
        this.updateDisplayName();
        this.updateUndoRedoFromScratch();
        this.validate();
    }

    @Override
    public void saveFile() {
        if (this.editorState.isFilenameEmpty()) {
            this.saveFileAs();
        } else {
            this.saveUnderFilename();
        }
    }

    @Override
    public void saveFileAs() {
        String string = this.askUserAboutFilenameToSave();
        if (!string.isEmpty()) {
            this.editorState.setFilename(string);
            this.saveUnderFilename();
        }
    }

    private String askUserAboutFilenameToSave() {
        String string = "Bitte Dateinamen eingeben.";
        String string2 = this.editorState.determineStartDirectory();
        FileFilter fileFilter = GuiTools.createAllFileFilter();
        String string3 = this.editorState.getBarename();
        return GuiTools.saveFileAsWithTitle(string, (Component)this.panel, string2, fileFilter, string3);
    }

    private void saveUnderFilename() {
        this.editorState.saveUnderFilename(this.editor.getText());
        this.signUnchangedState();
        this.updateUndoRedoFromScratch();
        this.editor.requestFocusInWindow();
    }

    @Override
    public int getFontSize() {
        return this.fontSize;
    }

    @Override
    public void setFontSize(int n) {
        this.fontSize = n;
        this.handleFontSizeChange(n);
        this.buttonBar.refreshFontSize();
    }

    private void handleFontSizeChange(int n) {
        this.doNotReactOnChanges();
        GuiTools.setFontSize(this.editor, n);
        this.reactOnChanges();
        this.highlightTextInEdt();
    }

    @Override
    public void incrementFontSize() {
        ++this.fontSize;
        this.handleFontSizeChange(this.fontSize);
    }

    @Override
    public void decrementFontSize() {
        if (this.fontSize > 1) {
            --this.fontSize;
            this.handleFontSizeChange(this.fontSize);
        }
    }

    public void cancelTimer() {
        this.highlightAfterUserInput.cancelTimer();
    }

    public String getFilename() {
        return this.editorState.getFilename();
    }

    private void validate() {
        this.editor.validate();
        this.scroll.validate();
    }

    public void requestFocusInWindow() {
        this.say("requestFocusInWindow()");
        this.editor.requestFocusInWindow();
    }

    private FocusListener createFocusListener() {
        return new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                HighlightingEditor.this.say("Fokus lost");
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                HighlightingEditor.this.say("Fokus gained");
                HighlightingEditor.this.showEditorIsActive();
                HighlightingEditor.this.checkFileOnDisk();
            }
        };
    }

    public void setFilenameButDoNotDoAnythingElse(String string) {
        this.editorState.setFilename(string);
    }

    public String getText() {
        return this.editor.getText();
    }

    public void setText(String string) {
        this.doNotReactOnChanges();
        this.showAfterOpenFile(string);
        this.signChangedState();
    }

    public void showEnd() {
        GuiTools.scrollScrollbarToMaximumLater(this.scroll);
    }

    public static HighlightingEditor getActiveEditor() {
        return activeEditor;
    }

    public void reload() {
        String string = this.editorState.getFilename();
        this.say("Lade Datei " + string + " erneut.");
        Charset charset = this.editorState.getCharset();
        this.openFile(string, charset);
    }

    public int getCaretPosition() {
        return this.editor.getCaretPosition();
    }

    public void setCaretPosition(int n) {
        this.editor.setCaretPosition(n);
        this.editor.requestFocusInWindow();
    }

    public void select(int n, int n2) {
        this.editor.select(n, n2);
        this.editor.requestFocusInWindow();
    }

    protected final void disableWatchFileOnDiskChange() {
        this.editorState.disableWatchFileOnDiskChange();
    }

    private void checkFileOnDisk() {
        boolean bl;
        if (this.editorState.doesFileNotExistAnymore()) {
            boolean bl2 = GuiTools.askUser(this.panel, "Hinweis", "<html>Die Datei wurde auf dem Dateisystem verschoben oder gel\u00f6scht. Wollen Sie sie trotzdem im Editor behalten?</html>");
            if (bl2) {
                this.editorState.notLoaded();
            } else {
                this.newFile();
            }
        } else if (this.editorState.hasFileChangedOnDisk() && (bl = GuiTools.askUser(this.panel, "Hinweis", "<html>Die Datei wurde auf dem Dateisystem ge\u00e4ndert. Soll sie neu geladen werden?</html>"))) {
            this.reload();
        }
    }

    private void updateUndoRedoFromScratch() {
        this.history.clear();
        this.updateUndoRedo();
    }

    private void updateUndoRedo() {
        this.editorState.setTextAndCaretPosition(this.editor.getText(), this.editor.getCaretPosition());
        this.history.add(this.editorState);
        this.checkEnableHistory();
    }

    private void checkEnableHistory() {
        HistoryHelper.checkEnableHistory(this.history, this.buttonBar);
    }

    @Override
    public void undo() {
        this.say("undo");
        if (this.history.hasPrevious()) {
            EditorState editorState = this.history.getPrevious();
            this.showUndoOrRedoEditorState(editorState);
        }
    }

    @Override
    public void redo() {
        this.say("redo");
        if (this.history.hasNext()) {
            EditorState editorState = this.history.getNext();
            this.showUndoOrRedoEditorState(editorState);
        }
    }

    private void showUndoOrRedoEditorState(EditorState editorState) {
        this.editorState = new EditorState(editorState);
        this.checkEnableHistory();
        this.updateDisplayName();
        this.editor.requestFocusInWindow();
        this.doNotReactOnChanges();
        this.editor.setText(this.editorState.getText());
        this.say("caretPosition = " + this.editorState.getCaretPosition());
        this.editor.setCaretPosition(this.editorState.getCaretPosition());
        this.reactOnChanges();
        this.highlightText();
    }

    protected final void say(String string) {
        String string2 = this.getFilename();
        String string3 = "(" + (null == string2 ? "unknown" : string2) + ") - ";
        DebugHelper.sayWithClassAndMethodAndTime(string3 + string);
    }

    public String toString() {
        return "HighlightingEditor [filename=" + this.getFilename() + "]";
    }
}

