/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.lights;

import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.swing.ui.colors.ColorTool;
import de.duehl.swing.ui.lights.data.CheckLightMode;
import de.duehl.swing.ui.panel.painted.CirclePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CheckLight {
    private static final Dimension LIGHT_DIMENSION = new Dimension(50, 50);
    private static final String NOT_STARTED_LIGHT_COLOR = "darkgray";
    private static final String BLACK_LIGHT_COLOR = "black";
    private static final String GREEN_LIGHT_COLOR = "green";
    private static final String YELLOW_LIGHT_COLOR = "yellow";
    private static final String RED_LIGHT_COLOR = "red";
    private final CheckLightMode mode;
    private final String checkDescription;
    private final JPanel panel;
    private final CirclePanel singleLight;
    private final CirclePanel greenLight;
    private final CirclePanel yellowLight;
    private final CirclePanel redLight;
    private final JLabel descriptionLabel;
    private final JLabel runtimeLabel;
    private final StopWatch checkWatch;

    public CheckLight(CheckLightMode checkLightMode, String string) {
        this.mode = checkLightMode;
        this.checkDescription = string;
        this.checkWatch = new StopWatch();
        this.panel = new JPanel();
        this.singleLight = new CirclePanel();
        this.greenLight = new CirclePanel();
        this.yellowLight = new CirclePanel();
        this.redLight = new CirclePanel();
        this.descriptionLabel = new JLabel();
        this.runtimeLabel = new JLabel();
        this.init();
        this.createGui();
    }

    private void init() {
        this.initPanel();
        this.initLabel();
        this.initLights();
    }

    private void initPanel() {
        this.panel.setLayout(new BorderLayout());
    }

    private void initLabel() {
        this.setNotStartedColor();
        this.descriptionLabel.setText(this.checkDescription);
        this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.runtimeLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    private void initLights() {
        this.singleLight.setPreferredSize(LIGHT_DIMENSION);
        this.greenLight.setPreferredSize(LIGHT_DIMENSION);
        this.yellowLight.setPreferredSize(LIGHT_DIMENSION);
        this.redLight.setPreferredSize(LIGHT_DIMENSION);
    }

    private void createGui() {
        this.panel.add(this.createLightsPart(), "West");
        this.panel.add(this.createDescriptionAndRuntimePart(), "Center");
    }

    private Component createLightsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 1, 1));
        switch (this.mode) {
            case ONE: {
                jPanel.add(this.singleLight);
                break;
            }
            case TWO: {
                jPanel.add(this.greenLight);
                jPanel.add(this.redLight);
                break;
            }
            case THREE: {
                jPanel.add(this.greenLight);
                jPanel.add(this.yellowLight);
                jPanel.add(this.redLight);
                break;
            }
            default: {
                throw new RuntimeException("Unbekannter Modus " + this.mode + ".");
            }
        }
        return jPanel;
    }

    private Component createDescriptionAndRuntimePart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 0));
        jPanel.add(this.descriptionLabel);
        jPanel.add(this.runtimeLabel);
        return jPanel;
    }

    public Component getPanel() {
        return this.panel;
    }

    public void setNotStartedColor() {
        this.singleLight.setSymbolColor(ColorTool.getColorByName(NOT_STARTED_LIGHT_COLOR));
        this.greenLight.setSymbolColor(ColorTool.getColorByName(NOT_STARTED_LIGHT_COLOR));
        this.yellowLight.setSymbolColor(ColorTool.getColorByName(NOT_STARTED_LIGHT_COLOR));
        this.redLight.setSymbolColor(ColorTool.getColorByName(NOT_STARTED_LIGHT_COLOR));
        this.checkWatch.start();
    }

    public void setBlack() {
        this.singleLight.setSymbolColor(ColorTool.getColorByName(BLACK_LIGHT_COLOR));
        this.greenLight.setSymbolColor(ColorTool.getColorByName(BLACK_LIGHT_COLOR));
        this.yellowLight.setSymbolColor(ColorTool.getColorByName(BLACK_LIGHT_COLOR));
        this.redLight.setSymbolColor(ColorTool.getColorByName(BLACK_LIGHT_COLOR));
        this.checkWatch.start();
    }

    public void setGreen() {
        this.singleLight.setSymbolColor(ColorTool.getColorByName(GREEN_LIGHT_COLOR));
        this.greenLight.setSymbolColor(ColorTool.getColorByName(GREEN_LIGHT_COLOR));
        this.yellowLight.setSymbolColor(ColorTool.getColorByName(BLACK_LIGHT_COLOR));
        this.redLight.setSymbolColor(ColorTool.getColorByName(BLACK_LIGHT_COLOR));
        this.setRuntime();
    }

    public void setYellow() {
        if (this.mode == CheckLightMode.TWO) {
            throw new RuntimeException("Bei der Darstellung mit einer Ampel ohne Gelbphase kann sie nicht auf Gelb gesetzt werden.");
        }
        this.singleLight.setSymbolColor(ColorTool.getColorByName(YELLOW_LIGHT_COLOR));
        this.greenLight.setSymbolColor(ColorTool.getColorByName(BLACK_LIGHT_COLOR));
        this.yellowLight.setSymbolColor(ColorTool.getColorByName(YELLOW_LIGHT_COLOR));
        this.redLight.setSymbolColor(ColorTool.getColorByName(BLACK_LIGHT_COLOR));
        this.setRuntime();
    }

    public void setRed() {
        this.singleLight.setSymbolColor(ColorTool.getColorByName(RED_LIGHT_COLOR));
        this.greenLight.setSymbolColor(ColorTool.getColorByName(BLACK_LIGHT_COLOR));
        this.yellowLight.setSymbolColor(ColorTool.getColorByName(BLACK_LIGHT_COLOR));
        this.redLight.setSymbolColor(ColorTool.getColorByName(RED_LIGHT_COLOR));
        this.setRuntime();
    }

    private void setRuntime() {
        this.checkWatch.stop();
        this.runtimeLabel.setText("Laufzeit: " + this.checkWatch.getTime());
    }

    public String getRuntime() {
        if (null != this.checkWatch && this.checkWatch.isStopped()) {
            return this.checkWatch.getTime();
        }
        throw new RuntimeException("Der Schritt war noch nicht fertig.");
    }
}

