/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.menu.collection.tools;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.html.generation.SwingHtmlBuilder;
import de.duehl.swing.ui.menu.collection.StoredMyMenuItem;
import de.duehl.swing.ui.menu.collection.tools.MyMenuItemCollectionHelper;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class MyMenuItemsHtmlDescriptionGenerator {
    private final List<StoredMyMenuItem> collection;
    private final SwingHtmlBuilder html;
    private String css;
    private boolean sortByKeys;

    public MyMenuItemsHtmlDescriptionGenerator(List<StoredMyMenuItem> list) {
        this.collection = CollectionsHelper.copyList(list);
        this.html = new SwingHtmlBuilder();
        this.sortByKeys = false;
    }

    public void setCss(String string) {
        this.css = string;
    }

    public void sortByKeys() {
        this.sortByKeys = true;
    }

    public void buildDescription() {
        this.sortIfNecessary();
        this.appendHtmlHead();
        this.appendTableHead();
        this.appendTableBody();
        this.appendTableFoot();
        this.appendHtmlFoot();
    }

    private void sortIfNecessary() {
        if (this.sortByKeys) {
            this.sortCollectionByKeys();
        }
    }

    private void sortCollectionByKeys() {
        Collections.sort(this.collection, new Comparator<StoredMyMenuItem>(){

            @Override
            public int compare(StoredMyMenuItem storedMyMenuItem, StoredMyMenuItem storedMyMenuItem2) {
                int n;
                int n2 = storedMyMenuItem.getModifiers();
                if (n2 != (n = storedMyMenuItem2.getModifiers())) {
                    return n2 - n;
                }
                n2 = storedMyMenuItem.getKeyCode();
                n = storedMyMenuItem2.getKeyCode();
                return n2 - n;
            }
        });
    }

    private void appendHtmlHead() {
        Object object = "\u00dcbersicht \u00fcber die Tastaturbefehle";
        if (this.sortByKeys) {
            object = (String)object + " in Reihenfolge der Tasten";
        }
        if (this.css.isEmpty()) {
            this.html.appendHtml5HeadWithOwnCss((String)object);
        } else {
            this.html.appendHtml5HeadWithOwnExtendedCss((String)object, this.css);
        }
        Object object2 = "\u00dcbersicht \u00fcber die im Men\u00fc hinterlegten Tastaturbefehle";
        if (this.sortByKeys) {
            object2 = (String)object2 + " in Reihenfolge der Tasten";
        }
        this.html.appendH1((String)object2);
    }

    private void appendTableHead() {
        this.html.appendOpeningTableWithBorderWidth(2);
        this.html.appendOpeningTr();
        this.html.appendLeftAlignedTh("Tastaturbefehl");
        this.html.appendLeftAlignedTh("Funktion");
        this.html.appendClosingTr();
    }

    private void appendTableBody() {
        for (StoredMyMenuItem storedMyMenuItem : this.collection) {
            if (!storedMyMenuItem.isKeyCodeAndModifiersStored()) continue;
            this.appendTableRow(storedMyMenuItem);
        }
    }

    private void appendTableRow(StoredMyMenuItem storedMyMenuItem) {
        this.html.appendOpeningTr();
        this.html.appendTd(MyMenuItemCollectionHelper.generateKeyboardCommandDescription(storedMyMenuItem));
        this.html.appendTd(storedMyMenuItem.getText());
        this.html.appendClosingTr();
    }

    private void appendTableFoot() {
        this.html.appendClosingTable();
    }

    private void appendHtmlFoot() {
        this.html.appendFoot();
    }

    public String getHtmlDescription() {
        return this.html.toString();
    }
}

