/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.panel.painted;

import de.duehl.swing.ui.geometry.PixelLine;
import de.duehl.swing.ui.geometry.PixelPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;

public abstract class PaintedPanel
extends JPanel {
    private static final long serialVersionUID = -1L;
    private Color backgroundColor;
    protected Graphics2D graphics2;
    private boolean forceSquare;
    private Color symbolColor;

    public PaintedPanel() {
        this(Color.BLACK);
    }

    public PaintedPanel(Color color) {
        this.symbolColor = color;
        this.backgroundColor = null;
        this.forceSquare = false;
    }

    public final Color getSymbolColor() {
        return this.symbolColor;
    }

    public final void setSymbolColor(Color color) {
        this.symbolColor = color;
        this.repaint();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.repaint();
    }

    public boolean isForceSquare() {
        return this.forceSquare;
    }

    public void setForceSquare(boolean bl) {
        this.forceSquare = bl;
    }

    public void forceSquare() {
        this.setForceSquare(true);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.graphics2 = (Graphics2D)graphics.create();
        this.setStroke();
        this.paintBackground();
        this.setSymbolColorInGraphics();
        this.paintSymbol();
        this.graphics2.dispose();
    }

    protected void setStroke() {
        this.graphics2.setStroke(new BasicStroke(2.0f));
    }

    private void paintBackground() {
        if (null != this.backgroundColor) {
            this.graphics2.setColor(this.backgroundColor);
            this.graphics2.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    private void paintSymbol() {
        if (this.forceSquare) {
            this.paintSymbolSquare();
        } else {
            this.paintSymbolRectangle();
        }
    }

    protected final void setSymbolColorInGraphics() {
        this.graphics2.setColor(this.symbolColor);
    }

    protected abstract void paintSymbolRectangle();

    protected abstract void paintSymbolSquare();

    protected final void paintPointLengthRectangle(int n, int n2, int n3, int n4) {
        this.graphics2.fillRect(n, n2, n3, n4);
    }

    protected final void paintTwoPointRectangle(PixelPoint pixelPoint, PixelPoint pixelPoint2) {
        this.paintTwoPointRectangle(pixelPoint.getX(), pixelPoint.getY(), pixelPoint2.getX(), pixelPoint2.getY());
    }

    protected final void paintUnfilledRectangle(PixelPoint pixelPoint, PixelPoint pixelPoint2) {
        this.graphics2.drawRect(pixelPoint.getX(), pixelPoint.getY(), pixelPoint2.getX() - pixelPoint.getX(), pixelPoint2.getY() - pixelPoint.getY());
    }

    protected final void paintTwoPointRectangle(int n, int n2, int n3, int n4) {
        if (n > n3 || n2 > n4) {
            return;
        }
        int n5 = n;
        int n6 = n2;
        int n7 = n3 - n;
        int n8 = n4 - n2;
        this.graphics2.fillRect(n5, n6, n7, n8);
    }

    protected final void paintCircle(PixelPoint pixelPoint, int n) {
        this.paintCircle(pixelPoint.getX(), pixelPoint.getY(), n);
    }

    protected final void paintCircle(int n, int n2, int n3) {
        int n4 = n - n3;
        int n5 = n2 - n3;
        int n6 = 2 * n3;
        int n7 = 2 * n3;
        this.paintOval(n4, n5, n6, n7);
    }

    protected final void paintHollowCircle(PixelPoint pixelPoint, int n) {
        this.paintHollowCircle(pixelPoint.getX(), pixelPoint.getY(), n);
    }

    protected final void paintHollowCircle(int n, int n2, int n3) {
        int n4 = n - n3;
        int n5 = n2 - n3;
        int n6 = 2 * n3;
        int n7 = 2 * n3;
        this.paintHollowOval(n4, n5, n6, n7);
    }

    protected final void paintOval(int n, int n2, int n3, int n4) {
        this.graphics2.fillOval(n, n2, n3, n4);
    }

    protected final void paintHollowOval(int n, int n2, int n3, int n4) {
        this.graphics2.drawOval(n, n2, n3, n4);
    }

    protected final Polygon createPolygon(int[] nArray, int[] nArray2, int n) {
        return new Polygon(nArray, nArray2, n);
    }

    protected final Polygon createPolygon(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        if (n != nArray2.length) {
            throw new RuntimeException("xpoints und ypoints haben unterschiedliche L\u00e4ngen!\n\txPoints: " + n + "\n\tyPoints: " + nArray2.length);
        }
        return this.createPolygon(nArray, nArray2, n);
    }

    protected final Polygon createPolygon(List<PixelPoint> list) {
        int n = list.size();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (PixelPoint pixelPoint : list) {
            nArray[n2] = pixelPoint.getX();
            nArray2[n2] = pixelPoint.getY();
            ++n2;
        }
        return this.createPolygon(nArray, nArray2, n);
    }

    protected final Polygon createPolygon(PixelPoint ... pixelPointArray) {
        return this.createPolygon(Arrays.asList(pixelPointArray));
    }

    protected final void paintPolygon(Polygon polygon) {
        this.graphics2.fillPolygon(polygon);
    }

    protected final void paintPolygon(int[] nArray, int[] nArray2, int n) {
        this.paintPolygon(this.createPolygon(nArray, nArray2, n));
    }

    protected final void paintPolygon(int[] nArray, int[] nArray2) {
        this.paintPolygon(this.createPolygon(nArray, nArray2));
    }

    protected final void paintPolygon(List<PixelPoint> list) {
        this.paintPolygon(this.createPolygon(list));
    }

    protected final void paintPolygon(PixelPoint ... pixelPointArray) {
        this.paintPolygon(Arrays.asList(pixelPointArray));
    }

    protected final void paintHollowPolygon(Polygon polygon) {
        this.graphics2.drawPolygon(polygon);
    }

    protected final void paintHollowPolygon(int[] nArray, int[] nArray2, int n) {
        this.paintHollowPolygon(this.createPolygon(nArray, nArray2, n));
    }

    protected final void paintHollowPolygon(int[] nArray, int[] nArray2) {
        this.paintHollowPolygon(this.createPolygon(nArray, nArray2));
    }

    protected final void paintHollowPolygon(List<PixelPoint> list) {
        this.paintHollowPolygon(this.createPolygon(list));
    }

    protected final void paintHollowPolygon(PixelPoint ... pixelPointArray) {
        this.paintHollowPolygon(Arrays.asList(pixelPointArray));
    }

    protected final void paintLine(PixelPoint pixelPoint, PixelPoint pixelPoint2) {
        this.graphics2.drawLine(pixelPoint.getX(), pixelPoint.getY(), pixelPoint2.getX(), pixelPoint2.getY());
    }

    protected final void paintLine(PixelLine pixelLine) {
        this.paintLine(pixelLine.getStart(), pixelLine.getEnd());
    }
}

