/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.tables;

import de.duehl.swing.ui.colors.ColorTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DifferentBackgroundsTableRendererWithChangingSize
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final float DEFAULT_FONT_SIZE = 15.0f;
    private final Color lighterForeground;
    private final Color lighterBackground;
    private final Color darkerForeground;
    private final Color darkerBackground;
    private float fontSize;
    private boolean useSwitchedColorsForSelection;
    private boolean useDifferentBackgrounds;
    private Color normalForground;
    private Color normalBackground;

    public DifferentBackgroundsTableRendererWithChangingSize(Color color, Color color2) {
        this.lighterForeground = ColorTool.calculateLighterColor(color);
        this.lighterBackground = ColorTool.calculateLighterColor(color2);
        this.darkerForeground = ColorTool.calculateDarkerColor(color);
        this.darkerBackground = ColorTool.calculateDarkerColor(color2);
        this.normalForground = color;
        this.normalBackground = color2;
        this.useSwitchedColorsForSelection = true;
        this.fontSize = 15.0f;
        this.useDifferentBackgrounds = true;
    }

    public void doNotUseSwitchedColorsForSelection() {
        this.useSwitchedColorsForSelection = false;
    }

    public boolean isUseSwitchedColorsForSelection() {
        return this.useSwitchedColorsForSelection;
    }

    public void setUseDifferentBackgrounds(boolean bl) {
        this.useDifferentBackgrounds = bl;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color;
        Color color2;
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(this.fontSize));
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(2);
        if (this.useDifferentBackgrounds) {
            boolean bl3 = n % 2 == 0;
            color2 = bl3 ? this.lighterForeground : this.darkerForeground;
            color = bl3 ? this.lighterBackground : this.darkerBackground;
        } else {
            color2 = this.normalForground;
            color = this.normalBackground;
        }
        if (bl && this.useSwitchedColorsForSelection) {
            this.setForeground(color);
            this.setBackground(color2);
        } else {
            this.setForeground(color2);
            this.setBackground(color);
        }
        return jLabel;
    }

    public void initRowHeightOfTable(JTable jTable) {
        int n = (int)(1.6 * (double)this.fontSize);
        jTable.setRowHeight(n);
    }

    public void increaseFontSize() {
        this.fontSize += 1.0f;
    }

    public void decreaseFontSize() {
        this.fontSize -= 1.0f;
    }

    public void setFontSize(float f) {
        this.fontSize = f;
    }

    public float getFontSize() {
        return this.fontSize;
    }
}

