/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.tabs.bars.editors;

import de.duehl.basics.io.FileHelper;
import de.duehl.swing.ui.highlightingeditor.HighlightingEditor;
import de.duehl.swing.ui.tabs.bars.editors.TabBarWithEditorsBase;
import de.duehl.swing.ui.tabs.bars.generic.GrowingTabBar;
import de.duehl.swing.ui.tabs.bars.generic.TabBar;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class GrowingTabBarWithEditors
extends TabBarWithEditorsBase {
    private static final int DEFAULT_FONT_SIZE = 20;
    private String basePath;
    private final List<HighlightingEditor> editors;

    public GrowingTabBarWithEditors() {
        this(true);
    }

    public GrowingTabBarWithEditors(boolean bl) {
        this.setShowCloseButton(bl);
        this.setTabBar(this.createTabBar(bl));
        this.createAndAddChangeListener();
        this.basePath = "c:";
        this.editors = new ArrayList<HighlightingEditor>();
    }

    private TabBar<Component> createTabBar(boolean bl) {
        return new GrowingTabBar<Component>(bl, string -> this.createNewTab(string));
    }

    private void createNewTab(String string) {
        TabBar<Component> tabBar = this.getTabBar();
        String string2 = tabBar.generateNotUsedTitle(string);
        HighlightingEditor highlightingEditor = this.createEditor(string2);
        this.addTab(highlightingEditor);
        this.editors.add(highlightingEditor);
    }

    private HighlightingEditor createEditor(String string) {
        HighlightingEditor highlightingEditor = new HighlightingEditor();
        highlightingEditor.useMonospaceFont();
        highlightingEditor.setFontSize(20);
        String string2 = FileHelper.concatPathes(this.basePath, string);
        highlightingEditor.setFilenameButDoNotDoAnythingElse(string2);
        return highlightingEditor;
    }

    public void setBasePath(String string) {
        this.basePath = string;
        for (HighlightingEditor highlightingEditor : this.editors) {
            String string2 = highlightingEditor.getFilename();
            String string3 = FileHelper.getBareName(string2);
            String string4 = FileHelper.concatPathes(string, string3);
            highlightingEditor.setFilenameButDoNotDoAnythingElse(string4);
        }
    }
}

