/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.tabs.bars.editors;

import de.duehl.basics.io.FileHelper;
import de.duehl.swing.ui.highlightingeditor.HighlightingEditor;
import de.duehl.swing.ui.tabs.Tabulator;
import de.duehl.swing.ui.tabs.bars.generic.TabBar;
import de.duehl.swing.ui.tabs.close.CloseButtonReaktor;
import de.duehl.swing.ui.tabs.elements.TabElements;
import de.duehl.swing.ui.tabs.elements.TabElementsWithEditor;
import java.awt.Component;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class TabBarWithEditorsBase {
    private boolean showCloseButton;
    private TabBar<Component> tabBar;

    protected void setShowCloseButton(boolean bl) {
        this.showCloseButton = bl;
    }

    protected boolean isShowCloseButton() {
        return this.showCloseButton;
    }

    protected TabBar<Component> getTabBar() {
        return this.tabBar;
    }

    protected void setTabBar(TabBar<Component> tabBar) {
        this.tabBar = tabBar;
    }

    protected void createAndAddChangeListener() {
        this.tabBar.addChangeListener(this.createChangeListener());
    }

    private ChangeListener createChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TabBarWithEditorsBase.this.reactOnTabChange();
            }
        };
    }

    private void reactOnTabChange() {
        TabElements<Component> tabElements = this.tabBar.getSelectedTabElements();
        if (null != tabElements && tabElements instanceof TabElementsWithEditor) {
            TabElementsWithEditor tabElementsWithEditor = (TabElementsWithEditor)tabElements;
            HighlightingEditor highlightingEditor = tabElementsWithEditor.getEditor();
            SwingUtilities.invokeLater(() -> highlightingEditor.requestFocusInWindow());
        }
    }

    public TabElementsWithEditor addTab(HighlightingEditor highlightingEditor) {
        TabElementsWithEditor tabElementsWithEditor = this.createNewTabElements(highlightingEditor);
        this.tabBar.addTab(tabElementsWithEditor);
        return tabElementsWithEditor;
    }

    private TabElementsWithEditor createNewTabElements(HighlightingEditor highlightingEditor) {
        String string;
        String string2 = highlightingEditor.getFilename();
        String string3 = string = FileHelper.getBareName(string2);
        Tabulator tabulator = this.createTabulator(string3);
        return new TabElementsWithEditor(string3, tabulator, highlightingEditor);
    }

    private Tabulator createTabulator(String string) {
        String string2 = "Title: " + string;
        if (this.showCloseButton) {
            return new Tabulator(string2, string, this.createCloseReaktor(string), this.showCloseButton);
        }
        return new Tabulator(string2, string, this.showCloseButton);
    }

    private CloseButtonReaktor createCloseReaktor(final String string) {
        return new CloseButtonReaktor(){

            @Override
            public void closeButtonPressed(String string2) {
                TabBarWithEditorsBase.this.removeTab(string);
            }
        };
    }

    public void removeTab(String string) {
        this.tabBar.removeTab(string);
    }

    public Component getComponent() {
        return this.tabBar.getComponent();
    }

    public void validate() {
        this.tabBar.validate();
    }

    public void cancelTimer() {
        for (TabElements<Component> tabElements : this.tabBar.getTabElementsList()) {
            TabElementsWithEditor tabElementsWithEditor = (TabElementsWithEditor)tabElements;
            HighlightingEditor highlightingEditor = tabElementsWithEditor.getEditor();
            highlightingEditor.cancelTimer();
        }
    }

    public void focusSelectedEditor() {
        this.reactOnTabChange();
    }

    public void select(HighlightingEditor highlightingEditor) {
        for (TabElements<Component> tabElements : this.tabBar.getTabElementsList()) {
            TabElementsWithEditor tabElementsWithEditor = (TabElementsWithEditor)tabElements;
            if (!highlightingEditor.equals(tabElementsWithEditor.getEditor())) continue;
            this.tabBar.select(tabElements);
        }
    }
}

