/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.tabs.close;

import de.duehl.swing.ui.tabs.close.CloseButtonReaktor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;

public class CloseTabButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private static final Dimension BUTTON_DIMENSION = new Dimension(17, 17);
    private final String tabIdentifier;
    private final CloseButtonReaktor closeButtonReaktor;
    private static final MouseListener BUTTON_MOUSE_LISTENER = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBorderPainted(false);
            }
        }
    };

    public CloseTabButton(String string, CloseButtonReaktor closeButtonReaktor) {
        this.tabIdentifier = string;
        this.closeButtonReaktor = closeButtonReaktor;
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.setPreferredSize(BUTTON_DIMENSION);
        this.addCloseActionListener();
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setBorderPainted(false);
        this.addMouseListener(BUTTON_MOUSE_LISTENER);
        this.setRolloverEnabled(true);
    }

    private void addCloseActionListener() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CloseTabButton.this.closeButtonReaktor.closeButtonPressed(CloseTabButton.this.tabIdentifier);
                CloseTabButton.this.removeActionListener(this);
            }
        });
    }

    public void reactivate() {
        this.addCloseActionListener();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.getModel().isPressed()) {
            graphics2D.translate(1, 1);
        }
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setColor(Color.BLACK);
        if (this.getModel().isRollover()) {
            graphics2D.setColor(Color.RED);
        }
        int n = 6;
        graphics2D.drawLine(n, n, this.getWidth() - n - 1, this.getHeight() - n - 1);
        graphics2D.drawLine(this.getWidth() - n - 1, n, n, this.getHeight() - n - 1);
        graphics2D.dispose();
    }
}

