/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.text.html;

import de.duehl.swing.logic.Quitter;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.key.BindKeysOnRootPane;
import de.duehl.swing.ui.layout.ExtendedFlowLayout;
import de.duehl.swing.ui.text.html.HtmlCardPanel;
import de.duehl.swing.ui.text.html.HtmlPanelCard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.EmptyBorder;

public class HtmlAndSourceCodePanel {
    private final HtmlCardPanel htmlCardPanel = new HtmlCardPanel();
    private final JPanel panel;
    private final JButton toggleHtmlAndSourceCodeButton = new JButton();
    private final JPanel rightButtonsPanel;
    private final JPanel leftButtonsPanel;

    private HtmlAndSourceCodePanel() {
        this.initToggleHtmlAndSourceCodeButton();
        this.rightButtonsPanel = new JPanel();
        this.leftButtonsPanel = new JPanel();
        this.initLeftAndRightButtonPanels();
        this.panel = new JPanel();
        this.initPanel();
    }

    private void initToggleHtmlAndSourceCodeButton() {
        this.showRightToggleButtonText();
        this.toggleHtmlAndSourceCodeButton.addActionListener(actionEvent -> this.toggle());
    }

    public void toggle() {
        this.htmlCardPanel.switchCard();
        this.showRightToggleButtonText();
    }

    private void showRightToggleButtonText() {
        HtmlPanelCard htmlPanelCard = this.htmlCardPanel.getCurrentCard();
        this.toggleHtmlAndSourceCodeButton.setText(htmlPanelCard.getTextForToggleButton());
    }

    private void initLeftAndRightButtonPanels() {
        this.leftButtonsPanel.setLayout(new ExtendedFlowLayout(0, 5, 0));
        this.rightButtonsPanel.setLayout(new ExtendedFlowLayout(2, 5, 0));
    }

    private void initPanel() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.htmlCardPanel.getCardPanel(), "Center");
        this.panel.add(this.createButtonPart(), "South");
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2));
        jPanel.add((Component)this.leftButtonsPanel, "West");
        jPanel.add((Component)this.rightButtonsPanel, "East");
        return jPanel;
    }

    public void setColors(Colorizer colorizer) {
        if (null != colorizer) {
            this.htmlCardPanel.setColors(colorizer);
            colorizer.setColors(this.panel);
            colorizer.setColors(this.rightButtonsPanel);
            colorizer.setColors(this.leftButtonsPanel);
        }
    }

    public void createBorderAroundTextFields(int n) {
        JPanel jPanel = this.htmlCardPanel.getCardPanel();
        jPanel.setBorder(new EmptyBorder(n, n, n, n));
    }

    public void addButtonOnRight(Component component) {
        this.rightButtonsPanel.add(component);
    }

    public void addButtonOnLeft(Component component) {
        this.leftButtonsPanel.add(component);
    }

    public void addButtonAtFrontOnLeft(Component component) {
        this.leftButtonsPanel.add(component, 0);
    }

    public void addToggleButtonToLeft() {
        this.addButtonOnLeft(this.toggleHtmlAndSourceCodeButton);
    }

    public void addQuitButtonToRight(Quitter quitter) {
        this.addButtonOnRight(this.createQuitButton(quitter));
    }

    private Component createQuitButton(Quitter quitter) {
        JButton jButton = new JButton();
        jButton.setText("Beenden");
        jButton.addActionListener(actionEvent -> quitter.quit());
        return jButton;
    }

    public Component getComponent() {
        return this.panel;
    }

    public void setKeyBindings(JRootPane jRootPane) {
        BindKeysOnRootPane bindKeysOnRootPane = new BindKeysOnRootPane(jRootPane);
        bindKeysOnRootPane.setKeyBindingCtrlHome(() -> this.htmlCardPanel.scrollScrollbarToMinimumLater());
        bindKeysOnRootPane.setKeyBindingCtrlEnd(() -> this.htmlCardPanel.scrollScrollbarToMaximumLater());
        bindKeysOnRootPane.setKeyBindingPageUp(() -> this.htmlCardPanel.scrollScrollbarToPreviousSectionLater());
        bindKeysOnRootPane.setKeyBindingPageDown(() -> this.htmlCardPanel.scrollScrollbarToNextSectionLater());
    }

    public void scrollScrollbarToMinimumLater() {
        this.htmlCardPanel.scrollScrollbarToMinimumLater();
    }

    public void scrollScrollbarToMaximumLater() {
        this.htmlCardPanel.scrollScrollbarToMaximumLater();
    }

    public void scrollScrollbarToPreviousSectionLater() {
        this.htmlCardPanel.scrollScrollbarToPreviousSectionLater();
    }

    public void scrollScrollbarToNextSectionLater() {
        this.htmlCardPanel.scrollScrollbarToNextSectionLater();
    }

    public int getTextLength() {
        return this.htmlCardPanel.getTextLength();
    }

    public void showHtml(URL uRL) {
        this.htmlCardPanel.showHtml(uRL);
    }

    public void setText(String string) {
        this.htmlCardPanel.setText(string);
    }

    public void setTextAndScrollToTop(String string) {
        this.htmlCardPanel.setTextAndScrollToTop(string);
    }

    public void repaint() {
        this.htmlCardPanel.repaint();
    }

    public void setPreferredSize(Dimension dimension) {
        this.htmlCardPanel.setPreferredSize(dimension);
    }

    public void setPreferredSize(int n, int n2) {
        this.htmlCardPanel.setPreferredSize(n, n2);
    }

    public void setDragEnabled(boolean bl) {
        this.htmlCardPanel.setDragEnabled(bl);
    }

    public void setCaretPosition(int n) {
        this.htmlCardPanel.setCaretPosition(n);
    }

    public int getCaretPosition() {
        return this.htmlCardPanel.getCaretPosition();
    }

    public Rectangle getVisibleRect() {
        return this.htmlCardPanel.getVisibleRect();
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        this.htmlCardPanel.scrollRectToVisible(rectangle);
    }

    public int getSelectionStart() {
        return this.htmlCardPanel.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.htmlCardPanel.getSelectionEnd();
    }

    public void setSelectionStart(int n) {
        this.htmlCardPanel.setSelectionStart(n);
    }

    public void setSelectionEnd(int n) {
        this.htmlCardPanel.setSelectionEnd(n);
    }

    public String getSelectedText() {
        return this.htmlCardPanel.getSelectedText();
    }

    public void clearSelection() {
        this.htmlCardPanel.clearSelection();
    }

    public boolean hasFocus() {
        return this.htmlCardPanel.hasFocus();
    }

    public void setBackground(Color color) {
        this.htmlCardPanel.setBackground(color);
    }

    public void ignorePageUpAndPageDown() {
        this.htmlCardPanel.ignorePageUpAndPageDown();
    }

    public void ignoreUpAndDown() {
        this.htmlCardPanel.ignoreUpAndDown();
    }

    public void ignoreCtrlPos1AndCtrlEnd() {
        this.htmlCardPanel.ignoreCtrlPos1AndCtrlEnd();
    }

    public void showCursor() {
        this.htmlCardPanel.showCursor();
    }

    public static HtmlAndSourceCodePanel createWithOkButtonAndToggleButton(Quitter quitter) {
        HtmlAndSourceCodePanel htmlAndSourceCodePanel = HtmlAndSourceCodePanel.createWithToggleButton();
        htmlAndSourceCodePanel.addQuitButtonToRight(quitter);
        return htmlAndSourceCodePanel;
    }

    public static HtmlAndSourceCodePanel createWithToggleButton() {
        HtmlAndSourceCodePanel htmlAndSourceCodePanel = HtmlAndSourceCodePanel.create();
        htmlAndSourceCodePanel.addToggleButtonToLeft();
        return htmlAndSourceCodePanel;
    }

    public static HtmlAndSourceCodePanel create() {
        HtmlAndSourceCodePanel htmlAndSourceCodePanel = new HtmlAndSourceCodePanel();
        return htmlAndSourceCodePanel;
    }

    public void storeVerticalPosition() {
        this.htmlCardPanel.storeVerticalPosition();
    }

    public void restoreVerticalPosition() {
        this.htmlCardPanel.restoreVerticalPosition();
    }

    public String getHtmlText() {
        return this.htmlCardPanel.getHtmlText();
    }

    public void sourceCodePanelBiggerFont(int n) {
        this.htmlCardPanel.sourceCodePanelBiggerFont(n);
    }
}

