/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.text.html;

import de.duehl.basics.text.Text;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.text.TextualComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class HtmlComponent
implements TextualComponent {
    private final JEditorPane htmlComponent = new JEditorPane();

    public HtmlComponent() {
        this.initComponent();
    }

    private void initComponent() {
        this.htmlComponent.setContentType("text/html");
        this.htmlComponent.setEditable(false);
    }

    public void showCursor() {
        this.htmlComponent.setCaretColor(Color.RED);
        this.htmlComponent.getCaret().setVisible(true);
        this.htmlComponent.getCaret().setBlinkRate(0);
    }

    @Override
    public void setText(String string) {
        this.htmlComponent.setText(string);
    }

    public void showHtml(URL uRL) {
        this.showHtmlWithoutSettingCaretPosition(uRL);
        this.htmlComponent.setCaretPosition(0);
    }

    private void showHtmlWithoutSettingCaretPosition(URL uRL) {
        try {
            this.tryToShowHtmlWithoutSettingCaretPosition(uRL);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Fehler beim \u00f6ffnen der URL '" + uRL.toString() + "'.", iOException);
        }
    }

    private void tryToShowHtmlWithoutSettingCaretPosition(URL uRL) throws IOException {
        this.htmlComponent.setPage(uRL);
        this.htmlComponent.addHyperlinkListener(this.createHyperLinkListener());
    }

    private HyperlinkListener createHyperLinkListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
                if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
                    HtmlComponent.this.reactOnClickedLink(hyperlinkEvent.getURL());
                }
            }
        };
    }

    private void reactOnClickedLink(URL uRL) {
        URL uRL2 = this.htmlComponent.getPage();
        if (null == uRL2) {
            this.showHtml(uRL);
        } else {
            String string;
            String string2 = Text.skipSublinkPart(uRL.toString());
            if (string2.equals(string = Text.skipSublinkPart(uRL2.toString()))) {
                this.showHtmlWithoutSettingCaretPosition(uRL);
            } else {
                this.showHtml(uRL);
            }
        }
    }

    public void setDragEnabled(boolean bl) {
        this.htmlComponent.setDragEnabled(bl);
    }

    public int getCaretPosition() {
        return this.htmlComponent.getCaretPosition();
    }

    @Override
    public void setCaretPosition(int n) {
        this.htmlComponent.setCaretPosition(n);
    }

    public Rectangle getVisibleRect() {
        return this.htmlComponent.getVisibleRect();
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        this.htmlComponent.scrollRectToVisible(rectangle);
    }

    public int getSelectionStart() {
        return this.htmlComponent.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.htmlComponent.getSelectionEnd();
    }

    public void setSelectionStart(int n) {
        this.htmlComponent.setSelectionStart(n);
    }

    public void setSelectionEnd(int n) {
        this.htmlComponent.setSelectionEnd(n);
    }

    public String getSelectedText() {
        try {
            String string = this.htmlComponent.getSelectedText();
            if (null == string) {
                return "";
            }
            return string;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public void clearSelection() {
        this.htmlComponent.select(0, 0);
    }

    @Override
    public int getTextLength() {
        return this.htmlComponent.getText().length();
    }

    @Override
    public void repaint() {
        this.htmlComponent.repaint();
        this.htmlComponent.validate();
    }

    @Override
    public void setPreferredSize(int n, int n2) {
        this.htmlComponent.setPreferredSize(new Dimension(n, n2));
    }

    @Override
    public void setColors(Colorizer colorizer) {
        if (colorizer != null) {
            colorizer.setColors(this.htmlComponent);
        }
    }

    @Override
    public Component getComponent() {
        return this.htmlComponent;
    }

    public boolean hasFokus() {
        return this.htmlComponent.hasFocus();
    }

    public void setBackground(Color color) {
        this.htmlComponent.setOpaque(true);
        this.htmlComponent.setBackground(color);
    }

    public void ignorePageUpAndPageDown() {
        GuiTools.ignorePageUpAndPageDownInComponent(this.htmlComponent);
    }

    public void ignoreUpAndDown() {
        GuiTools.ignoreUpAndDownInComponent(this.htmlComponent);
    }

    public void ignoreCtrlPos1AndCtrlEnd() {
        GuiTools.ignoreCtrlPos1AndCtrlEndInComponent(this.htmlComponent);
    }

    public String getHtmlText() {
        return this.htmlComponent.getText();
    }
}

