/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.symbol.kana.html;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.vocabulary.japanese.data.symbol.Katakana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.html.KanaHtmlCreator;
import de.duehl.vocabulary.japanese.logic.symbol.kana.html.data.KanaStructure;

public class KatakanaHtmlCreator {
    private KanaStructure structure;
    private String html;

    public void create() {
        this.createStructure();
        this.createKanaHtml();
    }

    private void createStructure() {
        this.structure = new KanaStructure();
        this.structure.fillAIUEO(Katakana.A.toKana(), Katakana.I.toKana(), Katakana.U.toKana(), Katakana.E.toKana(), Katakana.O.toKana());
        this.structure.fillKaKiKuKeKo(Katakana.KA.toKana(), Katakana.KI.toKana(), Katakana.KU.toKana(), Katakana.KE.toKana(), Katakana.KO.toKana());
        this.structure.fillSaShiSuSeSo(Katakana.SA.toKana(), Katakana.SHI.toKana(), Katakana.SU.toKana(), Katakana.SE.toKana(), Katakana.SO.toKana());
        this.structure.fillTaChiTsuTeTo(Katakana.TA.toKana(), Katakana.CHI.toKana(), Katakana.TSU.toKana(), Katakana.TE.toKana(), Katakana.TO.toKana());
        this.structure.fillNaNiNuNeNo(Katakana.NA.toKana(), Katakana.NI.toKana(), Katakana.NU.toKana(), Katakana.NE.toKana(), Katakana.NO.toKana());
        this.structure.fillHaHiFuHeHo(Katakana.HA.toKana(), Katakana.HI.toKana(), Katakana.FU.toKana(), Katakana.HE.toKana(), Katakana.HO.toKana());
        this.structure.fillMaMiMuMeMo(Katakana.MA.toKana(), Katakana.MI.toKana(), Katakana.MU.toKana(), Katakana.ME.toKana(), Katakana.MO.toKana());
        this.structure.fillYaYuYo(Katakana.YA.toKana(), Katakana.YU.toKana(), Katakana.YO.toKana());
        this.structure.fillRaRiRuReRo(Katakana.RA.toKana(), Katakana.RI.toKana(), Katakana.RU.toKana(), Katakana.RE.toKana(), Katakana.RO.toKana());
        this.structure.fillWaWo(Katakana.WA.toKana(), Katakana.WO.toKana());
        this.structure.fillN(Katakana.N.toKana());
        this.structure.fillGaGiGuGeGo(Katakana.GA.toKana(), Katakana.GI.toKana(), Katakana.GU.toKana(), Katakana.GE.toKana(), Katakana.GO.toKana());
        this.structure.fillZaJiZuZeZo(Katakana.ZA.toKana(), Katakana.JI1.toKana(), Katakana.ZU1.toKana(), Katakana.ZE.toKana(), Katakana.ZO.toKana());
        this.structure.fillDaJiZuDeDo(Katakana.DA.toKana(), Katakana.JI2.toKana(), Katakana.ZU2.toKana(), Katakana.DE.toKana(), Katakana.DO.toKana());
        this.structure.fillBaBiBuBeBo(Katakana.BA.toKana(), Katakana.BI.toKana(), Katakana.BU.toKana(), Katakana.BE.toKana(), Katakana.BO.toKana());
        this.structure.fillPaPiPuPePo(Katakana.PA.toKana(), Katakana.PI.toKana(), Katakana.PU.toKana(), Katakana.PE.toKana(), Katakana.PO.toKana());
        this.structure.fillKyaKyuKyo(Katakana.KYA.toKana(), Katakana.KYU.toKana(), Katakana.KYO.toKana());
        this.structure.fillShaShuSho(Katakana.SHA.toKana(), Katakana.SHU.toKana(), Katakana.SHO.toKana());
        this.structure.fillChaChuCho(Katakana.CHA.toKana(), Katakana.CHU.toKana(), Katakana.CHO.toKana());
        this.structure.fillNyaNyuNyo(Katakana.NYA.toKana(), Katakana.NYU.toKana(), Katakana.NYO.toKana());
        this.structure.fillHyaHyuHyo(Katakana.HYA.toKana(), Katakana.HYU.toKana(), Katakana.HYO.toKana());
        this.structure.fillMyaMyuMyo(Katakana.MYA.toKana(), Katakana.MYU.toKana(), Katakana.MYO.toKana());
        this.structure.fillRyaRyuRyo(Katakana.RYA.toKana(), Katakana.RYU.toKana(), Katakana.RYO.toKana());
        this.structure.fillGyaGyuGyo(Katakana.GYA.toKana(), Katakana.GYU.toKana(), Katakana.GYO.toKana());
        this.structure.fillJaJuJo1(Katakana.JA1.toKana(), Katakana.JU1.toKana(), Katakana.JO1.toKana());
        this.structure.fillJaJuJo2(Katakana.JA2.toKana(), Katakana.JU2.toKana(), Katakana.JO2.toKana());
        this.structure.fillByaByuByo(Katakana.BYA.toKana(), Katakana.BYU.toKana(), Katakana.BYO.toKana());
        this.structure.fillPyaPyuPyo(Katakana.PYA.toKana(), Katakana.PYU.toKana(), Katakana.PYO.toKana());
        this.structure.fillKanaLehnworte(CollectionsHelper.buildListFrom(Katakana.LEHNWORT_F1.toKana(), Katakana.LEHNWORT_F2.toKana(), Katakana.LEHNWORT_F3.toKana(), Katakana.LEHNWORT_F4.toKana(), Katakana.LEHNWORT_W1.toKana(), Katakana.LEHNWORT_W2.toKana(), Katakana.LEHNWORT_W3.toKana(), Katakana.LEHNWORT_W4.toKana(), Katakana.LEHNWORT_W5.toKana(), Katakana.LEHNWORT_TI.toKana(), Katakana.LEHNWORT_DI.toKana(), Katakana.LEHNWORT_TU.toKana(), Katakana.LEHNWORT_DU.toKana()));
        this.structure.fillKleinesTsu(Katakana.SMALL_TSU.toKana());
        this.structure.fillKleinesYaYuYoGo(Katakana.SMALL_YA.toKana(), Katakana.SMALL_YU.toKana(), Katakana.SMALL_YO.toKana());
    }

    private void createKanaHtml() {
        KanaHtmlCreator kanaHtmlCreator = new KanaHtmlCreator(this.structure, "Katakana");
        kanaHtmlCreator.create();
        this.html = kanaHtmlCreator.getHtml();
    }

    public String getHtml() {
        return this.html;
    }
}

