/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.symbol.kana.internal;

import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanaData;
import de.duehl.vocabulary.japanese.data.symbol.Hiragana;
import de.duehl.vocabulary.japanese.data.symbol.Katakana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.InternalKanaDataRequester;
import java.util.Map;

public class RealInternalKanaDataRequester
implements InternalKanaDataRequester {
    public static final String HIRAGANA_PRE = "HIRAGANA_";
    public static final String KATAKANA_PRE = "KATAKANA_";
    private final Map<String, InternalAdditionalKanaData> key2InternalKanaDataMap;

    public RealInternalKanaDataRequester(Map<String, InternalAdditionalKanaData> map) {
        this.key2InternalKanaDataMap = map;
    }

    @Override
    public InternalAdditionalKanaData getInternalDataForHiragana(Hiragana hiragana) {
        String string = HIRAGANA_PRE + hiragana.name();
        if (this.key2InternalKanaDataMap.containsKey(string)) {
            return this.key2InternalKanaDataMap.get(string);
        }
        throw new RuntimeException("Das Verzeichnis der internen Daten zu einem Hiragana nach dem dem Schl\u00fcssel des zugeh\u00f6rigen Hiragana enth\u00e4lt keinen Eintrag f\u00fcr das \u00fcbergebene Hiragana.\n\thiragana: " + hiragana + "\n\tkey  : " + string + "\n");
    }

    @Override
    public InternalAdditionalKanaData getInternalDataForKatakana(Katakana katakana) {
        String string = KATAKANA_PRE + katakana.name();
        if (this.key2InternalKanaDataMap.containsKey(string)) {
            return this.key2InternalKanaDataMap.get(string);
        }
        throw new RuntimeException("Das Verzeichnis der internen Daten zu einem Katakana nach dem dem Schl\u00fcssel des zugeh\u00f6rigen Katakana enth\u00e4lt keinen Eintrag f\u00fcr das \u00fcbergebene Katakana.\n\tkatakana: " + katakana + "\n\tkey  : " + string + "\n");
    }
}

