/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.symbol.kanji.test;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.math.stochastic.RandomSampleWithoutPutBack;
import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanjiData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.test.data.KanjiForTestSelectionMethod;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest.KanjiTestParameterChooser;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest.KanjiTester;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KanjiTesterLogic {
    private static final boolean DEBUG = false;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private boolean goAhead;
    private List<Kanji> kanjiList;
    private int numberOfKanjiToTest;
    private boolean useOriginalKanjiOrder;
    private List<Kanji> kanjiToTest;
    private String kanjiToTestDescription;
    private KanjiForTestSelectionMethod selectionMethod;
    private boolean germanMeaningCaseSensitivity;
    private boolean onLesungCaseSensitivity;
    private boolean kunLesungCaseSensitivity;
    private List<Kanji> notTenTimesGoodTestedKanjiList;
    private Point chooserLocation;

    public KanjiTesterLogic(FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects) {
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
    }

    public void test() {
        this.init();
        if (this.goAhead) {
            this.askTestParameters();
        }
        if (this.goAhead) {
            this.determineKanjiToTest();
        }
        if (this.goAhead) {
            this.startRealTest();
        }
    }

    private void init() {
        this.goAhead = true;
        this.determineNotTenTimesGoodTestedKanjiList();
    }

    private void determineNotTenTimesGoodTestedKanjiList() {
        this.notTenTimesGoodTestedKanjiList = new ArrayList<Kanji>();
        InternalKanjiDataRequester internalKanjiDataRequester = this.dataStructures.getInternalKanjiDataRequester();
        for (Kanji kanji : Kanji.getAllKanjiAsList()) {
            InternalAdditionalKanjiData internalAdditionalKanjiData = internalKanjiDataRequester.getInternalDataForKanji(kanji);
            if (internalAdditionalKanjiData.getLastCorrectTestsCount() >= 10) continue;
            this.notTenTimesGoodTestedKanjiList.add(kanji);
        }
    }

    private void askTestParameters() {
        KanjiTestParameterChooser kanjiTestParameterChooser = new KanjiTestParameterChooser(this.dataStructures.getKanjiSets(), this.dataStructures.getOptions(), this.notTenTimesGoodTestedKanjiList, this.uiObjects.getGuiLocation(), this.uiObjects.getProgramImage());
        kanjiTestParameterChooser.setVisible(true);
        if (kanjiTestParameterChooser.isApplied()) {
            this.kanjiList = kanjiTestParameterChooser.getKanjiList();
            this.numberOfKanjiToTest = kanjiTestParameterChooser.getNumberOfKanjiToTest();
            this.useOriginalKanjiOrder = kanjiTestParameterChooser.isUseOriginalKanjiOrder();
            this.selectionMethod = kanjiTestParameterChooser.getSelectionMethod();
            this.germanMeaningCaseSensitivity = kanjiTestParameterChooser.isGermanMeaningCaseSensitivity();
            this.onLesungCaseSensitivity = kanjiTestParameterChooser.isOnLesungCaseSensitivity();
            this.kunLesungCaseSensitivity = kanjiTestParameterChooser.isKunLesungCaseSensitivity();
            if (this.kanjiList.isEmpty()) {
                String string = "Leer Menge an Kanji ausgew\u00e4hlt";
                String string2 = "Sie haben eine leere Menge an abzufragenden Kanji ausgew\u00e4hlt, daher ist nichts abzufragen.";
                GuiTools.informUser(string, string2);
                this.goAhead = false;
            } else {
                this.chooserLocation = kanjiTestParameterChooser.getLocation();
            }
        } else {
            this.goAhead = false;
        }
    }

    private void determineKanjiToTest() {
        switch (this.selectionMethod) {
            case RANDOM_BY_NUMBER: {
                this.determineKanjiToTestByRandomNumber();
                return;
            }
            case ALL: {
                this.useAllKanji();
                return;
            }
            case LAST_N: {
                this.useLastNKanji();
                return;
            }
            case NOT_TEN_TIMES_GOOD_TESTED: {
                this.useNotTenTimesGoodTestedKanjiList();
                return;
            }
            case OLDEST_TESTED_N: {
                this.useOldestNKanji();
                return;
            }
            case MOST_SELDOM_TESTED_N: {
                this.useMostSeldomTestedNKanji();
                return;
            }
        }
        this.goAhead = false;
    }

    private void determineKanjiToTestByRandomNumber() {
        List<Integer> list = this.createKanjiPositionSample();
        this.fillKanjiToTestWithKanjiPositionSample(list);
        this.kanjiToTestDescription = this.numberOfKanjiToTest + " zuf\u00e4llige Kanji";
    }

    private List<Integer> createKanjiPositionSample() {
        int n = 1;
        int n2 = this.kanjiList.size();
        int n3 = Math.min(this.kanjiList.size(), this.numberOfKanjiToTest);
        RandomSampleWithoutPutBack randomSampleWithoutPutBack = new RandomSampleWithoutPutBack(n, n2, n3);
        randomSampleWithoutPutBack.drawSample();
        List<Integer> list = randomSampleWithoutPutBack.getSample();
        if (this.useOriginalKanjiOrder) {
            Collections.sort(list);
        }
        return list;
    }

    private void fillKanjiToTestWithKanjiPositionSample(List<Integer> list) {
        this.kanjiToTest = new ArrayList<Kanji>();
        for (int n : list) {
            int n2 = n - 1;
            Kanji kanji = this.kanjiList.get(n2);
            this.kanjiToTest.add(kanji);
        }
    }

    private void useAllKanji() {
        this.kanjiToTest = new ArrayList<Kanji>();
        this.kanjiToTest.addAll(this.kanjiList);
        if (!this.useOriginalKanjiOrder) {
            Collections.shuffle(this.kanjiToTest);
        }
        this.kanjiToTestDescription = "alle Kanji";
    }

    private void useLastNKanji() {
        int n;
        this.kanjiToTest = new ArrayList<Kanji>();
        int n2 = this.kanjiList.size();
        for (int i = n = Math.max(0, n2 - this.numberOfKanjiToTest); i <= n2 - 1; ++i) {
            Kanji kanji = this.kanjiList.get(i);
            this.kanjiToTest.add(kanji);
        }
        if (!this.useOriginalKanjiOrder) {
            Collections.shuffle(this.kanjiToTest);
        }
        this.kanjiToTestDescription = "die letzten " + this.numberOfKanjiToTest + " Kanji";
    }

    private void useNotTenTimesGoodTestedKanjiList() {
        this.kanjiToTest = new ArrayList<Kanji>();
        this.kanjiToTest.addAll(this.notTenTimesGoodTestedKanjiList);
        if (!this.useOriginalKanjiOrder) {
            Collections.shuffle(this.kanjiToTest);
        }
        this.kanjiToTestDescription = "Kanji die nicht zuletzt 10 x richtig abgefragt wurden";
    }

    private void useOldestNKanji() {
        this.kanjiToTest = new ArrayList<Kanji>();
        Map<Kanji, Integer> map = this.createDaysNotTestedByKanjiMap();
        List<Kanji> list = this.createKanjiListSortedByDaysNotTested(map);
        list = this.shuffleEqualLongNotTestedKanjis(list, map);
        for (int i = 0; i < this.numberOfKanjiToTest; ++i) {
            Kanji kanji = list.get(i);
            this.kanjiToTest.add(kanji);
        }
        if (!this.useOriginalKanjiOrder) {
            Collections.shuffle(this.kanjiToTest);
        }
        this.kanjiToTestDescription = "die " + this.numberOfKanjiToTest + " am l\u00e4ngsten nicht mehr abgefragten Kanji";
    }

    private Map<Kanji, Integer> createDaysNotTestedByKanjiMap() {
        HashMap<Kanji, Integer> hashMap = new HashMap<Kanji, Integer>();
        ImmutualDate immutualDate = new ImmutualDate();
        InternalKanjiDataRequester internalKanjiDataRequester = this.dataStructures.getInternalKanjiDataRequester();
        for (Kanji kanji : this.kanjiList) {
            InternalAdditionalKanjiData internalAdditionalKanjiData = internalKanjiDataRequester.getInternalDataForKanji(kanji);
            ImmutualDate immutualDate2 = internalAdditionalKanjiData.getLastTestDate();
            int n = immutualDate2.difference(immutualDate);
            hashMap.put(kanji, n);
        }
        return hashMap;
    }

    private List<Kanji> createKanjiListSortedByDaysNotTested(final Map<Kanji, Integer> map) {
        ArrayList<Kanji> arrayList = new ArrayList<Kanji>();
        arrayList.addAll(this.kanjiList);
        Collections.sort(arrayList, new Comparator<Kanji>(){

            @Override
            public int compare(Kanji kanji, Kanji kanji2) {
                int n = (Integer)map.get((Object)kanji);
                int n2 = (Integer)map.get((Object)kanji2);
                return n2 - n;
            }
        });
        return arrayList;
    }

    private List<Kanji> shuffleEqualLongNotTestedKanjis(List<Kanji> list, Map<Kanji, Integer> map) {
        ArrayList arrayList = new ArrayList();
        ArrayList<Kanji> arrayList2 = new ArrayList<Kanji>();
        int n = -1;
        for (Kanji object : list) {
            int n2 = map.get((Object)object);
            if (n2 != n) {
                if (!arrayList2.isEmpty()) {
                    arrayList.add(arrayList2);
                    arrayList2 = new ArrayList();
                }
                n = n2;
            }
            arrayList2.add(object);
        }
        if (!arrayList2.isEmpty()) {
            arrayList.add(arrayList2);
        }
        for (List list2 : arrayList) {
            Collections.shuffle(list2);
        }
        ArrayList arrayList3 = new ArrayList();
        for (List list3 : arrayList) {
            arrayList3.addAll(list3);
        }
        return arrayList3;
    }

    private void useMostSeldomTestedNKanji() {
        int n;
        this.kanjiToTest = new ArrayList<Kanji>();
        List<Kanji> list = this.createKanjiListSortedByNumberTested();
        int n2 = list.size();
        for (int i = n = Math.max(0, n2 - this.numberOfKanjiToTest); i <= n2 - 1; ++i) {
            Kanji kanji = list.get(i);
            this.kanjiToTest.add(kanji);
        }
        if (!this.useOriginalKanjiOrder) {
            Collections.shuffle(this.kanjiToTest);
        }
        this.kanjiToTestDescription = "die " + this.numberOfKanjiToTest + " am seltesten abgefragten Kanji";
    }

    private List<Kanji> createKanjiListSortedByNumberTested() {
        ArrayList<Kanji> arrayList = new ArrayList<Kanji>();
        arrayList.addAll(this.kanjiList);
        Collections.sort(arrayList, new Comparator<Kanji>(){

            @Override
            public int compare(Kanji kanji, Kanji kanji2) {
                InternalKanjiDataRequester internalKanjiDataRequester = KanjiTesterLogic.this.dataStructures.getInternalKanjiDataRequester();
                InternalAdditionalKanjiData internalAdditionalKanjiData = internalKanjiDataRequester.getInternalDataForKanji(kanji);
                InternalAdditionalKanjiData internalAdditionalKanjiData2 = internalKanjiDataRequester.getInternalDataForKanji(kanji2);
                int n = internalAdditionalKanjiData.getTestCount();
                int n2 = internalAdditionalKanjiData2.getTestCount();
                return n2 - n;
            }
        });
        return arrayList;
    }

    private void startRealTest() {
        Options options = this.dataStructures.getOptions();
        Point point = options.isShowKanjiTestAtParameterDialogPosition() ? this.uiObjects.getGuiLocation() : this.chooserLocation;
        KanjiTester kanjiTester = new KanjiTester(this.kanjiToTest, this.kanjiToTestDescription, this.germanMeaningCaseSensitivity, this.onLesungCaseSensitivity, this.kunLesungCaseSensitivity, this.dataStructures, this.uiObjects, point);
        kanjiTester.setVisible(true);
    }
}

