/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.translation;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GermanToJapaneseTranslation {
    private static final boolean PRINT_MULTIPLE_VOCABLE_GERMAN_TERMS = false;
    private final List<Vocabulary> vocabularies;
    private final Map<String, List<Vocable>> vocablesByGermanTerms;

    public GermanToJapaneseTranslation(List<Vocabulary> list) {
        this.vocabularies = list;
        this.vocablesByGermanTerms = new HashMap<String, List<Vocable>>();
        this.fillHash();
        this.printMultipleVocableGermanTerms();
    }

    private void fillHash() {
        for (Vocabulary vocabulary : this.vocabularies) {
            this.fillHashForVocabulary(vocabulary);
        }
    }

    private void fillHashForVocabulary(Vocabulary vocabulary) {
        for (Vocable vocable : vocabulary.getVocables()) {
            this.fillHashForVocable(vocable);
        }
    }

    private void fillHashForVocable(Vocable vocable) {
        for (String string : vocable.getTranslations()) {
            List<Vocable> list;
            if (!this.vocablesByGermanTerms.containsKey(string)) {
                this.vocablesByGermanTerms.put(string, new ArrayList());
            }
            if ((list = this.vocablesByGermanTerms.get(string)).contains(vocable)) continue;
            list.add(vocable);
        }
    }

    private void printMultipleVocableGermanTerms() {
    }

    private void reallyPrintMultipleVocableGermanTerms() {
        System.out.println("Alle \u00dcbersetzungen, die zu mehr als einer Vokabel passen:");
        List<String> list = CollectionsHelper.getSortedMapStringIndices(this.vocablesByGermanTerms);
        for (String string : list) {
            List<Vocable> list2 = this.vocablesByGermanTerms.get(string);
            if (list2.size() <= 1) continue;
            System.out.print(string);
            for (Vocable vocable : list2) {
                System.out.print(" - " + vocable.getKanji() + " " + vocable.getKana() + " " + vocable.getTranslations().get(0));
            }
            System.out.println();
        }
    }

    public List<Vocable> getMatchingVocablesForGermanTerm(String string) {
        if (this.vocablesByGermanTerms.containsKey(string)) {
            return this.vocablesByGermanTerms.get(string);
        }
        throw new RuntimeException("Zum deutschen Begriff '" + string + "' ist keine zugeh\u00f6rige Vokabel bekannt.");
    }
}

