/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.startup.logic.steps;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.KanjiSet;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.io.AllKanjiSetsReader;
import de.duehl.vocabulary.japanese.startup.logic.steps.StartupStep;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Step13LoadKanjiSets
extends StartupStep {
    private List<KanjiSet> kanjiSets;

    public Step13LoadKanjiSets(String string, Options options, SplashScreenable splashScreenable, StopWatch stopWatch) {
        super(string, options, splashScreenable, stopWatch);
    }

    @Override
    protected void runInternalStep() {
        this.loadKanjiSets();
        this.checkIfKanjiAreInMultipleKanjiSetsOfSameGroup();
    }

    private void loadKanjiSets() {
        this.appendMessage("Lade die benutzerdefinierten Kanji-Mengen ...");
        this.kanjiSets = AllKanjiSetsReader.read();
    }

    private void checkIfKanjiAreInMultipleKanjiSetsOfSameGroup() {
        Map<String, List<KanjiSet>> map = this.createKanjiSetsByGroup();
        for (String string : CollectionsHelper.getSortedMapStringIndices(map)) {
            List<KanjiSet> list = map.get(string);
            this.checkIfKanjiAreInMultipleKanjiSetsOfSameGroup(list);
        }
    }

    private Map<String, List<KanjiSet>> createKanjiSetsByGroup() {
        HashMap<String, List<KanjiSet>> hashMap = new HashMap<String, List<KanjiSet>>();
        for (KanjiSet kanjiSet : this.kanjiSets) {
            String string = kanjiSet.getGroup();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new ArrayList());
            }
            List list = (List)hashMap.get(string);
            list.add(kanjiSet);
        }
        return hashMap;
    }

    private void checkIfKanjiAreInMultipleKanjiSetsOfSameGroup(List<KanjiSet> list) {
        Map<Kanji, List<String>> map = this.createNamesByKanji(list);
        for (Kanji kanji : map.keySet()) {
            List<String> list2 = map.get((Object)kanji);
            if (list2.size() <= 1) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("Das Kanji \u300c" + kanji.getCharacter() + "\u300d ist in mehr als einer Kanji-Menge der gleichen Gruppe enthalten:");
            for (String string : list2) {
                arrayList.add("    in Kanji-Menge '" + string + "'");
            }
            String string = Text.joinWithLineBreak(arrayList);
            this.appendMessage(string);
            this.warningsInStep(string);
        }
    }

    private Map<Kanji, List<String>> createNamesByKanji(List<KanjiSet> list) {
        HashMap<Kanji, List<String>> hashMap = new HashMap<Kanji, List<String>>();
        for (KanjiSet kanjiSet : list) {
            for (Kanji kanji : kanjiSet.getSet()) {
                if (!hashMap.containsKey((Object)kanji)) {
                    hashMap.put(kanji, new ArrayList());
                }
                List list2 = (List)hashMap.get((Object)kanji);
                list2.add(kanjiSet.getName());
            }
        }
        return hashMap;
    }

    public List<KanjiSet> getKanjiSets() {
        return this.kanjiSets;
    }
}

