/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.components.display;

import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.persistence.RomajiAndPronunciationColorOptions;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.ui.components.text.RomajiAndPronunciationTextCreator;
import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class RomajiAndPronunciationDisplay {
    private static final int FONT_SIZE_BASE = 24;
    private final Vocable vocable;
    private final JTextPane romajiAndPronunciationPane;
    private final Color backgroundColor;
    private final RomajiAndPronunciationColorOptions options;
    private Style regularStyle;
    private Style romajiStyle;
    private Style pronunciationStyle;
    private boolean showRomaji;
    private boolean showPronunciation;

    public RomajiAndPronunciationDisplay(Vocable vocable, JTextPane jTextPane, Color color, RomajiAndPronunciationColorOptions romajiAndPronunciationColorOptions) {
        this.vocable = vocable;
        this.romajiAndPronunciationPane = jTextPane;
        this.backgroundColor = color;
        this.options = romajiAndPronunciationColorOptions;
        this.showRomaji = true;
        this.showPronunciation = true;
    }

    public void hideRomaji() {
        this.showRomaji = false;
    }

    public void hidePronunciation() {
        this.showPronunciation = false;
    }

    public void display() {
        this.initTextPane();
        this.createStyles();
        this.clearContent();
        this.fillWithNewText();
    }

    private void initTextPane() {
        this.romajiAndPronunciationPane.setEditable(false);
        GuiTools.respectTextPaneBackgroundInNimbusLookAndFeel(this.romajiAndPronunciationPane);
        this.romajiAndPronunciationPane.setBackground(this.backgroundColor);
    }

    private void createStyles() {
        StyledDocument styledDocument = this.romajiAndPronunciationPane.getStyledDocument();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        this.regularStyle = styledDocument.addStyle("regular", style);
        StyleConstants.setForeground(this.regularStyle, this.options.getVocableColorStandard());
        StyleConstants.setBackground(this.regularStyle, this.backgroundColor);
        StyleConstants.setFontSize(this.regularStyle, 24);
        StyleConstants.setSpaceAbove(this.regularStyle, 1.0f);
        StyleConstants.setSpaceBelow(this.regularStyle, 1.0f);
        StyleConstants.setLeftIndent(this.regularStyle, 16.0f);
        StyleConstants.setRightIndent(this.regularStyle, 16.0f);
        StyleConstants.setFirstLineIndent(this.regularStyle, 16.0f);
        StyleConstants.setFontFamily(this.regularStyle, "serif");
        StyleConstants.setAlignment(this.regularStyle, 0);
        this.romajiStyle = styledDocument.addStyle("romaji", this.regularStyle);
        StyleConstants.setForeground(this.romajiStyle, this.options.getVocableColorRomaji());
        StyleConstants.setBackground(this.romajiStyle, this.backgroundColor);
        StyleConstants.setFontSize(this.romajiStyle, 28);
        StyleConstants.setBold(this.romajiStyle, true);
        this.pronunciationStyle = styledDocument.addStyle("pronunciation", this.regularStyle);
        StyleConstants.setForeground(this.pronunciationStyle, this.options.getVocableColorPronunciation());
        StyleConstants.setBackground(this.pronunciationStyle, this.backgroundColor);
    }

    private void clearContent() {
        try {
            StyledDocument styledDocument = this.romajiAndPronunciationPane.getStyledDocument();
            styledDocument.remove(0, styledDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Probleme beim L\u00f6schen des Inhaltes des Dokument.", badLocationException);
        }
    }

    private void fillWithNewText() {
        try {
            this.tryToFillWithNewText();
        }
        catch (Exception exception) {
            throw new RuntimeException("Probleme beim Einf\u00fcgen eines Stils ins Dokument.", exception);
        }
    }

    private void tryToFillWithNewText() throws BadLocationException {
        boolean bl;
        RomajiAndPronunciationTextCreator romajiAndPronunciationTextCreator = new RomajiAndPronunciationTextCreator(this.vocable, this.showRomaji, this.showPronunciation);
        romajiAndPronunciationTextCreator.create();
        String string = romajiAndPronunciationTextCreator.getFirstTextPart();
        String string2 = romajiAndPronunciationTextCreator.getTextPartInBrace();
        boolean bl2 = romajiAndPronunciationTextCreator.isBraceInOwnLine();
        StyledDocument styledDocument = this.romajiAndPronunciationPane.getStyledDocument();
        boolean bl3 = !string.isBlank();
        boolean bl4 = !string2.isBlank();
        boolean bl5 = bl = !string.isBlank() && !string2.isBlank();
        if (bl3) {
            styledDocument.insertString(styledDocument.getLength(), string, this.romajiStyle);
        }
        if (bl) {
            if (bl2) {
                styledDocument.insertString(styledDocument.getLength(), "\n", this.regularStyle);
            } else {
                styledDocument.insertString(styledDocument.getLength(), " ", this.regularStyle);
            }
            styledDocument.insertString(styledDocument.getLength(), "(", this.regularStyle);
        }
        if (bl4) {
            styledDocument.insertString(styledDocument.getLength(), "\"", this.regularStyle);
            styledDocument.insertString(styledDocument.getLength(), string2, this.pronunciationStyle);
            styledDocument.insertString(styledDocument.getLength(), "\"", this.regularStyle);
        }
        if (bl) {
            styledDocument.insertString(styledDocument.getLength(), ")", this.regularStyle);
        }
    }
}

