/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.grammar.options;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.additional.LocationGetter;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.grammar.headers.GrammarTableHeaderEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class GrammarTableOptionsPanel {
    private final Options options;
    private final LocationGetter locationGetter;
    private final FumikoUiObjects uiObjects;
    private JPanel panel;
    private final JCheckBox showKanjiCheckBox;
    private final JCheckBox showKanaCheckBox;
    private final JCheckBox showRomajiCheckBox;
    private final JCheckBox searchForBaseFormsCheckBox;
    private final JCheckBox leaveNotFoundFormsBlankCheckBox;
    private final JCheckBox useUserHeadersCheckBox;

    public GrammarTableOptionsPanel(Options options, LocationGetter locationGetter, FumikoUiObjects fumikoUiObjects) {
        this.options = options;
        this.locationGetter = locationGetter;
        this.uiObjects = fumikoUiObjects;
        this.panel = new JPanel();
        this.showKanjiCheckBox = new JCheckBox("Kanji anzeigen");
        this.showKanaCheckBox = new JCheckBox("Kana anzeigen");
        this.showRomajiCheckBox = new JCheckBox("Romaji anzeigen");
        this.searchForBaseFormsCheckBox = new JCheckBox("Nach W\u00f6rterbuchformen / Grundformen suchen");
        this.leaveNotFoundFormsBlankCheckBox = new JCheckBox("Nicht gefundene Formen bleiben in der Tabelle leer");
        this.useUserHeadersCheckBox = new JCheckBox("Die vom Benutzer eingegebenen \u00dcberschriften verwenden.");
        this.init();
        this.fillPanel();
    }

    private void init() {
        this.initPanel();
        this.initOptionsCheckBoxesFromOptions();
    }

    private void initPanel() {
        this.panel.setLayout(new BorderLayout());
    }

    private void initOptionsCheckBoxesFromOptions() {
        this.showKanjiCheckBox.setSelected(this.options.isGrammarTableShowKanji());
        this.showKanaCheckBox.setSelected(this.options.isGrammarTableShowKana());
        this.showRomajiCheckBox.setSelected(this.options.isGrammarTableShowRomaji());
        this.searchForBaseFormsCheckBox.setSelected(this.options.isGrammarTableSearchForBaseForms());
        this.leaveNotFoundFormsBlankCheckBox.setSelected(this.options.isGrammarTableLeaveNotFoundFormsBlank());
        this.useUserHeadersCheckBox.setSelected(this.options.isGrammarTableUseUserHeaders());
    }

    private void fillPanel() {
        this.panel.add(this.createOptionsSelectionPart(), "Center");
        this.panel.add(this.createChangeHeadersPart(), "South");
    }

    private Component createOptionsSelectionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Optionen zur Tabellenerstellung", jPanel);
        jPanel.add(this.showKanjiCheckBox);
        jPanel.add(this.showKanaCheckBox);
        jPanel.add(this.showRomajiCheckBox);
        jPanel.add(this.searchForBaseFormsCheckBox);
        jPanel.add(this.leaveNotFoundFormsBlankCheckBox);
        jPanel.add(this.useUserHeadersCheckBox);
        return jPanel;
    }

    private Component createChangeHeadersPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createEditGrammarTableHeadersButton(), "Center");
        return jPanel;
    }

    private Component createEditGrammarTableHeadersButton() {
        JButton jButton = new JButton("\u00dcberschriften der Grammatik-Tabellen bearbeiten");
        jButton.addActionListener(actionEvent -> this.editGrammarTableHeaders());
        return jButton;
    }

    private void editGrammarTableHeaders() {
        GrammarTableHeaderEditor grammarTableHeaderEditor = new GrammarTableHeaderEditor(this.options, this.locationGetter.getLocation(), this.uiObjects);
        grammarTableHeaderEditor.setVisible(true);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void storeIntoOptions() {
        boolean bl = this.showKanjiCheckBox.isSelected();
        boolean bl2 = this.showKanaCheckBox.isSelected();
        boolean bl3 = this.showRomajiCheckBox.isSelected();
        boolean bl4 = this.searchForBaseFormsCheckBox.isSelected();
        boolean bl5 = this.leaveNotFoundFormsBlankCheckBox.isSelected();
        boolean bl6 = this.useUserHeadersCheckBox.isSelected();
        this.options.setGrammarTableShowKanji(bl);
        this.options.setGrammarTableShowKana(bl2);
        this.options.setGrammarTableShowRomaji(bl3);
        this.options.setGrammarTableSearchForBaseForms(bl4);
        this.options.setGrammarTableLeaveNotFoundFormsBlank(bl5);
        this.options.setGrammarTableUseUserHeaders(bl6);
    }
}

