/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kanji.table.components;

import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.lister.VocabularyListerDialog;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class AllVocablesWithKanjiShower {
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final LongTimeProcessInformer informer;
    private final Point parentLocation;

    public AllVocablesWithKanjiShower(FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, Point point, LongTimeProcessInformer longTimeProcessInformer) {
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.parentLocation = point;
        this.informer = longTimeProcessInformer;
    }

    public void showKanji(Kanji kanji) {
        List<Vocable> list = this.determineVocablesWithKanji(kanji);
        if (!list.isEmpty()) {
            VocabularyListerDialog vocabularyListerDialog = new VocabularyListerDialog(list, "Vokabeln mit Kanji " + kanji.getCharacter(), this.dataStructures, this.uiObjects, this.parentLocation, this.informer);
            vocabularyListerDialog.setVisible(true);
        }
    }

    private List<Vocable> determineVocablesWithKanji(Kanji kanji) {
        String string = kanji.getCharacter();
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        List<Vocabulary> list = this.dataStructures.getVocabularies();
        for (Vocabulary vocabulary : list) {
            for (Vocable vocable : vocabulary.getVocables()) {
                if (!vocable.getKanji().contains(string)) continue;
                arrayList.add(vocable);
            }
        }
        return arrayList;
    }
}

