/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.options;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import de.duehl.basics.text.html.HtmlTool;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.DirSelection;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.elements.sidelist.SideListOrganiserPanel;
import de.duehl.swing.ui.elements.size.ChangeButtonWithSizeChooser;
import de.duehl.swing.ui.elements.size.SizeChooser;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.VocabularyTrainerVersion;
import de.duehl.vocabulary.japanese.common.color.VocableColors;
import de.duehl.vocabulary.japanese.common.data.VocablesShuffleType;
import de.duehl.vocabulary.japanese.common.data.VocablesSubsetSelectionType;
import de.duehl.vocabulary.japanese.common.data.VocabularySortOrder;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.common.persistence.data.EmptyTranslationsAcceptance;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.grammar.options.GrammarTableOptionsPanel;
import de.duehl.vocabulary.japanese.ui.dialog.options.colors.eleven.ElevenColorsOptionsUi;
import de.duehl.vocabulary.japanese.ui.dialog.options.colors.vocable.VocableColorsOptionsUi;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class OptionsDialog
extends ModalDialogBase {
    private static final Dimension DILOG_DIMENSION = new Dimension(1000, 800);
    private final Options options;
    private final DirSelection vocabulariesPathSelection;
    private final JCheckBox switchToNextVocableAfterEntringTranslationCheckBox;
    private final JCheckBox showKanaWhenTestingVocableCheckBox;
    private final JCheckBox showKanjiWhenTestingVocableCheckBox;
    private final JCheckBox hideKanjiWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox;
    private final JCheckBox showRomajiWhenTestingVocableCheckBox;
    private final JCheckBox hideRomajiWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox;
    private final JCheckBox showPronunciationWhenTestingVocableCheckBox;
    private final JCheckBox hidePronunciationWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox;
    private final JCheckBox showCommentWhenTestingVocableCheckBox;
    private final JCheckBox showVocabularyDescriptionWhenTestingVocableCheckBox;
    private final JCheckBox colorVocableDependingOnLastSuccessWhenTestingVocableCheckBox;
    private final JCheckBox colorVocableDependingOnLastSuccessWhenViewingVocableCheckBox;
    private final JCheckBox colorVocabularyDependingOnLastSuccessCheckBox;
    private final JCheckBox hideStartOfVocabularyDescriptionCheckBox;
    private final JCheckBox useTestOrderForViewingVocablesCheckBox;
    private final JCheckBox useOnlyFirstGermanTermTestingCheckBox;
    private final List<VocabularySortOrder> vocabularySortOrders;
    private final List<JRadioButton> vocabularySortOrderRadioButtons;
    private final List<VocablesShuffleType> vocablesShuffleTypes;
    private final List<JRadioButton> vocablesShuffleTypesRadioButtons;
    private final JCheckBox reverseShuffledVocablesCheckBox;
    private final JCheckBox useVocablesShuffleTypeForShowingListsAndSheetsTooCheckBox;
    private final List<VocablesSubsetSelectionType> vocablesSubsetSelectionTypes;
    private final List<JRadioButton> vocablesSubsetSelectionTypesRadioButtons;
    private final JCheckBox showSuccessPercentInVocabularyBarCheckBox;
    private final ChangeButtonWithSizeChooser numberOfVocabularyBarColumnsChooser;
    private final JCheckBox hideVocablesFromListInSearchAreaInOwnListEditorCheckBox;
    private final ChangeButtonWithSizeChooser numberOfColumnsOfBlattDarstellungChooser;
    private final JCheckBox allowMissingMp3CheckBox;
    private final JCheckBox reportMissingMp3CheckBox;
    private final JCheckBox informAboutDoubleMp3AtStartupCheckBox;
    private final JCheckBox informAboutEqualKanaAndKanjiAtStartupCheckBox;
    private final JCheckBox showDetailsButtonInEinzeldarstellungCheckBox;
    private final JCheckBox showDetailsButtonInVokabelblattDarstellungCheckBox;
    private final JCheckBox hideLessStartOfVocabularyDescriptionForVhsCheckBox;
    private final JCheckBox checkNewOwnListsVersionAtStartCheckBox;
    private final JCheckBox showKanaInKanjiSizeWhenTestingVocableCheckBox;
    private final List<EmptyTranslationsAcceptance> emptyTranslationsAcceptances;
    private final List<JRadioButton> emptyTranslationsAcceptancesRadioButtons;
    private final JButton numberOfDaysForAWhileButton;
    private final JButton numberOfDaysAVocableIsNewButton;
    private int numberOfDaysForAWhile;
    private int numberOfDaysAVocableIsNew;
    private final ElevenColorsOptionsUi elevenColorsUi;
    private final VocableColorsOptionsUi vocablesColorsUi;
    private final JCheckBox useSplitPaneInOwnListEditorCheckBox;
    private final JCheckBox showTimestampsInStartupCheckBox;
    private final JCheckBox createGermanJapaneseTranslationAtStartupCheckBox;
    private final JCheckBox informAboutEOrUInVocableFieldAusspracheAtStartupCheckBox;
    private int numberOfRememberedOwnLists;
    private final JButton numberOfRememberedOwnListsButton;
    private final JCheckBox showAllTranslationsCheckBox;
    private int numberOfShownTranslations;
    private final JButton numberOfShownTranslationsButton;
    private final JCheckBox showNumberOfListsInListerCheckBox;
    private final JCheckBox showDetailBottomButonsInEinzeldarstellungTooCheckBox;
    private final JCheckBox showDetailBottomButonsInTranslationEvaluationTooCheckBox;
    private final JCheckBox playMP3WhenTestingVocablesCheckBox;
    private final JCheckBox colorUserInputAtKanjiTestEvaluationDialogCheckBox;
    private final JCheckBox stopAfterStartupCheckBox;
    private final JCheckBox waitForXAfterStartupCheckBox;
    private final JCheckBox closeSingleViewWhenOpeningDetailsAfterSimpleSearchCheckBox;
    private final JCheckBox showWarningsAfterStartCheckBox;
    private final JCheckBox showKanjiTestAtParameterDialogPositionCheckBox;
    private final JCheckBox showKanjiNumberInMyHandwrittenKanjiNotebooksCheckBox;
    private final GrammarTableOptionsPanel grammarOptionsPanel;
    private boolean showOnlyOwnListDialogOptions;
    private boolean applied;
    private final SideListOrganiserPanel sideListOrganiser;

    public OptionsDialog(Options options, Point point, FumikoUiObjects fumikoUiObjects) {
        super(point, fumikoUiObjects.getProgramImage(), "Optionen", DILOG_DIMENSION);
        this.options = options;
        this.vocabulariesPathSelection = new DirSelection("Der Pfad zu den Vokabularien und den Sound-Files:");
        this.switchToNextVocableAfterEntringTranslationCheckBox = new JCheckBox(this.breakLongText("Nach der Eingabe der \u00dcbersetzung wird gleich zur n\u00e4chsten Vokabel gesprungen."));
        this.showKanaWhenTestingVocableCheckBox = new JCheckBox(this.breakLongText("Beim Abfragen der Vokabeln wird die Darstellung in Kana mit angezeigt."));
        this.showKanjiWhenTestingVocableCheckBox = new JCheckBox(this.breakLongText("Beim Abfragen der Vokabeln wird die Darstellung in Kanji mit angezeigt."));
        this.hideKanjiWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox = new JCheckBox(this.breakLongText("Beim Abfragen von reinen Hiragana-Vokabeln wird die Darstellung in Kanji versteckt."));
        this.showRomajiWhenTestingVocableCheckBox = new JCheckBox(this.breakLongText("Beim Abfragen der Vokabeln wird die Darstellung in Romaji mit angezeigt."));
        this.hideRomajiWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox = new JCheckBox(this.breakLongText("Beim Abfragen von reinen Hiragana-Vokabeln wird die Darstellung in Romaji versteckt."));
        this.showPronunciationWhenTestingVocableCheckBox = new JCheckBox(this.breakLongText("Beim Abfragen der Vokabeln wird die Aussprache mit angezeigt."));
        this.hidePronunciationWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox = new JCheckBox(this.breakLongText("Beim Abfragen von reinen Hiragana-Vokabeln wird die Aussprache versteckt."));
        this.showCommentWhenTestingVocableCheckBox = new JCheckBox(this.breakLongText("Beim Abfragen der Vokabeln wird der Kommentar mit angezeigt."));
        this.showVocabularyDescriptionWhenTestingVocableCheckBox = new JCheckBox(this.breakLongText("Beim Abfragen der Vokabeln wird die Beschreibung des Vokabulars mit angezeigt."));
        this.colorVocableDependingOnLastSuccessWhenTestingVocableCheckBox = new JCheckBox(this.breakLongText("Beim Abfragen der Vokabeln wird die Darstellung abh\u00e4ngig vom Erfolg bei den letzten zehn Abfragen eingef\u00e4rbt."));
        this.colorVocableDependingOnLastSuccessWhenViewingVocableCheckBox = new JCheckBox(this.breakLongText("Beim Anzeigen der Vokabeln wird die Darstellung abh\u00e4ngig vom Erfolg bei den letzten zehn Abfragen eingef\u00e4rbt."));
        this.colorVocabularyDependingOnLastSuccessCheckBox = new JCheckBox(this.breakLongText("Die Darstellung der angezeigten Vokabularien wird abh\u00e4ngig vom Erfolg bei den letzten zehn Abfragen eingef\u00e4rbt."));
        this.hideStartOfVocabularyDescriptionCheckBox = new JCheckBox(this.breakLongText("Der Anfang der Beschreibung der Vokabularien (\"B1_K4_1_\" oder \"X_\") wird ausgeblendet."));
        this.useTestOrderForViewingVocablesCheckBox = new JCheckBox(this.breakLongText("Zum Betrachten der Vokabeln wird die Reihenfolge zum Abfragen verwendet."));
        this.allowMissingMp3CheckBox = new JCheckBox(this.breakLongText("Das Programm wird auch trotz fehlender MP3-Dateien gestartet."));
        this.reportMissingMp3CheckBox = new JCheckBox(this.breakLongText("Das Programm weist beim Start auf fehlende MP3-Dateien hin."));
        this.informAboutDoubleMp3AtStartupCheckBox = new JCheckBox(this.breakLongText("Beim Start des Programms soll \u00fcber doppelte MP3-Dateien mit dem gleichen Namen informiert werden."));
        this.informAboutEqualKanaAndKanjiAtStartupCheckBox = new JCheckBox(this.breakLongText("Beim Start des Programms soll \u00fcber gleiche Kana und Kanji informiert werden."));
        this.useOnlyFirstGermanTermTestingCheckBox = new JCheckBox(this.breakLongText("Bei der \u00dcbersetzung von Deutsch nach Japanisch wird nur der erste (statt einem zuf\u00e4lligen) deutsche Begriff, welcher in der Vokabel hinterlegt ist, abgefragt."));
        this.vocabularySortOrders = new ArrayList<VocabularySortOrder>();
        this.vocabularySortOrderRadioButtons = new ArrayList<JRadioButton>();
        this.vocablesShuffleTypes = new ArrayList<VocablesShuffleType>();
        this.vocablesShuffleTypesRadioButtons = new ArrayList<JRadioButton>();
        this.reverseShuffledVocablesCheckBox = new JCheckBox(this.breakLongText("Die unten festgelegte Sortierung von Vokabellisten wird umgedreht."));
        this.useVocablesShuffleTypeForShowingListsAndSheetsTooCheckBox = new JCheckBox(this.breakLongText("Die Sortierung von Vokabellisten wird auch zum Anzeigen der Listen oder Bl\u00e4tter verwendet."));
        this.vocablesSubsetSelectionTypes = new ArrayList<VocablesSubsetSelectionType>();
        this.vocablesSubsetSelectionTypesRadioButtons = new ArrayList<JRadioButton>();
        this.showSuccessPercentInVocabularyBarCheckBox = new JCheckBox(this.breakLongText("Der Erfolg bei den letzten zehn Abfragen der Vokabeln eines Vokabulars wird als Prozentzahl mit angezeigt."));
        this.numberOfVocabularyBarColumnsChooser = this.createNumberOfVocabularyBarColumnsChooser();
        this.numberOfColumnsOfBlattDarstellungChooser = this.createNumberOfColumnsOfBlattDarstellungChooser();
        this.hideVocablesFromListInSearchAreaInOwnListEditorCheckBox = new JCheckBox(this.breakLongText("Vokabeln aus der Liste rechts im Suchbereich werden versteckt. Falls nicht, werden sie nur anders dargestellt."));
        this.showDetailsButtonInEinzeldarstellungCheckBox = new JCheckBox(this.breakLongText("Der Button zum Anzeigen der Details wird in der Einzeldarstellung angezeigt."));
        this.showDetailsButtonInVokabelblattDarstellungCheckBox = new JCheckBox(this.breakLongText("Der Button zum Anzeigen der Details wird in der Darstellung als Vokabelblatt angezeigt."));
        this.hideLessStartOfVocabularyDescriptionForVhsCheckBox = new JCheckBox(this.breakLongText("Bei Vokabularien und Listen aus der VHS wird weniger vom Anfang der Beschreibung der Vokabularien ausgeblendet"));
        this.checkNewOwnListsVersionAtStartCheckBox = new JCheckBox(this.breakLongText("Auf neuere Version der eigenen Listen pr\u00fcfen."));
        this.showKanaInKanjiSizeWhenTestingVocableCheckBox = new JCheckBox(this.breakLongText("Stellt die Kana, wenn auch Kanji dargestellt werden, genauso gro\u00df wie die Kanji dar."));
        this.emptyTranslationsAcceptances = new ArrayList<EmptyTranslationsAcceptance>();
        this.emptyTranslationsAcceptancesRadioButtons = new ArrayList<JRadioButton>();
        this.sideListOrganiser = new SideListOrganiserPanel();
        this.numberOfDaysForAWhileButton = new JButton();
        this.numberOfDaysAVocableIsNewButton = new JButton();
        this.elevenColorsUi = new ElevenColorsOptionsUi(new VocableColors(options));
        this.vocablesColorsUi = new VocableColorsOptionsUi();
        this.useSplitPaneInOwnListEditorCheckBox = new JCheckBox(this.breakLongText("Einen variablen Trenner zwischen dem linken und rechten Teil verwenden."));
        this.showTimestampsInStartupCheckBox = new JCheckBox(this.breakLongText("Beim Startup wird die bis zu diesem Schritt bereits ben\u00f6tigte Laufzeit vor den Meldungen ausgegeben (das ist nat\u00fcrlich erst beim n\u00e4chsten Start des Programms wirksam)."));
        this.createGermanJapaneseTranslationAtStartupCheckBox = new JCheckBox(this.breakLongText("Das Verzeichnis f\u00fcr die \u00dcbersetzung Deutsch nach Japanisch wird beim Start aufgebaut. Dies dauert einige Zeit, die der Start l\u00e4nger dauert. Im anderen Fall wird dieses Verzeichnis erst aufgebaut, wenn es das erste Mal ben\u00f6tigt wird, also wenn die erste Vokabel von Deutsch nach Japanisch \u00fcbersetzt wird. \u00dcbersetzt man oft auch von Deutsch nach Japanisch, sollte man es beim Startup erzeugen, anderenfalls ist es besser, es erst dann zu erzeugen, wenn man es braucht, weil man es meistens nicht braucht und so der Vokabel-Trainer schneller startet."));
        this.informAboutEOrUInVocableFieldAusspracheAtStartupCheckBox = new JCheckBox(this.breakLongText("Beim Start wird gepr\u00fcft, ob \"e\" oder \"u\" in der Aussprache der Vokabeln vorkommt."));
        this.numberOfRememberedOwnListsButton = new JButton();
        this.showAllTranslationsCheckBox = new JCheckBox(this.breakLongText("Alle \u00dcbersetzungen anzeigen"));
        this.numberOfShownTranslationsButton = new JButton();
        this.showNumberOfListsInListerCheckBox = new JCheckBox(this.breakLongText("Die Anzahl der Listen, in der die Vokabel ist, wird zusammen mit einem Hinweis auf Lernlisten in der Listendarstellung eines Vokabulars oder einer eigenen Liste angezeigt."));
        this.showDetailBottomButonsInEinzeldarstellungTooCheckBox = new JCheckBox(this.breakLongText("Die Buttons zum Anzeigen der eigenen Listen, welche die Vokabel enthalten, zum Hinzuf\u00fcgen der Vokabel zu einer eigenen Liste und ggf. dem Button zum Anzeigen der bekannten Verb- bzw. Adjektivformen, werden auch im Dialog mit der Einzeldarstellung angezeigt."));
        this.showDetailBottomButonsInTranslationEvaluationTooCheckBox = new JCheckBox(this.breakLongText("Die Buttons zum Anzeigen der eigenen Listen, welche die Vokabel enthalten, zum Hinzuf\u00fcgen der Vokabel zu einer eigenen Liste und ggf. dem Button zum Anzeigen der bekannten Verb- bzw. Adjektivformen, werden auch im Dialog mit der Bewertung einer einzelnen Abfrage einer Vokabel angezeigt."));
        this.playMP3WhenTestingVocablesCheckBox = new JCheckBox(this.breakLongText("Beim Abfragen Vokabeln automatisch vorlesen."));
        this.colorUserInputAtKanjiTestEvaluationDialogCheckBox = new JCheckBox(this.breakLongText("Beim Abfragen der Kanji werden die Felder der Benutzereingaben im Dialog, welcher Erfolg oder Misserfolg der Angaben zu einem einzelnen Kanji anzeigt, rot oder gr\u00fcn eingef\u00e4rbt."));
        this.stopAfterStartupCheckBox = new JCheckBox(this.breakLongText("Zwischen dem Startup und dem Start des Vokabeltrainers eine Best\u00e4tigung des Benutzers eingeholt werden."));
        this.waitForXAfterStartupCheckBox = new JCheckBox(this.breakLongText("Zwischen dem Startup und dem Start des Vokabeltrainers wird auf das Schlie\u00dfen am [X] durch den Benutzers gewartet, ohne einen Dialog anzuzeigen. Dadurch bleibt der Dialog offen, w\u00e4hrend sich der Trainer bereits \u00f6ffnet."));
        this.closeSingleViewWhenOpeningDetailsAfterSimpleSearchCheckBox = new JCheckBox(this.breakLongText("Die Einzelansicht wird geschlossen, sobald man die Details ansieht, und die Einzelansicht aus der einfachen Suche heraus ge\u00f6ffnet wurde."));
        this.showWarningsAfterStartCheckBox = new JCheckBox(this.breakLongText("Nach dem Start werden die Warnungen angezeigt, wenn welche aufgetreten sind."));
        this.showKanjiTestAtParameterDialogPositionCheckBox = new JCheckBox(this.breakLongText("Der Dialog zur Abfrage eines Kanji wird an der gleichen Stelle angezeigt wie der Dialog zur Abfrage der Parameter zuvor."));
        this.showKanjiNumberInMyHandwrittenKanjiNotebooksCheckBox = new JCheckBox(this.breakLongText("Zeigt die Nummer des Kanji in meinen handschriftlichen Heften im Dialog zur Darstellung der Details eines Kanji und der Kanji-Tabelle an"));
        this.grammarOptionsPanel = new GrammarTableOptionsPanel(options, () -> this.getLocation(), fumikoUiObjects);
        this.showOnlyOwnListDialogOptions = false;
        this.applied = false;
    }

    private String breakLongText(String string) {
        return HtmlTool.htmlify(string, 100);
    }

    private ChangeButtonWithSizeChooser createNumberOfVocabularyBarColumnsChooser() {
        int n = 2;
        int n2 = 3;
        List<Integer> list = CollectionsHelper.buildListFrom(1, 2, 3, 4, 5, 6);
        Point point = new Point(this.getLocation());
        point.x += 300;
        point.y += 200;
        ChangeButtonWithSizeChooser changeButtonWithSizeChooser = new ChangeButtonWithSizeChooser(point, "Anzahl der Spalten mit den Vokabularien", n, n2, list);
        changeButtonWithSizeChooser.setSize(this.options.getNumberOfVocabularyBarColumns());
        changeButtonWithSizeChooser.differentSizesAreOk();
        return changeButtonWithSizeChooser;
    }

    private ChangeButtonWithSizeChooser createNumberOfColumnsOfBlattDarstellungChooser() {
        int n = 2;
        int n2 = 2;
        List<Integer> list = CollectionsHelper.buildListFrom(1, 2, 3, 4);
        Point point = new Point(this.getLocation());
        point.x += 300;
        point.y += 200;
        ChangeButtonWithSizeChooser changeButtonWithSizeChooser = new ChangeButtonWithSizeChooser(point, "Anzahl der Spalten in der Darstellung als Vokabelblatt", n, n2, list);
        changeButtonWithSizeChooser.setSize(this.options.getNumberOfVocabularyBarColumns());
        changeButtonWithSizeChooser.differentSizesAreOk();
        return changeButtonWithSizeChooser;
    }

    public void showOnlyOwnListDialogOptions() {
        this.showOnlyOwnListDialogOptions = true;
    }

    public void populate() {
        this.fillDialog();
    }

    @Override
    protected void populateDialog() {
        this.initElements();
        if (this.showOnlyOwnListDialogOptions) {
            this.add(this.createOwnListEditorSelectionsPart(), "Center");
            this.add(this.createButtonsPartWithoutDefaultButton(), "South");
        } else {
            this.add(this.sideListOrganiser.getPanel(), "Center");
            this.add(this.createButtonsPart(), "South");
        }
        this.fillOptionValuesIntoGui(this.options);
        this.addActionListenersForEnableDisableOptions();
        this.enableOrDisableElements();
    }

    private void initElements() {
        this.initVocabularySortOrders();
        this.initVocablesShuffleTypes();
        this.initVocablesSubsetSelectionTypes();
        this.initEmptyTranslationsAcceptanceButtonGroup();
        this.initDaysButtons();
        this.initNumberOfRememberedOwnListsButton();
        this.initNumberOfShownTranslationsButton();
        this.initShowAllTranslationsCheckBox();
        this.initSideListOrganiser();
    }

    private void initVocabularySortOrders() {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (VocabularySortOrder vocabularySortOrder : VocabularySortOrder.values()) {
            this.vocabularySortOrders.add(vocabularySortOrder);
            JRadioButton jRadioButton = new JRadioButton(vocabularySortOrder.getDescription());
            buttonGroup.add(jRadioButton);
            this.vocabularySortOrderRadioButtons.add(jRadioButton);
        }
    }

    private void initVocablesShuffleTypes() {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (VocablesShuffleType vocablesShuffleType : VocablesShuffleType.values()) {
            this.vocablesShuffleTypes.add(vocablesShuffleType);
            JRadioButton jRadioButton = new JRadioButton(vocablesShuffleType.getDescription());
            buttonGroup.add(jRadioButton);
            this.vocablesShuffleTypesRadioButtons.add(jRadioButton);
        }
    }

    private void initVocablesSubsetSelectionTypes() {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (VocablesSubsetSelectionType vocablesSubsetSelectionType : VocablesSubsetSelectionType.values()) {
            this.vocablesSubsetSelectionTypes.add(vocablesSubsetSelectionType);
            JRadioButton jRadioButton = new JRadioButton(vocablesSubsetSelectionType.getDescription());
            buttonGroup.add(jRadioButton);
            this.vocablesSubsetSelectionTypesRadioButtons.add(jRadioButton);
        }
    }

    private void initEmptyTranslationsAcceptanceButtonGroup() {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (EmptyTranslationsAcceptance emptyTranslationsAcceptance : EmptyTranslationsAcceptance.values()) {
            this.emptyTranslationsAcceptances.add(emptyTranslationsAcceptance);
            JRadioButton jRadioButton = new JRadioButton(emptyTranslationsAcceptance.getOptionDescription());
            buttonGroup.add(jRadioButton);
            this.emptyTranslationsAcceptancesRadioButtons.add(jRadioButton);
        }
    }

    private void initDaysButtons() {
        this.numberOfDaysForAWhileButton.addActionListener(actionEvent -> this.changeNumberOfDaysForAWhile());
        this.numberOfDaysAVocableIsNewButton.addActionListener(actionEvent -> this.changeNumberOfDaysAVocableIsNew());
    }

    private void changeNumberOfDaysForAWhile() {
        String string = "Anzahl Tage f\u00fcr 'lange nicht mehr' abgefragte Vokabeln";
        int n = 3;
        int n2 = 5;
        List<Integer> list = CollectionsHelper.buildListFrom(14, 20, 25, 30, 31, 40, 45, 50, 60, 70, 75, 80, 90, 100, 120);
        int n3 = this.chooseSize(this.numberOfDaysForAWhile, string, n, n2, list);
        if (n3 != -1 && n3 >= 0 && n3 <= 1000) {
            this.numberOfDaysForAWhile = n3;
            this.setNumberOfDaysForAWhileButtonText();
        }
    }

    private void changeNumberOfDaysAVocableIsNew() {
        String string = "Anzahl Tage wie lange eine Vokabel als 'neu' gilt";
        int n = 3;
        int n2 = 5;
        List<Integer> list = CollectionsHelper.buildListFrom(1, 2, 5, 7, 10, 14, 20, 25, 30, 31, 40, 45, 50, 60, 70);
        int n3 = this.chooseSize(this.numberOfDaysAVocableIsNew, string, n, n2, list);
        if (n3 != -1 && n3 >= 0 && n3 <= 1000) {
            this.numberOfDaysAVocableIsNew = n3;
            this.setNumberOfDaysAVocableIsNewButtonText();
        }
    }

    private int chooseSize(int n, String string, int n2, int n3, List<Integer> list) {
        SizeChooser sizeChooser = new SizeChooser(n, string, n2, n3, list, this.getLocation(), null);
        sizeChooser.setSize(n);
        sizeChooser.diffenrentSizesAreOk();
        sizeChooser.setVisible(true);
        int n4 = sizeChooser.getSize();
        return n4;
    }

    private void initNumberOfRememberedOwnListsButton() {
        this.numberOfRememberedOwnListsButton.addActionListener(actionEvent -> this.changeNumberOfRememberedOwnLists());
    }

    private void changeNumberOfRememberedOwnLists() {
        String string = "Anzahl der im Listen-Commander angezeigten zuletzt besuchten Eigenen Listen";
        int n = 3;
        int n2 = 7;
        List<Integer> list = CollectionsHelper.buildListFrom(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 25, 30, 35);
        int n3 = this.chooseSize(this.numberOfRememberedOwnLists, string, n, n2, list);
        if (n3 != -1 && n3 >= 1 && n3 <= 100) {
            this.numberOfRememberedOwnLists = n3;
            this.setNumberOfRememberedOwnListsButtonText();
        }
    }

    private void initNumberOfShownTranslationsButton() {
        this.numberOfShownTranslationsButton.addActionListener(actionEvent -> this.changeNumberOfShownTranslations());
    }

    private void changeNumberOfShownTranslations() {
        String string = "Anzahl angezeigter \u00dcbersetzungen in der Einzeldarstellung und bei der Abfrage von Vokabeln";
        int n = 3;
        int n2 = 7;
        List<Integer> list = CollectionsHelper.buildListFrom(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 25, 30, 35);
        int n3 = this.chooseSize(this.numberOfShownTranslations, string, n, n2, list);
        if (n3 != -1 && n3 >= 1 && n3 <= 100) {
            this.numberOfShownTranslations = n3;
            this.setNumberOfShownTranslationsButtonText();
        }
    }

    private void initShowAllTranslationsCheckBox() {
        this.showAllTranslationsCheckBox.addActionListener(actionEvent -> this.showAllTranslationsChanged());
    }

    private void showAllTranslationsChanged() {
        this.numberOfShownTranslationsButton.setEnabled(!this.showAllTranslationsCheckBox.isSelected());
    }

    private void initSideListOrganiser() {
        this.sideListOrganiser.setListPanelWidth(300);
        this.sideListOrganiser.addElement("Pfade und Startoptionen", this.createPathesAndStartOptionsPanel());
        this.sideListOrganiser.addElement("Vokabeln anzeigen 1", this.createShowVocables1Panel());
        this.sideListOrganiser.addElement("Vokabeln anzeigen 2", this.createShowVocables2Panel());
        this.sideListOrganiser.addElement("Vokabeln abfragen 1", this.createTestVocable1Panel());
        this.sideListOrganiser.addElement("Vokabeln abfragen 2", this.createTestVocable2Panel());
        this.sideListOrganiser.addElement("Erfolg - Farben", this.createElevenColorsPanel());
        this.sideListOrganiser.addElement("Vokabularien", this.createVocabularyPanel());
        this.sideListOrganiser.addElement("Eigene Listen", this.createOwnListPanel());
        this.sideListOrganiser.addElement("Kanji anzeigen", this.createShowKanjiPanel());
        this.sideListOrganiser.addElement("Kanji abfragen", this.createTestKanjiPanel());
        this.sideListOrganiser.addElement("Grammatik-Tabellen", this.createGrammarTablePanel());
        this.sideListOrganiser.showFirstAddedContent();
    }

    private Component createPathesAndStartOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.createPathesSelectionPart());
        jPanel.add(this.createCheckNewVersionsAtStartPart());
        jPanel.add(this.createOtherThingsAtStartPart());
        return jPanel;
    }

    private Component createTestVocable1Panel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.createTestingOptionsSelectionPart());
        jPanel.add(this.createTestingJapaneseOptionsSelectionPart());
        jPanel.add(this.createTestingGermanOptionsSelectionPart());
        return jPanel;
    }

    private Component createTestVocable2Panel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.createVocablesShuffleTypesPart());
        jPanel.add(this.createVocablesSubsetSelectionTypesPart());
        jPanel.add(this.createEmptyTranslationsAcceptancesPart());
        jPanel.add(this.numberOfDaysForAWhileButton);
        jPanel.add(this.numberOfDaysAVocableIsNewButton);
        return jPanel;
    }

    private Component createShowVocables1Panel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.createViewingOptionsSelectionPart());
        jPanel.add(this.createTranslationsShownPart());
        jPanel.add(this.createBlattdarstellungSelectionsPart());
        return jPanel;
    }

    private Component createShowVocables2Panel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.createVocableColorsPart());
        return jPanel;
    }

    private Component createVocabularyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.createVocabularyPart());
        jPanel.add(this.createVocabularyBarSelectionsPart());
        return jPanel;
    }

    private Component createElevenColorsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.elevenColorsUi.getPanel());
        return jPanel;
    }

    private Component createOwnListPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.createOtherOwnListSelectionsPart());
        jPanel.add(this.createOwnListEditorSelectionsPart());
        return jPanel;
    }

    private void fillOptionValuesIntoGui(Options options) {
        this.vocabulariesPathSelection.setText(Text.nicePath(options.getVocabulariesPath()));
        this.switchToNextVocableAfterEntringTranslationCheckBox.setSelected(options.isSwitchToNextVocableAfterEntringTranslation());
        this.showKanaWhenTestingVocableCheckBox.setSelected(options.isShowKanaWhenTestingVocable());
        this.showKanjiWhenTestingVocableCheckBox.setSelected(options.isShowKanjiWhenTestingVocable());
        this.hideKanjiWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox.setSelected(options.isHideKanjiWhenTestingVocableAndKanaContainsOnlyHiragana());
        this.showRomajiWhenTestingVocableCheckBox.setSelected(options.isShowRomajiWhenTestingVocable());
        this.hideRomajiWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox.setSelected(options.isHideRomajiWhenTestingVocableAndKanaContainsOnlyHiragana());
        this.showPronunciationWhenTestingVocableCheckBox.setSelected(options.isShowPronunciationWhenTestingVocable());
        this.hidePronunciationWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox.setSelected(options.isHidePronunciationWhenTestingVocableAndKanaContainsOnlyHiragana());
        this.showCommentWhenTestingVocableCheckBox.setSelected(options.isShowCommentWhenTestingVocable());
        this.showVocabularyDescriptionWhenTestingVocableCheckBox.setSelected(options.isShowVocabularyDescriptionWhenTestingVocable());
        this.colorVocableDependingOnLastSuccessWhenTestingVocableCheckBox.setSelected(options.isColorVocableDependingOnLastSuccessWhenTestingVocable());
        this.colorVocableDependingOnLastSuccessWhenViewingVocableCheckBox.setSelected(options.isColorVocableDependingOnLastSuccessWhenViewingVocable());
        this.colorVocabularyDependingOnLastSuccessCheckBox.setSelected(options.isColorVocabularyDependingOnLastSuccess());
        this.hideStartOfVocabularyDescriptionCheckBox.setSelected(options.isHideStartOfVocabularyDescription());
        this.useTestOrderForViewingVocablesCheckBox.setSelected(options.isUseTestOrderForViewingVocables());
        this.allowMissingMp3CheckBox.setSelected(options.isAllowMissingMp3());
        this.reportMissingMp3CheckBox.setSelected(options.isReportMissingMp3());
        this.informAboutDoubleMp3AtStartupCheckBox.setSelected(options.isInformAboutDoubleMp3AtStartup());
        this.informAboutEqualKanaAndKanjiAtStartupCheckBox.setSelected(options.isInformAboutEqualKanaAndKanjiAtStartup());
        this.useOnlyFirstGermanTermTestingCheckBox.setSelected(options.isUseOnlyFirstGermanTermWhenTestingVocableGermanToJapanese());
        VocabularySortOrder vocabularySortOrder = options.getVocabularySortOrder();
        int n = this.vocabularySortOrders.indexOf((Object)vocabularySortOrder);
        JRadioButton jRadioButton = this.vocabularySortOrderRadioButtons.get(n);
        jRadioButton.setSelected(true);
        VocablesShuffleType vocablesShuffleType = options.getVocablesShuffleType();
        int n2 = this.vocablesShuffleTypes.indexOf((Object)vocablesShuffleType);
        JRadioButton jRadioButton2 = this.vocablesShuffleTypesRadioButtons.get(n2);
        jRadioButton2.setSelected(true);
        this.reverseShuffledVocablesCheckBox.setSelected(options.isReverseShuffledVocables());
        this.useVocablesShuffleTypeForShowingListsAndSheetsTooCheckBox.setSelected(options.isUseVocablesShuffleTypeForShowingListsAndSheetsToo());
        VocablesSubsetSelectionType vocablesSubsetSelectionType = options.getVocablesSubsetSelectionType();
        int n3 = this.vocablesSubsetSelectionTypes.indexOf((Object)vocablesSubsetSelectionType);
        JRadioButton jRadioButton3 = this.vocablesSubsetSelectionTypesRadioButtons.get(n3);
        jRadioButton3.setSelected(true);
        this.showSuccessPercentInVocabularyBarCheckBox.setSelected(options.isShowSuccessPercentInVocabularyBar());
        this.numberOfVocabularyBarColumnsChooser.setSize(options.getNumberOfVocabularyBarColumns());
        this.numberOfColumnsOfBlattDarstellungChooser.setSize(options.getNumberOfColumnsOfBlattDarstellung());
        this.hideVocablesFromListInSearchAreaInOwnListEditorCheckBox.setSelected(options.isHideVocablesFromListInSearchAreaInOwnListEditor());
        this.showDetailsButtonInEinzeldarstellungCheckBox.setSelected(options.isShowDetailsButtonInEinzeldarstellung());
        this.showDetailsButtonInVokabelblattDarstellungCheckBox.setSelected(options.isShowDetailsButtonInVokabelblattDarstellung());
        this.hideLessStartOfVocabularyDescriptionForVhsCheckBox.setSelected(options.isHideLessStartOfVocabularyDescriptionForVhs());
        this.checkNewOwnListsVersionAtStartCheckBox.setSelected(options.isCheckNewOwnListsVersionAtStart());
        this.showKanaInKanjiSizeWhenTestingVocableCheckBox.setSelected(options.isShowKanaInKanjiSizeWhenTestingVocable());
        EmptyTranslationsAcceptance emptyTranslationsAcceptance = options.getEmptyTranslationsAcceptance();
        int n4 = this.emptyTranslationsAcceptances.indexOf((Object)emptyTranslationsAcceptance);
        JRadioButton jRadioButton4 = this.emptyTranslationsAcceptancesRadioButtons.get(n4);
        jRadioButton4.setSelected(true);
        this.numberOfDaysForAWhile = options.getNumberOfDaysForAWhile();
        this.setNumberOfDaysForAWhileButtonText();
        this.numberOfDaysAVocableIsNew = options.getNumberOfDaysAVocableIsNew();
        this.setNumberOfDaysAVocableIsNewButtonText();
        this.elevenColorsUi.initWithOptions(options);
        this.vocablesColorsUi.initWithOptions(options);
        this.useSplitPaneInOwnListEditorCheckBox.setSelected(options.isUseSplitPaneInOwnListEditor());
        this.showTimestampsInStartupCheckBox.setSelected(options.isShowTimestampsInStartup());
        this.createGermanJapaneseTranslationAtStartupCheckBox.setSelected(options.isCreateGermanJapaneseTranslationAtStartup());
        this.informAboutEOrUInVocableFieldAusspracheAtStartupCheckBox.setSelected(options.isInformAboutEOrUInVocableFieldAusspracheAtStartup());
        this.numberOfRememberedOwnLists = options.getNumberOfRememberedOwnLists();
        this.setNumberOfRememberedOwnListsButtonText();
        this.showAllTranslationsCheckBox.setSelected(options.isShowAllTranslations());
        this.numberOfShownTranslations = options.getNumberOfShownTranslations();
        this.setNumberOfShownTranslationsButtonText();
        this.showNumberOfListsInListerCheckBox.setSelected(options.isShowNumberOfListsInLister());
        this.showDetailBottomButonsInEinzeldarstellungTooCheckBox.setSelected(options.isShowDetailBottomButonsInEinzeldarstellungToo());
        this.showDetailBottomButonsInTranslationEvaluationTooCheckBox.setSelected(options.isShowDetailBottomButonsInTranslationEvaluationToo());
        this.playMP3WhenTestingVocablesCheckBox.setSelected(options.isPlayMP3WhenTestingVocables());
        this.colorUserInputAtKanjiTestEvaluationDialogCheckBox.setSelected(options.isColorUserInputAtKanjiTestEvaluationDialog());
        this.stopAfterStartupCheckBox.setSelected(options.isStopAfterStartup());
        this.waitForXAfterStartupCheckBox.setSelected(options.isWaitForXAfterStartup());
        this.closeSingleViewWhenOpeningDetailsAfterSimpleSearchCheckBox.setSelected(options.isCloseSingleViewWhenOpeningDetailsAfterSimpleSearch());
        this.showWarningsAfterStartCheckBox.setSelected(options.isShowWarningsAfterStart());
        this.showKanjiTestAtParameterDialogPositionCheckBox.setSelected(options.isShowKanjiTestAtParameterDialogPosition());
        this.showKanjiNumberInMyHandwrittenKanjiNotebooksCheckBox.setSelected(options.isShowKanjiNumberInMyHandwrittenKanjiNotebooks());
    }

    private void setNumberOfDaysForAWhileButtonText() {
        this.numberOfDaysForAWhileButton.setText("Anzahl Tage f\u00fcr 'lange nicht mehr' abgefragte Vokabeln, momentan " + this.numberOfDaysForAWhile);
    }

    private void setNumberOfDaysAVocableIsNewButtonText() {
        this.numberOfDaysAVocableIsNewButton.setText("Anzahl Tage wie lange eine Vokabel als 'neu' gilt, momentan " + this.numberOfDaysAVocableIsNew);
    }

    private void setNumberOfRememberedOwnListsButtonText() {
        this.numberOfRememberedOwnListsButton.setText("Anzahl der gemerkten zuletzt besuchten eigenen Listen, momentan " + this.numberOfRememberedOwnLists);
    }

    private void setNumberOfShownTranslationsButtonText() {
        this.numberOfShownTranslationsButton.setText("Anzahl der angezeigten \u00dcbersetzungen in der Einzeldarstellung und bei der Abfrage, momentan " + this.numberOfShownTranslations);
    }

    private void addActionListenersForEnableDisableOptions() {
        this.showKanjiWhenTestingVocableCheckBox.addActionListener(actionEvent -> this.enableOrDisableKanji());
        this.showRomajiWhenTestingVocableCheckBox.addActionListener(actionEvent -> this.enableOrDisableRomaji());
        this.showPronunciationWhenTestingVocableCheckBox.addActionListener(actionEvent -> this.enableOrDisablePronunciation());
        this.hideStartOfVocabularyDescriptionCheckBox.addActionListener(actionEvent -> this.enableOrDisableHideStartOfVocabularyDescription());
    }

    private void enableOrDisableElements() {
        this.enableOrDisableKanji();
        this.enableOrDisableRomaji();
        this.enableOrDisablePronunciation();
        this.enableOrDisableHideStartOfVocabularyDescription();
    }

    private void enableOrDisableKanji() {
        boolean bl = this.showKanjiWhenTestingVocableCheckBox.isSelected();
        this.hideKanjiWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox.setEnabled(bl);
    }

    private void enableOrDisableRomaji() {
        boolean bl = this.showRomajiWhenTestingVocableCheckBox.isSelected();
        this.hideRomajiWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox.setEnabled(bl);
    }

    private void enableOrDisablePronunciation() {
        boolean bl = this.showPronunciationWhenTestingVocableCheckBox.isSelected();
        this.hidePronunciationWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox.setEnabled(bl);
    }

    private void enableOrDisableHideStartOfVocabularyDescription() {
        boolean bl = this.hideStartOfVocabularyDescriptionCheckBox.isSelected();
        this.hideLessStartOfVocabularyDescriptionForVhsCheckBox.setEnabled(bl);
    }

    private Component createPathesSelectionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Pfade", jPanel);
        jPanel.add(this.vocabulariesPathSelection.getPanel());
        return jPanel;
    }

    private Component createCheckNewVersionsAtStartPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Pr\u00fcfung auf Updates beim Start des Programms", jPanel);
        jPanel.add(this.checkNewOwnListsVersionAtStartCheckBox);
        return jPanel;
    }

    private Component createOtherThingsAtStartPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(5, 3));
        GuiTools.createTitle("Pr\u00fcfungen etc. beim Start des Programms", jPanel);
        jPanel.add(this.informAboutDoubleMp3AtStartupCheckBox);
        jPanel.add(this.informAboutEqualKanaAndKanjiAtStartupCheckBox);
        jPanel.add(this.allowMissingMp3CheckBox);
        jPanel.add(this.reportMissingMp3CheckBox);
        jPanel.add(this.informAboutEOrUInVocableFieldAusspracheAtStartupCheckBox);
        jPanel.add(this.showTimestampsInStartupCheckBox);
        jPanel.add(this.createGermanJapaneseTranslationAtStartupCheckBox);
        jPanel.add(this.stopAfterStartupCheckBox);
        jPanel.add(this.waitForXAfterStartupCheckBox);
        jPanel.add(this.showWarningsAfterStartCheckBox);
        return jPanel;
    }

    private Component createVocabularyPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.createVocabularyBaseOptionsPart());
        jPanel.add(this.createVocabularySortOrderPart());
        return jPanel;
    }

    private Component createVocabularyBaseOptionsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Grundeinstellungen der Vokabularien", jPanel);
        jPanel.add(this.colorVocabularyDependingOnLastSuccessCheckBox);
        jPanel.add(this.showSuccessPercentInVocabularyBarCheckBox);
        jPanel.add(this.hideStartOfVocabularyDescriptionCheckBox);
        jPanel.add(this.hideLessStartOfVocabularyDescriptionForVhsCheckBox);
        return jPanel;
    }

    private Component createVocabularySortOrderPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Sortierung der Vokabularien", jPanel);
        for (JRadioButton jRadioButton : this.vocabularySortOrderRadioButtons) {
            jPanel.add(jRadioButton);
        }
        return jPanel;
    }

    private Component createTestingOptionsSelectionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Abfragen von Vokablen - generell", jPanel);
        jPanel.add(this.switchToNextVocableAfterEntringTranslationCheckBox);
        jPanel.add(this.colorVocableDependingOnLastSuccessWhenTestingVocableCheckBox);
        jPanel.add(this.showDetailBottomButonsInTranslationEvaluationTooCheckBox);
        return jPanel;
    }

    private Component createTestingJapaneseOptionsSelectionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Abfragen von japanischen Vokablen", jPanel);
        jPanel.add(this.showKanaWhenTestingVocableCheckBox);
        jPanel.add(this.showKanjiWhenTestingVocableCheckBox);
        jPanel.add(this.hideKanjiWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox);
        jPanel.add(this.showRomajiWhenTestingVocableCheckBox);
        jPanel.add(this.hideRomajiWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox);
        jPanel.add(this.showPronunciationWhenTestingVocableCheckBox);
        jPanel.add(this.hidePronunciationWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox);
        jPanel.add(this.showCommentWhenTestingVocableCheckBox);
        jPanel.add(this.showVocabularyDescriptionWhenTestingVocableCheckBox);
        jPanel.add(this.showKanaInKanjiSizeWhenTestingVocableCheckBox);
        jPanel.add(this.playMP3WhenTestingVocablesCheckBox);
        return jPanel;
    }

    private Component createTestingGermanOptionsSelectionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Abfragen von deutschen Vokablen", jPanel);
        jPanel.add(this.useOnlyFirstGermanTermTestingCheckBox);
        return jPanel;
    }

    private Component createVocablesShuffleTypesPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Sortierung von Vokabellisten f\u00fcr die Abfrage", jPanel);
        jPanel.add(this.createVocablesShuffleTypesOptionsPart());
        jPanel.add(this.createVocablesShuffleTypesRadioButtonsPart());
        return jPanel;
    }

    private Component createVocablesShuffleTypesOptionsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle(jPanel);
        jPanel.add(this.reverseShuffledVocablesCheckBox);
        jPanel.add(this.useVocablesShuffleTypeForShowingListsAndSheetsTooCheckBox);
        return jPanel;
    }

    private Component createVocablesShuffleTypesRadioButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle(jPanel);
        for (JRadioButton jRadioButton : this.vocablesShuffleTypesRadioButtons) {
            jPanel.add(jRadioButton);
        }
        return jPanel;
    }

    private Component createVocablesSubsetSelectionTypesPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Auswahl von Teilmengen von Vokabellisten f\u00fcr die Abfrage", jPanel);
        for (JRadioButton jRadioButton : this.vocablesSubsetSelectionTypesRadioButtons) {
            jPanel.add(jRadioButton);
        }
        return jPanel;
    }

    private Component createEmptyTranslationsAcceptancesPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Wann soll auf die Eingabe einer leeren \u00dcbersetzung reagiert werden?", jPanel);
        for (JRadioButton jRadioButton : this.emptyTranslationsAcceptancesRadioButtons) {
            jPanel.add(jRadioButton);
        }
        return jPanel;
    }

    private Component createViewingOptionsSelectionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Anzeigen von Vokablen", jPanel);
        jPanel.add(this.useTestOrderForViewingVocablesCheckBox);
        jPanel.add(this.colorVocableDependingOnLastSuccessWhenViewingVocableCheckBox);
        jPanel.add(this.showNumberOfListsInListerCheckBox);
        jPanel.add(this.showDetailBottomButonsInEinzeldarstellungTooCheckBox);
        jPanel.add(this.showDetailsButtonInEinzeldarstellungCheckBox);
        jPanel.add(this.showDetailsButtonInVokabelblattDarstellungCheckBox);
        jPanel.add(this.closeSingleViewWhenOpeningDetailsAfterSimpleSearchCheckBox);
        return jPanel;
    }

    private Component createVocableColorsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle("Farben bei der Darstellung einer Vokabel", jPanel);
        jPanel.add((Component)this.vocablesColorsUi.getPanel(), "Center");
        return jPanel;
    }

    private Component createTranslationsShownPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Anzeige der \u00dcbersetzungen in der Einzeldarstellung und bei der Bewertung der Abfrage von Vokabeln", jPanel);
        jPanel.add(this.showAllTranslationsCheckBox);
        jPanel.add(this.numberOfShownTranslationsButton);
        return jPanel;
    }

    private Component createBlattdarstellungSelectionsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Blattdarstellung", jPanel);
        jPanel.add(this.numberOfColumnsOfBlattDarstellungChooser.getSizeChangeButton());
        return jPanel;
    }

    private Component createVocabularyBarSelectionsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Sonstige Optionen f\u00fcr Vokabularien", jPanel);
        jPanel.add(this.numberOfVocabularyBarColumnsChooser.getSizeChangeButton());
        return jPanel;
    }

    private Component createOtherOwnListSelectionsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Sonstige Optionen f\u00fcr eigene Listen", jPanel);
        jPanel.add(this.numberOfRememberedOwnListsButton);
        return jPanel;
    }

    private Component createOwnListEditorSelectionsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Optionen f\u00fcr den Editor zur Bearbeitung eigener Listen", jPanel);
        jPanel.add(this.hideVocablesFromListInSearchAreaInOwnListEditorCheckBox);
        jPanel.add(this.useSplitPaneInOwnListEditorCheckBox);
        return jPanel;
    }

    private Component createShowKanjiPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.createOtherShowKanjiOptionsPart());
        return jPanel;
    }

    private Component createOtherShowKanjiOptionsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Sonstige Optionen f\u00fcr das Anzeigen von Kanji", jPanel);
        jPanel.add(this.showKanjiNumberInMyHandwrittenKanjiNotebooksCheckBox);
        return jPanel;
    }

    private Component createTestKanjiPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.createColorKanjiTestPart());
        jPanel.add(this.createOtherKanjiTestOptionsPart());
        return jPanel;
    }

    private Component createColorKanjiTestPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Optionen f\u00fcr das Einf\u00e4rben beim Testen von Kanji", jPanel);
        jPanel.add(this.colorUserInputAtKanjiTestEvaluationDialogCheckBox);
        return jPanel;
    }

    private Component createOtherKanjiTestOptionsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Sonstige Optionen f\u00fcr das Testen von Kanji", jPanel);
        jPanel.add(this.showKanjiTestAtParameterDialogPositionCheckBox);
        return jPanel;
    }

    private Component createGrammarTablePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.grammarOptionsPanel.getPanel());
        return jPanel;
    }

    private Component createButtonsPartWithoutDefaultButton() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "West");
        jPanel.add(this.createOkButton(), "East");
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createLeftButtonsPart(), "West");
        jPanel.add(this.createOkButton(), "East");
        return jPanel;
    }

    private Component createLeftButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "West");
        jPanel.add(this.createToDefaultButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Abbrechen");
        jButton.addActionListener(actionEvent -> this.closeDialog());
        return jButton;
    }

    private Component createToDefaultButton() {
        JButton jButton = new JButton("Defaultwerte");
        jButton.addActionListener(actionEvent -> this.toDefault());
        return jButton;
    }

    private void toDefault() {
        if (GuiTools.askUser(this.getDialog(), "Werte auf Default setzen?", "Sollen alle Optionen auf den Default-Wert gesetzt werden?")) {
            String string = this.options.getVocabulariesPath();
            Options options = new Options(new VocabularyTrainerVersion().getVersion());
            options.setVocabulariesPath(string);
            this.fillOptionValuesIntoGui(options);
        }
    }

    private Component createOkButton() {
        JButton jButton = new JButton("\u00c4nderungen \u00fcbernehmen");
        jButton.addActionListener(actionEvent -> this.apply());
        return jButton;
    }

    private void apply() {
        int n;
        int n2;
        int n3;
        String string = this.vocabulariesPathSelection.getText();
        boolean bl = this.switchToNextVocableAfterEntringTranslationCheckBox.isSelected();
        boolean bl2 = this.showKanaWhenTestingVocableCheckBox.isSelected();
        boolean bl3 = this.showKanjiWhenTestingVocableCheckBox.isSelected();
        boolean bl4 = this.hideKanjiWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox.isSelected();
        boolean bl5 = this.showRomajiWhenTestingVocableCheckBox.isSelected();
        boolean bl6 = this.hideRomajiWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox.isSelected();
        boolean bl7 = this.showPronunciationWhenTestingVocableCheckBox.isSelected();
        boolean bl8 = this.hidePronunciationWhenTestingVocableAndKanaContainsOnlyHiraganaCheckBox.isSelected();
        boolean bl9 = this.showCommentWhenTestingVocableCheckBox.isSelected();
        boolean bl10 = this.showVocabularyDescriptionWhenTestingVocableCheckBox.isSelected();
        boolean bl11 = this.colorVocableDependingOnLastSuccessWhenTestingVocableCheckBox.isSelected();
        boolean bl12 = this.colorVocableDependingOnLastSuccessWhenViewingVocableCheckBox.isSelected();
        boolean bl13 = this.colorVocabularyDependingOnLastSuccessCheckBox.isSelected();
        boolean bl14 = this.hideStartOfVocabularyDescriptionCheckBox.isSelected();
        boolean bl15 = this.useTestOrderForViewingVocablesCheckBox.isSelected();
        boolean bl16 = this.hideVocablesFromListInSearchAreaInOwnListEditorCheckBox.isSelected();
        boolean bl17 = this.allowMissingMp3CheckBox.isSelected();
        boolean bl18 = this.reportMissingMp3CheckBox.isSelected();
        boolean bl19 = this.informAboutDoubleMp3AtStartupCheckBox.isSelected();
        boolean bl20 = this.informAboutEqualKanaAndKanjiAtStartupCheckBox.isSelected();
        boolean bl21 = this.useOnlyFirstGermanTermTestingCheckBox.isSelected();
        boolean bl22 = this.showDetailsButtonInEinzeldarstellungCheckBox.isSelected();
        boolean bl23 = this.showDetailsButtonInVokabelblattDarstellungCheckBox.isSelected();
        boolean bl24 = this.hideLessStartOfVocabularyDescriptionForVhsCheckBox.isSelected();
        boolean bl25 = this.checkNewOwnListsVersionAtStartCheckBox.isSelected();
        boolean bl26 = this.showAllTranslationsCheckBox.isSelected();
        boolean bl27 = this.showNumberOfListsInListerCheckBox.isSelected();
        boolean bl28 = this.showDetailBottomButonsInEinzeldarstellungTooCheckBox.isSelected();
        boolean bl29 = this.showDetailBottomButonsInTranslationEvaluationTooCheckBox.isSelected();
        boolean bl30 = this.playMP3WhenTestingVocablesCheckBox.isSelected();
        boolean bl31 = this.colorUserInputAtKanjiTestEvaluationDialogCheckBox.isSelected();
        boolean bl32 = this.stopAfterStartupCheckBox.isSelected();
        boolean bl33 = this.waitForXAfterStartupCheckBox.isSelected();
        boolean bl34 = this.closeSingleViewWhenOpeningDetailsAfterSimpleSearchCheckBox.isSelected();
        boolean bl35 = this.showWarningsAfterStartCheckBox.isSelected();
        boolean bl36 = this.showKanjiTestAtParameterDialogPositionCheckBox.isSelected();
        boolean bl37 = this.showKanjiNumberInMyHandwrittenKanjiNotebooksCheckBox.isSelected();
        VocabularySortOrder vocabularySortOrder = this.options.getVocabularySortOrder();
        for (int i = 0; i < this.vocabularySortOrderRadioButtons.size(); ++i) {
            JRadioButton jRadioButton = this.vocabularySortOrderRadioButtons.get(i);
            if (!jRadioButton.isSelected()) continue;
            vocabularySortOrder = this.vocabularySortOrders.get(i);
            break;
        }
        VocablesShuffleType vocablesShuffleType = this.options.getVocablesShuffleType();
        for (n3 = 0; n3 < this.vocablesShuffleTypesRadioButtons.size(); n3 += 1) {
            JRadioButton jRadioButton = this.vocablesShuffleTypesRadioButtons.get(n3);
            if (!jRadioButton.isSelected()) continue;
            vocablesShuffleType = this.vocablesShuffleTypes.get(n3);
            break;
        }
        n3 = this.reverseShuffledVocablesCheckBox.isSelected() ? 1 : 0;
        boolean bl38 = this.useVocablesShuffleTypeForShowingListsAndSheetsTooCheckBox.isSelected();
        VocablesSubsetSelectionType vocablesSubsetSelectionType = this.options.getVocablesSubsetSelectionType();
        for (n2 = 0; n2 < this.vocablesSubsetSelectionTypesRadioButtons.size(); n2 += 1) {
            JRadioButton jRadioButton = this.vocablesSubsetSelectionTypesRadioButtons.get(n2);
            if (!jRadioButton.isSelected()) continue;
            vocablesSubsetSelectionType = this.vocablesSubsetSelectionTypes.get(n2);
            break;
        }
        n2 = this.showSuccessPercentInVocabularyBarCheckBox.isSelected() ? 1 : 0;
        int n4 = this.numberOfVocabularyBarColumnsChooser.getSize();
        int n5 = this.numberOfColumnsOfBlattDarstellungChooser.getSize();
        boolean bl39 = this.showKanaInKanjiSizeWhenTestingVocableCheckBox.isSelected();
        EmptyTranslationsAcceptance emptyTranslationsAcceptance = this.options.getEmptyTranslationsAcceptance();
        for (n = 0; n < this.emptyTranslationsAcceptancesRadioButtons.size(); n += 1) {
            JRadioButton jRadioButton = this.emptyTranslationsAcceptancesRadioButtons.get(n);
            if (!jRadioButton.isSelected()) continue;
            emptyTranslationsAcceptance = this.emptyTranslationsAcceptances.get(n);
            break;
        }
        n = this.useSplitPaneInOwnListEditorCheckBox.isSelected() ? 1 : 0;
        boolean bl40 = this.showTimestampsInStartupCheckBox.isSelected();
        boolean bl41 = this.createGermanJapaneseTranslationAtStartupCheckBox.isSelected();
        boolean bl42 = this.informAboutEOrUInVocableFieldAusspracheAtStartupCheckBox.isSelected();
        this.options.setVocabulariesPath(Text.nicePath(string));
        this.options.setSwitchToNextVocableAfterEntringTranslation(bl);
        this.options.setShowKanaWhenTestingVocable(bl2);
        this.options.setShowKanjiWhenTestingVocable(bl3);
        this.options.setHideKanjiWhenTestingVocableAndKanaContainsOnlyHiragana(bl4);
        this.options.setShowRomajiWhenTestingVocable(bl5);
        this.options.setHideRomajiWhenTestingVocableAndKanaContainsOnlyHiragana(bl6);
        this.options.setShowPronunciationWhenTestingVocable(bl7);
        this.options.setHidePronunciationWhenTestingVocableAndKanaContainsOnlyHiragana(bl8);
        this.options.setShowCommentWhenTestingVocable(bl9);
        this.options.setShowVocabularyDescriptionWhenTestingVocable(bl10);
        this.options.setColorVocableDependingOnLastSuccessWhenTestingVocable(bl11);
        this.options.setColorVocableDependingOnLastSuccessWhenViewingVocable(bl12);
        this.options.setVocabularySortOrder(vocabularySortOrder);
        this.options.setColorVocabularyDependingOnLastSuccess(bl13);
        this.options.setVocablesShuffleType(vocablesShuffleType);
        this.options.setVocablesSubsetSelectionType(vocablesSubsetSelectionType);
        this.options.setReverseShuffledVocables(n3 != 0);
        this.options.setUseVocablesShuffleTypeForShowingListsAndSheetsToo(bl38);
        this.options.setHideStartOfVocabularyDescription(bl14);
        this.options.setUseTestOrderForViewingVocables(bl15);
        this.options.setShowSuccessPercentInVocabularyBar(n2 != 0);
        this.options.setNumberOfVocabularyBarColumns(n4);
        this.options.setHideVocablesFromListInSearchAreaInOwnListEditor(bl16);
        this.options.setAllowMissingMp3(bl17);
        this.options.setReportMissingMp3(bl18);
        this.options.setNumberOfColumnsOfBlattDarstellung(n5);
        this.options.setInformAboutDoubleMp3AtStartup(bl19);
        this.options.setInformAboutEqualKanaAndKanjiAtStartup(bl20);
        this.options.setUseOnlyFirstGermanTermWhenTestingVocableGermanToJapanese(bl21);
        this.options.setShowDetailsButtonInEinzeldarstellung(bl22);
        this.options.setShowDetailsButtonInVokabelblattDarstellung(bl23);
        this.options.setHideLessStartOfVocabularyDescriptionForVhs(bl24);
        this.options.setCheckNewOwnListsVersionAtStart(bl25);
        this.options.setShowKanaInKanjiSizeWhenTestingVocable(bl39);
        this.options.setEmptyTranslationsAcceptance(emptyTranslationsAcceptance);
        this.options.setNumberOfDaysForAWhile(this.numberOfDaysForAWhile);
        this.options.setNumberOfDaysAVocableIsNew(this.numberOfDaysAVocableIsNew);
        this.elevenColorsUi.setIntoOptions(this.options);
        this.options.setUseSplitPaneInOwnListEditor(n != 0);
        this.vocablesColorsUi.setIntoOptions(this.options);
        this.options.setShowTimestampsInStartup(bl40);
        this.options.setCreateGermanJapaneseTranslationAtStartup(bl41);
        this.options.setInformAboutEOrUInVocableFieldAusspracheAtStartup(bl42);
        this.options.setShowAllTranslations(bl26);
        this.options.setNumberOfRememberedOwnLists(this.numberOfRememberedOwnLists);
        this.options.setNumberOfShownTranslations(this.numberOfShownTranslations);
        this.options.setShowNumberOfListsInLister(bl27);
        this.options.setShowDetailBottomButonsInEinzeldarstellungToo(bl28);
        this.options.setShowDetailBottomButonsInTranslationEvaluationToo(bl29);
        this.options.setPlayMP3WhenTestingVocables(bl30);
        this.options.setColorUserInputAtKanjiTestEvaluationDialog(bl31);
        this.options.setStopAfterStartup(bl32);
        this.options.setWaitForXAfterStartup(bl33);
        this.options.setCloseSingleViewWhenOpeningDetailsAfterSimpleSearch(bl34);
        this.options.setShowWarningsAfterStart(bl35);
        this.options.setShowKanjiTestAtParameterDialogPosition(bl36);
        this.options.setShowKanjiNumberInMyHandwrittenKanjiNotebooks(bl37);
        this.grammarOptionsPanel.storeIntoOptions();
        this.applied = true;
        this.closeDialog();
    }

    public boolean wasApplied() {
        return this.applied;
    }
}

