/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.table.katakana;

import de.duehl.swing.ui.tables.DifferentBackgroundsTableRendererWithChangingSize;
import de.duehl.vocabulary.japanese.ui.dialog.table.katakana.KatakanaTableModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class KatakanaTableRenderer
extends DifferentBackgroundsTableRendererWithChangingSize {
    private static final long serialVersionUID = 1L;
    private boolean colorForegroundDependingOnLastSuccess;
    private boolean colorBackgroundDependingOnLastSuccess;

    public KatakanaTableRenderer(Color color, Color color2) {
        super(color, color2);
        this.setUseDifferentBackgrounds(true);
    }

    public void toggleColorForegroundDependingOnLastSuccess() {
        this.colorForegroundDependingOnLastSuccess = !this.colorForegroundDependingOnLastSuccess;
        this.setUseDifferentBackgrounds();
    }

    public void toggleColorBackgroundDependingOnLastSuccess() {
        this.colorBackgroundDependingOnLastSuccess = !this.colorBackgroundDependingOnLastSuccess;
        this.setUseDifferentBackgrounds();
    }

    private void setUseDifferentBackgrounds() {
        this.setUseDifferentBackgrounds(!this.colorForegroundDependingOnLastSuccess && !this.colorBackgroundDependingOnLastSuccess);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        int n3 = this.colorBackgroundDependingOnLastSuccess || this.colorForegroundDependingOnLastSuccess ? jTable.convertRowIndexToModel(n) : n;
        return this.getTableCellRendererComponentInternal(jTable, object, bl, bl2, n3, n2);
    }

    private Component getTableCellRendererComponentInternal(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color;
        Color color2;
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        KatakanaTableModel katakanaTableModel = (KatakanaTableModel)jTable.getModel();
        if (this.colorForegroundDependingOnLastSuccess && this.colorBackgroundDependingOnLastSuccess) {
            color2 = katakanaTableModel.determineRowForegroundColor(n);
            color = katakanaTableModel.determineRowBackgroundColor(n);
        } else if (this.colorForegroundDependingOnLastSuccess) {
            color2 = katakanaTableModel.determineRowForegroundColor(n);
            color = bl && this.isUseSwitchedColorsForSelection() ? jLabel.getForeground() : jLabel.getBackground();
        } else if (this.colorBackgroundDependingOnLastSuccess) {
            color2 = Color.BLACK;
            color = katakanaTableModel.determineRowBackgroundColor(n);
        } else if (bl && this.isUseSwitchedColorsForSelection()) {
            color2 = jLabel.getBackground();
            color = jLabel.getForeground();
        } else {
            color2 = jLabel.getForeground();
            color = jLabel.getBackground();
        }
        if (bl && this.isUseSwitchedColorsForSelection()) {
            jLabel.setForeground(color);
            jLabel.setBackground(color2);
        } else {
            jLabel.setForeground(color2);
            jLabel.setBackground(color);
        }
        return jLabel;
    }
}

