/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.table.vocable;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.color.VocableColors;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.ui.dialog.table.TableHelper;
import java.awt.Color;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class VocableTableModel
extends AbstractTableModel {
    private static final int NUMBER_OF_COLUMNS_WITHOUT_NUMBER_OF_LISTS_COLUMN = 18;
    private static final long serialVersionUID = 1L;
    private final List<Vocable> vocables;
    private final FumikoDataStructures dataStructures;
    private final boolean translationJapaneseToGerman;
    private final TranslationDirection translationDirection;

    public VocableTableModel(List<Vocable> list, FumikoDataStructures fumikoDataStructures) {
        this.vocables = list;
        this.dataStructures = fumikoDataStructures;
        Options options = fumikoDataStructures.getOptions();
        this.translationDirection = options.getTranslationDirection();
        if (this.translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            this.translationJapaneseToGerman = true;
        } else if (this.translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            this.translationJapaneseToGerman = false;
        } else {
            throw new RuntimeException("Unbekannte Abfragerichtung " + this.translationDirection);
        }
    }

    @Override
    public int getRowCount() {
        return this.vocables.size();
    }

    @Override
    public int getColumnCount() {
        int n = 18;
        Options options = this.dataStructures.getOptions();
        if (options.isShowNumberOfListsInLister()) {
            ++n;
        }
        return n;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 6 || n2 == 17;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Vocable vocable = this.vocables.get(n);
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
        switch (n2) {
            case 0: {
                return n + 1;
            }
            case 1: {
                return vocable.getKana();
            }
            case 2: {
                return vocable.getKanji();
            }
            case 3: {
                return vocable.getRomaji();
            }
            case 4: {
                return vocable.getPronunciation();
            }
            case 5: {
                return Text.join(", ", vocable.getTranslations());
            }
            case 6: {
                return "abspielen";
            }
            case 7: {
                return vocable.getComment();
            }
            case 8: {
                return Text.joinWithCommaAndBlank(vocable.getSearchWords());
            }
            case 9: {
                return Text.joinWithCommaAndBlank(vocable.getPartsOfSpeech());
            }
            case 10: {
                return vocable.getVocabularyDescription();
            }
            case 11: {
                if (this.translationJapaneseToGerman) {
                    return internalAdditionalVocableData.getJapaneseToGermanTestCount();
                }
                return internalAdditionalVocableData.getGermanToJapaneseTestCount();
            }
            case 12: {
                if (this.translationJapaneseToGerman) {
                    return internalAdditionalVocableData.getCorrectJapaneseToGermanTestCount();
                }
                return internalAdditionalVocableData.getCorrectGermanToJapaneseTestCount();
            }
            case 13: {
                return internalAdditionalVocableData.getFirstSeenDate();
            }
            case 14: {
                if (this.translationJapaneseToGerman) {
                    return TableHelper.dateOrEmpty(internalAdditionalVocableData.getLastJapaneseToGermanTestDate(), internalAdditionalVocableData.getJapaneseToGermanTestCount());
                }
                return TableHelper.dateOrEmpty(internalAdditionalVocableData.getLastGermanToJapaneseTestDate(), internalAdditionalVocableData.getGermanToJapaneseTestCount());
            }
            case 15: {
                if (this.translationJapaneseToGerman) {
                    return TableHelper.dateOrEmpty(internalAdditionalVocableData.getLastCorrectJapaneseToGermanTestDate(), internalAdditionalVocableData.getCorrectJapaneseToGermanTestCount());
                }
                return TableHelper.dateOrEmpty(internalAdditionalVocableData.getLastCorrectGermanToJapaneseTestDate(), internalAdditionalVocableData.getCorrectGermanToJapaneseTestCount());
            }
            case 16: {
                if (this.translationJapaneseToGerman) {
                    return TableHelper.createMonospaceHtml(internalAdditionalVocableData.getLastTenJapaneseToGermanTestResultsAsStorageString());
                }
                return TableHelper.createMonospaceHtml(internalAdditionalVocableData.getLastTenGermanToJapaneseTestResultsAsStorageString());
            }
            case 17: {
                return " ";
            }
            case 18: {
                Options options = this.dataStructures.getOptions();
                if (options.isShowNumberOfListsInLister()) {
                    return this.createNumberOfTablesAndLernlistText(vocable);
                }
                return " ";
            }
        }
        throw new RuntimeException("Unzul\u00e4siger Spaltenindex '" + n2 + "'.");
    }

    private String createNumberOfTablesAndLernlistText(Vocable vocable) {
        OwnLists ownLists = this.dataStructures.getOwnLists();
        List<OwnList> list = ownLists.getOwnListsWithVocable(vocable);
        int n = 0;
        for (OwnList ownList : list) {
            if (!ownList.isLernliste()) continue;
            ++n;
        }
        String string = n == 0 ? "" : (n == 1 ? "L" : "L!");
        return Integer.toString(list.size()) + (String)string;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: 
            case 11: 
            case 12: {
                return Integer.class;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                return String.class;
            }
            case 13: 
            case 14: 
            case 15: {
                return ImmutualDate.class;
            }
        }
        return String.class;
    }

    public Color determineRowForegroundColor(int n) {
        Vocable vocable = this.vocables.get(n);
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
        Options options = this.dataStructures.getOptions();
        VocableColors vocableColors = new VocableColors(options);
        return vocableColors.determineForegroundColor(internalAdditionalVocableData, true, this.translationDirection);
    }

    public Color determineRowBackgroundColor(int n) {
        Vocable vocable = this.vocables.get(n);
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
        Options options = this.dataStructures.getOptions();
        VocableColors vocableColors = new VocableColors(options);
        return vocableColors.determineBackgroundColor(internalAdditionalVocableData, true, this.translationDirection);
    }
}

