/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.testing;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.MultipleElementsPanel;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.components.selections.tools.SelectionsHelper;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.ui.components.VocableViewer;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

public class VocableAfterTypingErrorSelectorDialog
extends ModalDialogBase {
    private final String translationByUser;
    private final List<Vocable> matchingVocables;
    private final FumikoDataStructures dataStructures;
    private Vocable correctVocable;
    private boolean hasUserSelected;

    public VocableAfterTypingErrorSelectorDialog(String string, List<Vocable> list, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, Point point) {
        super(point, fumikoUiObjects.getProgramImage(), "Auswahl der zur vertippten \u00dcbersetzung passenden Vokabel");
        this.translationByUser = string;
        this.matchingVocables = list;
        this.dataStructures = fumikoDataStructures;
        this.hasUserSelected = false;
        this.fillDialog();
    }

    @Override
    protected void populateDialog() {
        this.add(this.createTranlationPart(), "North");
        this.add(GuiTools.createScrollPane(this.createTitledMatchingVocablesPart()), "Center");
    }

    private Component createTranlationPart() {
        StringSelection stringSelection = new StringSelection("Die \u00dcbersetzung mit Tippfehler");
        SelectionsHelper.initSelectionAsViewer(stringSelection);
        stringSelection.setText(this.translationByUser);
        stringSelection.biggerLabelText(5);
        return stringSelection.getPanel();
    }

    private Component createTitledMatchingVocablesPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitledBorder("In Frage kommende Vokabeln", jPanel);
        jPanel.add(this.createMatchingVocablesPart(), "Center");
        return jPanel;
    }

    private Component createMatchingVocablesPart() {
        List<Component> list = this.createVocableSelectionPanels();
        if (list.size() == 1) {
            return list.get(0);
        }
        return this.createMultipleVocableSelectionPanelsDisplay(list);
    }

    private List<Component> createVocableSelectionPanels() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Vocable vocable : this.matchingVocables) {
            arrayList.add(this.createVocableComponent(vocable));
        }
        return arrayList;
    }

    private Component createVocableComponent(Vocable vocable) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createVocableButton(vocable), "West");
        jPanel.add(this.createVocablePanel(vocable), "Center");
        return jPanel;
    }

    private Component createMultipleVocableSelectionPanelsDisplay(List<Component> list) {
        int n = list.size();
        int n2 = n > 4 ? 3 : (n > 2 ? 2 : 1);
        MultipleElementsPanel<Component> multipleElementsPanel = new MultipleElementsPanel<Component>(list, n2, 1);
        return multipleElementsPanel;
    }

    private Component createVocableButton(Vocable vocable) {
        String string = "ausw\u00e4hlen";
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionEvent -> this.userSelectsVocable(vocable));
        return jButton;
    }

    private Component createVocablePanel(Vocable vocable) {
        Options options = this.dataStructures.getOptions();
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        VocableViewer vocableViewer = new VocableViewer(options);
        vocableViewer.showVocable(vocable, internalDataRequester.getInternalDataForVocable(vocable));
        return vocableViewer.getPanel();
    }

    private void userSelectsVocable(Vocable vocable) {
        this.hasUserSelected = true;
        this.correctVocable = vocable;
        this.closeDialog();
    }

    public Vocable getCorrectVocable() {
        return this.correctVocable;
    }

    public boolean hasUserSelected() {
        return this.hasUserSelected;
    }
}

